/*  
 *  THIS IS AN ALPHA RELEASE! DON'T USE IT FOR SERIOUS WORK!
 *  
 *  Rotate plug-in v0.1 by Sven Neumann, neumanns@uni-duesseldorf.de  
 *  1997/9/28
 *
 *  Any suggestions, bug-reports, patches are very welcome.
 */

/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Revision history
 *  (09/28/97)  v0.1  first development release 
 */

/* Todo List
 *  - make it undoable
 *  - nicer look for the dialog
 *  - rewrite the main function to make it work on tiles rather than
 *    process the image row by row. This should result in a significant
 *    speedup (thanks to quartic for this suggestion). 
 *  - make it work on layered images too (don't know exactly how this should
 *    be handled)
 */  

#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

/* Defines */
#define PLUG_IN_NAME "plug_in_rotate"
#define PLUG_IN_PRINT_NAME "Rotate"
#define PLUG_IN_VERSION "v0.1 (09/28/97)"
#define PLUG_IN_MENU_PATH "<Image>/Filters/Image/Rotate"
#define PLUG_IN_IMAGE_TYPES "RGB*, INDEXED*, GRAY*"
#define PLUG_IN_AUTHOR "Sven Neumann (neumanns@uni-duesseldorf.de)"
#define PLUG_IN_COPYRIGHT "Sven Neumann"
#define PLUG_IN_DESCRIBTION "Rotates the image by 90, 180 or 270 degrees"
#define PLUG_IN_HELP "This plug-in does rotate your image clockwise by multiples of 90 degrees. This should be useful when working with scanned images."

#define NUMBER_IN_ARGS 4
#define IN_ARGS { PARAM_INT32, "run_mode", "Interactive, non-interactive"},\
		{ PARAM_IMAGE, "image", "Input image" },\
		{ PARAM_DRAWABLE, "drawable", "Input drawable"},\
                { PARAM_INT32, "angle", "Angle { 90 (1), 180 (2), 270 (3) }"}

#define NUMBER_OUT_ARGS 0 
#define OUT_ARGS NULL

#define NUM_ANGLES 4

char *angle_label[NUM_ANGLES] = { "0", "90", "180", "270" };

typedef struct {
  gint angle;   
} RotateValues;

typedef struct {
  gint run;
} RotateInterface;

static RotateValues rotvals = 
{ 
  1         /* default to 90 */
};

static RotateInterface rotint =
{
  FALSE	    /* run */
};


static void   query (void);
static void   run (char *name,
		   int nparams,	         /* number of parameters passed in */
		   GParam * param,	 /* parameters passed in */
		   int *nreturn_vals,    /* number of parameters returned */
		   GParam ** return_vals);	/* parameters to be returned */
static void     rotate (void);
static void     rotate_compute_offsets (gint *offsetx, 
					gint *offsety, 
					gint image_width, gint image_height,
					gint width, gint height);
static gint     rotate_dialog (void);
static void     rotate_close_callback (GtkWidget *widget,
				       gpointer   data);
static void     rotate_ok_callback (GtkWidget *widget,
				    gpointer   data);
static void     rotate_toggle_update (GtkWidget *widget,
				      gpointer   data);
static void     ErrorMessage (guchar *);

/* Global Variables */
GPlugInInfo PLUG_IN_INFO =
{
  NULL,   /* init_proc  */
  NULL,	  /* quit_proc  */
  query,  /* query_proc */
  run     /* run_proc   */
};

/* the image and drawable that will be used later */
GDrawable *drawable = NULL;	
gint32    image_ID = -1;
gint nlayers;  


/* Functions */

MAIN ();		/* substitute for main(), predefined in gimp.h */

static void query (void)
{
  /* gives the type of parameters that run() needs. 
     the first three are always neccessary. after that, your own are needed.
     the first element of an entry is the type, the second the name of 
	the parameter, and the third a short describtion of the parameter. 
	(second and third entry are for autodocs */
static GParamDef args[] = {IN_ARGS};
  
/* number of arguments that run() expects (simple calculation here) */
static int nargs = NUMBER_IN_ARGS;

/* the parameters returned by run(); see args[] */
static GParamDef *return_vals = OUT_ARGS;

/* number of returned args by run(); see nargs */
static int nreturn_vals = NUMBER_OUT_ARGS;

/* the actual installation of the plugin */
gimp_install_procedure (PLUG_IN_NAME,
			PLUG_IN_DESCRIBTION,
			PLUG_IN_HELP,
			PLUG_IN_AUTHOR,
			PLUG_IN_COPYRIGHT,
			PLUG_IN_VERSION,
			PLUG_IN_MENU_PATH,
			PLUG_IN_IMAGE_TYPES,
			PROC_PLUG_IN,		
			nargs,
			nreturn_vals,
			args,
			return_vals);
}

static void 
run (char *name,		/* name of plugin */
     int nparams,		/* number of in-paramters */
     GParam * param,		/* in-parameters */
     int *nreturn_vals,		/* number of out-parameters */
     GParam ** return_vals)	/* out-parameters */
{
  /* Get the runmode from the in-parameters */
  GRunModeType run_mode = param[0].data.d_int32;	
  
  /* status variable, use it to check for errors in invocation usualy only 
     during non-interactive calling */	
  GStatusType status = STATUS_SUCCESS;	 
  
  /*always return at least the status to the caller. */
  static GParam values[1];
  
  /* initialize the return of the status */ 	
  values[0].type = PARAM_STATUS;
  values[0].data.d_status = status;
  *nreturn_vals = 1;
  *return_vals = values;

  /* get image and drawable */
  image_ID    = param[1].data.d_int32;
  drawable = gimp_drawable_get (param[2].data.d_drawable);
  
  /*how are we running today? */
  switch (run_mode)
  {
    case RUN_INTERACTIVE:
      /* Possibly retrieve data from a previous run */
      gimp_get_data (PLUG_IN_NAME, &rotvals);
      rotvals.angle = rotvals.angle % NUM_ANGLES;

      /* Get information from the dialog */
      if (!rotate_dialog())
		return;
      break;

    case RUN_NONINTERACTIVE:
      /* check to see if invoked with the correct number of parameters */
      if (nparams == NUMBER_IN_ARGS)
	{
	  rotvals.angle = (gint) param[3].data.d_int32;
	  rotvals.angle = rotvals.angle % NUM_ANGLES;
	}
      else
	status = STATUS_CALLING_ERROR;
      
      break;

  case RUN_WITH_LAST_VALS:
    /* Possibly retrieve data from a previous run */
    gimp_get_data (PLUG_IN_NAME, &rotvals);
    rotvals.angle = rotvals.angle % NUM_ANGLES;
    
    break;
    
  default:
    break;
  }

  if (status == STATUS_SUCCESS)
  {
    /*  Make sure that we work on a layer and only one layer */
    gimp_image_get_layers (image_ID, &nlayers);  
    if ((gimp_drawable_layer (drawable->id)) && (nlayers == 1)) 
      {
	/* Set the number of tiles you want to cache */
	gimp_tile_cache_ntiles (2 * (drawable->width / gimp_tile_width ()
				     + 1));
	
	/* Run the main function */
	rotate();
	
	/* If run mode is interactive, flush displays, else (script) don't 
	   do it, as the screen updates would make the scripts slow */
	if (run_mode != RUN_NONINTERACTIVE)
	  gimp_displays_flush ();
	
	/* Store variable states for next run */
	if (run_mode == RUN_INTERACTIVE)
	  gimp_set_data (PLUG_IN_NAME, &rotvals, sizeof (RotateValues));
      }
    else
      ErrorMessage("Sorry. Rotation only works on single-layer images.");
      status = STATUS_EXECUTION_ERROR;
  }
  values[0].data.d_status = status;
  
}


/* Some helper functions */

static void
rotate_compute_offsets (gint* offsetx,
			gint* offsety,
			gint image_width, gint image_height,
			gint width, gint height)
{
  gint buffer;

  switch ( rotvals.angle )
    {
    case 1:   /* 90 */
      buffer   = *offsetx;
      *offsetx = image_height - *offsety - height;
      *offsety = buffer;
      break;
    case 3:   /* 270 */
      buffer   = *offsetx;
      *offsetx = *offsety;
      *offsety = image_width - buffer - width;
    }
  return;
}




/* The main rotate function */
static void 
rotate (void)
{
  GPixelRgn srcPR, destPR;
  gint image_width, image_height;
  gint width, height, bytes;
  gint row, col, byte;
  gint offsetx, offsety;
  guchar *src_row, *dest_row, *dest_col;
  GDrawable *new_drawable;
  gint32 new_drawable_ID;
  gint nreturn_vals;

  if (rotvals.angle == 0) return;  

  gimp_progress_init ("Rotating...");
	  
  /* Get the size of the input drawable. */
  width = drawable->width;
  height = drawable->height;
  bytes = drawable->bpp;


  if (rotvals.angle == 2)  /* we're rotating by 180 */
    {  
      gimp_pixel_rgn_init (&srcPR, drawable, 0, 0, width, height, 
			   FALSE, FALSE);
      gimp_pixel_rgn_init (&destPR, drawable, 0, 0, width, height,
			   TRUE, TRUE);
      
      src_row = (guchar *) malloc (width * bytes);
      dest_row = (guchar *) malloc (width * bytes);
      
      for (row = 0; row < height; row++)
	{
	  gimp_pixel_rgn_get_row (&srcPR, src_row, 0, row, width); 
	  for (col = 0; col < width; col++) 
	    { 
	      for (byte = 0; byte < bytes; byte++)
		{
		  dest_row[col * bytes + byte] =  
		    src_row[(width - col - 1) * bytes + byte];
		}
	    } 	    
	  gimp_pixel_rgn_set_row (&destPR, dest_row, 0, (height - row - 1), 
				  width);
	  
	  if ((row % 5) == 0)
	    gimp_progress_update ((double) row / (double) height);
	}

      gimp_progress_update ( 1.0 );
 
      free (src_row);
      free (dest_row);
 
      gimp_drawable_flush (drawable); 
      gimp_drawable_merge_shadow (drawable->id, TRUE); 
      gimp_drawable_update (drawable->id, 0, 0, width, height); 

      /* Set the reference counter back by one */
      gimp_drawable_detach (drawable);
    }
  else                     /* we're rotating by 90 or 270 */
    {
      gimp_image_disable_undo ( image_ID );

      /* resize the image */
      image_width = gimp_image_width (image_ID);
      image_height = gimp_image_height (image_ID);
      gimp_image_resize (image_ID, image_height, image_width, 0, 0);

      /* create a new drawable to hold the rotated one */
      new_drawable_ID = gimp_layer_new (image_ID, 
					gimp_drawable_name (drawable->id),
					height,
					width,
					gimp_drawable_type (drawable->id),
					gimp_layer_get_opacity (drawable->id),
					gimp_layer_get_mode (drawable->id));
      new_drawable = gimp_drawable_get (new_drawable_ID);

      gimp_drawable_offsets (drawable->id, &offsetx, &offsety);
      rotate_compute_offsets (&offsetx, &offsety, 
			      image_width, image_height, width, height); 
      gimp_layer_set_offsets (new_drawable_ID, offsetx, offsety);

      gimp_image_add_layer (image_ID, new_drawable_ID, -1);
      
      gimp_pixel_rgn_init (&srcPR, drawable, 0, 0, width, height, 
			   FALSE, FALSE);
      gimp_pixel_rgn_init (&destPR, new_drawable, 0, 0, height, width,
			   TRUE, FALSE);
      
      src_row = (guchar *) malloc (width * bytes);
      dest_col = (guchar *) malloc (width * bytes);
      
      if (rotvals.angle == 1)     /* we're rotating by 90 */
	{
	  for (row = 0; row < height; row++)
	    {
	      gimp_pixel_rgn_get_row (&srcPR, src_row, 0, row, width); 
	      for (col = 0; col < width; col++) 
		{ 
		  for (byte = 0; byte < bytes; byte++)
		    {
		      dest_col[col * bytes + byte] =  
			src_row[col * bytes + byte];
		    }
		} 	    
	      gimp_pixel_rgn_set_col (&destPR, dest_col, (height - row - 1), 0,
				      width);

	      if ((row % 5) == 0)
		gimp_progress_update ((double) row / (double) height);
	    }
	}
      else                        /* we're rotating by 270 */
	{
	  for (row = 0; row < height; row++)
	    {
	      gimp_pixel_rgn_get_row (&srcPR, src_row, 0, row, width); 
	      for (col = 0; col < width; col++) 
		{ 
		  for (byte = 0; byte < bytes; byte++)
		    {
		      dest_col[col * bytes + byte] =  
			src_row[(width - col - 1) * bytes + byte];
		    }
		} 	    
	      gimp_pixel_rgn_set_col (&destPR, dest_col, row, 0, width);

	      if ((row % 5) == 0)
		gimp_progress_update ((double) row / (double) height);
	    }
	}
 
      gimp_progress_update ( 1.0 );
  
      free (src_row);
      free (dest_col);
      
      gimp_image_remove_layer (image_ID, drawable->id);
      gimp_drawable_delete (drawable);
      
      gimp_drawable_flush (new_drawable); 
      gimp_drawable_update (new_drawable->id, 0, 0, height, width); 

      gimp_image_enable_undo ( image_ID );

      /* Set the reference counter back by one */
      gimp_drawable_detach (new_drawable);
    }  
  return;
}


/* Rotate dialog */

static gint 
rotate_dialog (void)
{
  GtkWidget *dialog;
  GtkWidget *button;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *radio_button;
  GSList    *radio_group = NULL;
  gint radio_pressed[NUM_ANGLES];
  gint argc = 1;
  gint i;
  gchar **argv = g_new (gchar *, 1);
  argv[0] = g_strdup ("Rotate");

  for (i=0;i<NUM_ANGLES;i++)
    {
      radio_pressed[i] = (rotvals.angle == i);
    }

  /* Init GTK  */
  gtk_init (&argc, &argv);
  gtk_rc_parse (gimp_gtkrc ());

  gdk_set_use_xshm (gimp_use_xshm ());
  gtk_widget_set_default_visual (gtk_preview_get_visual ());

  /* Main Dialog */
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), PLUG_IN_PRINT_NAME);
  gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy",
		      (GtkSignalFunc) rotate_close_callback,
		      NULL);
  /*  Action area  */
  button = gtk_button_new_with_label ("OK");
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      (GtkSignalFunc) rotate_ok_callback,
                      dialog);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), 
		      button, TRUE, TRUE, 0);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);

  button = gtk_button_new_with_label ("Cancel");
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			     (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (dialog));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), 
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);

  /*  parameter settings  */
  frame = gtk_frame_new ("Rotate clockwise by:");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_container_border_width (GTK_CONTAINER (frame), 10);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), 
		      frame, TRUE, TRUE, 0);

  /* hbox for radio_buttons */
  vbox = gtk_vbox_new (FALSE, 1);
  gtk_container_border_width (GTK_CONTAINER (vbox), 10);

  /* put the hbox in the frame */
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  /* radio buttons */

  for (i = 0; i < NUM_ANGLES; i++)
    { radio_button = gtk_radio_button_new_with_label (radio_group, 
						      angle_label[i]);
      radio_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radio_button));
      gtk_box_pack_start (GTK_BOX (vbox), radio_button, TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT (radio_button), "toggled",
			  (GtkSignalFunc) rotate_toggle_update,
			  &radio_pressed[i]);
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio_button), 
				   radio_pressed[i]);
      gtk_widget_show (radio_button);
    }

  gtk_widget_show (vbox);
  gtk_widget_show (frame);
  gtk_widget_show (dialog);

  gtk_main ();
  gdk_flush ();

  rotvals.angle=0;
  for (i = 0; i < NUM_ANGLES; i++)
    {
      if (radio_pressed[i]==TRUE)
	{
	  rotvals.angle = i;
	  break;
	}
    }

  return rotint.run;
}


/*  Rotate interface functions  */

static void
rotate_close_callback (GtkWidget *widget,
		       gpointer   data)
{
  gtk_main_quit ();
}

static void
rotate_ok_callback (GtkWidget *widget,
		    gpointer   data)
{
  rotint.run = TRUE;
  gtk_widget_destroy (GTK_WIDGET (data));
}

static void
rotate_toggle_update (GtkWidget *widget,
		      gpointer   data)
{
  gint *toggle_val;

  toggle_val = (int *) data;

  if (GTK_TOGGLE_BUTTON (widget)->active)
    *toggle_val = TRUE;
  else
    *toggle_val = FALSE;
}


/* Error Message 
 * 
 * This code was stolen from Pavel Greenfield's Colormap Rotation plug-in */

static void 
ErrorMessage(guchar *message)
{
  GtkWidget *window, *label, *button, *table;
  gchar **argv=g_new (gchar *, 1);
  gint argc=1;
  argv[0] = g_strdup ("rotate");
  gtk_init (&argc, &argv);
  gtk_rc_parse (gimp_gtkrc ());
  
  window=gtk_dialog_new();
  gtk_window_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
  gtk_window_set_title(GTK_WINDOW(window), "Rotate Error Message");
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      (GtkSignalFunc) rotate_close_callback,
		      NULL);
  
  button = gtk_button_new_with_label ("Got It!");
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      (GtkSignalFunc) rotate_ok_callback,
                      window);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), button, TRUE, TRUE, 0);
 
  table=gtk_table_new(2,2,FALSE);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),table,TRUE,TRUE,0);
  gtk_widget_show(table);
  
  label=gtk_label_new("");
  gtk_label_set(GTK_LABEL(label),message);
  gtk_widget_show(label);
  gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,
		   GTK_FILL|GTK_EXPAND,GTK_FILL|GTK_EXPAND,15,15);
  
  gtk_widget_show(window);
  gtk_main ();
}


