/* skkserv.h
 * SKK Server Version 3.5.2 of May 13, 1991
 * Copyright (C) 1991 Yukiyoshi Kameyama (kam@sato.riec.tohoku.ac.jp)
 *
 * Programmed by
 * Yukiyoshi Kameyama (kam@sato.riec.tohoku.ac.jp)
 * Research Institute of Electrical Communication
 * Tohoku University
 *
 * Contributed by 
 * Nobu Takahashi (nt@hpycla.yhp.co.jp) for System V patch
 * Chikahiro Kimura (kimura@2oa.kb.nec.co.jp) for "ntohs" bug
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 1, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with SKK, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Compatibilities */
#ifdef HP-UX
#define NO_TIOCNOTTY
#define NO_BZERO
#define NO_GETDTABLESIZE
#endif

/* if your hostent structure defined in "netdb.h" does not have */
/* h_addr_list, uncomment the following line */
/* #define NO_ADDR_LIST */
/* Necessary for SunOS 3.x and maybe other old systems */


#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/ioctl.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>
#ifdef NO_TIOCNOTTY
#include	<signal.h>
#endif

#ifndef DEFAULT_JISYO
#define DEFAULT_JISYO 	"/usr/local/nemacs/etc/SKK-JISYO.L"	
#endif
					/* default jisho name */
#define SERVICE_NAME	"skkserv"	/* service name */

#ifdef PRIVATE
#define PORTNUM	1178
#endif

#define	MAXQUE		5
#ifdef NO_GETDTABLESIZE
#define MAXDTAB		_NFILE
#else
#define MAXDTAB		getdtablesize()	
				/* max number of file descriptors */
				/* it returns 64 on SunOS 4.x & NEWS OS 3.3 */
				/* it returns 30 on SunOS 3.x & NEWS OS 2.2 */
				/* 20 is guaranteed value on all machines */
#endif
#define MAXCLNT		64	/* max number of clients */
#define	BUFSIZE		512	/* max size of a request */
#define KANAMOJI	100	/* number of KANA moji */

/*
 * bit-operation in select
 */
#ifndef FD_SET
#define	NFDBITS	(sizeof(long) * 8)
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define	FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif


