.\" X-BASED MASTERBALL(tm)
.\"
.\" xmball.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 99	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH MASTERBALL 6 "20 June 1999" "V5.5"
.SH NAME
xmball \- Masterball X widget
.SH SYNOPSIS
.B /usr/games/xmball
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-{border|bd} {color}] [-wedge{0|1|2|3|4|5|6|7} {color}]
[-wedges {int}] [-rings {int}] [-[no]orient] [-[no]practice]
[-base {int}] [-username {string}]
.SH DESCRIPTION
.LP
The original puzzle has 8 sectors on a sphere (longitudinal cuts), with
each sector divided into 4 segments (latitudinal cuts).  There are
essentially 3 varieties: Geomaster 8 colors (beachball, default colors
in this puzzle), Duomaster 2 colors (black and white beachball), and a
variety of picture Masterballs.  For some reason, they say the Geomaster
is harder than the Duomaster.  The picture Masterballs are the hardest
since all the pieces have a set solved postion.  On the Duo and Geo
Masterballs pieces could be swapped or in a different order and still be
in a solved postion.  Zurick University's Mathematics faculty has
calculated that Masterball's 32 segments can be arranged in
355,682,548,566,633,480,192,000,000 different possible combinations.
Masterball was invented by Dr. Geza Gyovai Hungarian Engineer,
manufactured by Whole Systems Design, Inc..
.SH FEATURES
Press "\fBmouse-left\fP" button to move a sector.  Release
"\fBmouse-left\fP" button on another piece and the pieces will turn
towards where the mouse button is released.  Usually, a click and release
on the same wedge is ambiguous and the puzzle will not turn.
.LP
Click "\fBmouse-center\fP", or press "\fBP\fP" or "\fBp\fP" keys to toggle
the practice mode (in practice mode the record should say "practice").
One must double click on "\fBmouse-center\fP" if the puzzle is being worked
on.  This is good for learning moves and experimenting.
.LP
Click "\fBmouse-right\fP", or press "\fBR\fP" or "\fBr\fP" keys to randomize
(this must be done first to set a new record).  One must double click on
"\fBmouse-right\fP" if the puzzle is being worked on.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increase the number of rings.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrease the number of rings.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  One has to
orient the wedges in orient mode, besides getting all the wedges to be the
same color.  To do this one has to get the numbers to be on the same side
of the ball in clockwise order.
.LP
Press "\fB2\fP", "\fB4\fP", "\fB6\fP", or  "\fB8\fP" keys (not the keypad
2, 4, 6, 8) to change to 2, 4, 6, or 8 wedges, respectively.  Note: if
there were odd number of wedges, there would be no 180 degree turn and
therefore the puzzle would be inoperable.
.LP
"\fBS\fP" or "\fBs\fP" are reserved for the auto-solver (unimplemented).
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad, "R" keys, or arrow keys to move without mouse clicks.
.br
Key pad is defined for Masterball as:
.br
  /     Counterclockwise
.sp
7 8 9   Upper Left, Up, Upper Right
.br
  ^
.br
4<5>6   Left, Clockwise, Right
.br
  v
.br
1 2 3   Lower Left, Down, Lower Right
.LP
Use the control key and the left mouse button, keypad, or arrow keys to
move the whole Masterball.  This is not recorded as a turn.
.LP
The title is in the following format (non-motif version):
.RS
xmball.{2|4|6|8<wedges>}: <number of sectors per wedge> @
(<Number of moves>/{<Record number of moves> <username>|"NEVER
noaccess"|"practice"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the masterball window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to  display on a color screen as if monochrome
(resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the masterball window in reverse video
(resource name "\fIreverse\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the masterball window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the masterball window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the sectors in the masterball
window (resource name "\fIborderColor\fP").
.TP 8
.B \-wedge{0|1|2|3|4|5|6|7} <\fIcolor\fP>
This option allows you to change the color of a wedge (resource name
"\fIwedgeColorN\fP"). In mono-mode, color is represented as the first letter
of the color name. The wedges are ordered clockwise.  If you have two colors
that begin with the same letter you should have one in uppercase and one in
lowercase to distinguish them in mono-mode. You can change the colors of the
wedges to make a stupid Masterball (i.e. all White or in mono-mode all "W").
Unfortunately, it will not normally say its solved when its randomized.
Similarly, with the Duomasterball (black and white), it may be solved
color-wise but not by its internal representation.  This would be cheating.
.TP 8
.B \-wedges <\fIint\fP>
This option allows you to change the number of wedges (resource name
"\fIwedges\fP").
.TP 8
.B \-rings <\fIint\fP>
This option allows you to change the number of rings (resource name
"\fIrings\fP").
.TP 8
.B \-[no]orient
This option allows you to access the orient mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]practice
This option allows you to access the practice mode (resource name
"\fIpractice\fP").
.TP 8
.B \-base \fIint\fP
This option specifies the base used (default is base 16) (resource name
"\fIbase\fP").  When there are 12 wedges there is not much room, so base
10 was not used as the default.
.TP 8
.B \-username \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
Masterball numbered clockwise, with default colors, not randomized:
.br
    0            Y       Yellow
.br
 7     1      D     B    Dark Green, Blue
.sp
6       2    C       R   Cyan, Red
.sp
 5     3      O     M    Orange, Magenta
.br
    4            G       Green
.sp
.RS
wedges: 1-8 <number of wedges around ball>
.br
rings: 1-MAXINT <number of slices around ball>
.br
orient: 0-1 <0 false, 1 true; if true then numbers on puzzle to be
oriented and ordered>
.br
practice: 0-1 <0 false, 1 true>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <2 dimensional array of sector wedge position,
if orient mode then orientation number follows each wedge number>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <wedge> <ring> <direction> <control>
.RE
Each turn is with respect to a sector defined by wedge and ring.
.br
Direction is represented as 0 up, 1 right, 2 down, 3 left, 4 upper right,
5 lower right, 6 lower left, 7 upper left, 9 clockwise, and 15
counterclockwise.
.br
Control is represented as 0 or 1, 1 if the whole ball is moved at once, 0
if not.  The xmball record keeper does not count a control move as a move,
but here we do.
.sp
Caution: the program may crash on corrupted input.
.SH REFERENCES
http://wsd.com/masterball
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6),
xmlink(6), xpanex(6), xcubes(6), xtriangles(6), xhexagons(6), xabacus(1)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-99, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
.br
\fIftp://ftp.x.org/contrib/games\fP

