/* 
 * Copyright (C) 1995 Andrew Scherpbier <Andrew@sdsu.edu>
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _state_h_
#define _state_h_

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "conf.h"
#include "tcp.h"

typedef enum
{
	Connected,
	Not_connected,
	Waiting_between_connect_attempts,
} CState;

/*
 * The following structure contains all the state information that is used throughout the
 * xrplay program.  (Basically global variables grouped into one place...)
 */
typedef struct
{
	char		*rptp_host;
	int			rptp_port;
	int			debug;				/* debug level.  0 == no debug, >1 more debug */
	CState		command_state;
	CState		data_state;
	char		*program_name;
	Connection	*command;
	Connection	*data;
	char		*version;
	int			is_playing;			/* Flags to indicate that sounds are playing or paused */
	int			is_paused;
	int			playing_sounds;		/* This is set when sounds are played by xrplay itself */
	int			currently_playing;	/* We are actively playing a sound */
	int			started_playing;	/* TRUE if we have started playing the sound list at least once */
	char		current_id[20];		/* spool id of the sound we are working on */
	int			volume;				/* The volume for playing sounds */
	int			quit;				/* Quit after playing all sounds. */
	char		audio_port[128];
} State;


extern State	state;

#endif

/*
 * Local variables:
 * tab-width: 4
 * End:
 */
