/* 
 * Copyright (C) 1995 Andrew Scherpbier <Andrew@sdsu.edu>
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _io_h_
#define _io_h_

typedef void (*Callback)();

void register_read(int fd, Callback callback);
void register_process(int fd, Callback callback);
void register_write(int fd, Callback callback);

void io_write_line(int fd, char *fmt, ...);
void io_write(int fd, char *data, int length, Callback callback);
void read_proc(int fd);
void write_proc(int fd);

#endif

/*
 * Local variables:
 * tab-width: 4
 * End:
 */
