/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _buffer_h
#define _buffer_h

#include "conf.h"

#define BUFFER_SIZE	1024	/* must be >= RPTP_MAX_LINE */

/*
 * Maximum number of buffers to have on the free list.
 * The number should really depend on the value of BUFFER_SIZE.
 */
#define BUFFER_MAX_FREE	16

#define BUFFER_FREE	0	/* a temporary buffer */
#define BUFFER_KEEP	1	/* a permanent buffer */

typedef struct _buffer
{
	struct _buffer	*next;
	int		nbytes;
	char		buf[BUFFER_SIZE];
	int		status;
} BUFFER;

#ifdef __STDC__
BUFFER	*buffer_create(void);
void	buffer_destroy(BUFFER *b);
#else
BUFFER	*buffer_create();
void	buffer_destroy(/* BUFFER *b */);
#endif

#endif /* _buffer_h */
