/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _conf_h
#define _conf_h

/*
 * rplay configuration options and settings
 *
 * Toggle options using #define and #undef.
 */

/*
 * mmap sound files instead of malloc
 */
#define MMAP

/*
 * host authentication
 */
#define AUTH	

/*
 * support rplay 2.0 packets, defining this won't hurt much
 */
#define OLD_RPLAY

/*
 * maximum number of simultaneous sounds
 */
#define SPOOL_SIZE	12

/*
 * do you need strdup?
 *
 * This must be defined for Ultrix.
 */
#undef NEED_STRDUP

/*
 * size of rplayd's hash table
 */
#define MAX_SOUNDS	4001	/* yes that is a prime number */

/*
 * rplay configuration file
 */
#define RPLAY_CONF	"/usr/local/etc/rplay.conf"

/*
 * rplay host authentication file to use if AUTH is enabled
 */
#ifdef AUTH
#define RPLAY_HOSTS	"/usr/local/etc/rplay.hosts"
#endif /* AUTH */

/*
 * rplay servers file
 */
#define RPLAY_SERVERS	"/usr/local/etc/rplay.servers"

/*
 * rplay cache directory
 */
#define RPLAY_CACHE	"/tmp/rplay.cache"

/*
 * The default rplay log file.
 */
#define RPLAY_LOG	"/tmp/rplay.log"

/*
 * Define the default rplayd logging level:
 * 	0 - No logging.
 *	1 - System and rplayd errors.
 *	2 - " + RPTP connections, get, put, find.
 *	3 - " + play, stop, pause, continue, etc.
 *	4 - " + Debug messages. 
 *
 * Use 0 if you do not want logging.  Note that the logging
 * level can also be specified with rplayd command line options.
 */
#define RPLAY_LOG_LEVEL		2

/*
 * maximum packet size
 */
#define MAX_PACKET		8192

/*
 * exit after 360 idle seconds (disabled with zero)
 */
#define RPLAYD_TIMEOUT		360

/*
 * name of the audio device (SGI users can ignore this)
 */
#define AUDIO_DEVICE		"/dev/audio"

/*
 * close the audio device after 5 idle seconds (disabled with zero)
 */
#define AUDIO_TIMEOUT		5

/*
 * maximum size of the rplay.cache directory
 *
 * 100k is good for debugging.
 *
 * The size you choose should at least be big enough to hold the
 * largest sound you plan on playing.
 */
#define RPLAY_CACHE_SIZE	(1024*1024)

/*
 * delay time between RPTP server pings
 */
#define RPTP_PING_DELAY		5

/*
 * number of times to try and connect to an RPTP server
 */
#define RPTP_CONNECT_ATTEMPTS	3

/*
 * close RPTP connections after 300 idle seconds
 */
#define RPTP_CONNECTION_TIMEOUT	300

/*
 * maximum number of RPTP client connections (disabled with zero)
 */
#define RPTP_MAX_CONNECTIONS	16

/*
 * free memory used by sounds after 60 idle seconds
 */
#define SOUND_CLEANUP_TIMEOUT	60

/*
 * The sample rate of your audio device.
 * Sun's use 8000 samples per second.
 */
#define AUDIO_SAMPLE_RATE	8000
#define AUDIO_RATE		20
#define AUDIO_BUFSIZE		(AUDIO_SAMPLE_RATE / AUDIO_RATE)

/*************** EVERYTHING BELOW THIS LINE SHOULD BE OK *********************/

/*
 * Use the correct PORTABLE_LONG definition depending on your machine's
 * architecture.
 */
#ifdef i386
/*
 * Little endian architectures
 */
#define PORTABLE_LONG(buf) (unsigned long )(((( \
	((((unsigned long )((unsigned char *)(buf))[0]) << 8) | \
	(unsigned long )((unsigned char *)(buf))[1]) << 8) | \
	(unsigned long )((unsigned char *)(buf))[2]) << 8) | \
	(unsigned long )((unsigned char *)(buf))[3])
#else
/*
 * Big endian architectures
 */
#define PORTABLE_LONG(buf) *(unsigned long *)(buf)
#endif

/*
 * Solaris 2.x using gcc or SunPro cc and HP-UX
 */
#if (defined(sun) && (defined(__svr4__) || defined(SVR4))) || defined(__hpux)
#define random()	lrand48()
#define srandom(x)	srand48(x)
#endif

#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif

#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif

#endif /* _conf_h */
