#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/bitmaps/gray1>
#include <X11/bitmaps/gray3>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "al.h"

static char	*colornames[] =
{
	"gray80",
	"black",
	"gray94",
	"gray40",
	"gray72",
	"white",
	"black",
};

AL_state	state;

static void al_color_init()
{
	XGCValues		values;
	XColor			color;
	XColor			rcolor;
	int				i;

	state.color = True;
	state.colormap = DefaultColormap(state.display, state.screen);
	for (i = 0; i < AL_MAX_COLORS; i++)
	{
		XAllocNamedColor(state.display, state.colormap, colornames[i], &color, &rcolor);
		state.colors[i] = rcolor.pixel;
	}
	values.foreground = state.colors[AL_FOREGROUND];
	values.background = state.colors[AL_BACKGROUND];
	values.font = state.normal_font->fid;
	values.fill_style = FillStippled;
	values.stipple = state.stipple3;

	state.gc[GC_NORMAL] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont | GCStipple, &values);
	state.gc[GC_REVERSE] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont | GCStipple, &values);
	state.gc[GC_BUSY] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont | GCFillStyle | GCStipple, &values);
	state.gc[GC_BRIGHT_SLOPE] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont, &values);
	state.gc[GC_DARK_SLOPE] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont, &values);
	state.gc[GC_SELECTED] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont, &values);
	XSetForeground(state.display, state.gc[GC_REVERSE], state.colors[AL_BACKGROUND]);
	XSetBackground(state.display, state.gc[GC_REVERSE], state.colors[AL_FOREGROUND]);
	XSetForeground(state.display, state.gc[GC_BRIGHT_SLOPE], state.colors[AL_BRIGHT_SLOPE]);
	XSetForeground(state.display, state.gc[GC_DARK_SLOPE], state.colors[AL_DARK_SLOPE]);
	XSetForeground(state.display, state.gc[GC_SELECTED], state.colors[AL_SELECTED]);
	XSetFunction(state.display, state.gc[GC_BUSY], GXcopy);
}


static void al_mono_init()
{
	XGCValues		values;

	state.color = False;
	values.foreground = BlackPixel(state.display, state.screen);
	values.background = WhitePixel(state.display, state.screen);
	values.font = state.normal_font->fid;
	values.stipple = state.stipple3;

	state.gc[GC_NORMAL] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont | GCStipple, &values);
	values.fill_style = FillStippled;
	state.gc[GC_BUSY] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont | GCFillStyle | GCStipple, &values);
	values.stipple = state.stipple1;
	values.fill_style = FillOpaqueStippled;
	state.gc[GC_BRIGHT_SLOPE] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont | GCFillStyle | GCStipple, &values);
	state.gc[GC_DARK_SLOPE] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont, &values);
	state.gc[GC_SELECTED] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont, &values);
	state.gc[GC_REVERSE] = XCreateGC(state.display,
		RootWindow(state.display, state.screen),
		GCForeground | GCBackground | GCFont | GCStipple, &values);
	XSetForeground(state.display, state.gc[GC_SELECTED], values.background);
	XSetBackground(state.display, state.gc[GC_SELECTED], values.foreground);
	XSetForeground(state.display, state.gc[GC_REVERSE], values.background);
	XSetBackground(state.display, state.gc[GC_REVERSE], values.foreground);
	XSetFunction(state.display, state.gc[GC_BUSY], GXcopy);
}


void al_init(Display *display)
{
	state.display = display;
	state.screen = DefaultScreen(display);
	state.normal_font = XLoadQueryFont(display, DEFAULT_FONT);
	state.bold_font = XLoadQueryFont(display, BOLD_FONT);

	state.stipple1 = XCreateBitmapFromData(display, RootWindow(display, state.screen),
		gray1_bits, gray1_width, gray1_height);
	state.stipple3 = XCreateBitmapFromData(display, RootWindow(display, state.screen),
		gray3_bits, gray3_width, gray3_height);

	state.visual = DefaultVisual(state.display, state.screen);
	if (DefaultDepth(display, state.screen) == 1)
		al_mono_init();
	else
		al_color_init();
}


Window CreateWindow(int width, int height)
{
	Window	win;

	win = XCreateSimpleWindow(state.display, RootWindow(state.display, state.screen),
		0, 0, width, height, 0, state.colors[AL_FOREGROUND], state.colors[AL_BACKGROUND]);

	return win;
}


void al_drawbox(Window win, int x, int y, int width, int height, int mode, int thick)
{
	int		i;
	XPoint	points[6];

	switch (mode)
	{
		case AL_3D_OUT:
			points[0].x = x - thick;			points[0].y = y - thick;
			points[1].x = width + 2 * thick;	points[1].y = 0;
			points[2].x = -thick;				points[2].y = thick;
			points[3].x = -width;				points[3].y = 0;
			points[4].x = 0;					points[4].y = height;
			points[5].x = -thick;				points[5].y = thick;
			XFillPolygon(state.display, win, state.gc[GC_BRIGHT_SLOPE],
				points, 6, Nonconvex, CoordModePrevious);
												points[0].y = y + height + thick;
			points[1].x = thick;				points[1].y = -thick;
			points[2].x = width;				points[2].y = 0;
			points[3].x = 0;					points[3].y = -height;
			points[4].x = thick;				points[4].y = -thick;
			points[5].x = 0;					points[5].y = height + 2 * thick;
			XFillPolygon(state.display, win, state.gc[GC_DARK_SLOPE],
				points, 6, Nonconvex, CoordModePrevious);
			break;

		case AL_3D_IN:
			points[0].x = x - thick;			points[0].y = y - thick;
			points[1].x = width + 2 * thick;	points[1].y = 0;
			points[2].x = -thick;				points[2].y = thick;
			points[3].x = -width;				points[3].y = 0;
			points[4].x = 0;					points[4].y = height;
			points[5].x = -thick;				points[5].y = thick;
			XFillPolygon(state.display, win, state.gc[GC_DARK_SLOPE],
				points, 6, Nonconvex, CoordModePrevious);
												points[0].y = y + height + thick;
			points[1].x = thick;				points[1].y = -thick;
			points[2].x = width;				points[2].y = 0;
			points[3].x = 0;					points[3].y = -height;
			points[4].x = thick;				points[4].y = -thick;
			points[5].x = 0;					points[5].y = height + 2 * thick;
			XFillPolygon(state.display, win, state.gc[GC_BRIGHT_SLOPE],
				points, 6, Nonconvex, CoordModePrevious);
			break;

		case AL_3D_FLAT:
			points[0].x = x - thick;			points[0].y = y - thick;
			points[1].x = width + 2 * thick;	points[1].y = 0;
			points[2].x = -thick;				points[2].y = thick;
			points[3].x = -width;				points[3].y = 0;
			points[4].x = 0;					points[4].y = height;
			points[5].x = -thick;				points[5].y = thick;
			XFillPolygon(state.display, win, state.gc[GC_REVERSE],
				points, 6, Nonconvex, CoordModePrevious);
												points[0].y = y + height + thick;
			points[1].x = thick;				points[1].y = -thick;
			points[2].x = width;				points[2].y = 0;
			points[3].x = 0;					points[3].y = -height;
			points[4].x = thick;				points[4].y = -thick;
			points[5].x = 0;					points[5].y = height + 2 * thick;
			XFillPolygon(state.display, win, state.gc[GC_REVERSE],
				points, 6, Nonconvex, CoordModePrevious);
			break;
	}
}

