#ifndef	_al_h_
#define	_al_h_

enum
{
	AL_3D_OUT,
	AL_3D_IN,
	AL_3D_FLAT,
	AL_3D_OUT_SELECTED,
	AL_3D_IN_SELECTED,
};

enum
{
	AL_BACKGROUND,
	AL_FOREGROUND,
	AL_BRIGHT_SLOPE,
	AL_DARK_SLOPE,
	AL_SELECTED,
	AL_WHITE,
	AL_BLACK,
	AL_MAX_COLORS,
};

enum
{
	GC_NORMAL,
	GC_REVERSE,
	GC_BUSY,
	GC_SELECTED,
	GC_BRIGHT_SLOPE,
	GC_DARK_SLOPE,

	NUM_GC,
};

typedef struct
{
	Display			*display;
	GC				gc[NUM_GC];
	int				screen;
	XFontStruct		*normal_font;
	XFontStruct		*bold_font;
	Pixmap			stipple1;
	Pixmap			stipple3;
	int				color;
	Colormap		colormap;
	int				colors[AL_MAX_COLORS];
	Visual			*visual;
} AL_state;

extern AL_state		state;

#define	DEFAULT_FONT	"-b&h-lucida-medium-r-normal-sans-*-120-*-*-p-*-*-*"
#define	BOLD_FONT		"-b&h-lucida-bold-r-normal-sans-*-120-*-*-p-*-*-*"

#define	THREE_D_WIDTH	2

#endif	_al_h_
