#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "Button.h"
#include "al.h"


int in_rectangle(int ex, int ey, int x, int y, int width, int height)
{
	if (ex >= x && ex < x + width &&
	    ey >= y && ey < y + height)
		return 1;
	else
		return 0;
}


Button * CreateButton(Window win)
{
	Button	*button = (Button *) malloc(sizeof(Button));
	button->win = win;
	button->x = button->y = 0;
	button->width = button->height = 1;
	button->label = NULL;

	return button;
}


void SetButtonLocation(Button *button, int x, int y)
{
	button->x = x;
	button->y = y;
}


void SetButtonLabel(Button *button, char *label)
{
	if (button->label)
		free(button->label);
	button->label = strdup(label);
}


void SetButtonCallback(Button *button, void (*callback)(Button *))
{
	button->callback = callback;
}


void ButtonBusy(Button *button)
{
	XFillRectangle(state.display, button->win, state.gc[GC_BUSY],
		button->x, button->y, button->width, button->height);
}


void ButtonFeedback(Button *button, int t)
{
	switch (t)
	{
		case 0:
			XClearArea(state.display, button->win,
				button->x, button->y, button->width, button->height, False);
			al_drawbox(button->win, button->x, button->y,
				button->width, button->height, AL_3D_OUT, THREE_D_WIDTH);
			XDrawString(state.display, button->win, state.gc[GC_NORMAL],
				button->string_x, button->string_y,
				button->label, strlen(button->label));
			break;
		case 1:
			al_drawbox(button->win, button->x, button->y,
				button->width, button->height, AL_3D_IN, THREE_D_WIDTH);
			if (state.color)
			{
				XFillRectangle(state.display, button->win, state.gc[GC_SELECTED],
					button->x, button->y, button->width, button->height);
				XDrawString(state.display, button->win, state.gc[GC_NORMAL],
					button->string_x, button->string_y,
					button->label, strlen(button->label));
			}
			else
			{
				XFillRectangle(state.display, button->win, state.gc[GC_NORMAL],
					button->x + 1, button->y + 1, button->width - 2, button->height - 2);
				XDrawString(state.display, button->win, state.gc[GC_REVERSE],
					button->string_x, button->string_y,
					button->label, strlen(button->label));
			}
			break;
		case 2:
			XClearArea(state.display, button->win,
				button->x, button->y, button->width, button->height, False);
			al_drawbox(button->win, button->x, button->y,
				button->width, button->height, AL_3D_OUT, THREE_D_WIDTH);
			XDrawString(state.display, button->win, state.gc[GC_NORMAL],
				button->string_x, button->string_y,
				button->label, strlen(button->label));
			ButtonBusy(button);
			break;
	}
}


void ButtonRedraw(Button *button)
{
	int		direction, ascent, descent;
	XCharStruct	overall;

	/*
	 * Compute the button dimensions from the label string
	 */
	XTextExtents(state.normal_font, button->label, strlen(button->label),
		&direction, &ascent, &descent, &overall);

	button->width = overall.width + 16;
	button->height = state.normal_font->ascent + state.normal_font->descent + 5;
	button->string_x = button->x + 8;
	button->string_y = button->y + state.normal_font->ascent +  3;

	ButtonFeedback(button, 0);
}


void ButtonEventLoop(Button *button)
{
	XEvent	event;
	int	feedback = 1;

	/*
	 * Start feedback
	 */
	ButtonFeedback(button, 1);
	while (1)
	{
		XNextEvent(state.display, &event);
		switch (event.type)
		{
			case ButtonRelease:
				if (in_rectangle(event.xbutton.x, event.xbutton.y,
					 button->x, button->y, button->width, button->height))
				{
					if (button->callback)
					{
						ButtonFeedback(button, 2);
						feedback = 2;
						(*button->callback)(button);
					}
				}
				/*
				 * End feedback
				 */
				if (feedback)
					ButtonFeedback(button, 0);
				return;
			case MotionNotify:
				if (in_rectangle(event.xmotion.x, event.xmotion.y,
					 button->x, button->y, button->width, button->height))
				{
					if (!feedback)
					{
						ButtonFeedback(button, 1);
						feedback = 1;
					}
				}
				else
				{
					if (feedback)
					{
						ButtonFeedback(button, 0);
						feedback = 0;
					}
				}
				break;
			default:
				break;
		}
	}
}

int ButtonEvent(Button *button, XEvent *event)
{
	switch (event->type)
	{
		case ButtonPress:
			if (in_rectangle(event->xbutton.x, event->xbutton.y,
					 button->x, button->y, button->width, button->height))
			{
				ButtonEventLoop(button);
				return 1;
			}
			else
				return 0;
		default:
			return 0;
	}
}

