/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr


 * SPDX-License-Identifier: GPL-3.0-or-later


 ***************************************************************************/
/** @file
 * This file is a test for SKGComboBox component.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestcombobox.h"

#include <qtestkeyboard.h>

#include "skgcombobox.h"

void SKGTESTComboBox::Test()
{
    SKGComboBox combo;
    QVERIFY(combo.text() == QLatin1String(""));
    combo.setText(QLatin1String("Hello"));
    QVERIFY(combo.text() == QLatin1String("Hello"));

    combo.setEditable(false);
    QTest::keyClicks(&combo, QLatin1String("ABCD"));
    QCOMPARE(combo.text(), QLatin1String("Hello"));

    combo.setEditable(true);
    QTest::keyClicks(&combo, QLatin1String("ABCD"));
    QCOMPARE(combo.text(), QLatin1String("HelloABCD"));

    combo.setPalette(combo.palette());
}

QTEST_MAIN(SKGTESTComboBox)

