/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgservices.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    // ============================================================================
    {
        // Test bank document
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGBankObject bank(&document1);
        SKGAccountObject account;
        SKGUnitObject unit_euro(&document1);
        SKGUnitValueObject unit_euro_val1;
        QDate d1 = QDate::currentDate().addMonths(-6);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("BANK_T1"), err)

            // Creation bank
            SKGTESTERROR(QLatin1String("BANK:setName"), bank.setName(QLatin1String("CREDIT COOP")), true)
            SKGTESTERROR(QLatin1String("BANK:save"), bank.save(), true)

            // Creation account
            SKGTESTERROR(QLatin1String("BANK:addAccount"), bank.addAccount(account), true)
            SKGTESTERROR(QLatin1String("ACCOUNT:setName"), account.setName(QLatin1String("Courant steph")), true)
            SKGTESTERROR(QLatin1String("ACCOUNT:save"), account.save(), true)

            // Creation unit
            SKGTESTERROR(QLatin1String("UNIT:setName"), unit_euro.setName(QLatin1String("euro")), true)
            SKGTESTERROR(QLatin1String("UNIT:save"), unit_euro.save(), true)

            // Creation unitvalue
            SKGTESTERROR(QLatin1String("UNIT:addUnitValue"), unit_euro.addUnitValue(unit_euro_val1), true)
            SKGTESTERROR(QLatin1String("UNITVALUE:setQuantity"), unit_euro_val1.setQuantity(1), true)
            SKGTESTERROR(QLatin1String("UNITVALUE:setDate"), unit_euro_val1.setDate(d1), true)
            SKGTESTERROR(QLatin1String("UNITVALUE:save"), unit_euro_val1.save(), true)

            // Creation operation
            SKGOperationObject op;
            SKGTESTERROR(QLatin1String("ACCOUNT:addOperation"), account.addOperation(op), true)
            SKGTESTERROR(QLatin1String("OPE:setMode"), op.setMode(QLatin1String("cheque")), true)
            SKGTESTERROR(QLatin1String("OPE:setDate"), op.setDate(d1), true)
            SKGTESTERROR(QLatin1String("OPE:setUnit"), op.setUnit(unit_euro), true)
            SKGTESTERROR(QLatin1String("OPE:save"), op.save(), true)

            SKGSubOperationObject subop1;
            SKGTESTERROR(QLatin1String("OPE:addSubOperation"), op.addSubOperation(subop1), true)
            SKGTESTERROR(QLatin1String("SUBOPE:setQuantity"), subop1.setQuantity(21), true)
            SKGTESTERROR(QLatin1String("SUBOPE:save"), subop1.save(), true)
            SKGSubOperationObject subop2;
            SKGTESTERROR(QLatin1String("OPE:addSubOperation"), op.addSubOperation(subop2), true)
            SKGTESTERROR(QLatin1String("SUBOPE:setQuantity"), subop2.setQuantity(1), true)
            SKGTESTERROR(QLatin1String("SUBOPE:save"), subop2.save(), true)

            SKGTrackerObject tracker(&document1);
            SKGTrackerObject trackerCopy(tracker);
            SKGTrackerObject trackerCopy2(static_cast<SKGObjectBase>(tracker));
            SKGTESTERROR(QLatin1String("REF:setName"), tracker.setName(QLatin1String("tracker")), true)
            SKGTESTERROR(QLatin1String("REF:setComment"), tracker.setComment(QLatin1String("comment")), true)
            SKGTESTERROR(QLatin1String("REF:save"), tracker.save(), true)
            SKGTEST(QLatin1String("REF:getName"), tracker.getName(), QLatin1String("tracker"))
            SKGTEST(QLatin1String("REF:getComment"), tracker.getComment(), QLatin1String("comment"))

            SKGTESTBOOL("REF:isClosed", tracker.isClosed(), false)
            SKGTESTERROR(QLatin1String("OPE:setClosed"), tracker.setClosed(true), true)
            SKGTESTBOOL("REF:isClosed", tracker.isClosed(), true)
            SKGTESTERROR(QLatin1String("OPE:setClosed"), tracker.setClosed(false), true)
            SKGTESTBOOL("REF:isClosed", tracker.isClosed(), false)

            SKGTESTERROR(QLatin1String("OPE:setTracker"), subop1.setTracker(tracker), true)
            SKGTESTERROR(QLatin1String("OPE:save"), subop1.save(), true)

            SKGTESTERROR(QLatin1String("OPE:setClosed"), tracker.setClosed(true), true)
            SKGTESTERROR(QLatin1String("OPE:save"), tracker.save(), true)

            // BUG 250350 vvv
            SKGTESTERROR(QLatin1String("OPE:setTracker"), subop1.setTracker(tracker), true)
            SKGTESTERROR(QLatin1String("OPE:setTracker"), subop1.setTracker(tracker), true)

            SKGTrackerObject trackerclose(&document1);
            SKGTESTERROR(QLatin1String("REF:setName"), trackerclose.setName(QLatin1String("trackerclose")), true)
            SKGTESTERROR(QLatin1String("OPE:setClosed"), trackerclose.setClosed(true), true)
            SKGTESTERROR(QLatin1String("REF:save"), trackerclose.save(), true)
            SKGTESTERROR(QLatin1String("OPE:setTracker"), subop1.setTracker(trackerclose), false)

            SKGTrackerObject trackeropen(&document1);
            SKGTESTERROR(QLatin1String("REF:setName"), trackeropen.setName(QLatin1String("trackeropen")), true)
            SKGTESTERROR(QLatin1String("OPE:setClosed"), trackerclose.setClosed(true), true)
            SKGTESTERROR(QLatin1String("OPE:setTracker"), subop1.setTracker(trackeropen), false)
            // BUG 250350 ^^^

            SKGTrackerObject tracker2;
            SKGTESTERROR(QLatin1String("OPE:getTracker"), subop1.getTracker(tracker2), true)
            SKGTESTBOOL("OPE:compare", (tracker == tracker2), true)

            SKGTESTERROR(QLatin1String("REF:load"), tracker.load(), true)
            SKGTEST(QLatin1String("REF:getCurrentAmount"), tracker.getCurrentAmount(), 21)
            SKGObjectBase::SKGListSKGObjectBase oSubOperations;
            SKGTESTERROR(QLatin1String("REF:getSubOperations"), tracker.getSubOperations(oSubOperations), true)
            SKGTEST(QLatin1String("REF:compare"), oSubOperations.count(), 1)

            SKGTrackerObject track;
            SKGTESTERROR(QLatin1String("REF:createTracker"), SKGTrackerObject::createTracker(&document1, QLatin1String("track"), track, true), true)

            SKGTESTERROR(QLatin1String("OPE:setClosed"), tracker.setClosed(false), true)
            SKGTESTERROR(QLatin1String("REF:save"), tracker.save(), true)
            SKGTESTERROR(QLatin1String("REF:merge"), track.merge(tracker), true)

            SKGTrackerObject trackBlank;
            SKGTESTERROR(QLatin1String("REF:createTracker"), SKGTrackerObject::createTracker(&document1, QLatin1String(""), trackBlank, true), true)
        }
    }


    // End test
    SKGENDTEST()
}
