/**
 * gnome-print-bonobo-client.h: a print client interface for
 *                              compound documents.
 *
 * Author:
 *    Michael Meeks (mmeeks@gnu.org)
 *
 * Copyright 2000, Helix Code, Inc.
 */
#ifndef __GNOME_PRINT_BONOBO_CLIENT_H__
#define __GNOME_PRINT_BONOBO_CLIENT_H__

#include <bonobo/bonobo-object.h>
#include <libgnomeprint/gnome-print-meta.h>

G_BEGIN_DECLS

typedef struct _GnomePrintBonoboDimensions GnomePrintBonoboDimensions;
typedef struct _GnomePrintBonoboData       GnomePrintBonoboData;

/* Setup the dimensions */
GnomePrintBonoboDimensions *gnome_print_bonobo_dimensions_new       (double                 width,
								     double                 height);
void                        gnome_print_bonobo_dimensions_free      (GnomePrintBonoboDimensions *dims);

GnomePrintBonoboDimensions *gnome_print_bonobo_dimensions_new_full  (double                 width,
								     double                 height,
								     double                 width_first_page,
								     double                 width_per_page,
								     double                 height_first_page,
								     double                 height_per_page);

/* Remote render */
GnomePrintBonoboData       *gnome_print_bonobo_client_remote_render (Bonobo_Print                      print,
								     const GnomePrintBonoboDimensions *dims,
								     CORBA_Environment                *opt_ev);
void                        gnome_print_bonobo_data_free            (GnomePrintBonoboData             *pd);

/* Then re-render localy */
void                        gnome_print_bonobo_data_re_render       (GnomePrintContext           *ctx,
								     double                       x,
								     double                       y,
								     GnomePrintBonoboData        *pd,
								     double                       meta_x,
								     double                       meta_y);
GnomePrintMeta             *gnome_print_bonobo_data_get_meta        (GnomePrintBonoboData        *pd);

G_END_DECLS

#endif /* ! ___GNOME_PRINT_BONOBO_CLIENT_H__ */
