/* rygel-xbox-hacks.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-xbox-hacks.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <stdio.h>


#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
typedef struct _RygelXBoxHacksPrivate RygelXBoxHacksPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelXboxHacksSearchData RygelXboxHacksSearchData;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

typedef enum  {
	RYGEL_XBOX_HACKS_ERROR_NA
} RygelXBoxHacksError;
#define RYGEL_XBOX_HACKS_ERROR rygel_xbox_hacks_error_quark ()
struct _RygelXBoxHacks {
	GObject parent_instance;
	RygelXBoxHacksPrivate * priv;
};

struct _RygelXBoxHacksClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* date;
	char* mime_type;
	char* dlna_profile;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const char* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const char* uri, const char* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	char* (*to_string) (RygelSearchExpression* self);
};

struct _RygelXboxHacksSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelXBoxHacks* self;
	RygelMediaContainer* container;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* results;
	gboolean _tmp0_;
	RygelRelationalExpression* rel_expression;
	RygelSearchExpression* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_;
};


static char* rygel_xbox_hacks_AGENT;
static char* rygel_xbox_hacks_AGENT = NULL;
static char* rygel_xbox_hacks_DMS;
static char* rygel_xbox_hacks_DMS = NULL;
static char* rygel_xbox_hacks_DMS_V1;
static char* rygel_xbox_hacks_DMS_V1 = NULL;
static char* rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX;
static char* rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX = NULL;
static char* rygel_xbox_hacks_MODEL_NAME;
static char* rygel_xbox_hacks_MODEL_NAME = NULL;
static gpointer rygel_xbox_hacks_parent_class = NULL;

GQuark rygel_xbox_hacks_error_quark (void);
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_XBOX_HACKS_DUMMY_PROPERTY
};
RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error);
GType rygel_root_device_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const char* template_path, GError** error);
static void rygel_xbox_hacks_modify_dms_desc (RygelXBoxHacks* self, xmlDoc* doc);
static void rygel_xbox_hacks_save_modified_desc (RygelXBoxHacks* self, GUPnPXMLDoc* doc, const char* desc_path, GError** error);
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, RygelMediaQueryAction* action, char** container_id);
GType rygel_search_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_xbox_hacks_search_data_free (gpointer _data);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_xbox_hacks_search (RygelXBoxHacks* self, RygelMediaContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_xbox_hacks_search_finish (RygelXBoxHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_xbox_hacks_search_co (RygelXboxHacksSearchData* data);
void rygel_media_container_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
static xmlNode* rygel_xbox_hacks_find_cds_type_node (RygelXBoxHacks* self, xmlNode* doc_node);
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:2"
RygelXBoxHacks* rygel_xbox_hacks_new (void);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type);
static void rygel_xbox_hacks_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_xbox_hacks_error_quark (void) {
	return g_quark_from_static_string ("rygel_xbox_hacks_error-quark");
}


#line 1173 "glib-2.0.vapi"
static gboolean string_contains (const char* self, const char* needle) {
#line 338 "rygel-xbox-hacks.c"
	gboolean result = FALSE;
#line 1173 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1173 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 344 "rygel-xbox-hacks.c"
	result = strstr (self, needle) != NULL;
#line 1174 "glib-2.0.vapi"
	return result;
#line 348 "rygel-xbox-hacks.c"
}


#line 39 "rygel-xbox-hacks.vala"
RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error) {
#line 354 "rygel-xbox-hacks.c"
	RygelXBoxHacks * self;
	SoupMessage* _tmp0_;
	char* _tmp1_;
	char* agent;
	GError * _inner_error_ = NULL;
#line 39 "rygel-xbox-hacks.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 39 "rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) g_object_new (object_type, NULL);
#line 40 "rygel-xbox-hacks.vala"
	agent = (_tmp1_ = g_strdup (soup_message_headers_get_one ((_tmp0_ = gupnp_service_action_get_message (action))->request_headers, "User-Agent")), _g_object_unref0 (_tmp0_), _tmp1_);
#line 41 "rygel-xbox-hacks.vala"
	if (!string_contains (agent, "Xbox")) {
#line 368 "rygel-xbox-hacks.c"
		_inner_error_ = g_error_new_literal (RYGEL_XBOX_HACKS_ERROR, RYGEL_XBOX_HACKS_ERROR_NA, _ ("Not Applicable"));
		{
			if (_inner_error_->domain == RYGEL_XBOX_HACKS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (agent);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (agent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_g_free0 (agent);
	return self;
}


#line 39 "rygel-xbox-hacks.vala"
RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error) {
#line 39 "rygel-xbox-hacks.vala"
	return rygel_xbox_hacks_construct_for_action (RYGEL_TYPE_XBOX_HACKS, action, error);
#line 393 "rygel-xbox-hacks.c"
}


#line 1177 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 399 "rygel-xbox-hacks.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 408 "rygel-xbox-hacks.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1179 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 416 "rygel-xbox-hacks.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch49_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1180 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 427 "rygel-xbox-hacks.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch49_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1180 "glib-2.0.vapi"
		return result;
#line 442 "rygel-xbox-hacks.c"
	}
	goto __finally49;
	__catch49_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1182 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 453 "rygel-xbox-hacks.c"
			_g_error_free0 (e);
		}
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 46 "rygel-xbox-hacks.vala"
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const char* template_path, GError** error) {
#line 468 "rygel-xbox-hacks.c"
	GUPnPXMLDoc* doc;
	char* desc_path;
	GRegex* regex;
	char* server_path;
	GError * _inner_error_ = NULL;
#line 46 "rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 46 "rygel-xbox-hacks.vala"
	g_return_if_fail (device != NULL);
#line 46 "rygel-xbox-hacks.vala"
	g_return_if_fail (template_path != NULL);
#line 48 "rygel-xbox-hacks.vala"
	if (!g_str_has_prefix (gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) device), rygel_xbox_hacks_DMS)) {
#line 49 "rygel-xbox-hacks.vala"
		return;
#line 484 "rygel-xbox-hacks.c"
	}
#line 52 "rygel-xbox-hacks.vala"
	doc = gupnp_xml_doc_new_from_path (template_path, &_inner_error_);
#line 488 "rygel-xbox-hacks.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 53 "rygel-xbox-hacks.vala"
	rygel_xbox_hacks_modify_dms_desc (self, doc->doc);
#line 55 "rygel-xbox-hacks.vala"
	desc_path = string_replace (template_path, ".xml", "-xbox.xml");
#line 56 "rygel-xbox-hacks.vala"
	rygel_xbox_hacks_save_modified_desc (self, doc, desc_path, &_inner_error_);
#line 499 "rygel-xbox-hacks.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (desc_path);
		_g_object_unref0 (doc);
		return;
	}
#line 58 "rygel-xbox-hacks.vala"
	regex = g_regex_new (rygel_xbox_hacks_AGENT, G_REGEX_CASELESS, 0, &_inner_error_);
#line 508 "rygel-xbox-hacks.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (desc_path);
		_g_object_unref0 (doc);
		return;
	}
#line 59 "rygel-xbox-hacks.vala"
	server_path = g_strconcat ("/", gupnp_root_device_get_relative_location ((GUPnPRootDevice*) device), NULL);
#line 60 "rygel-xbox-hacks.vala"
	gupnp_context_host_path_for_agent (gupnp_device_info_get_context ((GUPnPDeviceInfo*) device), desc_path, server_path, regex);
#line 519 "rygel-xbox-hacks.c"
	_g_free0 (server_path);
	_g_regex_unref0 (regex);
	_g_free0 (desc_path);
	_g_object_unref0 (doc);
}


#line 63 "rygel-xbox-hacks.vala"
void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, RygelMediaQueryAction* action, char** container_id) {
#line 529 "rygel-xbox-hacks.c"
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 63 "rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 63 "rygel-xbox-hacks.vala"
	g_return_if_fail (action != NULL);
#line 63 "rygel-xbox-hacks.vala"
	g_return_if_fail (container_id != NULL);
#line 65 "rygel-xbox-hacks.vala"
	if (RYGEL_IS_SEARCH (action)) {
#line 540 "rygel-xbox-hacks.c"
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 66 "rygel-xbox-hacks.vala"
		if (_vala_strcmp0 (*container_id, "1") == 0) {
#line 66 "rygel-xbox-hacks.vala"
			_tmp6_ = TRUE;
#line 550 "rygel-xbox-hacks.c"
		} else {
#line 67 "rygel-xbox-hacks.vala"
			_tmp6_ = _vala_strcmp0 (*container_id, "4") == 0;
#line 554 "rygel-xbox-hacks.c"
		}
#line 66 "rygel-xbox-hacks.vala"
		if (_tmp6_) {
#line 66 "rygel-xbox-hacks.vala"
			_tmp5_ = TRUE;
#line 560 "rygel-xbox-hacks.c"
		} else {
#line 68 "rygel-xbox-hacks.vala"
			_tmp5_ = _vala_strcmp0 (*container_id, "5") == 0;
#line 564 "rygel-xbox-hacks.c"
		}
#line 66 "rygel-xbox-hacks.vala"
		if (_tmp5_) {
#line 66 "rygel-xbox-hacks.vala"
			_tmp4_ = TRUE;
#line 570 "rygel-xbox-hacks.c"
		} else {
#line 69 "rygel-xbox-hacks.vala"
			_tmp4_ = _vala_strcmp0 (*container_id, "6") == 0;
#line 574 "rygel-xbox-hacks.c"
		}
#line 66 "rygel-xbox-hacks.vala"
		if (_tmp4_) {
#line 66 "rygel-xbox-hacks.vala"
			_tmp3_ = TRUE;
#line 580 "rygel-xbox-hacks.c"
		} else {
#line 70 "rygel-xbox-hacks.vala"
			_tmp3_ = _vala_strcmp0 (*container_id, "7") == 0;
#line 584 "rygel-xbox-hacks.c"
		}
#line 66 "rygel-xbox-hacks.vala"
		if (_tmp3_) {
#line 66 "rygel-xbox-hacks.vala"
			_tmp2_ = TRUE;
#line 590 "rygel-xbox-hacks.c"
		} else {
#line 71 "rygel-xbox-hacks.vala"
			_tmp2_ = _vala_strcmp0 (*container_id, "F") == 0;
#line 594 "rygel-xbox-hacks.c"
		}
#line 66 "rygel-xbox-hacks.vala"
		_tmp1_ = _tmp2_;
#line 598 "rygel-xbox-hacks.c"
	} else {
#line 65 "rygel-xbox-hacks.vala"
		_tmp1_ = FALSE;
#line 602 "rygel-xbox-hacks.c"
	}
#line 65 "rygel-xbox-hacks.vala"
	if (_tmp1_) {
#line 65 "rygel-xbox-hacks.vala"
		_tmp0_ = TRUE;
#line 608 "rygel-xbox-hacks.c"
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 72 "rygel-xbox-hacks.vala"
		if (RYGEL_IS_BROWSE (action)) {
#line 73 "rygel-xbox-hacks.vala"
			_tmp9_ = _vala_strcmp0 (*container_id, "15") == 0;
#line 617 "rygel-xbox-hacks.c"
		} else {
#line 72 "rygel-xbox-hacks.vala"
			_tmp9_ = FALSE;
#line 621 "rygel-xbox-hacks.c"
		}
#line 72 "rygel-xbox-hacks.vala"
		if (_tmp9_) {
#line 72 "rygel-xbox-hacks.vala"
			_tmp8_ = TRUE;
#line 627 "rygel-xbox-hacks.c"
		} else {
#line 74 "rygel-xbox-hacks.vala"
			_tmp8_ = _vala_strcmp0 (*container_id, "14") == 0;
#line 631 "rygel-xbox-hacks.c"
		}
#line 72 "rygel-xbox-hacks.vala"
		if (_tmp8_) {
#line 72 "rygel-xbox-hacks.vala"
			_tmp7_ = TRUE;
#line 637 "rygel-xbox-hacks.c"
		} else {
#line 75 "rygel-xbox-hacks.vala"
			_tmp7_ = _vala_strcmp0 (*container_id, "16") == 0;
#line 641 "rygel-xbox-hacks.c"
		}
#line 72 "rygel-xbox-hacks.vala"
		_tmp0_ = _tmp7_;
#line 645 "rygel-xbox-hacks.c"
	}
#line 65 "rygel-xbox-hacks.vala"
	if (_tmp0_) {
#line 649 "rygel-xbox-hacks.c"
		char* _tmp10_;
#line 76 "rygel-xbox-hacks.vala"
		*container_id = (_tmp10_ = g_strdup ("0"), _g_free0 (*container_id), _tmp10_);
#line 653 "rygel-xbox-hacks.c"
	}
}


#line 80 "rygel-xbox-hacks.vala"
void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item) {
#line 80 "rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 80 "rygel-xbox-hacks.vala"
	g_return_if_fail (item != NULL);
#line 81 "rygel-xbox-hacks.vala"
	if (_vala_strcmp0 (item->mime_type, "video/x-msvideo") == 0) {
#line 666 "rygel-xbox-hacks.c"
		char* _tmp0_;
#line 82 "rygel-xbox-hacks.vala"
		item->mime_type = (_tmp0_ = g_strdup ("video/avi"), _g_free0 (item->mime_type), _tmp0_);
#line 670 "rygel-xbox-hacks.c"
	} else {
#line 83 "rygel-xbox-hacks.vala"
		if (_vala_strcmp0 (item->mime_type, "video/mpeg") == 0) {
#line 674 "rygel-xbox-hacks.c"
			char* _tmp1_;
#line 85 "rygel-xbox-hacks.vala"
			item->mime_type = (_tmp1_ = g_strdup ("invalid/content"), _g_free0 (item->mime_type), _tmp1_);
#line 678 "rygel-xbox-hacks.c"
		}
	}
}


static void rygel_xbox_hacks_search_data_free (gpointer _data) {
	RygelXboxHacksSearchData* data;
	data = _data;
	_g_object_unref0 (data->container);
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelXboxHacksSearchData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


void rygel_xbox_hacks_search (RygelXBoxHacks* self, RygelMediaContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelXboxHacksSearchData* _data_;
	_data_ = g_slice_new0 (RygelXboxHacksSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_xbox_hacks_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_xbox_hacks_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->container = _g_object_ref0 (container);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_xbox_hacks_search_co (_data_);
}


RygelMediaObjects* rygel_xbox_hacks_search_finish (RygelXBoxHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelXboxHacksSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelXboxHacksSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_xbox_hacks_search_co (data);
}


static gboolean rygel_xbox_hacks_search_co (RygelXboxHacksSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 38:
		goto _state_38;
	}
	_state_0:
	data->_state_ = 38;
	rygel_media_container_search (data->container, data->expression, data->offset, data->max_count, data->cancellable, rygel_xbox_hacks_search_ready, data);
	return FALSE;
	_state_38:
	data->results = rygel_media_container_search_finish (data->container, data->_res_, &data->total_matches, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
#line 101 "rygel-xbox-hacks.vala"
	if (data->total_matches == 0) {
#line 101 "rygel-xbox-hacks.vala"
		data->_tmp0_ = RYGEL_IS_RELATIONAL_EXPRESSION (data->expression);
#line 775 "rygel-xbox-hacks.c"
	} else {
#line 101 "rygel-xbox-hacks.vala"
		data->_tmp0_ = FALSE;
#line 779 "rygel-xbox-hacks.c"
	}
#line 101 "rygel-xbox-hacks.vala"
	if (data->_tmp0_) {
#line 783 "rygel-xbox-hacks.c"
		data->rel_expression = _rygel_search_expression_ref0 ((data->_tmp1_ = data->expression, RYGEL_IS_RELATIONAL_EXPRESSION (data->_tmp1_) ? ((RygelRelationalExpression*) data->_tmp1_) : NULL));
#line 104 "rygel-xbox-hacks.vala"
		if (G_LIKELY (((const char*) ((RygelSearchExpression*) data->rel_expression)->operand1) != NULL)) {
#line 105 "rygel-xbox-hacks.vala"
			data->_tmp2_ = _vala_strcmp0 ((const char*) ((RygelSearchExpression*) data->rel_expression)->operand1, "upnp:class") == 0;
#line 789 "rygel-xbox-hacks.c"
		} else {
#line 104 "rygel-xbox-hacks.vala"
			data->_tmp2_ = FALSE;
#line 793 "rygel-xbox-hacks.c"
		}
#line 104 "rygel-xbox-hacks.vala"
		if (data->_tmp2_) {
#line 106 "rygel-xbox-hacks.vala"
			data->total_matches = (guint) gee_collection_get_size ((GeeCollection*) data->results);
#line 799 "rygel-xbox-hacks.c"
		}
		_rygel_search_expression_unref0 (data->rel_expression);
	}
	data->result = data->results;
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->results);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 113 "rygel-xbox-hacks.vala"
static void rygel_xbox_hacks_modify_dms_desc (RygelXBoxHacks* self, xmlDoc* doc) {
#line 828 "rygel-xbox-hacks.c"
	xmlNode* element;
#line 113 "rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 113 "rygel-xbox-hacks.vala"
	g_return_if_fail (doc != NULL);
#line 114 "rygel-xbox-hacks.vala"
	element = rygel_xml_utils_get_element ((xmlNode*) doc, "root", "device", "deviceType", NULL);
#line 118 "rygel-xbox-hacks.vala"
	g_assert (element != NULL);
#line 119 "rygel-xbox-hacks.vala"
	xmlNodeSetContent (element, rygel_xbox_hacks_DMS_V1);
#line 121 "rygel-xbox-hacks.vala"
	element = rygel_xml_utils_get_element ((xmlNode*) doc, "root", "device", "modelName", NULL);
#line 125 "rygel-xbox-hacks.vala"
	g_assert (element != NULL);
#line 126 "rygel-xbox-hacks.vala"
	xmlNodeSetContent (element, rygel_xbox_hacks_MODEL_NAME);
#line 128 "rygel-xbox-hacks.vala"
	element = rygel_xml_utils_get_element ((xmlNode*) doc, "root", "device", "friendlyName", NULL);
#line 132 "rygel-xbox-hacks.vala"
	g_assert (element != NULL);
#line 133 "rygel-xbox-hacks.vala"
	xmlNodeAddContent (element, rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX);
#line 135 "rygel-xbox-hacks.vala"
	element = rygel_xbox_hacks_find_cds_type_node (self, doc);
#line 136 "rygel-xbox-hacks.vala"
	g_assert (element != NULL);
#line 137 "rygel-xbox-hacks.vala"
	xmlNodeSetContent (element, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1);
#line 858 "rygel-xbox-hacks.c"
}


#line 140 "rygel-xbox-hacks.vala"
static xmlNode* rygel_xbox_hacks_find_cds_type_node (RygelXBoxHacks* self, xmlNode* doc_node) {
#line 864 "rygel-xbox-hacks.c"
	xmlNode* result = NULL;
	xmlNode* element;
	xmlNode* cds_type_node;
#line 140 "rygel-xbox-hacks.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "rygel-xbox-hacks.vala"
	element = rygel_xml_utils_get_element (doc_node, "root", "device", "serviceList", NULL);
#line 145 "rygel-xbox-hacks.vala"
	g_assert ((element != NULL) && (element->children != NULL));
#line 147 "rygel-xbox-hacks.vala"
	cds_type_node = NULL;
#line 876 "rygel-xbox-hacks.c"
	{
		xmlNode* service_node;
#line 149 "rygel-xbox-hacks.vala"
		service_node = element->children;
#line 881 "rygel-xbox-hacks.c"
		{
			gboolean _tmp0_;
#line 149 "rygel-xbox-hacks.vala"
			_tmp0_ = TRUE;
#line 149 "rygel-xbox-hacks.vala"
			while (TRUE) {
#line 149 "rygel-xbox-hacks.vala"
				if (!_tmp0_) {
#line 151 "rygel-xbox-hacks.vala"
					service_node = service_node->next;
#line 892 "rygel-xbox-hacks.c"
				}
#line 149 "rygel-xbox-hacks.vala"
				_tmp0_ = FALSE;
#line 150 "rygel-xbox-hacks.vala"
				if (!(service_node != NULL)) {
#line 150 "rygel-xbox-hacks.vala"
					break;
#line 900 "rygel-xbox-hacks.c"
				}
				{
					xmlNode* type_node;
#line 152 "rygel-xbox-hacks.vala"
					type_node = service_node->children;
#line 906 "rygel-xbox-hacks.c"
					{
						gboolean _tmp1_;
#line 152 "rygel-xbox-hacks.vala"
						_tmp1_ = TRUE;
#line 152 "rygel-xbox-hacks.vala"
						while (TRUE) {
#line 913 "rygel-xbox-hacks.c"
							gboolean _tmp2_ = FALSE;
#line 152 "rygel-xbox-hacks.vala"
							if (!_tmp1_) {
#line 154 "rygel-xbox-hacks.vala"
								type_node = type_node->next;
#line 919 "rygel-xbox-hacks.c"
							}
#line 152 "rygel-xbox-hacks.vala"
							_tmp1_ = FALSE;
#line 153 "rygel-xbox-hacks.vala"
							if (!(type_node != NULL)) {
#line 153 "rygel-xbox-hacks.vala"
								break;
#line 927 "rygel-xbox-hacks.c"
							}
#line 155 "rygel-xbox-hacks.vala"
							if (_vala_strcmp0 (type_node->name, "serviceType") == 0) {
#line 931 "rygel-xbox-hacks.c"
								char* _tmp3_;
#line 156 "rygel-xbox-hacks.vala"
								_tmp2_ = _vala_strcmp0 (_tmp3_ = xmlNodeGetContent (type_node), RYGEL_CONTENT_DIRECTORY_UPNP_TYPE) == 0;
#line 935 "rygel-xbox-hacks.c"
								_g_free0 (_tmp3_);
							} else {
#line 155 "rygel-xbox-hacks.vala"
								_tmp2_ = FALSE;
#line 940 "rygel-xbox-hacks.c"
							}
#line 155 "rygel-xbox-hacks.vala"
							if (_tmp2_) {
#line 157 "rygel-xbox-hacks.vala"
								cds_type_node = type_node;
#line 946 "rygel-xbox-hacks.c"
							}
						}
					}
				}
#line 161 "rygel-xbox-hacks.vala"
				if (cds_type_node != NULL) {
#line 162 "rygel-xbox-hacks.vala"
					break;
#line 955 "rygel-xbox-hacks.c"
				}
			}
		}
	}
	result = cds_type_node;
#line 166 "rygel-xbox-hacks.vala"
	return result;
#line 963 "rygel-xbox-hacks.c"
}


#line 169 "rygel-xbox-hacks.vala"
static void rygel_xbox_hacks_save_modified_desc (RygelXBoxHacks* self, GUPnPXMLDoc* doc, const char* desc_path, GError** error) {
#line 969 "rygel-xbox-hacks.c"
	FILE* f;
	gint res;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 169 "rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 169 "rygel-xbox-hacks.vala"
	g_return_if_fail (doc != NULL);
#line 169 "rygel-xbox-hacks.vala"
	g_return_if_fail (desc_path != NULL);
#line 171 "rygel-xbox-hacks.vala"
	f = fopen (desc_path, "w+");
#line 172 "rygel-xbox-hacks.vala"
	res = -1;
#line 174 "rygel-xbox-hacks.vala"
	if (f != NULL) {
#line 175 "rygel-xbox-hacks.vala"
		res = xmlDocDump (f, doc->doc);
#line 988 "rygel-xbox-hacks.c"
	}
#line 177 "rygel-xbox-hacks.vala"
	if (f == NULL) {
#line 177 "rygel-xbox-hacks.vala"
		_tmp0_ = TRUE;
#line 994 "rygel-xbox-hacks.c"
	} else {
#line 177 "rygel-xbox-hacks.vala"
		_tmp0_ = res == (-1);
#line 998 "rygel-xbox-hacks.c"
	}
#line 177 "rygel-xbox-hacks.vala"
	if (_tmp0_) {
#line 1002 "rygel-xbox-hacks.c"
		char* message;
#line 178 "rygel-xbox-hacks.vala"
		message = g_strdup (_ ("Failed to write modified description to %s."));
#line 1006 "rygel-xbox-hacks.c"
		_inner_error_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, message, desc_path);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (message);
			_fclose0 (f);
			return;
		}
		_g_free0 (message);
	}
	_fclose0 (f);
}


#line 31 "rygel-xbox-hacks.vala"
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type) {
#line 1022 "rygel-xbox-hacks.c"
	RygelXBoxHacks * self;
#line 31 "rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) g_object_new (object_type, NULL);
#line 1026 "rygel-xbox-hacks.c"
	return self;
}


#line 31 "rygel-xbox-hacks.vala"
RygelXBoxHacks* rygel_xbox_hacks_new (void) {
#line 31 "rygel-xbox-hacks.vala"
	return rygel_xbox_hacks_construct (RYGEL_TYPE_XBOX_HACKS);
#line 1035 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_class_init (RygelXBoxHacksClass * klass) {
	rygel_xbox_hacks_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_xbox_hacks_finalize;
	rygel_xbox_hacks_AGENT = g_strdup (".*Xbox.*");
	rygel_xbox_hacks_DMS = g_strdup ("urn:schemas-upnp-org:device:MediaServer");
	rygel_xbox_hacks_DMS_V1 = g_strconcat (rygel_xbox_hacks_DMS, ":1", NULL);
	rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX = g_strdup (": 1 : Windows Media Connect");
	rygel_xbox_hacks_MODEL_NAME = g_strdup ("Windows Media Connect");
}


static void rygel_xbox_hacks_instance_init (RygelXBoxHacks * self) {
}


static void rygel_xbox_hacks_finalize (GObject* obj) {
	RygelXBoxHacks * self;
	self = RYGEL_XBOX_HACKS (obj);
	G_OBJECT_CLASS (rygel_xbox_hacks_parent_class)->finalize (obj);
}


GType rygel_xbox_hacks_get_type (void) {
	static volatile gsize rygel_xbox_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_xbox_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelXBoxHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_xbox_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelXBoxHacks), 0, (GInstanceInitFunc) rygel_xbox_hacks_instance_init, NULL };
		GType rygel_xbox_hacks_type_id;
		rygel_xbox_hacks_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelXBoxHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_xbox_hacks_type_id__volatile, rygel_xbox_hacks_type_id);
	}
	return rygel_xbox_hacks_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




