/* rygel-changelog.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-changelog.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;
typedef struct _RygelChangeLogPrivate RygelChangeLogPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelChangeLog {
	GObject parent_instance;
	RygelChangeLogPrivate * priv;
};

struct _RygelChangeLogClass {
	GObjectClass parent_class;
};

struct _RygelChangeLogPrivate {
	GUPnPService* _service;
	char* service_ns;
	GString* str;
	GeeHashMap* hash;
	guint timeout_id;
};


static gpointer rygel_change_log_parent_class = NULL;

GType rygel_change_log_get_type (void) G_GNUC_CONST;
#define RYGEL_CHANGE_LOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogPrivate))
enum  {
	RYGEL_CHANGE_LOG_DUMMY_PROPERTY,
	RYGEL_CHANGE_LOG_SERVICE
};
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const char* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const char* service_ns);
void rygel_change_log_set_service (RygelChangeLog* self, GUPnPService* value);
static gboolean rygel_change_log_timeout (RygelChangeLog* self);
GUPnPService* rygel_change_log_get_service (RygelChangeLog* self);
char* rygel_change_log_finish (RygelChangeLog* self);
static void rygel_change_log_ensure_timeout (RygelChangeLog* self);
static gboolean _rygel_change_log_timeout_gsource_func (gpointer self);
void rygel_change_log_log (RygelChangeLog* self, const char* variable, const char* value);
void rygel_change_log_log_with_channel (RygelChangeLog* self, const char* variable, const char* value, const char* channel);
static void rygel_change_log_finalize (GObject* obj);
static void rygel_change_log_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_change_log_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



#line 39 "rygel-changelog.vala"
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const char* service_ns) {
#line 94 "rygel-changelog.c"
	RygelChangeLog * self;
	char* _tmp0_;
	GString* _tmp1_;
	GeeHashMap* _tmp2_;
#line 39 "rygel-changelog.vala"
	g_return_val_if_fail (service_ns != NULL, NULL);
#line 39 "rygel-changelog.vala"
	self = (RygelChangeLog*) g_object_new (object_type, NULL);
#line 40 "rygel-changelog.vala"
	rygel_change_log_set_service (self, service);
#line 41 "rygel-changelog.vala"
	self->priv->service_ns = (_tmp0_ = g_strdup (service_ns), _g_free0 (self->priv->service_ns), _tmp0_);
#line 42 "rygel-changelog.vala"
	self->priv->str = (_tmp1_ = g_string_new (""), _g_string_free0 (self->priv->str), _tmp1_);
#line 43 "rygel-changelog.vala"
	self->priv->hash = (_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL), _g_object_unref0 (self->priv->hash), _tmp2_);
#line 111 "rygel-changelog.c"
	return self;
}


#line 39 "rygel-changelog.vala"
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const char* service_ns) {
#line 39 "rygel-changelog.vala"
	return rygel_change_log_construct (RYGEL_TYPE_CHANGE_LOG, service, service_ns);
#line 120 "rygel-changelog.c"
}


#line 52 "rygel-changelog.vala"
static gboolean rygel_change_log_timeout (RygelChangeLog* self) {
#line 126 "rygel-changelog.c"
	gboolean result = FALSE;
	char* _tmp0_;
#line 52 "rygel-changelog.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 54 "rygel-changelog.vala"
	gupnp_service_notify (self->priv->_service, "LastChange", G_TYPE_STRING, _tmp0_ = rygel_change_log_finish (self), NULL);
#line 133 "rygel-changelog.c"
	_g_free0 (_tmp0_);
#line 55 "rygel-changelog.vala"
	g_debug ("rygel-changelog.vala:55: LastChange sent");
#line 58 "rygel-changelog.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) self->priv->hash);
#line 59 "rygel-changelog.vala"
	g_string_erase (self->priv->str, (gssize) 0, (gssize) (-1));
#line 60 "rygel-changelog.vala"
	self->priv->timeout_id = (guint) 0;
#line 143 "rygel-changelog.c"
	result = FALSE;
#line 62 "rygel-changelog.vala"
	return result;
#line 147 "rygel-changelog.c"
}


#line 52 "rygel-changelog.vala"
static gboolean _rygel_change_log_timeout_gsource_func (gpointer self) {
#line 153 "rygel-changelog.c"
	gboolean result;
	result = rygel_change_log_timeout (self);
	return result;
}


#line 65 "rygel-changelog.vala"
static void rygel_change_log_ensure_timeout (RygelChangeLog* self) {
#line 162 "rygel-changelog.c"
	gboolean _tmp0_ = FALSE;
#line 65 "rygel-changelog.vala"
	g_return_if_fail (self != NULL);
#line 67 "rygel-changelog.vala"
	if (self->priv->_service != NULL) {
#line 67 "rygel-changelog.vala"
		_tmp0_ = self->priv->timeout_id == 0;
#line 170 "rygel-changelog.c"
	} else {
#line 67 "rygel-changelog.vala"
		_tmp0_ = FALSE;
#line 174 "rygel-changelog.c"
	}
#line 67 "rygel-changelog.vala"
	if (_tmp0_) {
#line 68 "rygel-changelog.vala"
		g_debug ("rygel-changelog.vala:68: Setting up timeout for LastChange");
#line 69 "rygel-changelog.vala"
		self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _rygel_change_log_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 182 "rygel-changelog.c"
	}
}


#line 73 "rygel-changelog.vala"
void rygel_change_log_log (RygelChangeLog* self, const char* variable, const char* value) {
#line 189 "rygel-changelog.c"
	char* _tmp0_;
#line 73 "rygel-changelog.vala"
	g_return_if_fail (self != NULL);
#line 73 "rygel-changelog.vala"
	g_return_if_fail (variable != NULL);
#line 73 "rygel-changelog.vala"
	g_return_if_fail (value != NULL);
#line 74 "rygel-changelog.vala"
	g_debug ("rygel-changelog.vala:74: '%s = %s' logged", variable, value);
#line 75 "rygel-changelog.vala"
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->hash, variable, _tmp0_ = g_strdup_printf ("<%s val=\"%s\"/>", variable, value));
#line 201 "rygel-changelog.c"
	_g_free0 (_tmp0_);
#line 77 "rygel-changelog.vala"
	rygel_change_log_ensure_timeout (self);
#line 205 "rygel-changelog.c"
}


#line 80 "rygel-changelog.vala"
void rygel_change_log_log_with_channel (RygelChangeLog* self, const char* variable, const char* value, const char* channel) {
#line 211 "rygel-changelog.c"
	char* _tmp0_;
#line 80 "rygel-changelog.vala"
	g_return_if_fail (self != NULL);
#line 80 "rygel-changelog.vala"
	g_return_if_fail (variable != NULL);
#line 80 "rygel-changelog.vala"
	g_return_if_fail (value != NULL);
#line 80 "rygel-changelog.vala"
	g_return_if_fail (channel != NULL);
#line 83 "rygel-changelog.vala"
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->hash, variable, _tmp0_ = g_strdup_printf ("<%s val=\"%s\" channel=\"%s\"/>", variable, value, channel));
#line 223 "rygel-changelog.c"
	_g_free0 (_tmp0_);
#line 88 "rygel-changelog.vala"
	rygel_change_log_ensure_timeout (self);
#line 227 "rygel-changelog.c"
}


#line 91 "rygel-changelog.vala"
char* rygel_change_log_finish (RygelChangeLog* self) {
#line 233 "rygel-changelog.c"
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
#line 91 "rygel-changelog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "rygel-changelog.vala"
	g_string_append (self->priv->str, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("<Event xmlns=\"", self->priv->service_ns, NULL), "\"><InstanceID val=\"0\">", NULL));
#line 241 "rygel-changelog.c"
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	{
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _line_it;
#line 95 "rygel-changelog.vala"
		_line_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_values ((GeeMap*) self->priv->hash))), _g_object_unref0 (_tmp2_), _tmp3_);
#line 95 "rygel-changelog.vala"
		while (TRUE) {
#line 252 "rygel-changelog.c"
			char* line;
#line 95 "rygel-changelog.vala"
			if (!gee_iterator_next (_line_it)) {
#line 95 "rygel-changelog.vala"
				break;
#line 258 "rygel-changelog.c"
			}
#line 95 "rygel-changelog.vala"
			line = (char*) gee_iterator_get (_line_it);
#line 96 "rygel-changelog.vala"
			g_string_append (self->priv->str, line);
#line 264 "rygel-changelog.c"
			_g_free0 (line);
		}
		_g_object_unref0 (_line_it);
	}
#line 98 "rygel-changelog.vala"
	g_string_append (self->priv->str, "</InstanceID></Event>");
#line 271 "rygel-changelog.c"
	result = g_strdup (self->priv->str->str);
#line 100 "rygel-changelog.vala"
	return result;
#line 275 "rygel-changelog.c"
}


GUPnPService* rygel_change_log_get_service (RygelChangeLog* self) {
	GUPnPService* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_service;
#line 29 "rygel-changelog.vala"
	return result;
#line 285 "rygel-changelog.c"
}


void rygel_change_log_set_service (RygelChangeLog* self, GUPnPService* value) {
	g_return_if_fail (self != NULL);
	self->priv->_service = value;
	g_object_notify ((GObject *) self, "service");
}


static void rygel_change_log_class_init (RygelChangeLogClass * klass) {
	rygel_change_log_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelChangeLogPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_change_log_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_change_log_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_change_log_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_CHANGE_LOG_SERVICE, g_param_spec_object ("service", "service", "service", GUPNP_TYPE_SERVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_change_log_instance_init (RygelChangeLog * self) {
	self->priv = RYGEL_CHANGE_LOG_GET_PRIVATE (self);
	self->priv->timeout_id = (guint) 0;
}


static void rygel_change_log_finalize (GObject* obj) {
	RygelChangeLog * self;
	self = RYGEL_CHANGE_LOG (obj);
	{
#line 47 "rygel-changelog.vala"
		if (self->priv->timeout_id != 0) {
#line 48 "rygel-changelog.vala"
			g_source_remove (self->priv->timeout_id);
#line 320 "rygel-changelog.c"
		}
	}
	_g_free0 (self->priv->service_ns);
	_g_string_free0 (self->priv->str);
	_g_object_unref0 (self->priv->hash);
	G_OBJECT_CLASS (rygel_change_log_parent_class)->finalize (obj);
}


GType rygel_change_log_get_type (void) {
	static volatile gsize rygel_change_log_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_change_log_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelChangeLogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_change_log_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelChangeLog), 0, (GInstanceInitFunc) rygel_change_log_instance_init, NULL };
		GType rygel_change_log_type_id;
		rygel_change_log_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelChangeLog", &g_define_type_info, 0);
		g_once_init_leave (&rygel_change_log_type_id__volatile, rygel_change_log_type_id);
	}
	return rygel_change_log_type_id__volatile;
}


static void rygel_change_log_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelChangeLog * self;
	self = RYGEL_CHANGE_LOG (object);
	switch (property_id) {
		case RYGEL_CHANGE_LOG_SERVICE:
		g_value_set_object (value, rygel_change_log_get_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_change_log_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelChangeLog * self;
	self = RYGEL_CHANGE_LOG (object);
	switch (property_id) {
		case RYGEL_CHANGE_LOG_SERVICE:
		rygel_change_log_set_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




