/*
   Copyright (C) 2004 Fernando Herrera <fherrera@onirica.com>
   Copyright (C) 2004 Mariano Suárez-Alvarez <mariano@gnome.org>
   Copyright (C) 2004 GNOME Love Project <gnome-love@gnome.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef GNOME_KEYRING_MANAGER_PASSWORD_DIALOG_H
#define GNOME_KEYRING_MANAGER_PASSWORD_DIALOG_H

#include <config.h>

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GKM_TYPE_PASSWORD_DIALOG            (gkm_password_dialog_get_type ())
#define GKM_PASSWORD_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GKM_TYPE_PASSWORD_DIALOG, GKMPasswordDialog))
#define GKM_PASSWORD_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  GKM_TYPE_PASSWORD_DIALOG, GKMPasswordDialogClass))
#define GKM_IS_PASSWORD_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GKM_TYPE_PASSWORD_DIALOG))
#define GKM_IS_PASSWORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  GKM_TYPE_PASSWORD_DIALOG))
#define GKM_PASSWORD_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  GKM_TYPE_PASSWORD_DIALOG, GKMPasswordDialogClass))

typedef struct _GKMPasswordDialog         GKMPasswordDialog;
typedef struct _GKMPasswordDialogClass    GKMPasswordDialogClass;
typedef struct _GKMPasswordDialogPrivate  GKMPasswordDialogPrivate;

struct _GKMPasswordDialog
{
  GtkDialog dialog;

  GKMPasswordDialogPrivate *priv;
};

struct _GKMPasswordDialogClass
{
  GtkDialogClass dialog_class;
};

GType gkm_password_dialog_get_type (void);

GtkWidget *gkm_password_dialog_new (const char     *title,
                                    GtkWindow      *parent,
                                    GtkDialogFlags  flags,
                                    const char     *primary_text,
                                    const char     *secondary_text);

void gkm_password_dialog_accept_button_set_label      (GKMPasswordDialog *dialog,
                                                       const char        *text);
void gkm_password_dialog_accept_button_set_from_stock (GKMPasswordDialog *dialog,
                                                       const char        *stock_id);

char *gkm_password_dialog_get_password (GKMPasswordDialog *dialog);

G_END_DECLS

#endif
