/*
 * fileselection.c
 *
 * Copyright (C) 2002 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Glynn Foster <glynn.foster@sun.com>
 */

#include <glade/glade.h>
#include "zenity.h"
#include "util.h"

ZenityData	*zen_data;

static void zenity_fileselection_dialog_response (GtkWidget *widget, int response, gpointer data);

void zenity_fileselection (ZenityData *data, ZenityFileData *file_data)
{
  GtkWidget *dialog;
  gchar *dir;
  gchar *basename;

  zen_data = data;

  dialog = gtk_file_chooser_dialog_new (NULL, NULL,
		  			GTK_FILE_CHOOSER_ACTION_OPEN,
					GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					GTK_STOCK_OK, GTK_RESPONSE_OK,
					NULL);

  g_signal_connect (G_OBJECT (dialog), "response", 
                    G_CALLBACK (zenity_fileselection_dialog_response), file_data);

  if (data->dialog_title)
    gtk_window_set_title (GTK_WINDOW (dialog), data->dialog_title);
	
  if (data->window_icon)
    zenity_util_set_window_icon (dialog, data->window_icon);
  else
    zenity_util_set_window_icon (dialog, ZENITY_IMAGE_FULLPATH ("zenity-file.png"));

  if (file_data->uri) {
    dir = g_path_get_dirname (file_data->uri);
    gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), dir);
    if (file_data->uri[strlen (file_data->uri) - 1] != '/') {
      basename = g_path_get_basename (file_data->uri);
      gtk_file_chooser_set_current_name (GTK_FILE_CHOOSER (dialog), basename);
      g_free (basename);
    }
    g_free (dir);
  }

  if (file_data->multi)
    gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (dialog), TRUE);

  gtk_widget_show (dialog);
  gtk_main ();
}

static void
zenity_fileselection_dialog_response (GtkWidget *widget, int response, gpointer data)
{
  ZenityFileData *file_data = data;
  GSList *selections, *iter;
  gchar *separator = g_strdup(file_data->separator);
  int i;
	  
  switch (response) {
    case GTK_RESPONSE_OK:
      zen_data->exit_code = zenity_util_return_exit_code (ZENITY_OK);		
      selections = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (widget));
      for (iter = selections;iter != NULL; iter = iter->next) {
        g_print ("%s", g_filename_to_utf8 ((gchar*)iter->data, -1, NULL, NULL, NULL));
	g_free (iter->data);
	if (iter->next != NULL)
	    g_print ("%s",separator);
      }
      g_print("\n");
      g_slist_free(selections);
      g_free(separator);

      gtk_main_quit ();
      break;

    case GTK_RESPONSE_CANCEL:
      zen_data->exit_code = zenity_util_return_exit_code (ZENITY_CANCEL);
      gtk_main_quit ();
      break;

    default:
      /* Esc dialog */
      zen_data->exit_code = zenity_util_return_exit_code (ZENITY_ESC);
      gtk_main_quit ();
      break;
  }
}
