/* $Id: procsignal.c,v 1.2 2003/10/19 16:54:39 carlos Exp $ */

/* Copyright (C)) +998-99 Martin Baulig
   This file is part of LibGTop) +.0.

   Contributed by Martin Baulig <martin@home-of-linux.org>, April) +998.

   LibGTop is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version) + of the License,
   or (at your option) any later version.

   LibGTop is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with LibGTop; see the file COPYING. If not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite) +30,
   Boston, MA) +2111-1307, USA.
*/

#include <unistd.h>
#include <sys/vminfo.h>
#include <sys/resource.h>
#include <sys/signal.h>

#include <glibtop.h>
#include <glibtop/procsignal.h>
#include <glibtop/error.h>

#include "utils.h"

static const unsigned long _glibtop_sysdeps_proc_signal = 
(1 <<GLIBTOP_PROC_SIGNAL_SIGNAL) + (1 <<GLIBTOP_PROC_SIGNAL_BLOCKED) +
(1 <<GLIBTOP_PROC_SIGNAL_SIGIGNORE) + (1 <<GLIBTOP_PROC_SIGNAL_SIGCATCH);

/* Init function. */

void
glibtop_init_proc_signal_s (glibtop *server)
{
	server->sysdeps.proc_signal = _glibtop_sysdeps_proc_signal;
}

/* Provides detailed information about a process. */

void
glibtop_get_proc_signal_s (glibtop *server, glibtop_proc_signal *buf,
			   pid_t pid)
{
	struct procsinfo *pinfo;
	int i;
	long bit;

	memset (buf, 0, sizeof (glibtop_proc_signal));

	pinfo = _glibtop_get_procinfo(server, pid);
	if (pinfo == NULL)
	{
		glibtop_error_io_r (server, "Cannot read procsinfo");

		return;
	}
	
	/* pending signals */

#define NB_BITS	(8 * sizeof(u_int64_t))

	for (i = 0; (i < NSIG) && (i < 2 * NB_BITS); i++)
	{
		bit = 1 << (NB_BITS - 1 - (i % NB_BITS));

		if (sigismember(&pinfo->pi_sig, i))
			buf->signal[i / NB_BITS] |= bit;

		if (pinfo->pi_signal[i] == (long)SIG_HOLD)
			buf->blocked[i / NB_BITS] |= bit;

		if (pinfo->pi_signal[i] == (long)SIG_IGN)
			buf->sigignore[i / NB_BITS] |= bit;

		if (pinfo->pi_signal[i] == (long)SIG_CATCH)
			buf->sigcatch[i / NB_BITS] |= bit;
	}
	
	buf->flags = _glibtop_sysdeps_proc_signal;
}
