#! /usr/bin/env python

#
# Simple script for generating .mo files from .po files.
#

import os
import commands
import sys


MSGFMT = "msgfmt --statistics --output=%(mofile)s %(pofile)s"


def compile_po(domain, source, targetpath):

    file = os.path.basename(source)
    lang, ext = os.path.splitext(file)
    fulltargetpath = os.path.join(targetpath, lang, "LC_MESSAGES")
    os.system("mkdir -p " + fulltargetpath)
    
    print (source)
    mofile = os.path.join(fulltargetpath, domain + ".mo")
    pofile = source
    os.system(MSGFMT % vars())
    print

def print_usage():
	print "Usage: install_locale.py domain [source-path] [target-path]"
	print
	print "         domain              the gettext domain to use"
	print "         source-path (opt.)  the path containing the po files"
	print "         target-path (opt.)  the base path where the compiled po files should"
	print "                             be stored (cp. ${localedir} variable)"

if (len (sys.argv) > 1):
	domain = sys.argv[1]
	print
	print "Domain: %(domain)s" % vars()
	print
else:
	print_usage()
	print
	sys.exit("INFO: Exiting.")

# if 2nd argument is a path, use it as source path.
if (len (sys.argv) > 2 and os.path.exists(sys.argv[2])):
	sourcepath = os.path.abspath(sys.argv[2])
else:
	print "WARNING: No source path specified. Using default."
	print "INFO: Run script without arguments to get usage info."
	print
	sourcepath = os.path.abspath("../po")
print "Source Path: %(sourcepath)s" % vars()
print

# if 3rd argument is a path, use it as target path.
if (len (sys.argv) > 3 and os.path.exists(sys.argv[3])):
	targetpath = os.path.abspath(sys.argv[3])
else:
	print "WARNING: No target path specified. Using default."
	print "INFO: Run script without arguments to get usage info."
	print
	targetpath = os.getcwd()
print "Target Path: %(targetpath)s" % vars()
print

status, output = commands.getstatusoutput("ls " + sourcepath + "/*.po")
if status != 0:
    print "WARNING: No .po file found in source path."
    print "ERROR: Aborting."
    sys.exit()

#pofile = os.path.basename(output)
files = os.listdir(sourcepath)
for f in files:
    nil, ext = os.path.splitext(f)
    if (ext == ".po"):
        compile_po(domain, os.path.join (sourcepath + "/" + f), targetpath)
