/* rygel-main.c generated by valac, the Vala compiler
 * generated from rygel-main.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cstuff.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>
#include <gst/gst.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>


#define RYGEL_TYPE_MAIN (rygel_main_get_type ())
#define RYGEL_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MAIN, RygelMain))
#define RYGEL_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MAIN, RygelMainClass))
#define RYGEL_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MAIN))
#define RYGEL_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MAIN))
#define RYGEL_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MAIN, RygelMainClass))

typedef struct _RygelMain RygelMain;
typedef struct _RygelMainClass RygelMainClass;
typedef struct _RygelMainPrivate RygelMainPrivate;

#define RYGEL_TYPE_PLUGIN_LOADER (rygel_plugin_loader_get_type ())
#define RYGEL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader))
#define RYGEL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))
#define RYGEL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))

typedef struct _RygelPluginLoader RygelPluginLoader;
typedef struct _RygelPluginLoaderClass RygelPluginLoaderClass;

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_LOG_HANDLER (rygel_log_handler_get_type ())
#define RYGEL_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandler))
#define RYGEL_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))
#define RYGEL_IS_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_IS_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_LOG_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))

typedef struct _RygelLogHandler RygelLogHandler;
typedef struct _RygelLogHandlerClass RygelLogHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _rygel_root_device_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_root_device_factory_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelMainCreateDeviceData RygelMainCreateDeviceData;

#define RYGEL_TYPE_DBUS_SERVICE (rygel_dbus_service_get_type ())
#define RYGEL_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusService))
#define RYGEL_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))
#define RYGEL_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))

typedef struct _RygelDBusService RygelDBusService;
typedef struct _RygelDBusServiceClass RygelDBusServiceClass;

struct _RygelMain {
	GObject parent_instance;
	RygelMainPrivate * priv;
	gboolean restart;
};

struct _RygelMainClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	char* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	char* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_title) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_string) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const char* section, const char* key, GError** error);
};

struct _RygelMainPrivate {
	RygelPluginLoader* plugin_loader;
	GUPnPContextManager* context_manager;
	GeeArrayList* factories;
	GeeArrayList* root_devices;
	RygelConfiguration* config;
	RygelLogHandler* log_handler;
	GMainLoop* main_loop;
	gint exit_code;
};

struct _RygelRootDeviceFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelRootDeviceFactoryPrivate * priv;
	GUPnPContext* context;
};

struct _RygelRootDeviceFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelRootDeviceFactory *self);
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	char* name;
	char* title;
	char* description;
	char* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelMainCreateDeviceData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMain* self;
	RygelPlugin* plugin;
	RygelRootDeviceFactory* factory;
	RygelRootDevice* device;
	GError * _error_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()

static gint rygel_main_PLUGIN_TIMEOUT;
static gint rygel_main_PLUGIN_TIMEOUT = 5;
static gpointer rygel_main_parent_class = NULL;

GType rygel_main_get_type (void);
GType rygel_plugin_loader_get_type (void);
gpointer rygel_root_device_factory_ref (gpointer instance);
void rygel_root_device_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_root_device_factory (GValue* value, gpointer v_object);
void rygel_value_take_root_device_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_root_device_factory (const GValue* value);
GType rygel_root_device_factory_get_type (void);
GType rygel_root_device_get_type (void);
GType rygel_log_level_get_type (void);
GType rygel_configuration_get_type (void);
GType rygel_log_handler_get_type (void);
#define RYGEL_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MAIN, RygelMainPrivate))
enum  {
	RYGEL_MAIN_DUMMY_PROPERTY
};
RygelLogHandler* rygel_log_handler_get_default (void);
GType rygel_meta_config_get_type (void);
RygelMetaConfig* rygel_meta_config_get_default (void);
RygelPluginLoader* rygel_plugin_loader_new (void);
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type);
static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self);
GType rygel_plugin_get_type (void);
static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin);
static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self);
static void rygel_main_application_exit_cb (RygelMain* self, gboolean restart);
static void _rygel_main_application_exit_cb_cstuff_utils_application_exit_cb (gboolean restart, gpointer self);
static RygelMain* rygel_main_new (GError** error);
static RygelMain* rygel_main_construct (GType object_type, GError** error);
void rygel_main_exit (RygelMain* self, gint exit_code);
void rygel_plugin_loader_load_plugins (RygelPluginLoader* self);
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self);
static gboolean _lambda8_ (RygelMain* self);
static gboolean __lambda8__gsource_func (gpointer self);
static gint rygel_main_run (RygelMain* self);
static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_);
gint rygel_configuration_get_port (RygelConfiguration* self, GError** error);
static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
char* rygel_configuration_get_interface (RygelConfiguration* self, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
static void rygel_main_create_device_data_free (gpointer _data);
static void rygel_main_create_device_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _rygel_main_create_device_co_gsource_func (gpointer self);
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
gboolean rygel_plugin_get_available (RygelPlugin* self);
static void rygel_main_on_plugin_notify (RygelMain* self, RygelPlugin* plugin, GParamSpec* spec);
static void _rygel_main_on_plugin_notify_g_object_notify (RygelPlugin* _sender, GParamSpec* pspec, gpointer self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void);
static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* data);
GType rygel_dbus_service_get_type (void);
static char** _vala_array_dup1 (char** self, int length);
GQuark rygel_cmdline_config_error_quark (void);
void rygel_cmdline_config_parse_args (char*** args, int* args_length1, GError** error);
RygelDBusService* rygel_dbus_service_new (RygelMain* main, GError** error);
RygelDBusService* rygel_dbus_service_construct (GType object_type, RygelMain* main, GError** error);
static gint rygel_main_main (char** args, int args_length1);
static void rygel_main_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 93 "rygel-main.vala"
static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self) {
#line 347 "rygel-main.c"
	rygel_main_on_plugin_loaded (self, _sender, plugin);
}


#line 87 "rygel-main.vala"
static void _rygel_main_application_exit_cb_cstuff_utils_application_exit_cb (gboolean restart, gpointer self) {
#line 354 "rygel-main.c"
	rygel_main_application_exit_cb (self, restart);
}


#line 44 "rygel-main.vala"
static RygelMain* rygel_main_construct (GType object_type, GError** error) {
#line 361 "rygel-main.c"
	RygelMain * self;
	RygelLogHandler* _tmp0_;
	RygelConfiguration* _tmp1_;
	RygelPluginLoader* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GUPnPContextManager* _tmp5_;
	GMainLoop* _tmp6_;
#line 44 "rygel-main.vala"
	self = (RygelMain*) g_object_new (object_type, NULL);
#line 45 "rygel-main.vala"
	g_set_application_name (_ (PACKAGE_NAME));
#line 47 "rygel-main.vala"
	self->priv->log_handler = (_tmp0_ = rygel_log_handler_get_default (), _g_object_unref0 (self->priv->log_handler), _tmp0_);
#line 48 "rygel-main.vala"
	self->priv->config = (_tmp1_ = (RygelConfiguration*) rygel_meta_config_get_default (), _g_object_unref0 (self->priv->config), _tmp1_);
#line 49 "rygel-main.vala"
	self->priv->plugin_loader = (_tmp2_ = rygel_plugin_loader_new (), _g_object_unref0 (self->priv->plugin_loader), _tmp2_);
#line 50 "rygel-main.vala"
	self->priv->root_devices = (_tmp3_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->root_devices), _tmp3_);
#line 51 "rygel-main.vala"
	self->priv->factories = (_tmp4_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE_FACTORY, (GBoxedCopyFunc) rygel_root_device_factory_ref, rygel_root_device_factory_unref, NULL), _g_object_unref0 (self->priv->factories), _tmp4_);
#line 52 "rygel-main.vala"
	self->priv->context_manager = (_tmp5_ = rygel_main_create_context_manager (self), _g_object_unref0 (self->priv->context_manager), _tmp5_);
#line 53 "rygel-main.vala"
	self->priv->main_loop = (_tmp6_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (self->priv->main_loop), _tmp6_);
#line 55 "rygel-main.vala"
	self->priv->exit_code = 0;
#line 57 "rygel-main.vala"
	g_signal_connect_object (self->priv->plugin_loader, "plugin-available", (GCallback) _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available, self, 0);
#line 59 "rygel-main.vala"
	on_application_exit (_rygel_main_application_exit_cb_cstuff_utils_application_exit_cb, self);
#line 394 "rygel-main.c"
	return self;
}


#line 44 "rygel-main.vala"
static RygelMain* rygel_main_new (GError** error) {
#line 44 "rygel-main.vala"
	return rygel_main_construct (RYGEL_TYPE_MAIN, error);
#line 403 "rygel-main.c"
}


#line 62 "rygel-main.vala"
void rygel_main_exit (RygelMain* self, gint exit_code) {
#line 62 "rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 63 "rygel-main.vala"
	self->priv->exit_code = exit_code;
#line 65 "rygel-main.vala"
	g_main_loop_quit (self->priv->main_loop);
#line 415 "rygel-main.c"
}


#line 71 "rygel-main.vala"
static gboolean _lambda8_ (RygelMain* self) {
#line 421 "rygel-main.c"
	gboolean result = FALSE;
	GeeCollection* _tmp0_;
	gboolean _tmp1_;
#line 72 "rygel-main.vala"
	if ((_tmp1_ = gee_collection_get_size (_tmp0_ = rygel_plugin_loader_list_plugins (self->priv->plugin_loader)) == 0, _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 73 "rygel-main.vala"
		g_warning (_ ("No plugins found in %d seconds, giving up.."), rygel_main_PLUGIN_TIMEOUT);
#line 76 "rygel-main.vala"
		rygel_main_exit (self, -82);
#line 431 "rygel-main.c"
	}
	result = FALSE;
#line 79 "rygel-main.vala"
	return result;
#line 436 "rygel-main.c"
}


#line 71 "rygel-main.vala"
static gboolean __lambda8__gsource_func (gpointer self) {
#line 442 "rygel-main.c"
	return _lambda8_ (self);
}


#line 68 "rygel-main.vala"
static gint rygel_main_run (RygelMain* self) {
#line 449 "rygel-main.c"
	gint result = 0;
#line 68 "rygel-main.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 69 "rygel-main.vala"
	rygel_plugin_loader_load_plugins (self->priv->plugin_loader);
#line 71 "rygel-main.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) rygel_main_PLUGIN_TIMEOUT, __lambda8__gsource_func, g_object_ref (self), g_object_unref);
#line 82 "rygel-main.vala"
	g_main_loop_run (self->priv->main_loop);
#line 459 "rygel-main.c"
	result = self->priv->exit_code;
#line 84 "rygel-main.vala"
	return result;
#line 463 "rygel-main.c"
}


#line 87 "rygel-main.vala"
static void rygel_main_application_exit_cb (RygelMain* self, gboolean restart) {
#line 87 "rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 88 "rygel-main.vala"
	self->restart = restart;
#line 90 "rygel-main.vala"
	rygel_main_exit (self, 0);
#line 475 "rygel-main.c"
}


#line 93 "rygel-main.vala"
static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin) {
#line 481 "rygel-main.c"
	GeeIterator* iterator;
#line 93 "rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 93 "rygel-main.vala"
	g_return_if_fail (plugin_loader != NULL);
#line 93 "rygel-main.vala"
	g_return_if_fail (plugin != NULL);
#line 95 "rygel-main.vala"
	iterator = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->factories);
#line 96 "rygel-main.vala"
	while (TRUE) {
#line 493 "rygel-main.c"
		RygelRootDeviceFactory* _tmp0_;
#line 96 "rygel-main.vala"
		if (!gee_iterator_next (iterator)) {
#line 96 "rygel-main.vala"
			break;
#line 499 "rygel-main.c"
		}
#line 97 "rygel-main.vala"
		rygel_main_create_device (self, plugin, _tmp0_ = (RygelRootDeviceFactory*) gee_iterator_get (iterator), NULL, NULL);
#line 503 "rygel-main.c"
		_rygel_root_device_factory_unref0 (_tmp0_);
	}
	_g_object_unref0 (iterator);
}


#line 116 "rygel-main.vala"
static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
#line 512 "rygel-main.c"
	rygel_main_on_context_available (self, _sender, p0);
}


#line 148 "rygel-main.vala"
static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
#line 519 "rygel-main.c"
	rygel_main_on_context_unavailable (self, _sender, p0);
}


#line 101 "rygel-main.vala"
static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self) {
#line 526 "rygel-main.c"
	GUPnPContextManager* result = NULL;
	GError * _inner_error_;
	gint port;
	GUPnPContextManager* manager;
#line 101 "rygel-main.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 533 "rygel-main.c"
	_inner_error_ = NULL;
#line 102 "rygel-main.vala"
	port = 0;
#line 537 "rygel-main.c"
	{
		gint _tmp0_;
#line 105 "rygel-main.vala"
		_tmp0_ = rygel_configuration_get_port (self->priv->config, &_inner_error_);
#line 542 "rygel-main.c"
		if (_inner_error_ != NULL) {
			goto __catch60_g_error;
		}
#line 105 "rygel-main.vala"
		port = _tmp0_;
#line 548 "rygel-main.c"
	}
	goto __finally60;
	__catch60_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally60:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 108 "rygel-main.vala"
	manager = gupnp_context_manager_new (NULL, (guint) port);
#line 110 "rygel-main.vala"
	g_signal_connect_object (manager, "context-available", (GCallback) _rygel_main_on_context_available_gupnp_context_manager_context_available, self, 0);
#line 111 "rygel-main.vala"
	g_signal_connect_object (manager, "context-unavailable", (GCallback) _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
#line 572 "rygel-main.c"
	result = manager;
#line 113 "rygel-main.vala"
	return result;
#line 576 "rygel-main.c"
}


#line 116 "rygel-main.vala"
static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
#line 582 "rygel-main.c"
	GError * _inner_error_;
	char* iface;
	gboolean _tmp2_ = FALSE;
#line 116 "rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 116 "rygel-main.vala"
	g_return_if_fail (manager != NULL);
#line 116 "rygel-main.vala"
	g_return_if_fail (context != NULL);
#line 592 "rygel-main.c"
	_inner_error_ = NULL;
#line 118 "rygel-main.vala"
	iface = NULL;
#line 120 "rygel-main.vala"
	g_debug (_ ("new network context %s (%s) available."), gssdp_client_get_interface ((GSSDPClient*) context), gssdp_client_get_host_ip ((GSSDPClient*) context));
#line 598 "rygel-main.c"
	{
		char* _tmp0_;
		char* _tmp1_;
#line 125 "rygel-main.vala"
		_tmp0_ = rygel_configuration_get_interface (self->priv->config, &_inner_error_);
#line 604 "rygel-main.c"
		if (_inner_error_ != NULL) {
			goto __catch61_g_error;
		}
#line 125 "rygel-main.vala"
		iface = (_tmp1_ = _tmp0_, _g_free0 (iface), _tmp1_);
#line 610 "rygel-main.c"
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally61:
	if (_inner_error_ != NULL) {
		_g_free0 (iface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 128 "rygel-main.vala"
	if (iface == NULL) {
#line 128 "rygel-main.vala"
		_tmp2_ = TRUE;
#line 633 "rygel-main.c"
	} else {
#line 128 "rygel-main.vala"
		_tmp2_ = _vala_strcmp0 (iface, gssdp_client_get_interface ((GSSDPClient*) context)) == 0;
#line 637 "rygel-main.c"
	}
#line 128 "rygel-main.vala"
	if (_tmp2_) {
#line 641 "rygel-main.c"
		{
			RygelRootDeviceFactory* factory;
			GeeCollection* _tmp3_;
			GeeIterator* _tmp4_;
			GeeIterator* iterator;
#line 130 "rygel-main.vala"
			factory = rygel_root_device_factory_new (context, &_inner_error_);
#line 649 "rygel-main.c"
			if (_inner_error_ != NULL) {
				goto __catch62_g_error;
			}
#line 131 "rygel-main.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->factories, factory);
#line 133 "rygel-main.vala"
			iterator = (_tmp4_ = gee_iterable_iterator ((GeeIterable*) (_tmp3_ = rygel_plugin_loader_list_plugins (self->priv->plugin_loader))), _g_object_unref0 (_tmp3_), _tmp4_);
#line 134 "rygel-main.vala"
			while (TRUE) {
#line 659 "rygel-main.c"
				RygelPlugin* _tmp5_;
#line 134 "rygel-main.vala"
				if (!gee_iterator_next (iterator)) {
#line 134 "rygel-main.vala"
					break;
#line 665 "rygel-main.c"
				}
#line 135 "rygel-main.vala"
				rygel_main_create_device (self, _tmp5_ = (RygelPlugin*) gee_iterator_get (iterator), factory, NULL, NULL);
#line 669 "rygel-main.c"
				_g_object_unref0 (_tmp5_);
			}
			_rygel_root_device_factory_unref0 (factory);
			_g_object_unref0 (iterator);
		}
		goto __finally62;
		__catch62_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
#line 138 "rygel-main.vala"
				g_warning (_ ("Failed to create root device factory: %s"), err->message);
#line 684 "rygel-main.c"
				_g_error_free0 (err);
			}
		}
		__finally62:
		if (_inner_error_ != NULL) {
			_g_free0 (iface);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
#line 142 "rygel-main.vala"
		g_debug (_ ("Ignoring network context %s (%s)."), gssdp_client_get_interface ((GSSDPClient*) context), gssdp_client_get_host_ip ((GSSDPClient*) context));
#line 698 "rygel-main.c"
	}
	_g_free0 (iface);
}


#line 148 "rygel-main.vala"
static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
#line 706 "rygel-main.c"
	GeeIterator* factory_iter;
	GeeIterator* device_iter;
#line 148 "rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 148 "rygel-main.vala"
	g_return_if_fail (manager != NULL);
#line 148 "rygel-main.vala"
	g_return_if_fail (context != NULL);
#line 150 "rygel-main.vala"
	g_debug (_ ("Network context %s (%s) now unavailable."), gssdp_client_get_interface ((GSSDPClient*) context), gssdp_client_get_host_ip ((GSSDPClient*) context));
#line 154 "rygel-main.vala"
	factory_iter = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->factories);
#line 155 "rygel-main.vala"
	while (TRUE) {
#line 721 "rygel-main.c"
		RygelRootDeviceFactory* _tmp0_;
		gboolean _tmp1_;
#line 155 "rygel-main.vala"
		if (!gee_iterator_next (factory_iter)) {
#line 155 "rygel-main.vala"
			break;
#line 728 "rygel-main.c"
		}
#line 156 "rygel-main.vala"
		if ((_tmp1_ = context == (_tmp0_ = (RygelRootDeviceFactory*) gee_iterator_get (factory_iter))->context, _rygel_root_device_factory_unref0 (_tmp0_), _tmp1_)) {
#line 157 "rygel-main.vala"
			gee_iterator_remove (factory_iter);
#line 734 "rygel-main.c"
		}
	}
#line 161 "rygel-main.vala"
	device_iter = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->root_devices);
#line 162 "rygel-main.vala"
	while (TRUE) {
#line 741 "rygel-main.c"
		RygelRootDevice* _tmp2_;
		gboolean _tmp3_;
#line 162 "rygel-main.vala"
		if (!gee_iterator_next (device_iter)) {
#line 162 "rygel-main.vala"
			break;
#line 748 "rygel-main.c"
		}
#line 163 "rygel-main.vala"
		if ((_tmp3_ = context == gupnp_device_info_get_context ((GUPnPDeviceInfo*) (_tmp2_ = (RygelRootDevice*) gee_iterator_get (device_iter))), _g_object_unref0 (_tmp2_), _tmp3_)) {
#line 164 "rygel-main.vala"
			gee_iterator_remove (device_iter);
#line 754 "rygel-main.c"
		}
	}
	_g_object_unref0 (factory_iter);
	_g_object_unref0 (device_iter);
}


static void rygel_main_create_device_data_free (gpointer _data) {
	RygelMainCreateDeviceData* data;
	data = _data;
	_g_object_unref0 (data->plugin);
	_rygel_root_device_factory_unref0 (data->factory);
	g_object_unref (data->self);
	g_slice_free (RygelMainCreateDeviceData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_root_device_factory_ref0 (gpointer self) {
	return self ? rygel_root_device_factory_ref (self) : NULL;
}


static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMainCreateDeviceData* _data_;
	_data_ = g_slice_new0 (RygelMainCreateDeviceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_main_create_device);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_main_create_device_data_free);
	_data_->self = g_object_ref (self);
	_data_->plugin = _g_object_ref0 (plugin);
	_data_->factory = _rygel_root_device_factory_ref0 (factory);
	rygel_main_create_device_co (_data_);
}


static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_) {
	RygelMainCreateDeviceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_main_create_device_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMainCreateDeviceData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_main_create_device_co (data);
}


#line 169 "rygel-main.vala"
static gboolean _rygel_main_create_device_co_gsource_func (gpointer self) {
#line 810 "rygel-main.c"
	return rygel_main_create_device_co (self);
}


#line 195 "rygel-main.vala"
static void _rygel_main_on_plugin_notify_g_object_notify (RygelPlugin* _sender, GParamSpec* pspec, gpointer self) {
#line 817 "rygel-main.c"
	rygel_main_on_plugin_notify (self, _sender, pspec);
}


static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 46:
		goto _state_46;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
#line 177 "rygel-main.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_main_create_device_co_gsource_func, data, NULL);
#line 835 "rygel-main.c"
		data->_state_ = 46;
		return FALSE;
		_state_46:
		;
		{
			data->device = rygel_root_device_factory_create (data->factory, data->plugin, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch63_g_error;
			}
#line 183 "rygel-main.vala"
			gupnp_root_device_set_available ((GUPnPRootDevice*) data->device, rygel_plugin_get_available (data->plugin));
#line 185 "rygel-main.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) data->self->priv->root_devices, data->device);
#line 187 "rygel-main.vala"
			g_signal_connect_object ((GObject*) data->plugin, "notify::available", (GCallback) _rygel_main_on_plugin_notify_g_object_notify, data->self, 0);
#line 851 "rygel-main.c"
			_g_object_unref0 (data->device);
		}
		goto __finally63;
		__catch63_g_error:
		{
			data->_error_ = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
#line 189 "rygel-main.vala"
				g_warning (_ ("Failed to create RootDevice for %s. Reason: %s"), data->plugin->name, data->_error_->message);
#line 862 "rygel-main.c"
				_g_error_free0 (data->_error_);
			}
		}
		__finally63:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 195 "rygel-main.vala"
static void rygel_main_on_plugin_notify (RygelMain* self, RygelPlugin* plugin, GParamSpec* spec) {
#line 195 "rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 195 "rygel-main.vala"
	g_return_if_fail (plugin != NULL);
#line 195 "rygel-main.vala"
	g_return_if_fail (spec != NULL);
#line 893 "rygel-main.c"
	{
		GeeIterator* _device_it;
		_device_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->root_devices);
#line 197 "rygel-main.vala"
		while (TRUE) {
#line 899 "rygel-main.c"
			RygelRootDevice* device;
#line 197 "rygel-main.vala"
			if (!gee_iterator_next (_device_it)) {
#line 197 "rygel-main.vala"
				break;
#line 905 "rygel-main.c"
			}
#line 197 "rygel-main.vala"
			device = (RygelRootDevice*) gee_iterator_get (_device_it);
#line 198 "rygel-main.vala"
			if (gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) device) == GUPNP_RESOURCE_FACTORY (plugin)) {
#line 199 "rygel-main.vala"
				gupnp_root_device_set_available ((GUPnPRootDevice*) device, rygel_plugin_get_available (plugin));
#line 913 "rygel-main.c"
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_it);
	}
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


#line 204 "rygel-main.vala"
static gint rygel_main_main (char** args, int args_length1) {
#line 935 "rygel-main.c"
	gint result = 0;
	GError * _inner_error_;
	RygelMain* main;
	RygelDBusService* service;
	char** _tmp1_;
	gint _original_args_size_;
	gint original_args_length1;
	char** _tmp0_;
	char** original_args;
	gint exit_code;
	_inner_error_ = NULL;
#line 205 "rygel-main.vala"
	main = NULL;
#line 949 "rygel-main.c"
	service = NULL;
	original_args = (_tmp1_ = (_tmp0_ = args, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, args_length1)), original_args_length1 = args_length1, _original_args_size_ = original_args_length1, _tmp1_);
	{
		char** _tmp2_;
		gint _dummy_args_size_;
		gint dummy_args_length1;
		char** dummy_args;
		RygelMain* _tmp3_;
		RygelMain* _tmp4_;
		RygelDBusService* _tmp5_;
		RygelDBusService* _tmp6_;
#line 212 "rygel-main.vala"
		rygel_cmdline_config_parse_args (&args, &args_length1, &_inner_error_);
#line 963 "rygel-main.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch64_dbus_gerror;
			}
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
				goto __catch64_rygel_cmdline_config_error_version_only;
			}
			goto __catch64_g_error;
		}
		dummy_args = (_tmp2_ = g_new0 (char*, 0 + 1), dummy_args_length1 = 0, _dummy_args_size_ = dummy_args_length1, _tmp2_);
#line 216 "rygel-main.vala"
		gst_init (&dummy_args_length1, &dummy_args);
#line 218 "rygel-main.vala"
		_tmp3_ = rygel_main_new (&_inner_error_);
#line 978 "rygel-main.c"
		if (_inner_error_ != NULL) {
			dummy_args = (_vala_array_free (dummy_args, dummy_args_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch64_dbus_gerror;
			}
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
				goto __catch64_rygel_cmdline_config_error_version_only;
			}
			goto __catch64_g_error;
		}
#line 218 "rygel-main.vala"
		main = (_tmp4_ = _tmp3_, _g_object_unref0 (main), _tmp4_);
#line 219 "rygel-main.vala"
		_tmp5_ = rygel_dbus_service_new (main, &_inner_error_);
#line 993 "rygel-main.c"
		if (_inner_error_ != NULL) {
			dummy_args = (_vala_array_free (dummy_args, dummy_args_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch64_dbus_gerror;
			}
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
				goto __catch64_rygel_cmdline_config_error_version_only;
			}
			goto __catch64_g_error;
		}
#line 219 "rygel-main.vala"
		service = (_tmp6_ = _tmp5_, _g_object_unref0 (service), _tmp6_);
#line 1006 "rygel-main.c"
		dummy_args = (_vala_array_free (dummy_args, dummy_args_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally64;
	__catch64_dbus_gerror:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 221 "rygel-main.vala"
			g_warning (_ ("Failed to start D-Bus service: %s"), err->message);
#line 1018 "rygel-main.c"
			_g_error_free0 (err);
		}
	}
	goto __finally64;
	__catch64_rygel_cmdline_config_error_version_only:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			result = 0;
			_g_error_free0 (err);
			_g_object_unref0 (main);
			_g_object_unref0 (service);
			original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 223 "rygel-main.vala"
			return result;
#line 1036 "rygel-main.c"
		}
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 225 "rygel-main.vala"
			g_error ("rygel-main.vala:225: %s", err->message);
#line 1048 "rygel-main.c"
			result = -1;
			_g_error_free0 (err);
			_g_object_unref0 (main);
			_g_object_unref0 (service);
			original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 227 "rygel-main.vala"
			return result;
#line 1056 "rygel-main.c"
		}
	}
	__finally64:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (main);
		_g_object_unref0 (service);
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
#line 230 "rygel-main.vala"
	exit_code = rygel_main_run (main);
#line 232 "rygel-main.vala"
	if (main->restart) {
#line 233 "rygel-main.vala"
		restart_application (original_args);
#line 1074 "rygel-main.c"
	}
	result = exit_code;
	_g_object_unref0 (main);
	_g_object_unref0 (service);
	original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 236 "rygel-main.vala"
	return result;
#line 1082 "rygel-main.c"
}


#line 204 "rygel-main.vala"
int main (int argc, char ** argv) {
#line 1088 "rygel-main.c"
	g_thread_init (NULL);
#line 204 "rygel-main.vala"
	g_type_init ();
#line 204 "rygel-main.vala"
	return rygel_main_main (argv, argc);
#line 1094 "rygel-main.c"
}


static void rygel_main_class_init (RygelMainClass * klass) {
	rygel_main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMainPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_main_finalize;
}


static void rygel_main_instance_init (RygelMain * self) {
	self->priv = RYGEL_MAIN_GET_PRIVATE (self);
}


static void rygel_main_finalize (GObject* obj) {
	RygelMain * self;
	self = RYGEL_MAIN (obj);
	_g_object_unref0 (self->priv->plugin_loader);
	_g_object_unref0 (self->priv->context_manager);
	_g_object_unref0 (self->priv->factories);
	_g_object_unref0 (self->priv->root_devices);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->log_handler);
	_g_main_loop_unref0 (self->priv->main_loop);
	G_OBJECT_CLASS (rygel_main_parent_class)->finalize (obj);
}


GType rygel_main_get_type (void) {
	static volatile gsize rygel_main_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMain), 0, (GInstanceInitFunc) rygel_main_instance_init, NULL };
		GType rygel_main_type_id;
		rygel_main_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMain", &g_define_type_info, 0);
		g_once_init_leave (&rygel_main_type_id__volatile, rygel_main_type_id);
	}
	return rygel_main_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




