/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __galeon_navigation_button_h
#define __galeon_navigation_button_h

#include "galeon-tbi.h"

/* object forward declarations */

typedef struct _GaleonNavigationButton GaleonNavigationButton;
typedef struct _GaleonNavigationButtonClass GaleonNavigationButtonClass;
typedef struct _GaleonNavigationButtonPrivate GaleonNavigationButtonPrivate;

/**
 * TbiZoom object
 */

#define GALEON_TYPE_NAVIGATION_BUTTON			(galeon_navigation_button_get_type())
#define GALEON_NAVIGATION_BUTTON(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), \
							 GALEON_TYPE_NAVIGATION_BUTTON, GaleonNavigationButton))
#define GALEON_NAVIGATION_BUTTON_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), GALEON_TYPE_NAVIGATION_BUTTON,\
							 GaleonNavigationButtonClass))
#define GALEON_IS_NAVIGATION_BUTTON(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), \
							 GALEON_TYPE_NAVIGATION_BUTTON))
#define GALEON_IS_NAVIGATION_BUTTON_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), GALEON_TYPE_NAVIGATION_BUTTON))
#define GALEON_NAVIGATION_BUTTON_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GALEON_TYPE_NAVIGATION_BUTTON,\
							 GaleonNavigationButtonClass))

typedef enum
{
	GALEON_NAVIGATION_DIRECTION_UP,
	GALEON_NAVIGATION_DIRECTION_BACK,
	GALEON_NAVIGATION_DIRECTION_FORWARD
} GaleonNavigationDirection;

struct _GaleonNavigationButtonClass 
{
	GaleonTbiClass parent_class;
};

/* Remember: fields are public read-only */
struct _GaleonNavigationButton
{
	GaleonTbi parent_object;
	GaleonNavigationButtonPrivate *priv;
};

/* this class is abstract */

GType				galeon_navigation_button_get_type	(void);
GaleonNavigationButton *	galeon_navigation_button_new		(void);
void			 	galeon_navigation_button_set_direction	(GaleonNavigationButton *a,
									 GaleonNavigationDirection d);
void				galeon_navigation_button_set_show_arrow	(GaleonNavigationButton *b,
									 gboolean value);
GaleonNavigationDirection 	galeon_navigation_button_get_direction	(GaleonNavigationButton *b);
void				galeon_navigation_button_set_sensitive	(GaleonNavigationButton *b, gboolean s);

#endif
