/*
 * Copyright © 2007,2008 Jaap Haitsma <jaap@haitsma.org>
 * Copyright © 2007-2009 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Ryan zeigler <zeiglerr@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __CHEESE_CAMERA_DEVICE_MONITOR_H__
#define __CHEESE_CAMERA_DEVICE_MONITOR_H__

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gst/interfaces/xoverlay.h>
#include <cheese-camera-device.h>

G_BEGIN_DECLS

#define CHEESE_TYPE_CAMERA_DEVICE_MONITOR (cheese_camera_device_monitor_get_type ())
#define CHEESE_CAMERA_DEVICE_MONITOR(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), CHEESE_TYPE_CAMERA_DEVICE_MONITOR, \
                                                                               CheeseCameraDeviceMonitor))
#define CHEESE_CAMERA_DEVICE_MONITOR_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), CHEESE_TYPE_CAMERA_DEVICE_MONITOR, \
                                                                            CheeseCameraDeviceMonitorClass))
#define CHEESE_IS_CAMERA_DEVICE_MONITOR(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), CHEESE_TYPE_CAMERA_DEVICE_MONITOR))
#define CHEESE_IS_CAMERA_DEVICE_MONITOR_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), CHEESE_TYPE_CAMERA_DEVICE_MONITOR))
#define CHEESE_CAMERA_DEVICE_MONITOR_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), CHEESE_TYPE_CAMERA_DEVICE_MONITOR, \
                                                                              CheeseCameraDeviceMonitorClass))

typedef struct
{
  GObject parent;
} CheeseCameraDeviceMonitor;

typedef struct
{
  GObjectClass parent_class;
  void (*added)(CheeseCameraDeviceMonitor *camera, CheeseCameraDevice *device);
  void (*removed)(CheeseCameraDeviceMonitor *camera, const char *id);
} CheeseCameraDeviceMonitorClass;


GType                      cheese_camera_device_monitor_get_type (void);
CheeseCameraDeviceMonitor *cheese_camera_device_monitor_new (void);
void                       cheese_camera_device_monitor_coldplug (CheeseCameraDeviceMonitor *monitor);

G_END_DECLS

#endif /* __CHEESE_CAMERA_DEVICE_MONITOR_H__ */
