/* GStreamer
 * Copyright (C) <2003> Julien Moutte <julien@moutte.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_XIMAGESINK_H__
#define __GST_XIMAGESINK_H__

#include <gst/video/videosink.h>

#include "ximageutil.h"

#include <string.h>
#include <math.h>

G_BEGIN_DECLS

#define GST_TYPE_XIMAGESINK \
  (gst_ximagesink_get_type())
#define GST_XIMAGESINK(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GST_TYPE_XIMAGESINK, GstXImageSink))
#define GST_XIMAGESINK_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), GST_TYPE_XIMAGESINK, GstXImageSink))
#define GST_IS_XIMAGESINK(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GST_TYPE_XIMAGESINK))
#define GST_IS_XIMAGESINK_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), GST_TYPE_XIMAGESINK))

typedef struct _GstXImageSink GstXImageSink;
typedef struct _GstXImageSinkClass GstXImageSinkClass;

struct _GstXImageSink {
  /* Our element stuff */
  GstVideoSink videosink;

  char *display_name;

  GstXContext *xcontext;
  GstXWindow *xwindow;
  GstXImage *ximage;
  GstXImage *cur_image;

  gdouble framerate;
  GMutex *x_lock;
  GMutex *stream_lock;

  /* Unused */
  gint pixel_width, pixel_height;
  GValue *par;                  /* object-set pixel aspect ratio */

  GstClockTime time;

  GMutex *pool_lock;
  GSList *image_pool;

  gboolean synchronous;
  gboolean sw_scaling_failed;  
  gboolean need_expose;

  GMutex *nav_lock;
  GSList *pend_nav_events;
};

struct _GstXImageSinkClass {
  GstVideoSinkClass parent_class;
};

GType gst_ximagesink_get_type(void);

G_END_DECLS

#endif /* __GST_XIMAGESINK_H__ */
