/* $Id: main.c,v 1.49 2005/06/15 18:54:40 vnoel Exp $ */

/*
 *  Mike Hughes <mfh@psilord.com>
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  Main program function
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib/goption.h>
#include <glib/gi18n.h>
#include <libgnomeui/gnome-ui-init.h>
#include <libgnomeui/gnome-client.h>
#include "gdict-app.h"

extern GSList *gdict_windows;

static gboolean
save_yourself_cb (GnomeClient       *client,
                  gint               phase,
                  GnomeRestartStyle  save_style,
                  gint               shutdown,
                  GnomeInteractStyle interact_style,
                  gint               fast,
                  gpointer           client_data)
{
	gchar **argv;
	gchar *word;
  GSList *tmp = gdict_windows;
	GDictWindow *gdict;
  int i, argc;

  argc = g_slist_length(gdict_windows + 1);
  argv = g_malloc (sizeof(gchar *) * argc);

	argv[0] = g_get_prgname ();
  for (i=1; i < argc; i++) {
    gdict = tmp->data;
    word = gdict_defbox_get_word (gdict->defbox);
    argv[i] = word;
    tmp = g_slist_next (tmp);
  }

	gnome_client_set_restart_command(client, argc, argv);
	gnome_client_set_clone_command(client, 0, NULL);

	return TRUE;
}

#if 0
static gint
die_cb (GnomeClient *client, gpointer client_data)
{
	gtk_main_quit ();
}
#endif

int main (int argc, char *argv[])
{
	GnomeClient *client;
	GnomeProgram *program;
	GDictWindow *gdict;
	GtkWidget *window;
	GOptionContext *ctx;
	GError *error;
	gint i;

	bindtextdomain(GETTEXT_PACKAGE, GNOMELOCALEDIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain(GETTEXT_PACKAGE);

	program = gnome_program_init ("gnome-dictionary",
				      VERSION,
				      LIBGNOMEUI_MODULE,
				      argc, argv,
				      GNOME_PARAM_APP_DATADIR,
				      DATADIR, NULL);

	g_set_application_name (_("Dictionary"));
	gtk_window_set_default_icon_name ("gdict");

	if ((client = gnome_master_client()) != NULL) {
		g_signal_connect (client, "save_yourself",
				  G_CALLBACK (save_yourself_cb), NULL);
	    /* FIXME: We should really connect to this, but gnome-session wants to 
	     * remove non-reponsive clients after a timeout - in this case the 
	     * client is busy trying to connect to the dict server
             * g_signal_connect (client, "die", G_CALLBACK (client_die_cb), NULL);
	     */
	}

	ctx = g_option_context_new (" - Dictionary and spelling tool");
  g_option_context_set_ignore_unknown_options (ctx, TRUE);
	g_option_context_parse (ctx, &argc, &argv, &error);

	if (argc > 1) {
		for (i = 1; i < argc; i++) {
      if (argv[i] != NULL && g_ascii_isalpha (argv[i][0])) {
        window = gdict_window_new ();
        gdict = GDICT_WINDOW (window);
        gtk_window_present (GTK_WINDOW(gdict));
        gdict_lookup_definition (gdict, (char *)argv[i]);
      }
		}
	} else {
		window = gdict_window_new ();
		gdict = GDICT_WINDOW (window);
    gtk_window_present (GTK_WINDOW(gdict));
	}

	gtk_main();

	return 0;
}
