#include <locale.h>
#include <config.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>

#include <gst/player/gstmediaplay.h>

#if 0
#define GST_PLAYER_DISCLAIMER \
  "Warning ! GStreamer Media Player is highly alpha code !\n \
   This means :\n \
   - you don't need to tell us it sucks\n \
   - you shouldn't remove xine/mplayer/Windows Media Player yet\n \
   - you are welcome to do patches or suggest features\n \
   - you should make liberal use of http://bugzilla.gnome.org/ for bugs\n \
   - you should attach output of gst-feedback to your bug report\n \
   \n \
   In general, this is only a test bed for GStreamer features, and not yet \
   the finished product we intend to ship.\n \
   Check the README for more information. \
   You can turn off this warning (but not the reason for it) \
   by unsetting the show-warning GConf key.\n"


static void
on_load_file_selected (GtkWidget *button, GstMediaPlay *mplay)
{
	GtkWidget *file_selection;

	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	file_selection = GTK_WIDGET(g_object_get_data(G_OBJECT(button), "file_selection"));
	gst_media_play_set_location (mplay, gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_selection)));
}

static void
cb_open (GtkWidget *widget, GstMediaPlay *mplay)
{
	GtkWidget *file_selection;

	g_return_if_fail (GST_IS_MEDIA_PLAY(mplay));

	file_selection = gtk_file_selection_new (_("Please select a file to load."));
	
	g_object_set_data(G_OBJECT(GTK_FILE_SELECTION(file_selection)->ok_button), "file_selection", file_selection);

	g_signal_connect (G_OBJECT (GTK_FILE_SELECTION(file_selection)->ok_button),
			  "clicked", G_CALLBACK (on_load_file_selected), mplay);
  
	g_signal_connect_swapped (GTK_OBJECT (GTK_FILE_SELECTION (file_selection)->ok_button),
				   "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
				   (gpointer) file_selection);
	g_signal_connect_swapped (GTK_OBJECT (GTK_FILE_SELECTION (file_selection)->cancel_button),
				   "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
				   (gpointer) file_selection);
	
	gtk_widget_show (file_selection);
}

static void
on_open_location_selected (GtkDialog *dialog, gint response, GstMediaPlay *mplay)
{
	GtkWidget *textbox;

	if (response != GTK_RESPONSE_ACCEPT){
		return;
	}
	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	textbox = GTK_WIDGET(g_object_get_data(G_OBJECT(dialog), "textbox"));
	gst_media_play_set_location (mplay, gtk_entry_get_text(GTK_ENTRY(textbox)));
}

static void
cb_open_location (GtkWidget *widget, GstMediaPlay *mplay)
{
	GtkWidget *dialog;
	GtkWidget *textbox;

	dialog = gtk_dialog_new_with_buttons("Please enter a URL to load.", GTK_WINDOW(gtk_widget_get_toplevel(widget)), 
	                                     GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, 
                                             GTK_STOCK_CANCEL,
                                             GTK_RESPONSE_REJECT,
					     GTK_STOCK_OK,
                                             GTK_RESPONSE_ACCEPT,
                                             NULL);

	g_return_if_fail(GTK_IS_DIALOG(dialog));
	textbox = gtk_entry_new();
	gtk_entry_set_width_chars(GTK_ENTRY(textbox), 80);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), textbox);
	g_object_set_data(G_OBJECT(dialog), "textbox", textbox);
	g_signal_connect (G_OBJECT(dialog),
			  "response", G_CALLBACK (on_open_location_selected), mplay);
	g_signal_connect_swapped (GTK_OBJECT (dialog),
				   "response", GTK_SIGNAL_FUNC (gtk_widget_destroy),
				   (gpointer) dialog);
	gtk_widget_show_all (dialog);
}
#endif

void
cb_destroy (GObject object, GtkWidget *window)
{
	gtk_main_quit ();
}

static void
toggle_play_pause (GtkWidget *widget, GstMediaPlay *mplay)
{
	GstElementState playstate;

	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));

	playstate = gst_media_play_get_state (mplay);

	if (playstate == GST_STATE_PLAYING) {
		gst_media_play_set_state (mplay, GST_STATE_PAUSED);
	}
	else {
		gst_media_play_set_state (mplay, GST_STATE_PLAYING);
	}
}

static void
toggle_mini_display_mode (GtkWidget *widget, GstMediaPlay *mplay)
{
	GstMediaPlayMode display_mode;
	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	
	display_mode = gst_media_play_get_display_mode (mplay);
	if (display_mode == GST_MEDIA_PLAY_MINI){
		gst_media_play_set_display_mode (mplay, GST_MEDIA_PLAY_NORMAL);
	}
	else {
		gst_media_play_set_display_mode (mplay, GST_MEDIA_PLAY_MINI);
	}
}

static void
toggle_fullscreen (GtkWidget *widget, GstMediaPlay *mplay)
{
	GstMediaPlayMode display_mode;
	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	
	display_mode = gst_media_play_get_display_mode (mplay);
	if (display_mode == GST_MEDIA_PLAY_FULLSCREEN){
		gst_media_play_set_display_mode (mplay, GST_MEDIA_PLAY_NORMAL);
	}
	else {
		gst_media_play_set_display_mode (mplay, GST_MEDIA_PLAY_FULLSCREEN);
	}
}

static void
current_location (GstMediaPlay *mplay, gchar *location, gchar *location_short, GtkWidget *window)
{
	gtk_window_set_title (GTK_WINDOW (window),location_short);
}

#if 0
static void
display_mode_change (GstMediaPlay *mplay, GstMediaPlayMode display_mode, GtkWidget *window)
{
	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	if (display_mode == GST_MEDIA_PLAY_MINI){
		gtk_widget_hide (GTK_WINDOW (window)->menubar);
	}
	else {
		gtk_widget_show (GTK_WINDOW (window)->menubar);
	}
}
#endif

#if 0
static void
half_size (GtkWidget *widget, GstMediaPlay *mplay)
{
	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	gst_media_play_set_video_scale(mplay, 0.5F);
}

static void
full_size (GtkWidget *widget, GstMediaPlay *mplay)
{
	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	gst_media_play_set_video_scale(mplay, 1.0F);
}

static void
double_size (GtkWidget *widget, GstMediaPlay *mplay)
{
	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	gst_media_play_set_video_scale(mplay, 2.0F);
}

static void
show_media_info (GtkWidget *widget, GstMediaPlay *mplay)
{
	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	gst_media_play_show_media_info(mplay);
}

static void
show_preferences (GtkWidget *widget, GstMediaPlay *mplay)
{
	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	gst_media_play_show_preferences(mplay);
}

static void
show_about (GtkWidget *widget, GstMediaPlay *mplay)
{
	g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));
	gst_media_play_show_about(mplay);
}
#endif

static int
window_key_press_event (GtkWidget *widget, GdkEventKey *event, GstMediaPlay *mplay)
{
	guint state;
	gboolean handled = FALSE;
  
	//g_return_if_fail(GST_IS_MEDIA_PLAY(mplay));

	state = event->state;
  
	switch (event->keyval) {
	case GDK_KP_Add:
		gst_media_play_set_volume(mplay, gst_media_play_get_volume(mplay) + 0.1);
		handled = TRUE;
		break;
	case GDK_KP_Subtract:
		gst_media_play_set_volume(mplay, gst_media_play_get_volume(mplay) - 0.1);
		handled = TRUE;
		break;
	case GDK_space:
		toggle_play_pause (widget, mplay);
		handled = TRUE;
		break;
	case GDK_m:
		toggle_fullscreen (widget, mplay);
		handled = TRUE;
		break;
	case GDK_Return:
		if (state & GDK_MOD1_MASK)
			toggle_fullscreen (widget, mplay);
		handled = TRUE;
		break;
	}
  
	return handled;
}

#if 0
static GnomeUIInfo file_menu [] = 
{
	GNOMEUIINFO_MENU_OPEN_ITEM (cb_open, NULL),
	{
		GNOME_APP_UI_ITEM, N_("Open _Location"),
		NULL,
		cb_open_location, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		GDK_L, (GdkModifierType) GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_EXIT_ITEM (cb_destroy, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo view_menu [] =
{
	{
		GNOME_APP_UI_ITEM, N_("Mini Mode"),
		NULL,
		toggle_mini_display_mode, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		GDK_T, (GdkModifierType) GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("_Half Size"),
		NULL,
		half_size, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		GDK_1, (GdkModifierType) GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("_Original Size"),
		NULL,
		full_size, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		GDK_2, (GdkModifierType) GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("_Double Size"),
		NULL,
		double_size, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		GDK_3, (GdkModifierType) GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("_Full Screen"),
		NULL,
		toggle_fullscreen, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		GDK_4, (GdkModifierType) GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
};

static GnomeUIInfo help_menu [] =
{
	GNOMEUIINFO_MENU_ABOUT_ITEM (show_about, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo main_menu [] = 
{
	GNOMEUIINFO_MENU_FILE_TREE (file_menu),
	GNOMEUIINFO_MENU_VIEW_TREE (view_menu),
	GNOMEUIINFO_MENU_HELP_TREE (help_menu),
	GNOMEUIINFO_END
};
#endif

static void embedded (GtkPlug *plug, gpointer data)
{

}

static void do_help(void)
{
	fprintf(stderr,"swf_play [--xid NNN] file.swf\n");
	exit(1);
}

int xid = 0;
int width = 0;
int height = 0;

int
main (int argc, char **argv)
{
	GstMediaPlay *mplay;
	GtkWidget *window;
	GtkWidget *dialog;	/* disclaimer dialog */
	gboolean hide_warning = FALSE;
	poptContext context;
	const gchar **argvn;
	char *file;
	static struct poptOption options[] = {
		{ "xid", 'x', POPT_ARG_INT, &xid, 0,
			"XID of window", "XID"},
		{ "width", 'w', POPT_ARG_INT, &width, 0,
			"width", "WIDTH"},
		{ "height", 'h', POPT_ARG_INT, &height, 0,
			"height", "HEIGHT"},
		{ NULL, '\0', POPT_ARG_INCLUDE_TABLE,
			NULL, 0, "GStreamer", NULL },
		POPT_TABLEEND
	};
	int c;
	int index;

	gtk_init(&argc, &argv);

	options[3].arg = (void *) gst_init_get_popt_table ();
	context = poptGetContext("noname",argc,argv,options,0);
	while(poptGetNextOpt(context)!=-1);

	/* i18n initialization */
	bindtextdomain (PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (PACKAGE, "UTF-8");
	textdomain (PACKAGE);

	/* gtk window */
	if(xid){
		window = gtk_plug_new(0);
		gtk_signal_connect(GTK_OBJECT(window), "embedded",
			GTK_SIGNAL_FUNC(embedded), NULL);
	}else{
		window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	}
	g_return_if_fail (window != NULL);

	gtk_window_set_default_size (GTK_WINDOW (window), 100, 100);
	gtk_window_set_resizable (GTK_WINDOW (window), FALSE);

	mplay = gst_media_play_new ();
	gtk_container_add(GTK_CONTAINER(window),
		GTK_WIDGET(mplay));
	
	g_signal_connect (G_OBJECT (window), "destroy",
		  G_CALLBACK (cb_destroy), NULL);
	g_signal_connect (G_OBJECT (window), "key-press-event",
			  G_CALLBACK (window_key_press_event), mplay);
#if 0
	g_signal_connect (G_OBJECT (mplay), "display_mode_change",
			  G_CALLBACK (display_mode_change), window);
#endif
	g_signal_connect (G_OBJECT (mplay), "current_location",
			  G_CALLBACK (current_location), window);

	gtk_widget_show (GTK_WIDGET(mplay));
	gtk_widget_show (window);

	if(xid){
		XReparentWindow(GDK_WINDOW_XDISPLAY(window->window),
			GDK_WINDOW_XID(window->window),
			xid, 0, 0);
		XMapWindow(GDK_WINDOW_XDISPLAY(window->window),
			GDK_WINDOW_XID(window->window));
		gtk_widget_add_events(window, GDK_ALL_EVENTS_MASK);
	}

	argvn = poptGetArgs(context);
	gst_media_play_set_location(mplay, *argvn);

	gtk_main ();

	return 0;
}
 

