/* Generated by GOB (v2.0.3) on Sat Nov  2 08:21:41 2002
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 3

#define selfp (self->_priv)

#include <string.h> /* memset() */


#line 3 "gnome-vfs-metadata.gob"

#include <glib.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xmlmemory.h>
#include "gnome-vfs-utils.h"
#include "gnome-vfs-uri.h"
#include "gnome-vfs-metadata.h"
#include "gnome-vfs-metadata-private.h"

#line 27 "gnome-vfs-metadata.c"
/* self casting macros */
#define SELF(x) GNOME_VFS_METADATA(x)
#define SELF_CONST(x) GNOME_VFS_METADATA_CONST(x)
#define IS_SELF(x) GNOME_IS_VFS_METADATA(x)
#define TYPE_SELF GNOME_TYPE_VFS_METADATA
#define SELF_CLASS(x) GNOME_VFS_METADATA_CLASS(x)

#define SELF_GET_CLASS(x) GNOME_VFS_METADATA_GET_CLASS(x)

/* self typedefs */
typedef GnomeVfsMetadata Self;
typedef GnomeVfsMetadataClass SelfClass;

/* here are local prototypes */
static void gnome_vfs_metadata_init (GnomeVfsMetadata * o) G_GNUC_UNUSED;
static void gnome_vfs_metadata_class_init (GnomeVfsMetadataClass * c) G_GNUC_UNUSED;
static char * ___real_gnome_vfs_metadata_get_string (GnomeVfsMetadata * self, const char * key);
static void ___real_gnome_vfs_metadata_set_string (GnomeVfsMetadata * self, const char * key, const char * value);
static int ___real_gnome_vfs_metadata_get_int (GnomeVfsMetadata * self, const char * key);
static void ___real_gnome_vfs_metadata_set_int (GnomeVfsMetadata * self, const char * key, gpointer value);
static void gnome_vfs_metadata_set_uri (GnomeVfsMetadata * self, const char * uri) G_GNUC_UNUSED;
static void gnome_vfs_metadata_load_keys (GnomeVfsMetadata * self) G_GNUC_UNUSED;
static void gnome_vfs_metadata_save_keys (GnomeVfsMetadata * self) G_GNUC_UNUSED;
static void gnome_vfs_metadata_save_string_property (const char * key, const char * value, xmlNodePtr parent) G_GNUC_UNUSED;
static void gnome_vfs_metadata_save_int_property (const char * key, gpointer pvalue, xmlNodePtr parent) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_get_string(args...) gnome_vfs_metadata_get_string(args)
#define self_set_string(args...) gnome_vfs_metadata_set_string(args)
#define self_get_int(args...) gnome_vfs_metadata_get_int(args)
#define self_set_int(args...) gnome_vfs_metadata_set_int(args)
#define self_new(args...) gnome_vfs_metadata_new(args)
#define self_set_uri(args...) gnome_vfs_metadata_set_uri(args)
#define self_load_keys(args...) gnome_vfs_metadata_load_keys(args)
#define self_save_keys(args...) gnome_vfs_metadata_save_keys(args)
#define self_save_string_property(args...) gnome_vfs_metadata_save_string_property(args)
#define self_save_int_property(args...) gnome_vfs_metadata_save_int_property(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static char * (* const self_get_string) (GnomeVfsMetadata * self, const char * key) = gnome_vfs_metadata_get_string;
static void (* const self_set_string) (GnomeVfsMetadata * self, const char * key, const char * value) = gnome_vfs_metadata_set_string;
static int (* const self_get_int) (GnomeVfsMetadata * self, const char * key) = gnome_vfs_metadata_get_int;
static void (* const self_set_int) (GnomeVfsMetadata * self, const char * key, gpointer value) = gnome_vfs_metadata_set_int;
static GObject * (* const self_new) (const char * uri) = gnome_vfs_metadata_new;
static void (* const self_set_uri) (GnomeVfsMetadata * self, const char * uri) = gnome_vfs_metadata_set_uri;
static void (* const self_load_keys) (GnomeVfsMetadata * self) = gnome_vfs_metadata_load_keys;
static void (* const self_save_keys) (GnomeVfsMetadata * self) = gnome_vfs_metadata_save_keys;
static void (* const self_save_string_property) (const char * key, const char * value, xmlNodePtr parent) = gnome_vfs_metadata_save_string_property;
static void (* const self_save_int_property) (const char * key, gpointer pvalue, xmlNodePtr parent) = gnome_vfs_metadata_save_int_property;

GType
gnome_vfs_metadata_get_type (void)
{
	static GType type = 0;

	if (type == 0) {
		static const GTypeInfo info = {
			sizeof (GnomeVfsMetadataClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_vfs_metadata_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GnomeVfsMetadata),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gnome_vfs_metadata_init,
		};

		type = g_type_register_static (G_TYPE_OBJECT, "GnomeVfsMetadata", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GnomeVfsMetadata *)g_object_new(gnome_vfs_metadata_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GnomeVfsMetadata * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GnomeVfsMetadata *
GET_NEW_VARG (const char *first, ...)
{
	GnomeVfsMetadata *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GnomeVfsMetadata *)g_object_new_valist (gnome_vfs_metadata_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::finalize"
	GnomeVfsMetadata *self = GNOME_VFS_METADATA (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 221 "gnome-vfs-metadata.gob"
	if(self->key_file_uri) { ((*(void (*)(void *))g_free)) (self->key_file_uri); self->key_file_uri = NULL; }
#line 135 "gnome-vfs-metadata.c"
#line 222 "gnome-vfs-metadata.gob"
	if(self->metadata_dir_uri) { ((*(void (*)(void *))g_free)) (self->metadata_dir_uri); self->metadata_dir_uri = NULL; }
#line 138 "gnome-vfs-metadata.c"
#line 224 "gnome-vfs-metadata.gob"
	if(self->_priv->strings) { ((*(void (*)(void *))g_hash_table_destroy)) (self->_priv->strings); self->_priv->strings = NULL; }
#line 141 "gnome-vfs-metadata.c"
#line 225 "gnome-vfs-metadata.gob"
	if(self->_priv->integers) { ((*(void (*)(void *))g_hash_table_destroy)) (self->_priv->integers); self->_priv->integers = NULL; }
#line 144 "gnome-vfs-metadata.c"
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
gnome_vfs_metadata_init (GnomeVfsMetadata * o)
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::init"
	o->_priv = g_new0 (GnomeVfsMetadataPrivate, 1);
#line 221 "gnome-vfs-metadata.gob"
	o->key_file_uri = NULL;
#line 158 "gnome-vfs-metadata.c"
#line 222 "gnome-vfs-metadata.gob"
	o->metadata_dir_uri = NULL;
#line 161 "gnome-vfs-metadata.c"
#line 224 "gnome-vfs-metadata.gob"
	o->_priv->strings = NULL;
#line 164 "gnome-vfs-metadata.c"
#line 225 "gnome-vfs-metadata.gob"
	o->_priv->integers = NULL;
#line 167 "gnome-vfs-metadata.c"
#line 225 "gnome-vfs-metadata.gob"
	o->_priv->keys_loaded = FALSE;
#line 170 "gnome-vfs-metadata.c"
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
gnome_vfs_metadata_class_init (GnomeVfsMetadataClass * c)
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 24 "gnome-vfs-metadata.gob"
	c->get_string = ___real_gnome_vfs_metadata_get_string;
#line 37 "gnome-vfs-metadata.gob"
	c->set_string = ___real_gnome_vfs_metadata_set_string;
#line 54 "gnome-vfs-metadata.gob"
	c->get_int = ___real_gnome_vfs_metadata_get_int;
#line 63 "gnome-vfs-metadata.gob"
	c->set_int = ___real_gnome_vfs_metadata_set_int;
#line 191 "gnome-vfs-metadata.c"
	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__



/**
 * gnome_vfs_metadata_get_string:
 * @self: Metadata object to get the property of
 * @key: key to retrieve
 *
 * Gets the piece of string metadata associated with @key.
 *
 * Return value: the string associated with @key
 **/
#line 24 "gnome-vfs-metadata.gob"
char * 
gnome_vfs_metadata_get_string (GnomeVfsMetadata * self, const char * key)
#line 213 "gnome-vfs-metadata.c"
{
	GnomeVfsMetadataClass *klass;
#line 24 "gnome-vfs-metadata.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 24 "gnome-vfs-metadata.gob"
	g_return_val_if_fail (GNOME_IS_VFS_METADATA (self), (char * )0);
#line 220 "gnome-vfs-metadata.c"
	klass = GNOME_VFS_METADATA_GET_CLASS(self);

	if(klass->get_string)
		return (*klass->get_string)(self,key);
	else
		return (char * )(0);
}
#line 24 "gnome-vfs-metadata.gob"
static char * 
___real_gnome_vfs_metadata_get_string (GnomeVfsMetadata * self, const char * key)
#line 231 "gnome-vfs-metadata.c"
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::get_string"
{
#line 24 "gnome-vfs-metadata.gob"
	
    const char *value;
    if (!self->_priv->keys_loaded) self_load_keys (self);

    value = g_hash_table_lookup (self->_priv->strings, key);

    if (value != NULL) {
      return g_strdup (value);
    } else {
      return NULL;
    }
  }}
#line 248 "gnome-vfs-metadata.c"
#undef __GOB_FUNCTION__

#line 37 "gnome-vfs-metadata.gob"
void 
gnome_vfs_metadata_set_string (GnomeVfsMetadata * self, const char * key, const char * value)
#line 254 "gnome-vfs-metadata.c"
{
	GnomeVfsMetadataClass *klass;
#line 37 "gnome-vfs-metadata.gob"
	g_return_if_fail (self != NULL);
#line 37 "gnome-vfs-metadata.gob"
	g_return_if_fail (GNOME_IS_VFS_METADATA (self));
#line 261 "gnome-vfs-metadata.c"
	klass = GNOME_VFS_METADATA_GET_CLASS(self);

	if(klass->set_string)
		(*klass->set_string)(self,key,value);
}
#line 37 "gnome-vfs-metadata.gob"
static void 
___real_gnome_vfs_metadata_set_string (GnomeVfsMetadata * self, const char * key, const char * value)
#line 270 "gnome-vfs-metadata.c"
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::set_string"
{
#line 37 "gnome-vfs-metadata.gob"
	
    if (!self->_priv->keys_loaded) self_load_keys (self);

    g_hash_table_insert (self->_priv->strings, g_strdup (key), g_strdup (value));

    self_save_keys (self);
  }}
#line 282 "gnome-vfs-metadata.c"
#undef __GOB_FUNCTION__

/**
 * gnome_vfs_metadata_get_int:
 * @self: Metadata object to get the property of
 * @key: key to retrieve
 *
 * Gets the piece of integer metadata associated with @key.
 *
 * Return value: the integer associated with @key
 **/
#line 54 "gnome-vfs-metadata.gob"
int 
gnome_vfs_metadata_get_int (GnomeVfsMetadata * self, const char * key)
#line 297 "gnome-vfs-metadata.c"
{
	GnomeVfsMetadataClass *klass;
#line 54 "gnome-vfs-metadata.gob"
	g_return_val_if_fail (self != NULL, (int )0);
#line 54 "gnome-vfs-metadata.gob"
	g_return_val_if_fail (GNOME_IS_VFS_METADATA (self), (int )0);
#line 304 "gnome-vfs-metadata.c"
	klass = GNOME_VFS_METADATA_GET_CLASS(self);

	if(klass->get_int)
		return (*klass->get_int)(self,key);
	else
		return (int )(0);
}
#line 54 "gnome-vfs-metadata.gob"
static int 
___real_gnome_vfs_metadata_get_int (GnomeVfsMetadata * self, const char * key)
#line 315 "gnome-vfs-metadata.c"
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::get_int"
{
#line 54 "gnome-vfs-metadata.gob"
	
    gpointer value;
    if (!self->_priv->keys_loaded) self_load_keys (self);

    value = g_hash_table_lookup (self->_priv->integers, key);

    return GPOINTER_TO_INT (value);
  }}
#line 328 "gnome-vfs-metadata.c"
#undef __GOB_FUNCTION__

#line 63 "gnome-vfs-metadata.gob"
void 
gnome_vfs_metadata_set_int (GnomeVfsMetadata * self, const char * key, gpointer value)
#line 334 "gnome-vfs-metadata.c"
{
	GnomeVfsMetadataClass *klass;
#line 63 "gnome-vfs-metadata.gob"
	g_return_if_fail (self != NULL);
#line 63 "gnome-vfs-metadata.gob"
	g_return_if_fail (GNOME_IS_VFS_METADATA (self));
#line 341 "gnome-vfs-metadata.c"
	klass = GNOME_VFS_METADATA_GET_CLASS(self);

	if(klass->set_int)
		(*klass->set_int)(self,key,value);
}
#line 63 "gnome-vfs-metadata.gob"
static void 
___real_gnome_vfs_metadata_set_int (GnomeVfsMetadata * self, const char * key, gpointer value)
#line 350 "gnome-vfs-metadata.c"
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::set_int"
{
#line 63 "gnome-vfs-metadata.gob"
	
    if (!self->_priv->keys_loaded) self_load_keys (self);

    g_hash_table_insert (self->_priv->strings, g_strdup (key), GINT_TO_POINTER (value));

    self_save_keys (self);
  }}
#line 362 "gnome-vfs-metadata.c"
#undef __GOB_FUNCTION__

#line 71 "gnome-vfs-metadata.gob"
GObject * 
gnome_vfs_metadata_new (const char * uri)
#line 368 "gnome-vfs-metadata.c"
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::new"
{
#line 72 "gnome-vfs-metadata.gob"
	
    Self *object;

    object = GET_NEW;

    self_set_uri (object, uri);

    return (GObject *)object;
  }}
#line 382 "gnome-vfs-metadata.c"
#undef __GOB_FUNCTION__

#line 82 "gnome-vfs-metadata.gob"
static void 
gnome_vfs_metadata_set_uri (GnomeVfsMetadata * self, const char * uri)
#line 388 "gnome-vfs-metadata.c"
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::set_uri"
#line 82 "gnome-vfs-metadata.gob"
	g_return_if_fail (self != NULL);
#line 82 "gnome-vfs-metadata.gob"
	g_return_if_fail (GNOME_IS_VFS_METADATA (self));
#line 395 "gnome-vfs-metadata.c"
{
#line 83 "gnome-vfs-metadata.gob"
	
    char *key_file_uri, *metadata_dir_uri;
    GnomeVFSURI *parent_dir, *file_uri, *keys_uri;
    char *file_name, *value_file_name;
    
    file_uri   = gnome_vfs_uri_new (uri);
    parent_dir = gnome_vfs_uri_get_parent (file_uri);
    file_name  = gnome_vfs_uri_extract_short_path_name (file_uri);
    
    value_file_name = g_build_filename (".metadata", file_name, "keys.xml", NULL);
    keys_uri = gnome_vfs_uri_append_path (parent_dir, value_file_name);
    key_file_uri = gnome_vfs_uri_to_string (keys_uri, GNOME_VFS_URI_HIDE_NONE);
    g_free (value_file_name);
    gnome_vfs_uri_unref (keys_uri);
    
    value_file_name = g_build_filename (".metadata", file_name, NULL);
    keys_uri = gnome_vfs_uri_append_path (parent_dir, value_file_name);
    metadata_dir_uri = gnome_vfs_uri_to_string (keys_uri, GNOME_VFS_URI_HIDE_NONE);
    g_free (value_file_name);
    gnome_vfs_uri_unref (keys_uri);
    
    g_free (file_name);
    gnome_vfs_uri_unref (file_uri);
    gnome_vfs_uri_unref (parent_dir);

    printf ("Key file URI is %s\n", key_file_uri);

    self->key_file_uri = key_file_uri;
    self->metadata_dir_uri = metadata_dir_uri;
  }}
#line 428 "gnome-vfs-metadata.c"
#undef __GOB_FUNCTION__

#line 114 "gnome-vfs-metadata.gob"
static void 
gnome_vfs_metadata_load_keys (GnomeVfsMetadata * self)
#line 434 "gnome-vfs-metadata.c"
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::load_keys"
#line 114 "gnome-vfs-metadata.gob"
	g_return_if_fail (self != NULL);
#line 114 "gnome-vfs-metadata.gob"
	g_return_if_fail (GNOME_IS_VFS_METADATA (self));
#line 441 "gnome-vfs-metadata.c"
{
#line 115 "gnome-vfs-metadata.gob"
	
    xmlDocPtr doc;
    xmlNodePtr node;
    xmlChar *key, *value, *type;
    char *file_buffer;
    int file_size;
    GnomeVFSResult result;

    if (self->_priv->strings != NULL) {
      g_hash_table_destroy (self->_priv->strings);
    }
    if (self->_priv->integers != NULL) {
      g_hash_table_destroy (self->_priv->integers);
    }

    self->_priv->strings  = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
    self->_priv->integers = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);

    /* FIXME: must allow for loading out of URIs */
    printf ("Key file uri is %s, local is %s\n", self->key_file_uri, gnome_vfs_get_local_path_from_uri (self->key_file_uri));

    result = gnome_vfs_read_entire_file (self->key_file_uri, &file_size, &file_buffer);
    if (result != GNOME_VFS_OK) return;

    doc = xmlParseMemory (file_buffer, file_size);

    g_free (file_buffer);

    if (doc == NULL
	|| doc->xmlRootNode == NULL
	|| doc->xmlRootNode->name == NULL
	|| g_ascii_strcasecmp (doc->xmlRootNode->name, "metadata") != 0) {
    } else {
      for (node = doc->xmlRootNode->xmlChildrenNode; node != NULL; node = node->next) {
	key   = xmlGetProp (node, "key");
	value = xmlGetProp (node, "value");
	type  = xmlGetProp (node, "type");
	
	if (key != NULL && value != NULL && type != NULL) {
	  if (strcmp (type, "string") == 0) {
	    g_hash_table_insert (self->_priv->strings, g_strdup (key), g_strdup (value));
	  } else if (strcmp (type, "integer") == 0) {
	    g_hash_table_insert (self->_priv->integers, g_strdup (key), GINT_TO_POINTER (atoi (value)));
	    g_free (value);
	  }
	}
	
	xmlFree (key);
	xmlFree (value);
	xmlFree (type);
      }
    }

    xmlFreeDoc (doc);

    self->_priv->keys_loaded = TRUE;
  }}
#line 501 "gnome-vfs-metadata.c"
#undef __GOB_FUNCTION__

#line 173 "gnome-vfs-metadata.gob"
static void 
gnome_vfs_metadata_save_keys (GnomeVfsMetadata * self)
#line 507 "gnome-vfs-metadata.c"
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::save_keys"
#line 173 "gnome-vfs-metadata.gob"
	g_return_if_fail (self != NULL);
#line 173 "gnome-vfs-metadata.gob"
	g_return_if_fail (GNOME_IS_VFS_METADATA (self));
#line 514 "gnome-vfs-metadata.c"
{
#line 174 "gnome-vfs-metadata.gob"
	
    xmlDocPtr doc;
    /*char *document_contents;
    int document_length;*/

    xmlIndentTreeOutput = TRUE;
    doc = xmlNewDoc ("1.0");
    doc->children = xmlNewDocNode (doc, NULL, "Metadata", NULL);

    g_hash_table_foreach (self->_priv->strings,
			  (GHFunc) self_save_string_property, doc->children);        
    g_hash_table_foreach (self->_priv->integers,
			  (GHFunc) self_save_int_property, doc->children); 

    /* FIXME: save to the proper file */
    xmlSaveFormatFile ("/tmp/test.xml", doc, 1);
    /*xmlDocDumpFormatMemory (doc, &document_contents, &document_length, 1);*/

    xmlFreeDoc (doc);
  }}
#line 537 "gnome-vfs-metadata.c"
#undef __GOB_FUNCTION__

#line 195 "gnome-vfs-metadata.gob"
static void 
gnome_vfs_metadata_save_string_property (const char * key, const char * value, xmlNodePtr parent)
#line 543 "gnome-vfs-metadata.c"
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::save_string_property"
{
#line 196 "gnome-vfs-metadata.gob"
	
    xmlNodePtr xml_node;
    xml_node = xmlNewChild (parent, NULL, "entry", NULL);
    xmlSetProp (xml_node, "name", key);
    xmlSetProp (xml_node, "value", value);	
    xmlSetProp (xml_node, "type", "string");
  }}
#line 555 "gnome-vfs-metadata.c"
#undef __GOB_FUNCTION__

#line 204 "gnome-vfs-metadata.gob"
static void 
gnome_vfs_metadata_save_int_property (const char * key, gpointer pvalue, xmlNodePtr parent)
#line 561 "gnome-vfs-metadata.c"
{
#define __GOB_FUNCTION__ "Gnome:Vfs:Metadata::save_int_property"
{
#line 205 "gnome-vfs-metadata.gob"
	
    char *string_value;
    int value = GPOINTER_TO_INT (pvalue);
    xmlNodePtr xml_node;

    xml_node = xmlNewChild (parent, NULL, "entry", NULL);
    
    string_value = g_strdup_printf ("%d", value);

    xmlSetProp (xml_node, "name", key);
    xmlSetProp (xml_node, "value", string_value);
    xmlSetProp (xml_node, "type", "integer");
    
    g_free (string_value);
  }}
#line 581 "gnome-vfs-metadata.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___gnome_vfs_metadata_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_get_string)();
	((void (*)(void))self_set_string)();
	((void (*)(void))self_get_int)();
	((void (*)(void))self_set_int)();
	((void (*)(void))self_new)();
	((void (*)(void))self_set_uri)();
	((void (*)(void))self_load_keys)();
	((void (*)(void))self_save_keys)();
	((void (*)(void))self_save_string_property)();
	((void (*)(void))self_save_int_property)();
	___gnome_vfs_metadata_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

