/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* 
 * Copyright (C) 2000 Eazel, Inc
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Andy Hertzfeld
 */

/* main.c - main function and object activation function for the throbber component. */

#include <config.h>
#include "nautilus-throbber.h"

#include <eel/eel-debug.h>
#include <libgnomeui/gnome-client.h>
#include <libgnomeui/gnome-ui-init.h>
#include <libgnomevfs/gnome-vfs-init.h>
#include <libnautilus-private/nautilus-global-preferences.h>
#include <string.h>

static int object_count = 0;

static void
throbber_object_destroyed (GtkObject *obj)
{
	object_count--;
	if (object_count <= 0) {
		gtk_main_quit ();
	}
}

static BonoboObject *
throbber_make_object (BonoboGenericFactory *factory, 
		      const char *iid, 
		      void *closure)
{
	NautilusThrobber *throbber;
	BonoboObject *bonobo_control;

	if (strcmp (iid, "OAFIID:nautilus_throbber")) {
		return NULL;
	}
	
	throbber = NAUTILUS_THROBBER (g_object_new (NAUTILUS_TYPE_THROBBER, NULL));
	
	object_count++;
	
	bonobo_control = nautilus_throbber_get_control (throbber);
	
	g_signal_connect (bonobo_control, "destroy", G_CALLBACK (throbber_object_destroyed), NULL);

	return bonobo_control;
}

int
main (int argc, char *argv[])
{
	BonoboGenericFactory *factory;
	char *registration_id;

	if (g_getenv ("NAUTILUS_DEBUG") != NULL) {
		eel_make_warnings_and_criticals_stop_in_debugger ();
	}

	/* Initialize libraries. */
	gnome_program_init ("nautilus-throbber",
			    VERSION,
			    LIBGNOMEUI_MODULE,
			    argc, argv,
			    NULL);

	bonobo_ui_init ("nautilus-throbber", VERSION, &argc, argv);

	/* Disable session manager connection */
	g_object_set (G_OBJECT (gnome_program_get()),
	              GNOME_CLIENT_PARAM_SM_CONNECT, FALSE, NULL);

	nautilus_global_preferences_init ();   

	registration_id = bonobo_activation_make_registration_id ("OAFIID:nautilus_throbber_factory", g_getenv ("DISPLAY"));
	factory = bonobo_generic_factory_new ("OAFIID:nautilus_throbber_factory", 
					      throbber_make_object,
					      NULL);
	g_free (registration_id);

	if (factory != NULL) {
		bonobo_activate ();
		do {
			gtk_main ();
		} while (object_count > 0);
		
		bonobo_object_unref (factory);
	}

	gnome_vfs_shutdown ();

	return EXIT_SUCCESS;
}
