/*
 * GNOME panel launcher module.
 * (C) 1997 The Free Software Foundation
 *
 * Author: Miguel de Icaza
 */
#include <stdio.h>
#include <libintl.h>
#include <sys/stat.h>
#include <dlfcn.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include "gnome.h"
#include "../applet.h"
#define _(String) gettext(String)

PanelCallback callback;

void
cleanup (GtkWidget *widget, void *data)
{
	struct gnome_desktop_entry *item = data;

	gnome_desktop_entry_free (item);
}

void
launch (GtkWidget *widget, void *data)
{
	struct gnome_desktop_entry *item = data;

	gnome_desktop_entry_launch (item);
}

GtkWidget *
create_launcher (GtkWidget *window, char *parameters)
{
	GtkWidget *pixmap, *button;
	struct gnome_desktop_entry *dentry;
	static char *default_app_pixmap;

	if (!default_app_pixmap)
		default_app_pixmap = gnome_pixmap_file ("launcher-program.xpm");

	if (*parameters == '/')
		dentry = gnome_desktop_entry_load (parameters);
	else {
		char *apps_par, *entry, *extension;

		if (strstr (parameters, ".desktop"))
			extension = NULL;
		else
			extension = ".desktop";
		
		apps_par = g_copy_strings ("apps/", parameters, extension, NULL);
		entry = gnome_datadir_file (apps_par);
		g_free (apps_par);
		
		if (!entry)
			return 0;
		dentry = gnome_desktop_entry_load (entry);
		g_free (entry);
	}
	if (!dentry)
		return 0;

	button = gtk_button_new ();
	pixmap = gnome_create_pixmap_widget (window, button, dentry->transparent_icon);
	if (!pixmap){
		if (default_app_pixmap)
			pixmap = gnome_create_pixmap_widget (window, button, default_app_pixmap);
		else
			pixmap = gtk_label_new ("App");
	}
	gtk_container_add (GTK_CONTAINER(button), pixmap);
	gtk_widget_show (pixmap);
	gtk_widget_show (button);

	gtk_signal_connect (GTK_OBJECT(button), "clicked", (GtkSignalFunc)launch, dentry);
	gtk_signal_connect (GTK_OBJECT(button), "destroy", (GtkSignalFunc)cleanup, dentry);

	return button;
}

void *
launcher_callback (AppletCommand *cmd)
{
	return 0;
}

char *
query (void)
{
	return "Launcher";
}

void
init (PanelCallback cback, Panel *panel, char *params, int xpos, int ypos)
{
	GtkWidget *launcher;
	PanelCommand cmd;

	callback = cback;
	launcher = create_launcher (panel->window, params);

	if (!launcher)
		return;

	cmd.cmd = PANEL_CMD_REGISTER_TOY;
	cmd.params.register_toy.applet   = launcher;
	cmd.params.register_toy.callback = launcher_callback;
	cmd.params.register_toy.id       = query();
	cmd.params.register_toy.params   = params;
	cmd.params.register_toy.xpos     = xpos;
	cmd.params.register_toy.ypos     = ypos;
	cmd.params.register_toy.flags    = APPLET_HAS_PROPERTIES;

	(*callback) (&cmd);
}
