
#include <gtk/gtk.h>

#include "minefield.h"

#define MINESIZE 17

static gint minefield_signals[LAST_SIGNAL] = { 0 };

static void gtk_minefield_realize(GtkWidget *widget)
{
        GtkMineField *mfield;
        GdkWindowAttr attributes;
        gint attributes_mask;
        
        g_return_if_fail(widget != NULL);
        g_return_if_fail(GTK_IS_MINEFIELD (widget));
        
        mfield = GTK_MINEFIELD(widget);
        GTK_WIDGET_SET_FLAGS(widget, GTK_REALIZED);
        
        attributes.window_type = GDK_WINDOW_CHILD;
        attributes.x = widget->allocation.x;
        attributes.y = widget->allocation.y;
        attributes.width = widget->allocation.width;
        attributes.height = widget->allocation.height;
        attributes.wclass = GDK_INPUT_OUTPUT;
        attributes.visual = gtk_widget_get_visual(widget);
        attributes.colormap = gtk_widget_get_colormap(widget);
        attributes.event_mask = gtk_widget_get_events(widget);
	attributes.event_mask |= GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK |
		GDK_BUTTON_RELEASE_MASK;
        
        attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;
        
        widget->window = gdk_window_new(widget->parent->window, &attributes, attributes_mask);
        gdk_window_set_user_data(widget->window, mfield);
        
        widget->style = gtk_style_attach(widget->style, widget->window);
        gtk_style_set_background(widget->style, widget->window, GTK_STATE_ACTIVE);
}

static void gtk_minefield_size_allocate(GtkWidget *widget,
					 GtkAllocation *allocation)
{
        g_return_if_fail(widget != NULL);
        g_return_if_fail(GTK_IS_MINEFIELD (widget));
        g_return_if_fail(allocation != NULL);

        widget->allocation = *allocation;
        
	if (GTK_WIDGET_REALIZED(widget)) {
		gdk_window_move_resize(widget->window,
				       allocation->x, allocation->y,
				       GTK_MINEFIELD(widget)->xsize*MINESIZE,
				       GTK_MINEFIELD(widget)->ysize*MINESIZE);
	}
}

static void gtk_minefield_size_request(GtkWidget *widget,
				       GtkRequisition *requisition)
{
        requisition->width  = GTK_MINEFIELD(widget)->xsize*MINESIZE;
	requisition->height = GTK_MINEFIELD(widget)->ysize*MINESIZE;
}

static void gtk_mine_draw(GtkMineField *mfield, guint x, guint y)
{
        int c = x+mfield->xsize*y;
	int shadow_type = (mfield->cdown == c ? GTK_SHADOW_IN : GTK_SHADOW_OUT);
	int n;
        GtkWidget *widget = GTK_WIDGET(mfield);


	if (mfield->lose == 1) {
		gdk_window_clear_area(widget->window,
				      x*MINESIZE, y*MINESIZE,
				      MINESIZE,
				      MINESIZE);
		if (!mfield->mines[c].shown) {
			gtk_draw_shadow(widget->style, widget->window,
					GTK_WIDGET_STATE (widget), GTK_SHADOW_OUT,
					x*MINESIZE, y*MINESIZE,
					MINESIZE,
					MINESIZE);
		}
		if (mfield->mines[c].marked == 1) {
			if (mfield->marked_sign_mask) {
				gdk_gc_set_clip_mask(widget->style->black_gc,
						      mfield->marked_sign_mask);
				gdk_gc_set_clip_origin(widget->style->black_gc,
						       x*MINESIZE+3, y*MINESIZE+3);
			}

			gdk_draw_pixmap (widget->window,
					 widget->style->black_gc,
					 mfield->marked_sign,
					 0, 0, x*MINESIZE+3, y*MINESIZE+3, -1, -1);

			if (mfield->marked_sign_mask) {
				gdk_gc_set_clip_mask(widget->style->black_gc, NULL);
			}
			if (mfield->mines[c].mined != 1) {
				gdk_draw_line(widget->window,
					      widget->style->black_gc,
					      x*MINESIZE+2,
					      y*MINESIZE+3,
					      x*MINESIZE+MINESIZE-4,
					      y*MINESIZE+MINESIZE-3);
				gdk_draw_line(widget->window,
					      widget->style->black_gc,
					      x*MINESIZE+3,
					      y*MINESIZE+2,
					      x*MINESIZE+MINESIZE-3,
					      y*MINESIZE+MINESIZE-4);
				gdk_draw_line(widget->window,
					      widget->style->black_gc,
					      x*MINESIZE+2,
					      y*MINESIZE+MINESIZE-4,
					      x*MINESIZE+MINESIZE-4,
					      y*MINESIZE+2);
				gdk_draw_line(widget->window,
					      widget->style->black_gc,
					      x*MINESIZE+3,
					      y*MINESIZE+MINESIZE-3,
					      x*MINESIZE+MINESIZE-3,
					      y*MINESIZE+3);
			}
		} else if (mfield->mines[c].mined == 1) {
			if (mfield->mine_sign_mask) {
				gdk_gc_set_clip_mask(widget->style->black_gc,
						     mfield->mine_sign_mask);
				gdk_gc_set_clip_origin(widget->style->black_gc,
						       x*MINESIZE+3, y*MINESIZE+3);
			}

			gdk_draw_pixmap (widget->window,
					 widget->style->black_gc,
					 mfield->mine_sign,
					 0, 0, x*MINESIZE+3, y*MINESIZE+3, -1, -1);

			if (mfield->marked_sign_mask) {
				gdk_gc_set_clip_mask(widget->style->black_gc, NULL);
			}
		} else if (mfield->mines[c].shown == 1) {
			if ((n = mfield->mines[c].neighbours) != 0) {
				gdk_draw_string(widget->window,
						widget->style->font,
						widget->style->black_gc,
						x*MINESIZE+mfield->numstr[n].dx,
						y*MINESIZE+mfield->numstr[n].dy,
						mfield->numstr[n].text);
			}
		}
		return;
	}
		
		

	
        if (mfield->mines[c].shown == 1) {
                gdk_window_clear_area(widget->window,
				      x*MINESIZE, y*MINESIZE,
				      MINESIZE,
				      MINESIZE);
		if ((n = mfield->mines[c].neighbours) != 0) {
			gdk_draw_string(widget->window,
					widget->style->font,
					widget->style->black_gc,
					x*MINESIZE+mfield->numstr[n].dx,
					y*MINESIZE+mfield->numstr[n].dy,
					mfield->numstr[n].text);
		}
        } else {
                gtk_draw_shadow(widget->style, widget->window,
                                GTK_WIDGET_STATE (widget), shadow_type,
                                x*MINESIZE, y*MINESIZE,
                                MINESIZE,
				MINESIZE);

		if (mfield->mines[c].marked == 1) {
			if (mfield->marked_sign_mask) {
				gdk_gc_set_clip_mask(widget->style->black_gc,
						      mfield->marked_sign_mask);
				gdk_gc_set_clip_origin(widget->style->black_gc,
						       x*MINESIZE+3, y*MINESIZE+3);
			}

			gdk_draw_pixmap (widget->window,
					 widget->style->black_gc,
					 mfield->marked_sign,
					 0, 0, x*MINESIZE+3, y*MINESIZE+3, -1, -1);

			if (mfield->marked_sign_mask) {
				gdk_gc_set_clip_mask(widget->style->black_gc, NULL);
			}

		} else {

			gdk_window_clear_area(widget->window,
                                              x*MINESIZE+2, y*MINESIZE+2,
                                              MINESIZE-4,
                                              MINESIZE-4);
			gdk_gc_set_clip_origin(widget->style->black_gc,
					       0, 0);
		}
/*
		if (mfield->mines[c].mined == 1) {
			gdk_draw_rectangle(widget->window, widget->style->black_gc,
					   0,
					   x*MINESIZE+MINESIZE-3, y*MINESIZE+2,
					   1,1);
		}
*/
	}
}

void gtk_minefield_draw(GtkMineField *mfield)
{
	guint x, y;

	for (x = 0; x<mfield->xsize; x++) {
		for (y = 0; y<mfield->ysize; y++) {
			gtk_mine_draw(mfield, x, y);
		}
	}
}

static gint gtk_minefield_expose(GtkWidget *widget,
				 GdkEventExpose *event)
{
        g_return_val_if_fail(widget != NULL, FALSE);
        g_return_val_if_fail(GTK_IS_MINEFIELD(widget), FALSE);
        g_return_val_if_fail(event != NULL, FALSE);

        if (GTK_WIDGET_DRAWABLE(widget)) {
		gtk_minefield_draw(GTK_MINEFIELD(widget));

	}
	return FALSE;
}

#define SS(x,y) \
	do { \
	if (mfield->mines[(x)+mfield->xsize*(y)].shown == 0 && \
	mfield->mines[(x)+mfield->xsize*(y)].marked == 0) { \
	mfield->mines[(x)+mfield->xsize*(y)].shown = 1; \
	gtk_mine_draw(mfield, x, y); \
	changed=1; \
	} \
	} while (0)

static void gtk_minefield_check_field(GtkMineField *mfield)
{
        guint x, y;
        int changed;

	changed = 1;
	while (changed) {
                changed = 0;
		for (x=0; x<mfield->xsize; x++) {
			for (y=0; y<mfield->ysize; y++) {
				if (mfield->mines[x+mfield->xsize*y].neighbours == 0 &&
				    mfield->mines[x+mfield->xsize*y].shown == 1) {
					if (x>0) {
						SS(x-1, y);
						if (y>0) SS(x-1, y-1);
						if (y<mfield->ysize-1) SS(x-1, y+1);
					}
					if (x<mfield->xsize-1) {
						SS(x+1, y);
						if (y>0) SS(x+1, y-1);
						if (y<mfield->ysize-1) SS(x+1, y+1);
					}
					if (y>0) SS(x, y-1);
					if (y<mfield->ysize-1) SS(x, y+1);
				}
			}
		}
	}
}
#undef SS

static void gtk_minefield_set_shown(GtkMineField *mfield, guint x, guint y)
{
	int c = x+mfield->xsize*y;
	
	if (mfield->mines[c].marked != 1 && mfield->mines[c].shown != 1) {
		mfield->mines[c].shown = 1;

		gtk_mine_draw(mfield, mfield->cdownx, mfield->cdowny);
                gtk_minefield_check_field(mfield);
		if (mfield->mines[c].mined == 1) {
			mfield->lose = 1;
			gtk_minefield_draw(mfield);
			gtk_signal_emit(GTK_OBJECT(mfield),
					minefield_signals[EXPLODE_SIGNAL]);
		}
	}
}

static void gtk_minefield_rightdown(GtkMineField *mfield, guint x, guint y)
{
        int c = x+mfield->xsize*y;
        if (mfield->mines[c].shown == 0) {
		if ((mfield->mines[c].marked = 1-mfield->mines[c].marked) == 1) {
			mfield->flags++;
		} else {
			mfield->flags--;
		}
		gtk_signal_emit(GTK_OBJECT(mfield),
				minefield_signals[MARKS_CHANGED_SIGNAL]);
        }
}

static gint gtk_minefield_button_press(GtkWidget *widget, GdkEventButton *event)
{
        GtkMineField *mfield;
        guint x, y;
        
        g_return_val_if_fail(widget != NULL, 0);
        g_return_val_if_fail(GTK_IS_MINEFIELD(widget), 0);
        g_return_val_if_fail(event != NULL, 0);

        mfield = GTK_MINEFIELD(widget);

        if (!mfield->bdown) {
                x = event->x/MINESIZE;
                y = event->y/MINESIZE;
                
                mfield->cdownx = x;
                mfield->cdowny = y;
                mfield->cdown = x+y*(mfield->xsize);
                mfield->bdown = event->button;
                gtk_mine_draw(mfield, x, y);
        }
        return FALSE;
}

static gint gtk_minefield_button_release(GtkWidget *widget, GdkEventButton *event)
{
        GtkMineField *mfield;
        guint x, y;


        g_return_val_if_fail(widget != NULL, FALSE);
        g_return_val_if_fail(GTK_IS_MINEFIELD(widget), FALSE);
        g_return_val_if_fail(event != NULL, FALSE);

	mfield = GTK_MINEFIELD(widget);

	if (mfield->lose) return FALSE;

        if (event->button == mfield->bdown) {
                x = event->x/MINESIZE;
                y = event->y/MINESIZE;
                if (x+mfield->xsize*y == mfield->cdown) {
                        switch (event->button) {
			case 1: gtk_minefield_set_shown(mfield, x, y); break;
                        case 3: gtk_minefield_rightdown(mfield, x, y); break;
			}
                }
                mfield->cdown = -1;
                mfield->bdown = 0;
                gtk_mine_draw(mfield, mfield->cdownx, mfield->cdowny);
        }
        return FALSE;
}


static void gtk_minefield_class_init (GtkMineFieldClass *class)
{
	GtkWidgetClass *widget_class;
	GtkObjectClass *object_class;
	
        widget_class = (GtkWidgetClass *)class;
	object_class = (GtkObjectClass *)class;
	
        widget_class->realize = gtk_minefield_realize;
        widget_class->size_allocate = gtk_minefield_size_allocate;
        widget_class->size_request = gtk_minefield_size_request;
        widget_class->expose_event = gtk_minefield_expose;
        widget_class->button_press_event = gtk_minefield_button_press;
	widget_class->button_release_event = gtk_minefield_button_release;
	minefield_signals[MARKS_CHANGED_SIGNAL] =
		gtk_signal_new("marks_changed",
			       GTK_RUN_FIRST,
			       object_class->type,
			       GTK_SIGNAL_OFFSET(GtkMineFieldClass, marks_changed),
			       gtk_signal_default_marshaller,
			       GTK_TYPE_NONE,
			       0);
	minefield_signals[EXPLODE_SIGNAL] =
		gtk_signal_new("explode",
			       GTK_RUN_FIRST,
			       object_class->type,
			       GTK_SIGNAL_OFFSET(GtkMineFieldClass, explode),
			       gtk_signal_default_marshaller,
			       GTK_TYPE_NONE,
			       0);
	gtk_object_class_add_signals(object_class, minefield_signals, LAST_SIGNAL);
	

}

static void gtk_minefield_init (GtkMineField *mfield)
{
        GTK_WIDGET_SET_FLAGS (mfield, GTK_BASIC);
        mfield->xsize = 0;
        mfield->ysize = 0;
        
        GTK_WIDGET (mfield)->requisition.width = MINESIZE;
        GTK_WIDGET (mfield)->requisition.height = MINESIZE;
}


GtkWidget* gtk_minefield_new (guint xsize, guint ysize)
{
        GtkMineField *mfield;
        GtkWidget *widget;
	int i;
	char *marked_filename;
	char *mine_filename;
        
	marked_filename = gnome_unconditional_pixmap_file(MARKED_SIGN_FILENAME);
	mine_filename = gnome_unconditional_pixmap_file(MINE_SIGN_FILENAME);

	mfield = gtk_type_new(gtk_minefield_get_type());
	widget = GTK_WIDGET(mfield);
        mfield->xsize = xsize;
        mfield->ysize = ysize;
        mfield->mines = g_new(mine,xsize*ysize);
	mfield->marked_sign_style = gtk_widget_get_style(GTK_WIDGET(mfield));
	mfield->marked_sign = gdk_pixmap_create_from_xpm(GTK_WIDGET(mfield)->window,
				 &mfield->marked_sign_mask,
				 &mfield->marked_sign_style->bg[GTK_STATE_NORMAL],
				 marked_filename);

	mfield->mine_sign_style = gtk_widget_get_style(GTK_WIDGET(mfield));
	mfield->mine_sign = gdk_pixmap_create_from_xpm(GTK_WIDGET(mfield)->window,
				 &mfield->mine_sign_mask,
				 &mfield->mine_sign_style->bg[GTK_STATE_NORMAL],
				 mine_filename);

	g_free(marked_filename);
	g_free(mine_filename);

	for (i=0; i<8; i++) {
		mfield->numstr[i].text[0]=i+'0';
		mfield->numstr[i].text[1]='\0';
		mfield->numstr[i].dx=(MINESIZE-
		      gdk_string_width(widget->style->font,
				       mfield->numstr[i].text))/2;
		mfield->numstr[i].dy=(MINESIZE-widget->style->font->ascent)/2+10;
	}

	mfield->cdown = -1;
	gtk_minefield_restart(mfield);
        return GTK_WIDGET(mfield);
}

guint gtk_minefield_get_type ()
{
        static guint minefield_type = 0;
        
        if (!minefield_type)
        {
                GtkTypeInfo minefield_info =
                        {
                                "GtkMineField",
                                sizeof (GtkMineField),
                                sizeof (GtkMineFieldClass),
                                (GtkClassInitFunc) gtk_minefield_class_init,
                                (GtkObjectInitFunc) gtk_minefield_init,
                                (GtkArgFunc) NULL,
                        };
                        
                        minefield_type = gtk_type_unique (gtk_widget_get_type (), &minefield_info);
        }
        
        return minefield_type;
}

void gtk_minefield_set_size(GtkMineField *mfield, guint xsize, guint ysize)
{
	mfield->xsize = xsize;
	mfield->ysize = ysize;
}

void gtk_minefield_set_mines(GtkMineField *mfield, guint mcount)
{
        mfield->mcount = mcount;
}

static gulong random_seed;

void init_random(gulong seed)
{
        random_seed = seed;
}

gulong get_random(gulong limit)
{
	do {
		random_seed = (random_seed*1139113+10921)>>2;
	} while (random_seed > ((gulong)(G_MAXLONG/limit))*limit);
	return random_seed % limit;
}

#define MM(x,y) mfield->mines[(x)+(y)*mfield->xsize].mined

void gtk_minefield_restart(GtkMineField *mfield)
{
	guint i, j;
        guint x, y;
	guint tmp;
	guint n;

        mfield->flags = 0;
	mfield->lose  = 0;
	mfield->bdown = 0;
	
	for (i=0; i<mfield->mcount; i++) {
                mfield->mines[i].mined = 1;
	}
	for (i=mfield->mcount; i<mfield->xsize*mfield->ysize; i++) {
		mfield->mines[i].mined = 0;
	}

	for (i=0; i<mfield->xsize*mfield->ysize; i++) {
                mfield->mines[i].marked = 0;
                mfield->mines[i].shown = 0;
		j = (guint)get_random(mfield->xsize*mfield->ysize);
		tmp = mfield->mines[i].mined;
		mfield->mines[i].mined = mfield->mines[j].mined;
		mfield->mines[j].mined = tmp;
	}

	for (x=0; x<mfield->xsize; x++) {
		for (y=0; y<mfield->ysize; y++) {
			n = 0;
			if (x>0) {
				                       n += MM(x-1, y);
				if (y>0)               n += MM(x-1, y-1);
				if (y<mfield->ysize-1) n += MM(x-1, y+1);
			}
			if (x<mfield->xsize-1) {
				                       n += MM(x+1, y);
				if (y>0)               n += MM(x+1, y-1);
				if (y<mfield->ysize-1) n += MM(x+1, y+1);
			}
			if (y>0)                       n += MM(x, y-1);
			if (y<mfield->ysize-1)         n += MM(x, y+1);
                        mfield->mines[x+mfield->xsize*y].neighbours = n;
		}
	}
}

#undef MM

