#include <unistd.h>
#include <errno.h>

#include <gtk/gtk.h>

#include "raft_cmd.h"
#include "raft_config.h"
#include "raft_interface.h"

extern Raft_launcher *raft_launcher;
extern Raft_info raft_info;


void raft_cmd_execute (GtkWidget *widget, gpointer *data)
{
    gchar *command = (gchar *) data;
    int pid;

    /* check if we're in configuration mode. */
    if (raft_info.config_mode) {
	/* tell the config module what button was pressed. */
	raft_config_register_button(widget);
	/* and return.. we don't want to exec anything. */
	return;
    }

    /* close on launch ? */
    if (raft_info.close_on_launch)
	    raft_interface_hide_launcher();
    
    if (command == NULL)
	    return;
    
    pid = fork();
    
    if (pid == -1)
	    g_error("Forking: %s", g_strerror(errno));
    
    if (pid == 0) {
	char *argv[4];
	
	argv[0] = "sh";
	argv[1] = "-c";
	argv[2] = command;
	argv[3] = 0;
	execv("/bin/sh", argv);
	_exit(1);
    }
}





