#include <gtk/gtk.h>
#include "gtk-compat.h"

/* This whole file is rated XXX. */

gchar*
gtk_label_get_interp (GtkLabel *label)
{
  gchar *str;
  gtk_label_get (label, &str);
  return str;
}

/* cheap cop-out. */

void
gtk_menu_popup_interp (GtkMenu *menu,
		       GtkWidget *parent_menu_shell,
		       GtkWidget *parent_menu_item,
		       gint button,
		       guint32 activate_time)
{
  gtk_menu_popup (menu, parent_menu_shell, parent_menu_item,
		  NULL, NULL, button, activate_time);
}

GtkWidget*
gtk_radio_menu_item_new_with_label_interp (GtkRadioMenuItem *group,
					   gchar            *label)
{
  GSList *g = group? gtk_radio_menu_item_group (group) : NULL;
  return gtk_radio_menu_item_new_with_label (g, label);
}

GtkWidget*
gtk_radio_menu_item_new_interp (GtkRadioMenuItem *group)
{
  GSList *g = group? gtk_radio_menu_item_group (group) : NULL;
  return gtk_radio_menu_item_new (g);
}

GtkWidget*
gtk_pixmap_new_interp (gchar *file,
		       GtkWidget *intended_parent)
{
  GtkStyle *style;
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  style = gtk_widget_get_style (intended_parent);
  pixmap = gdk_pixmap_create_from_xpm (NULL, &mask,
				       &style->bg[GTK_STATE_NORMAL],
				       file);
  return gtk_pixmap_new (pixmap, mask);
}

#ifndef HAVE_GDK_COLORMAP_REF
GdkColormap *gdk_colormap_ref (GdkColormap *colormap)
{
  return colormap;
}

void gdk_colormap_unref (GdkColormap *colormap)
{
}
#endif

#ifndef HAVE_GDK_VISUAL_REF
GdkVisual *gdk_visual_ref (GdkVisual *visual)
{
  return visual;
}

void gdk_visual_unref (GdkVisual *visual)
{
}
#endif

#ifndef HAVE_GDK_WINDOW_REF
GdkWindow *gdk_window_ref (GdkWindow *window)
{
  return window;
}

void gdk_window_unref (GdkWindow *window)
{
}
#endif

#ifndef HAVE_GDK_EVENT_COPY
/*
 *--------------------------------------------------------------
 * gdk_event_copy
 *
 *   Copy a event structure into new storage.
 *
 * Arguments:
 *   "event" is the event struct to copy.
 *
 * Results:
 *   A new event structure.  Free it with gdk_event_free.
 *
 * Side effects:
 *   The reference count of the window in the event is increased.
 *
 *--------------------------------------------------------------
 */

static GMemChunk *event_chunk;

GdkEvent*
gdk_event_copy (GdkEvent *event)
{
  GdkEvent *new_event;
  
  g_return_val_if_fail (event != NULL, NULL);

  if (event_chunk == NULL)
    event_chunk = g_mem_chunk_new ("events",
				   sizeof (GdkEvent),
				   4096,
				   G_ALLOC_AND_FREE);

  new_event = g_chunk_new (GdkEvent, event_chunk);
  *new_event = *event;
  gdk_window_ref (new_event->any.window);
  return new_event;
}

/*
 *--------------------------------------------------------------
 * gdk_event_free
 *
 *   Free a event structure obtained from gdk_event_copy.  Do not use
 *   with other event structures.
 *
 * Arguments:
 *   "event" is the event struct to free.
 *
 * Results:
 *
 * Side effects:
 *   The reference count of the window in the event is decreased and
 *   might be freed, too.
 *
 *-------------------------------------------------------------- */

void
gdk_event_free (GdkEvent *event)
{
  g_assert (event_chunk != NULL);
  g_return_if_fail (event != NULL);

  gdk_window_unref (event->any.window);
  g_mem_chunk_free (event_chunk, event);
}
#endif

#ifndef HAVE_GTK_TOOLTIPS_REF
GtkTooltips*
gtk_tooltips_ref (GtkTooltips *tooltips)
{
  return tooltips;
}

void gtk_tooltips_unref (GtkTooltips *tooltips)
{
}
#endif

typedef struct {
  GtkCallbackMarshal marshal;
  gpointer func_data;
  GtkObject *object;
} callback_data;

static int
unmarshal_callback (gpointer data)
{
  callback_data *cdata = (callback_data *)data;
  int ret_val = FALSE;
  GtkArg args[1];
  args[0].type = GTK_TYPE_BOOL;
  args[0].name;
  GTK_RETLOC_BOOL (args[0]) = &ret_val;
  cdata->marshal (NULL, cdata->func_data, 0, args);
  return ret_val;
}

#ifndef HAVE_GTK_TIMEOUT_ADD_INTERP
gint
gtk_timeout_add_interp (guint32            interval,
			GtkCallbackMarshal function,
			gpointer           data,
			GtkDestroyNotify   notify)
{
  callback_data *cdata = g_new (callback_data, 1);
  cdata->marshal = function;
  cdata->func_data = data;
  return gtk_timeout_add (interval, unmarshal_callback, cdata);
}
#endif

#ifndef HAVE_GTK_IDLE_ADD_INTERP
gint
gtk_idle_add_interp (GtkCallbackMarshal function,
		     gpointer           data,
		     GtkDestroyNotify   notify)
{
  callback_data *cdata = g_new (callback_data, 1);
  cdata->marshal = function;
  cdata->func_data = data;
  return gtk_idle_add (unmarshal_callback, cdata);
}
#endif

#ifndef HAVE_GTK_SIGNAL_CONNECT_INTERP

typedef struct {
  GtkCallbackMarshal orig_func;
  gpointer orig_data;
  GtkDestroyNotify orig_notify;
} interp_data;

static void
remarshal (GtkObject *object,
	   gpointer data,
	   gint nparams,
	   GtkArg *args,
	   GtkType arg_types,
	   GtkType return_type)
{
  interp_data *idata = (interp_data *)data;

  args[nparams].type = return_type;
  args[nparams].name = NULL;
  idata->orig_func (object, idata->orig_data, nparams, args);
}

static void
renotify (gpointer data)
{
  interp_data *idata = (interp_data *)data;
  idata->orig_notify (idata->orig_data);
  g_free (idata);
}

gint 
gtk_signal_connect_interp (GtkObject         *object,
			   gchar             *signal,
			   GtkCallbackMarshal func,
			   gpointer           data,
			   GtkDestroyNotify   notify,
			   gint               after)
{
  interp_data *idata = g_new (interp_data, 1);
  idata->orig_func = func;
  idata->orig_data = data;
  idata->orig_notify = notify;
  return gtk_signal_connect_no_marshal (object, signal,
					(GtkSignalFunc) remarshal,
					idata, renotify, after);
}

#endif

#ifndef HAVE_GTK_RADIO_BUTTON_NEW_INTERP
GtkWidget*
gtk_radio_button_new_interp (GtkRadioButton *group)
{
  GSList *l = NULL;
  if (group)
    l = gtk_radio_button_group (group);
  return gtk_radio_button_new (l);
}

GtkWidget*
gtk_radio_button_new_with_label_interp (GtkRadioButton *group,
					const gchar    *label)
{
  GSList *l = NULL;
  if (group)
    l = gtk_radio_button_group (group);
  return gtk_radio_button_new_with_label (l, label);
}
#endif

#ifndef HAVE_GDK_COLOR_COPY
/*
 *--------------------------------------------------------------
 * gdk_color_copy
 *
 *   Copy a color structure into new storage.
 *
 * Arguments:
 *   "color" is the color struct to copy.
 *
 * Results:
 *   A new color structure.  Free it with gdk_color_free.
 *
 *--------------------------------------------------------------
 */

static GMemChunk *color_chunk;

GdkColor*
gdk_color_copy (GdkColor *color)
{
  GdkColor *new_color;
  
  g_return_val_if_fail (color != NULL, NULL);

  if (color_chunk == NULL)
    color_chunk = g_mem_chunk_new ("colors",
				   sizeof (GdkColor),
				   4096,
				   G_ALLOC_AND_FREE);

  new_color = g_chunk_new (GdkColor, color_chunk);
  *new_color = *color;
  return new_color;
}

/*
 *--------------------------------------------------------------
 * gdk_color_free
 *
 *   Free a color structure obtained from gdk_color_copy.  Do not use
 *   with other color structures.
 *
 * Arguments:
 *   "color" is the color struct to free.
 *
 *-------------------------------------------------------------- */

void
gdk_color_free (GdkColor *color)
{
  g_assert (color_chunk != NULL);
  g_return_if_fail (color != NULL);

  g_mem_chunk_free (color_chunk, color);
}
#endif

GdkColor*
gdk_color_parse_interp (char *spec)
{
  /* not reentrant */
  static GdkColor color;
  gdk_color_parse (spec, &color);
  return &color;
}
