#include "obgtkStatusbar.h"

@implementation Gtk_Statusbar
- castGtkStatusbar:(GtkStatusbar *)castitem
{
  gtkstatusbar = castitem;
  return [super castGtkHBox:GTK_HBOX(castitem)];
}

- init
{
  return [self castGtkStatusbar:GTK_STATUSBAR(gtk_statusbar_new())];
}

- (guint) get_context_id:(const gchar *) context_description
{
  return gtk_statusbar_get_context_id(gtkstatusbar,
				      context_description);
}

- (guint) push:(guint) context_id
	      :(const gchar *) text
{
  return gtk_statusbar_push(gtkstatusbar, context_id, text);
}

- pop:(guint) context_id
{
  gtk_statusbar_pop(gtkstatusbar, context_id);
  return self;
}

- remove:(guint) context_id
	:(guint) message_id
{
  gtk_statusbar_remove(gtkstatusbar, context_id, message_id);
  return self;
}
@end
