#include "obgtkViewport.h"

@implementation Gtk_Viewport
- init
{
  id th = [Gtk_Adjustment new], tv = [Gtk_Adjustment new], retval;
  retval = [self initWithAdjustments:th adjV:tv];
  [th free]; [tv free];
  return retval;
}

- initWithAdjustments:(Gtk_Adjustment *) hadjustment
		    adjV:(Gtk_Adjustment *) vadjustment
{
  gtkviewport = GTK_VIEWPORT(gtk_viewport_new(hadjustment->gtkadjustment,
					      vadjustment->gtkadjustment));
  return [super castGtkBin:GTK_BIN(gtkviewport)];
}

- (Gtk_Adjustment *)get_hadjustment
{
  return [[Gtk_Adjustment alloc] castGtkAdjustment:GTK_ADJUSTMENT(gtk_viewport_get_hadjustment(gtkviewport))];
}

- (Gtk_Adjustment *)get_vadjustment
{
  return [[Gtk_Adjustment alloc] castGtkAdjustment:GTK_ADJUSTMENT(gtk_viewport_get_vadjustment(gtkviewport))];
}

- set_hadjustment:(Gtk_Adjustment *) adjustment
{
  gtk_viewport_set_hadjustment(gtkviewport, adjustment->gtkadjustment);
  return self;
}

- set_vadjustment:(Gtk_Adjustment *) adjustment
{
  gtk_viewport_set_hadjustment(gtkviewport, adjustment->gtkadjustment);
  return self;
}

- set_shadow_type:(GtkShadowType) type
{
  gtk_viewport_set_shadow_type(gtkviewport, type);
  return self;
}
@end
