/* GnomENIUS Calculator
 * Copyright (C) 1997, 1998 the Free Software Foundation.
 *
 * Author: George Lebl
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the  Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */
%{
#include <glib.h>
#include <string.h>
#include "mpwrap.h"
#include "eval.h"
#include "dict.h"
#include "parse.h"
%}

%s NEGATIVE

%%

\;		return SEPAR;

~		return NEG;

infix		BEGIN INITIAL; return INFIX_EXPR;

postfix		BEGIN NEGATIVE; return POSTFIX_EXPR;

prefix		BEGIN NEGATIVE; return PREFIX_EXPR;

==		return EQ_CMP;
!=		return NE_CMP;
\<=\>		return CMP_CMP;

\<=		return LE_CMP;
\>=		return GE_CMP;

\<		return LT_CMP;
\>		return GT_CMP;

=		return EQUALS;

not		return LOGICAL_NOT;
and		return LOGICAL_AND;
xor		return LOGICAL_XOR;
or		return LOGICAL_OR;

while		return WHILE_CONS;

ifelse		return IFELSE_CONS;

if		return IF_CONS;

\{		{
			/*create a new context and push it on top of the
			  context stack, it's only temporary*/
			d_addcontext(NULL);
			return BEGINBLOCK;
		}

\}		{

			/*kill the temporary context, but keep the
			  declarations*/
			freedict(d_popcontext(),TRUE);
			return ENDBLOCK;
		}

arg[1-8]	{
			/*make static argument placeholders*/
			if((yylval.func=d_lookup(yytext,FALSE))==NULL)
				yylval.func=d_addfunc(d_makeufunc(yytext,
					NULL,NULL,0,FALSE));
			return FUNCID0;
		}

[0-8]\\[a-zA-Z][a-zA-Z0-9]*	{
				/*this is the function declaration*/

				/*create a dummy function, first character is
				  the number of arguments*/
				yylval.func=
					d_addfunc(d_makeufunc(&yytext[2],NULL,
						NULL,(int)(yytext[0]-'0'),
						FALSE));
				return FUNCDEF;
			}

[a-zA-Z][a-zA-Z0-9]*	{
				/* we need to find out the number of arguments
				   for this function, this is a limitation of
				   mostly the postfix and prefix notation
				   without parenthesis */
				func_t *n;

				n=d_lookup(yytext,TRUE);
				if(!n) {
					/*create a dummy function*/
					yylval.func=
						d_addfunc(d_makeufunc(
							yytext,NULL,NULL,0,
							FALSE));
					return FUNCID0;
				}

				yylval.func=n;
				switch(n->nargs) {
					case 0: return FUNCID0;
					case 1: return FUNCID1;
					case 2: return FUNCID2;
					case 3: return FUNCID3;
					case 4: return FUNCID4;
					case 5: return FUNCID5;
					case 6: return FUNCID6;
					case 7: return FUNCID7;
					case 8: return FUNCID8;
				}
				/*too many args or corrupted entry, this
				  shouldn't happen, and this is not a way
				  to deal with it, but oh well, for now*/
				REJECT;
			}

<NEGATIVE>-[0-9]*\.[0-9]+[e@]-?[0-9]+i	|
<NEGATIVE>-[0-9]+[e@]-?[0-9]+i		|
<NEGATIVE>-[0-9]+i			|
<NEGATIVE>-[0-9]*\.[0-9]+i	{
			char *s;
			if(yytext[1] == '.')
				s = g_strconcat("-0",&yytext[1],NULL);
			else
				s = g_strdup(yytext);
			mpw_init(yylval.val);
			mpw_set_str_complex(yylval.val,s,10);
			g_free(s);
			return NEGNUM;
		}

[0-9]*\.[0-9]+[e@]-?[0-9]+i	|
[0-9]+[e@]-?[0-9]+i		|
[0-9]+i				|
[0-9]*\.[0-9]+i	{
			char *s;
			if(yytext[0] == '.')
				s = g_strconcat("0",&yytext[0],NULL);
			else
				s = g_strdup(yytext);
			mpw_init(yylval.val);
			mpw_set_str_complex(yylval.val,s,10);
			g_free(s);
			return POSNUM;
		}

<NEGATIVE>-[0-9]*\.[0-9]+[e@]-?[0-9]+	|
<NEGATIVE>-[0-9]+[e@]-?[0-9]+		|
<NEGATIVE>-[0-9]*\.[0-9]+	{
			char *s;
			if(yytext[1] == '.')
				s = g_strconcat("-0",&yytext[1],NULL);
			else
				s = g_strdup(yytext);
			mpw_init(yylval.val);
			mpw_set_str_float(yylval.val,s,10);
			g_free(s);
			return NEGNUM;
		}

[0-9]*\.[0-9]+[e@]-?[0-9]+	|
[0-9]+[e@]-?[0-9]+		|
[0-9]*\.[0-9]+	{
			char *s;
			if(yytext[0] == '.')
				s = g_strconcat("0",&yytext[0],NULL);
			else
				s = g_strdup(yytext);
			mpw_init(yylval.val);
			mpw_set_str_float(yylval.val,s,10);
			g_free(s);
			return POSNUM;
		}

<NEGATIVE>-([1-3][0-9]|[1-9])#[0-9a-zA-Z]+#	{
			char *s;
			int base;

			s=g_malloc(strlen(yytext)-2); /*minus 3 and plus 1*/
			sscanf(yytext,"-%d#%[0-9a-zA-Z]s#",&base,s);
			if(base>36) { g_free(s); REJECT; }
			mpw_init(yylval.val);
			mpw_set_str_int(yylval.val,s,base);
			mpw_neg(yylval.val,yylval.val);
			return NEGNUM;
		}

([1-3][0-9]|[1-9])#[0-9a-zA-Z]+#	{
			char *s;
			int base;

			s=g_malloc(strlen(yytext)-2); /*minus 3 and plus 1*/
			sscanf(yytext,"%d#%[0-9a-zA-Z]s#",&base,s);
			if(base>36) { g_free(s); REJECT; }
			mpw_init(yylval.val);
			mpw_set_str_int(yylval.val,s,base);
			return POSNUM;
		}

<NEGATIVE>-0x[0-9a-fA-F]+	|
<NEGATIVE>-0[0-7]+	|
<NEGATIVE>-[0-9]+		{
			mpw_init(yylval.val);
			mpw_set_str_int(yylval.val,yytext,0);
			return NEGNUM;
		}

0x[0-9a-fA-F]+	|
0[0-7]+		|
[0-9]+		{
			mpw_init(yylval.val);
			mpw_set_str_int(yylval.val,yytext,0);
			return POSNUM;
		}

[ \t\n\r]+	; /*ignore whitespace*/

.		{ return yytext[0]; }

%%
