/* The two `main' functions are shamelessly ripped off from
 * guile-1.2/libguile/guile.c.
 *
 * Hopefully this will evolve into a nice shell.
 */

#include <config.h>

#include <libguile.h>
#include "../guile-gtk/guile-gtk.h"

#include "gnome.h"
#include "libgnome/gnome-history.h"

/* Debugger interface (don't change the order of the following lines) */
#define GDB_TYPE SCM
#include <libguile/gdb_interface.h>
GDB_INTERFACE;


extern void gnome_guile_client_init (void);

/***** Export Gnome functions to Scheme *****/

#if 0
/* FIXME!!!  All this stuff should be generated automatically.
 * XXX: Remember to export all useful GNOME functions to the Scheme part.
 */

static SCM
guile_gnome_libdir_file(SCM scm_filename)
{
	char *filename;
	char *libdir_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1, "gnome-libdir-file");

	filename    = SCM_CHARS(scm_filename);
	libdir_file = gnome_libdir_file(filename);

	ret = scm_makfrom0str(libdir_file);
	g_free(libdir_file);

	return ret;
}


static SCM
guile_gnome_datadir_file(SCM scm_filename)
{
	char *filename;
	char *datadir_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1, "gnome-datadir-file");
	
	filename    = SCM_CHARS(scm_filename);
	datadir_file = gnome_datadir_file(filename);

	ret = scm_makfrom0str(datadir_file);
	g_free(datadir_file);

	return ret;
}
	

static SCM
guile_gnome_pixmap_file(SCM scm_filename)
{
	char *filename;
	char *pixmap_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1, "gnome-pixmap-file");
	
	filename    = SCM_CHARS(scm_filename);
	pixmap_file = gnome_pixmap_file(filename);

	ret = scm_makfrom0str(pixmap_file);
	g_free(pixmap_file);

	return ret;
}
	

static SCM
guile_gnome_unconditional_libdir_file(SCM scm_filename)
{
	char *filename;
	char *libdir_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1,
		   "gnome-unconditional-libdir-file");

	filename    = SCM_CHARS(scm_filename);
	libdir_file = gnome_unconditional_libdir_file(filename);

	ret = scm_makfrom0str(libdir_file);
	g_free(libdir_file);

	return ret;
}


static SCM
guile_gnome_unconditional_datadir_file(SCM scm_filename)
{
	char *filename;
	char *datadir_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1,
		   "gnome-unconditional-datadir-file");
	
	filename    = SCM_CHARS(scm_filename);
	datadir_file = gnome_unconditional_datadir_file(filename);

	ret = scm_makfrom0str(datadir_file);
	g_free(datadir_file);

	return ret;
}
	

static SCM
guile_gnome_unconditional_pixmap_file(SCM scm_filename)
{
	char *filename;
	char *pixmap_file;
	SCM   ret;

	SCM_ASSERT(SCM_NIMP(scm_filename) && SCM_STRINGP(scm_filename), scm_filename, SCM_ARG1,
		   "gnome-unconditional-pixmap-file");
	
	filename    = SCM_CHARS(scm_filename);
	pixmap_file = gnome_unconditional_pixmap_file(filename);

	ret = scm_makfrom0str(pixmap_file);
	g_free(pixmap_file);

	return ret;
}


static SCM
guile_gnome_config_get_string(SCM path)
{
	char *thepath;
	char *value;
	SCM   ret;
	
	SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path, SCM_ARG1, "gnome-config-get-string");

	thepath = SCM_CHARS(path);
	value = gnome_config_get_string(thepath);

	ret = scm_makfrom0str(value);
	g_free(value);

	return ret;
}

#endif

static SCM
guile_gnome_about (SCM title, SCM version, SCM copyright,
		   SCM comments, SCM logo, SCM author_list)
{
  gchar **authors;
  int i, count;
  SCM l;
  GtkWidget *c_ret;

  SCM_ASSERT (SCM_NIMP (title) && SCM_STRINGP (title), title,
	      SCM_ARG1, "gnome-about");
  SCM_ASSERT (SCM_NIMP (version) && SCM_STRINGP (version), version,
	      SCM_ARG2, "gnome-about");
  SCM_ASSERT (SCM_NIMP (copyright) && SCM_STRINGP (copyright), copyright,
	      SCM_ARG3, "gnome-about");
  SCM_ASSERT (SCM_NIMP (comments) && SCM_STRINGP (comments), comments,
	      SCM_ARG4, "gnome-about");
  SCM_ASSERT (logo == SCM_BOOL_F
	      || (SCM_NIMP (logo) && SCM_STRINGP (logo)), logo,
	      SCM_ARG5, "gnome-about");

  SCM_COERCE_SUBSTR (title);
  SCM_COERCE_SUBSTR (version);
  SCM_COERCE_SUBSTR (copyright);
  SCM_COERCE_SUBSTR (comments);
  if (logo != SCM_BOOL_F)
    SCM_COERCE_SUBSTR (logo);

  /* Start at one for trailing NULL.  */
  count = 1;
  for (l = author_list; SCM_NNULLP (l); l = SCM_CDR (l))
    {
      SCM item;
      SCM_ASSERT (SCM_NIMP (l) && SCM_CONSP (l), l,
		  SCM_ARG6, "gnome-about");
      item = SCM_CAR (l);
      SCM_ASSERT (SCM_NIMP (item) && SCM_STRINGP (item), item,
		  SCM_ARG6, "gnome-about");
      ++count;
    }

  SCM_DEFER_INTS;
  authors = malloc (count * sizeof (char *));

  i = 0;
  for (l = author_list; ! SCM_NULLP (l); l = SCM_CDR (l))
    {
      SCM item = SCM_CAR (l);
      SCM_COERCE_SUBSTR (item);
      authors[i] = SCM_CHARS (item);
      ++i;
    }
  authors[i] = NULL;

  c_ret = gnome_about_new (SCM_CHARS (title), SCM_CHARS (version),
			   SCM_CHARS (copyright), authors,
			   SCM_CHARS (comments),
			   logo == SCM_BOOL_F? NULL : SCM_CHARS (logo));
  free (authors);

  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject *) c_ret);
}



/* FIXME: this is taken from guile-gtk.c.  */
static void
make_argv (SCM list, int *argc, char ***argv)
{
  static char *argv_storage[1] = { "guile-gtk" };

  int c = scm_ilength (list), i;
  char **v;

  *argv = argv_storage;
  *argc = 1;

  if (c < 0)
    return;

  v = (char **)scm_must_malloc ((c+1) * sizeof(char**), "make-argv");
  for (i = 0; i < c; i++, list = SCM_CDR (list))
    {
      if (SCM_IMP (SCM_CAR (list)) || SCM_NSTRINGP (SCM_CAR (list)))
	{
	  scm_must_free ((char *)v);
	  return;
	}
      v[i] = strdup (SCM_CHARS (SCM_CAR (list)));
    }
  v[c] = NULL;
  
  *argv = v;
  *argc = c;
}


/* FIXME: we need a global because there is no good way to pass this
   info around.  This is completely evil.  Don't call gnome_init
   reentrantly, and don't capture it in a continuation.  (If you do
   these things you're probably toast anyway, so this isn't a real
   restriction.)  */
static SCM parse_func_hack;

/* This is global so that we can eventually free it if we discover it
   hasn't been freed.  Yuck!  */
static struct argp_option *parse_options_hack = NULL;

static error_t
guile_gnome_parser (int key, char *arg, struct argp_state *state)
{
  char *name = NULL;
  SCM args = SCM_EOL, ans;

  if (key < 0)
    {
      /* One of our long options.  Find the name of the option and set
	 up to call the parser function.  */
      name = parse_options_hack[- key - 1].name;
    }
  else if (key == ARGP_KEY_ARG)
    {
      /* Recognize but do nothing.  */
    }
  else
    return ARGP_ERR_UNKNOWN;

  args = scm_cons (arg ? scm_makfrom0str (arg) : SCM_BOOL_F, args);
  args = scm_cons (name ? scm_makfrom0str (name) : SCM_BOOL_F, args);

  ans = scm_apply (parse_func_hack, args, SCM_EOL);

  if (SCM_FALSEP (ans))
    argp_usage (state);

  return 0;
}

static char sgnome_init_hack[] = "gnome-init-hack";

/* A hacky wrapper for gnome_init().  We give the function a funny
   name so that a closer approximation can later be named
   `gnome-init'.  This function handles argument parsing.  But it only
   lets long options through.  ARGS is a list of triples.  Each triple
   has the form (LONG-NAME DOC NAME); NAME is #f if the option has no
   argument.  See?  I told you it was hacky.  When an argument is
   found, PARSE_FUNC is called with the option name and the option
   argument (or #f if no argument) as arguments.  If an argument
   (e.g., file name) is seen, then PARSE_FUNC is called with the first
   arg #f and the second arg the argument.  */
static SCM
guile_gnome_init_hack (SCM app_id, SCM parse_func, SCM args)
{
  struct argp parser;
  SCM l;
  int i, len;
  int argc;
  char **argv;

  parser.parser = guile_gnome_parser;
  parser.args_doc = NULL;
  parser.doc = NULL;
  parser.children = NULL;
  parser.help_filter = NULL;
  parser.argp_domain = NULL;

  SCM_ASSERT (SCM_NIMP (app_id) && SCM_STRINGP (app_id), app_id,
	      SCM_ARG1, sgnome_init_hack);
  SCM_COERCE_SUBSTR (app_id);

  /* FIXME: make some assertion about the type of PARSE_FUNC.  */
  parse_func_hack = parse_func;

  /* Start at 1 for trailing NULL entry.  */
  len = 1;
  for (l = args; SCM_NNULLP (l); l = SCM_CDR (l))
    {
      SCM sub, item;
      int n;

      SCM_ASSERT (SCM_NIMP (l) && SCM_CONSP (l), l,
		  SCM_ARG3, sgnome_init_hack);

      n = 0;
      for (sub = SCM_CAR (l); SCM_NNULLP (sub) && n < 3; sub = SCM_CDR (sub))
	{
	  SCM item;

	  SCM_ASSERT (SCM_NIMP (sub) && SCM_CONSP (sub), sub,
		      SCM_ARG3, sgnome_init_hack);

	  item = SCM_CAR (sub);
	  /* Last item in triple can be #f.  */
	  if (n == 3 && SCM_FALSEP (item))
	    break;
	  SCM_ASSERT (SCM_NIMP (item) && SCM_STRINGP (item), item,
		      SCM_ARG3, sgnome_init_hack);
	  SCM_COERCE_SUBSTR (item);

	  ++n;
	}

      ++len;
    }


  SCM_DEFER_INTS;

  if (parse_options_hack)
    free (parse_options_hack);

  parse_options_hack = (struct argp_option *) malloc (len * sizeof (struct argp_option));

  i = 0;
  for (l = args; SCM_NNULLP (l); l = SCM_CDR (l))
    {
      SCM sub, item;

      sub = SCM_CAR (l);
      parse_options_hack[i].name = SCM_CHARS (SCM_CAR (sub));
      parse_options_hack[i].key = - i - 1;
      parse_options_hack[i].flags = 0;
      parse_options_hack[i].doc = SCM_CHARS (SCM_CAR (SCM_CDR (sub)));
      parse_options_hack[i].group = 1;

      item = SCM_CAR (SCM_CDR (SCM_CDR (sub)));
      if (SCM_FALSEP (item))
	parse_options_hack[i].arg = NULL;
      else
	parse_options_hack[i].arg = SCM_CHARS (item);

      ++i;
    }

  parse_options_hack[i].name = NULL;
  parse_options_hack[i].key = 0;
  parse_options_hack[i].flags = 0;
  parse_options_hack[i].doc = NULL;
  parse_options_hack[i].group = 0;
  parse_options_hack[i].arg = NULL;

  parser.options = parse_options_hack;

  make_argv (scm_program_arguments (), &argc, &argv);
  gnome_init (SCM_CHARS (app_id), &parser, argc, argv, 0, NULL);

  free (parse_options_hack);
  parse_options_hack = NULL;

  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}



void
gnome_init_guile_support (void)
{
	/* utilities */

#if 0
	scm_make_gsubr("gnome-libdir-file", 1, 0, 0, guile_gnome_libdir_file);
	scm_make_gsubr("gnome-datadir-file", 1, 0, 0, guile_gnome_datadir_file);
	scm_make_gsubr("gnome-pixmap-file", 1, 0, 0, guile_gnome_pixmap_file);
	scm_make_gsubr("gnome-unconditional-libdir-file", 1, 0, 0, guile_gnome_unconditional_libdir_file);
	scm_make_gsubr("gnome-unconditional-datadir-file", 1, 0, 0, guile_gnome_unconditional_datadir_file);
	scm_make_gsubr("gnome-unconditional-pixmap-file", 1, 0, 0, guile_gnome_unconditional_pixmap_file);

	scm_make_gsubr("gnome-config-get-string", 1, 0, 0, guile_gnome_config_get_string);
#endif

	/* FIXME: this should really be done via `gnome.defs'.  But
	   currently the .defs file doesn't have the syntax to
	   describe this interface.  Note that I changed the order of
	   arguments here.  I named the function "gnome-about" and not
	   "gnome-about-new" so that the latter can be used by the
	   .defs file without changing anything.  */
	scm_make_gsubr("gnome-about", 5, 0, 1, guile_gnome_about);

	scm_make_gsubr(sgnome_init_hack, 3, 0, 0, guile_gnome_init_hack);
}

#if 0
static void
locate_error (char *s)
{
	fprintf (stderr,
		 "I could not locate the %s file\n"
		 "please check that you have either installed the software,\n"
		 "Or you have set the GNOMEDIR variable to point to an appropiate\n"
		 "location\n", s);
	exit (1);
}

static void
inner_main (void *closure, int argc, char **argv)
{
	char *shared_guile_scm = gnome_datadir_file ("gnome-guile/gnome.scm");
	char *cmd;
	char **argv_copy;
	int  i;

	/* We load the glue... */

	if (!shared_guile_scm){
		locate_error ("gnome.scm");
		exit (1);
	}

	/* ... initialize Guile-Gtk... */

	sgtk_init_with_args (&argc, &argv);

	/* ... load the Scheme part of Gnome for apps to use... */

	init_guile_gnome_defs();
	sgtk_init_gnome_defs ();
	gnome_guile_client_init ();
	scm_init_toolkits_gtkstubs_module ();
	scm_primitive_load_path (scm_makfrom0str ("ice-9/boot-9.scm"));
	{
		extern int scm_ice_9_already_loaded;
		
		scm_ice_9_already_loaded = 1;
	}
	scm_primitive_load (scm_makfrom0str (shared_guile_scm));

	scm_shell (argc, argv);

	g_free (shared_guile_scm);
}

int
main (int argc, char **argv)
{
	scm_boot_guile (argc, argv, inner_main, 0);
	return 0; /* never reached */
}
#endif
