/* Aisleriot - menu.c
 * Copyright (C) 1998 Jonathan Blandford <jrb@mit.edu>
 *
 * This game is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define MENU_C
#include <config.h>
#include <guile/gh.h>
#include "sol.h"
#include "menu.h"
#include "draw.h"
#include "cscmi.h"
#include "dialog.h"
/*
 * Menu stuff...
 */


/* Call backs... */

int file_quit_callback (GtkWidget *app, void *data )
{
  gtk_widget_destroy (app);
  gtk_main_quit ();
  
  return TRUE;
}
int game_hint_callback (GtkWidget *app, void *data)
{
  SCM hint;
  int hint_type; 
  char hint_message[100]; //GString appears to be broken?  hack for now...
  char* temp_string;

  /* check to see if the game is over... */
  hint = gh_apply(game_data->game_over_lambda, gh_cons(SCM_EOL,SCM_EOL));

  if (!gh_scm2bool(hint)) {
	 show_hint_dialog(_("The game is over.\nNo hints are available"));
	 return TRUE;
  }  

  /* get the hint... */
  hint = gh_apply(game_data->hint_lambda, gh_cons(SCM_EOL,SCM_EOL));

  if (!gh_scm2bool(hint)) {
	 show_hint_dialog(_("This game does not have hint support yet."));
	 return TRUE;
  }
  hint_type = (gh_scm2int(gh_car(hint)));
  if (hint_type == 0) {
	 temp_string = gh_scm2newstr(gh_cadr(hint),NULL);
	 /* 'A' (not recommended, as i18n is less likely to work... */
	 strcpy(hint_message, temp_string);
	 show_hint_dialog(_((char*) hint_message));
	 free (temp_string);
  }
  else if (hint_type == 1) {
	 int offset = strlen(_("Move the "));
	 /* Move the 'A' on the 'B' */
	 temp_string = gh_scm2newstr(gh_cadr(hint),NULL);
	 strcpy(hint_message, _("Move the "));
	 strcpy(hint_message + offset, temp_string);
	 offset += strlen(temp_string);
	 free (temp_string);

	 temp_string = gh_scm2newstr(gh_caddr(hint),NULL);
	 strcpy(hint_message+offset, _(" on the "));
	 offset += strlen(_(" on the "));
	 strcpy(hint_message+offset, temp_string);
	 offset += strlen(temp_string);
	 free (temp_string);
	 strcpy(hint_message+offset, _("."));
	 show_hint_dialog(_((char*) hint_message));
  }
  else if (hint_type == 2) {
	 int offset = strlen(_("Move the "));
	 /* Move the 'A' on 'B' */
	 temp_string = gh_scm2newstr(gh_cadr(hint),NULL);
	 strcpy(hint_message, _("Move the "));
	 strcpy(hint_message + offset, temp_string);
	 offset += strlen(temp_string);
	 free (temp_string);

	 temp_string = gh_scm2newstr(gh_caddr(hint),NULL);
	 strcpy(hint_message+offset, _(" on "));
	 offset += strlen(_(" on "));
	 strcpy(hint_message+offset, temp_string);
	 offset += strlen(temp_string);
	 free (temp_string);
	 strcpy(hint_message+offset, _("."));
	 show_hint_dialog(_((char*) hint_message));
  }
  else if (hint_type == 3) {
	 /* Deal a new card <from slot A> */
  }
  else {
	 show_hint_dialog(_("This game is unable to provide a hint."));
  }
  return TRUE;
}

int game_load_game_callback (GtkWidget *app, void *data )
{
  score = 0;
  eval_installed_file((char*) data);
  g_string_assign(game, (char*) data);
  seed = random();
  srandom(seed);
  gh_apply(game_data->start_game_lambda, SCM_EOL);
  refresh_screen();
  
  make_title();
  return TRUE;
}

int file_new_game_callback (GtkWidget *app, void *data )
{
  score = 0;
  set_score();
  seed = random();
  srandom(seed);

  gh_apply(game_data->start_game_lambda, SCM_EOL);
  refresh_screen();

  hide_game_over_box();
  hide_select_box();

  make_title();
  return TRUE;
}
int file_select_game_callback (GtkWidget *app, void *data )
{
  show_select_game_dialog();
  return TRUE;
}
int help_about_callback (GtkWidget *widget, void *data)
{
  GtkWidget *about;
  gchar *authors[] = {
	  "Main program:  Jonathan Blandford (jrb@mit.edu)",
	  "Card Games:    Jonathan Blandford (jrb@mit.edu)",
	  "                      Ryu Changwoo (cwryu@eve.kaist.ac.kr)",
	  "                      Rosanna Yuen (rwsy@mit.edu)",
          NULL
          };

  about = gnome_about_new ( _("GNOME Solitaire"), VERSION,
        		/* copyrigth notice */
                        "(C) 1998 Jonathan Blandford (jrb@MIT.EDU)",
                        authors,
                        /* another comments */
                        _("The GNOME Generic Solitaire provides a rule-based "
			  "solitaire engine that allows many different games to be played"),
                        NULL);
  gtk_widget_show (about);

  return;
}

/* We fill the items in at runtime... */
GnomeUIInfo variation_menu[] = {
  {GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
};

GnomeUIInfo game_menu[] = {
  {GNOME_APP_UI_SUBTREE, N_("Variation"), NULL, variation_menu, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Hint"), NULL, game_hint_callback, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  {GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
};
GnomeUIInfo help_menu[] = {
  {GNOME_APP_UI_ITEM, N_("About..."), NULL, help_about_callback, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  {GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
};

GnomeUIInfo file_menu[] = {
  {GNOME_APP_UI_ITEM, N_("New"), NULL, file_new_game_callback, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 'n', GDK_CONTROL_MASK, NULL},
  {GNOME_APP_UI_ITEM, N_("Select Game"), NULL, file_select_game_callback, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 'n', GDK_CONTROL_MASK, NULL},
  {GNOME_APP_UI_ITEM, N_("Exit"), NULL, file_quit_callback, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 0, 0, NULL},
  {GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
};

GnomeUIInfo main_menu[] = {
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL, file_menu, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  {GNOME_APP_UI_SUBTREE, N_("Game"), NULL, game_menu, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL, help_menu, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  {GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
};

typedef struct {
  char *desc, *filename;
} AGame;

/* These should be in *reverse* alphabetical order */
AGame gamelist[] = {
  {N_("Spider"), "spider.scm"},
  {N_("Osmosis"), "osmosis.scm"},
  {N_("Odessa"), "odessa.scm"},
  {N_("Klondike"), "klondike.scm"},
  {N_("Freecell"), "freecell.scm"},
  {N_("Camelot"), "camelot.scm"},
  {NULL, NULL}
};

void create_menus(GnomeApp *app)
{
  int i;
  GtkWidget *w;
  gnome_app_create_menus(app, main_menu);

  for(i = 0; gamelist[i].desc; i++)
    {
      w = gtk_menu_item_new_with_label(_(gamelist[i].desc));
      gtk_widget_show(w);
      gtk_menu_shell_prepend(GTK_MENU_SHELL(variation_menu[0].widget), w);
      gtk_signal_connect(GTK_OBJECT(w), "activate", (GtkSignalFunc) game_load_game_callback,
			 (gpointer)gamelist[i].filename);
    }
}
