/*
 * $Id: config_panel.c,v 1.20 1998/05/26 21:36:42 jochen Exp $
 * GXSNMP -- An snmp management application.
 * Copyright (C) 1998 Gregory Mclean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * The configuration panel 
 */
#ifndef lint
static char const copyright[] =
"@(#) Copyright (c) 1998 Gregory McLean";
#endif
static char const rcsid[] = 
 "$Id: config_panel.c,v 1.20 1998/05/26 21:36:42 jochen Exp $";

#include <string.h>
#include <gtk/gtk.h>
#include "main.h"
#include "gui.h"

extern gxsnmp *app_info;
extern GdkPixmap *book_open;
extern GdkPixmap *book_closed;
extern GdkBitmap *book_open_mask;
extern GdkBitmap *book_closed_mask;

gxsnmp_config def_config = {
  "public",
  "private",
  1,
  161,
  5,
  3,
  "localhost",
  "nobody"
};
/*
 * Local data
 */

static char *snmp_label[] = {
  N_("Default read community"),
  N_("Default write community"),
  N_("Default remote port"),
  N_("Default retries"),
  N_("Default timeout (seconds)")
};

static char *sql_label[] = {
  N_("Default SQL host"),
  N_("Default SQL user"),
  N_("Default SQL password"),
  N_("Default SQL database"),
  N_("Default SQL remote port")
};

static GnomeUIInfo file_menu[] = {
  { GNOME_APP_UI_ITEM, N_("Open..."), NULL, NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save"), NULL, NULL, NULL, NULL, 
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save As..."), NULL, NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS, 0, 0, NULL },
  { GNOME_APP_UI_SEPARATOR },
  { GNOME_APP_UI_ITEM, N_("Close"), NULL, NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },
  { GNOME_APP_UI_ENDOFINFO }
};

static GnomeUIInfo config_menu[] = {
  { GNOME_APP_UI_SUBTREE, N_("File"), NULL, file_menu, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_ENDOFINFO }
};

/*
 * local functions
 */
static void             create_config_panel (void);
static void             ok_button_cb        (GtkWidget       *widget,
			                     gpointer        data);
static void             cancel_button_cb    (GtkWidget       *widget,
					     gpointer        data);
static void             save_button_cb      (GtkWidget       *widget,
					     gpointer        data);
static gint             panel_delete_cb     (GtkWidget       *widget,
					     GdkEvent        *e,
					     gpointer        data);
static GtkMenuFactory   *create_menu        (void);

/*
 * global functions
 */
static void
create_config_panel ()
{
  GtkWidget      *button;
  GtkWidget      *vbox;
  GtkWidget      *notebook;
  GtkWidget      *label;
  GtkWidget      *table;
  GtkWidget      *scrolled;
  GtkWidget      *bar;
  GtkWidget      *button_box;
  GtkWidget      *frame;
  GtkAdjustment  *adjustment;
  GtkMenuFactory *mf;
  char           buf[20];
  int            i;

  app_info->conf_panel = (config_panel *)g_malloc (sizeof(config_panel));

  app_info->conf_panel->window = gnome_app_new ( "GXSNMP", 
						 _("GXSNMP Configuration") );
  gtk_window_set_wmclass (GTK_WINDOW (app_info->conf_panel->window),
			  "config_dialog", "GXSnmp");
  gtk_signal_connect (GTK_OBJECT (app_info->conf_panel->window), 
		      "delete_event",
                      GTK_SIGNAL_FUNC (panel_delete_cb),
                      app_info->conf_panel);
  vbox = gtk_vbox_new (FALSE, 4);

  label = gtk_label_new (_("Configuration"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.0);
  gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, FALSE, 0);

  notebook = gtk_notebook_new ();
  gtk_signal_connect (GTK_OBJECT (notebook), "switch_page",
		      GTK_SIGNAL_FUNC (page_switch_cb), NULL);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
  gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);

  frame = gtk_frame_new (NULL);
  gtk_container_border_width (GTK_CONTAINER (frame), 5);

  table = gtk_table_new (ELEMENTS (snmp_label), 2, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), table);
  
  for (i = 0; i < ELEMENTS (snmp_label); i++)
    {
      label = gtk_label_new (gettext(snmp_label[i]));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_table_attach (GTK_TABLE (table), label, 0, 1, i, (i+1),
		    GTK_SHRINK | GTK_FILL, GTK_SHRINK, 2, 1);
      switch (i)
	{	
	case CONF_SNMP_RETR:
	  adjustment = GTK_ADJUSTMENT (gtk_adjustment_new
				       (app_info->current_config.def_snmp_retr,
					0.0, 32.0, 1.0, 1.0, 1.0));
	  app_info->conf_panel->entries[i] = gtk_hscale_new (GTK_ADJUSTMENT
							     (adjustment));
	  gtk_scale_set_digits (GTK_SCALE (app_info->conf_panel->entries[i]),
				0);
	  break;
	case CONF_SNMP_TIME:
	  adjustment = GTK_ADJUSTMENT (gtk_adjustment_new
				       (app_info->current_config.def_snmp_time,
					0.0, 300.0, 1.0, 1.0, 1.0));
	  app_info->conf_panel->entries[i] = gtk_hscale_new (GTK_ADJUSTMENT
							     (adjustment));
	  gtk_scale_set_digits (GTK_SCALE (app_info->conf_panel->entries[i]),
				0);
	  break;
	case CONF_SNMP_RCOM:
	case CONF_SNMP_WCOM:
	case CONF_SNMP_PORT:
	  app_info->conf_panel->entries[i] = gtk_entry_new ();
	  switch (i)
	    {
	    case CONF_SNMP_RCOM:
	      gtk_entry_set_text (GTK_ENTRY (app_info->conf_panel->entries[i]),
				  app_info->current_config.def_snmp_com);
	      break;
	    case CONF_SNMP_WCOM:
	      gtk_entry_set_text (GTK_ENTRY (app_info->conf_panel->entries[i]),
				  app_info->current_config.def_snmp_wcom);
	      break;
	    case CONF_SNMP_PORT:
	      snprintf (buf, sizeof (buf), "%d",
			app_info->current_config.def_snmp_port);
	      gtk_entry_set_text (GTK_ENTRY (app_info->conf_panel->entries[i]),
				  buf);
	      break;

	    }
	  break;
	default:
	  app_info->conf_panel->entries[i] = gtk_entry_new ();
	  break;
	}
      gtk_table_attach (GTK_TABLE (table), app_info->conf_panel->entries[i],
			1, 2, i, (i+1),
			GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK, 2, 1);
    }
  gtk_widget_show_all (table);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, 
			    notebook_tab (N_("SNMP")));

  /* 
   * SQL Page
   */
  frame = gtk_frame_new (NULL);
  gtk_container_border_width (GTK_CONTAINER (frame), 5);
  
  table = gtk_table_new (ELEMENTS (sql_label), 3, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), table);
 
  for (i = 0; i < ELEMENTS (sql_label); i++)
    {
      label = gtk_label_new (gettext(sql_label[i]));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_table_attach (GTK_TABLE (table), label, 0, 1, i, (i + 1),
			GTK_SHRINK | GTK_FILL, GTK_SHRINK, 2, 1);
    }

  app_info->conf_panel->def_sql_host = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (app_info->conf_panel->def_sql_host),
		      app_info->current_config.def_sql_host);
  gtk_table_attach (GTK_TABLE (table), app_info->conf_panel->def_sql_host, 
		    1, 2, 0, 1,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK, 2, 1);
  gtk_widget_show (app_info->conf_panel->def_sql_host);


  app_info->conf_panel->def_sql_user = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (app_info->conf_panel->def_sql_user),
		      app_info->current_config.def_sql_user);
  gtk_table_attach (GTK_TABLE (table), app_info->conf_panel->def_sql_user,
		    1, 2, 1, 2,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK, 2, 1);
  gtk_widget_show (app_info->conf_panel->def_sql_user);

  app_info->conf_panel->def_sql_passwd = gtk_entry_new ();
  if (app_info->current_config.def_sql_pass)
    gtk_entry_set_text (GTK_ENTRY (app_info->conf_panel->def_sql_passwd),
			app_info->current_config.def_sql_pass);
  gtk_table_attach (GTK_TABLE (table), app_info->conf_panel->def_sql_passwd,
		    1, 2, 2, 3,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK, 2, 1);
  gtk_widget_show (app_info->conf_panel->def_sql_passwd);

  app_info->conf_panel->def_sql_db = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (app_info->conf_panel->def_sql_db),
		      app_info->current_config.def_sql_db);
  gtk_entry_set_text (GTK_ENTRY (app_info->conf_panel->def_sql_db),
		      app_info->current_config.def_sql_db);
  gtk_table_attach (GTK_TABLE (table), app_info->conf_panel->def_sql_db,
		    1, 2, 3, 4,
		    GTK_EXPAND | GTK_FILL, GTK_SHRINK, 2, 1);
  button = gtk_button_new_with_label (N_("Browse...."));
  gtk_table_attach (GTK_TABLE (table), button,
		    2, 3, 3, 4,
		    GTK_EXPAND | GTK_FILL, GTK_SHRINK, 2, 1);

  app_info->conf_panel->def_sql_port = gtk_entry_new ();
  gtk_table_attach (GTK_TABLE (table), app_info->conf_panel->def_sql_port,
		    1, 2, 4, 5,
		    GTK_EXPAND | GTK_FILL | GTK_SHRINK, GTK_SHRINK, 2, 1);
  gtk_widget_show (app_info->conf_panel->def_sql_port);
  gtk_widget_show (table);

  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, 
			    notebook_tab (_("Database")));

  /*
   * General configuration page
   */
  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame,
			    notebook_tab (_("General")));

  /* 
   * Collecter config.. (global)
   */
  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, 
			    notebook_tab (_("Collector")));

  /*
   * Mib Library
   *
   * This page should look something like this:
   *   available mibs                  mibs to load
   * +-------------------+         +-------------------+
   * | blah blah blah    |  Add>>  | blah blah         |
   * | blah blah blag    |  <<Rem  |                   |
   * +-------------------+         +-------------------+
   * 
   * I would like this so that we don't load _all_ the mibs in the
   * directory and only load/parse (consume resources for) the mibs
   * that we use.
   *
   * I want to add a "search path" option to configure the directories
   * where MIBs can be found. So it's possible to keep the official
   * MIBS e.g in a dir like /usr/share/mibs and the personal ones 
   * (e.g. vendor MIBs or experimental) in ~/.mibs -- Jochen
   */
  frame = gtk_frame_new (NULL);
  table = gtk_table_new (4, 5, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), table);
  label = gtk_label_new (N_("Available mibs"));
  gtk_table_attach (GTK_TABLE (table), label,
		    0, 1, 0, 1,
		    GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 1);
  label = gtk_label_new (N_("Mibs to load"));
  gtk_table_attach (GTK_TABLE (table), label,
		    5, 6, 0, 1,
		    GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 1);
  scrolled = gtk_scrolled_window_new (NULL, NULL);
  gtk_table_attach (GTK_TABLE (table), scrolled,
		    0, 1, 1, 4,
		    GTK_FILL | GTK_EXPAND, GTK_EXPAND | GTK_FILL, 2, 1);
  
  bar = gtk_vseparator_new ();
  gtk_table_attach (GTK_TABLE (table), bar, 
		    2, 3, 1, 4,
		    GTK_FILL, GTK_FILL | GTK_EXPAND, 2, 1);
  button = gtk_button_new_with_label (N_("Add..."));
  gtk_table_attach (GTK_TABLE (table), button,
		    3, 4, 1, 2, 
		    GTK_FILL | GTK_SHRINK, GTK_SHRINK, 1, 2);
  button = gtk_button_new_with_label (N_("Remove"));
  gtk_table_attach (GTK_TABLE (table), button,
		    3, 4, 2, 3,
		    GTK_FILL | GTK_SHRINK, GTK_SHRINK, 1, 2);
  bar = gtk_vseparator_new ();
  gtk_table_attach (GTK_TABLE (table), bar,
		    4, 5, 1, 4,
		    GTK_FILL, GTK_FILL | GTK_EXPAND, 2, 1);
  scrolled = gtk_scrolled_window_new (NULL, NULL);
  gtk_table_attach (GTK_TABLE (table), scrolled,
		    5, 6, 1, 4,
		    GTK_FILL | GTK_EXPAND, GTK_EXPAND | GTK_FILL, 2, 1);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame,
			    notebook_tab (_("MIB Files")));
  
  /*
   * Button bar
   */
  gtk_widget_show_all (notebook);

  bar = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), bar, FALSE, TRUE, 0);
  gtk_widget_show (bar);

  button_box = gtk_hbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (button_box), 4);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (button_box),
                             GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (button_box), 2);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (button_box), 85, 20);
  gtk_box_pack_start (GTK_BOX (vbox), button_box, FALSE, FALSE, 0);
  gtk_widget_show (button_box);

  button = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (ok_button_cb),
                      NULL);
  gtk_container_add (GTK_CONTAINER (button_box), button);
  gtk_widget_show (button);
  button = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (cancel_button_cb),
                      NULL);
  gtk_container_add (GTK_CONTAINER (button_box), button);
  gtk_widget_show (button);

  button = gtk_button_new_with_label (_("Defaults"));
  gtk_container_add (GTK_CONTAINER (button_box), button);
  gtk_widget_show (button);

  button = gtk_button_new_with_label (_("Save"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (save_button_cb),
		      NULL);
  gtk_container_add (GTK_CONTAINER (button_box), button);
  gtk_widget_show (button);
  /* 
   * Put all this gibbeirsh in the gnome app window
   */
  gnome_app_set_contents (GNOME_APP (app_info->conf_panel->window), vbox);
  gnome_app_create_menus (GNOME_APP (app_info->conf_panel->window), 
			  config_menu);
  gtk_widget_show_all (app_info->conf_panel->window);
}

void
open_config_panel ()
{
  if( app_info->conf_panel == NULL )
    {
      create_config_panel ();
      return ;
    }
  else
    if (!GTK_WIDGET_VISIBLE (app_info->conf_panel->window))
      gtk_widget_show (app_info->conf_panel->window);
}

static void
ok_button_cb (GtkWidget *widget,
              gpointer  data)
{
  config_panel    *panel;
  GtkAdjustment   *adjustment;
  int             i;

  panel = app_info->conf_panel;

  for (i = 0; i < ELEMENTS (snmp_label); i++)
    {
      switch (i)
	{
	case CONF_SNMP_RCOM:
	  app_info->current_config.def_snmp_com = 
	    g_strdup (gtk_entry_get_text (GTK_ENTRY 
					  (panel->entries[CONF_SNMP_RCOM])));
	  break;
	case CONF_SNMP_WCOM:
	  app_info->current_config.def_snmp_wcom =
	    g_strdup (gtk_entry_get_text (GTK_ENTRY
					  (panel->entries[CONF_SNMP_WCOM])));
	  break;
	case CONF_SNMP_PORT:
	  app_info->current_config.def_snmp_port =
	    atoi (gtk_entry_get_text (GTK_ENTRY 
				      (panel->entries[CONF_SNMP_PORT])));
	  break;
	case CONF_SNMP_RETR:
	  adjustment = 
	    gtk_range_get_adjustment (GTK_RANGE
				      (panel->entries[CONF_SNMP_RETR]));
	  app_info->current_config.def_snmp_retr = abs (adjustment->value);
	  break;
	case CONF_SNMP_TIME:
	  adjustment =
	    gtk_range_get_adjustment (GTK_RANGE
				      (panel->entries[CONF_SNMP_TIME]));
	  app_info->current_config.def_snmp_time = abs (adjustment->value);
	  break;
	}                  /* switch */
    }                      /* for */

  /*
   * SQL config
   */
  app_info->current_config.def_sql_host = 
    g_strdup (gtk_entry_get_text (GTK_ENTRY (panel->def_sql_host)));
  app_info->current_config.def_sql_user = 
    g_strdup (gtk_entry_get_text (GTK_ENTRY (panel->def_sql_user)));
  app_info->current_config.def_sql_pass =
    g_strdup (gtk_entry_get_text (GTK_ENTRY (panel->def_sql_passwd)));
  app_info->current_config.def_sql_db = 
    g_strdup (gtk_entry_get_text (GTK_ENTRY (panel->def_sql_db)));
  
  gtk_widget_hide (app_info->conf_panel->window);
}

/* 
 * The callbacks
 */
static void
cancel_button_cb (GtkWidget *widget,
                  gpointer  data)
{
  gtk_widget_hide (app_info->conf_panel->window);
}

static void
save_button_cb (GtkWidget *widget,
		gpointer  data)
{
  GtkAdjustment   *adjustment;
  config_panel    *panel;
  int             i;

  panel = app_info->conf_panel;
  for (i = 0; i < ELEMENTS (snmp_label); i++)
    {
      switch (i)
	{
	case CONF_SNMP_RCOM:
	  app_info->current_config.def_snmp_com = 
	    g_strdup (gtk_entry_get_text (GTK_ENTRY 
					  (panel->entries[CONF_SNMP_RCOM])));
	  break;
	case CONF_SNMP_WCOM:
	  app_info->current_config.def_snmp_wcom =
	    g_strdup (gtk_entry_get_text (GTK_ENTRY
					  (panel->entries[CONF_SNMP_WCOM])));
	  break;
	case CONF_SNMP_PORT:
	  app_info->current_config.def_snmp_port =
	    atoi (gtk_entry_get_text (GTK_ENTRY 
				      (panel->entries[CONF_SNMP_PORT])));
	  break;
	case CONF_SNMP_RETR:
	  adjustment = 
	    gtk_range_get_adjustment (GTK_RANGE
				      (panel->entries[CONF_SNMP_RETR]));
	  app_info->current_config.def_snmp_retr = abs (adjustment->value);
	  break;
	case CONF_SNMP_TIME:
	  adjustment =
	    gtk_range_get_adjustment (GTK_RANGE
				      (panel->entries[CONF_SNMP_TIME]));
	  app_info->current_config.def_snmp_time = abs (adjustment->value);
	  break;
	}                  /* switch */
    }                      /* for */

  /* 
   * SQL config
   */
  app_info->current_config.def_sql_host = 
    g_strdup (gtk_entry_get_text (GTK_ENTRY (panel->def_sql_host)));
  app_info->current_config.def_sql_user = 
    g_strdup (gtk_entry_get_text (GTK_ENTRY (panel->def_sql_user)));
  app_info->current_config.def_sql_pass =
    g_strdup (gtk_entry_get_text (GTK_ENTRY (panel->def_sql_passwd)));
  app_info->current_config.def_sql_db = 
    g_strdup (gtk_entry_get_text (GTK_ENTRY (panel->def_sql_db)));
  
  save_config ();
  gtk_widget_hide (app_info->conf_panel->window);
}

static gint
panel_delete_cb (GtkWidget *widget,
                 GdkEvent  *e,
                 gpointer  data)
{
  gtk_widget_destroy (app_info->conf_panel->window);
  g_free (app_info->conf_panel);
  app_info->conf_panel = NULL;
  return TRUE;
}

/*
 * Local helper functions 
 */
static GtkMenuFactory *
create_menu ()
{
  GtkMenuFactory  *subfactory;
  int             i;

  subfactory = gtk_menu_factory_new (GTK_MENU_FACTORY_MENU_BAR);
  gtk_menu_factory_add_entries (subfactory, config_menu, ELEMENTS 
				(config_menu));
  return subfactory;
}

/*
 * Global standard panel functions
 */
#if 0
void 
open_config_panel ()
{
}
#endif


void
hide_config_panel ()
{
}

void 
destroy_config_panel ()
{
}

void 
reset_config_panel ()
{
}
    
/* EOF */

