#include <sys/time.h>
#include <proc/ps.h>
#include "fromtop.h"

void
sprint_time (char *s, time_t ti)
{
	time_t t = ti/HZ;
	time_t centi_sec = (ti%HZ) * 100 / HZ;

	if (t < 0)                            /* time overflow */
		sprintf(s, ">>d");
	else if (t >= 48*60*60)               /* > 2 days */
		sprintf(s, "%5lud", t/(24*60*60));
	else if (t >= 60*60)                  /* > 1 hour */
		sprintf(s, "%2lu:%02uh", t/(60*60), (unsigned) ((t/60)%60));
	else if (t > 60)                      /* > 1 minute */
		sprintf(s, "%2lu:%02um", t/60, (unsigned) t%60);
	else
		sprintf(s, "%2lu.%02us", t, centi_sec);
}

void get_etime (char *s, int t, int uptime) {
	/* int t;

	if (stime > uptime*HZ) {
	t = 0;
	} else {
	t = stime);
	}
	sprint_time_ival (s, t/HZ, 6, (t%HZ) * 100 / HZ); */
}

int shift_main (int main) {
	return  main >> PAGE_SHIFT;
}

int pcpu_sort (proc_t ** P, proc_t ** Q)
{
    if ((*P)->pcpu < (*Q)->pcpu)
        return -1;
    if ((*P)->pcpu > (*Q)->pcpu)
        return 1;
    return 0;
}

int mem_sort (proc_t ** P, proc_t ** Q)
{
    if ((*P)->resident < (*Q)->resident)
        return -1;
    if ((*P)->resident > (*Q)->resident)
        return 1;
    return 0;
}

/*
 * Finds the current time (in microseconds) and calculates the time
 * elapsed since the last update. This is essential for computing
 * percent CPU usage.
 */
float get_elapsed_time(void)
{
    struct timeval time;
    static struct timeval oldtime;
    struct timezone timez;
    float elapsed_time;

    gettimeofday(&time, &timez);
    elapsed_time = (time.tv_sec - oldtime.tv_sec)
        + (float) (time.tv_usec - oldtime.tv_usec) / 1000000.0;
    oldtime.tv_sec = time.tv_sec;
    oldtime.tv_usec = time.tv_usec;
    return (elapsed_time);
}

