/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_class_is_a (ValaClass* self,
                                ValaClass* cl,
                                ValaTypeSymbol* t);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_class_finalize (ValaCodeNode * obj);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaObjectType* _tmp11_;
		ValaObjectType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", (ValaDataType*) _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp23_ = _tmp29_ > 0;
		_vala_iterable_unref0 (_tmp27_);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaScope* _tmp32_;
			ValaScope* _tmp33_;
			ValaLocalVariable* _tmp34_;
			ValaLocalVariable* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp32_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			vala_scope_remove (_tmp33_, _tmp37_);
		}
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_copy (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_local_variable_new (_tmp41_, "result", NULL, _tmp43_);
		_tmp45_ = _tmp44_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp45_);
		_vala_code_node_unref0 (_tmp45_);
		_vala_code_node_unref0 (_tmp41_);
		_tmp46_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp47_ = _tmp46_;
		vala_local_variable_set_is_result (_tmp47_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp50_;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gboolean _tmp69_ = FALSE;
		gboolean _tmp70_;
		_tmp48_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp50_;
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			vala_report_error (_tmp61_, _tmp68_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_tmp70_ = self->priv->_is_abstract;
		if (_tmp70_) {
			ValaCreationMethod* _tmp71_;
			ValaSymbolAccessibility _tmp72_;
			ValaSymbolAccessibility _tmp73_;
			_tmp71_ = cm;
			_tmp72_ = vala_symbol_get_access ((ValaSymbol*) _tmp71_);
			_tmp73_ = _tmp72_;
			_tmp69_ = _tmp73_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp69_ = FALSE;
		}
		if (_tmp69_) {
			gboolean _tmp74_;
			gboolean _tmp75_;
			_tmp74_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp75_ = _tmp74_;
			if (_tmp75_) {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_warning (_tmp77_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp78_;
				ValaSourceReference* _tmp79_;
				_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp79_ = _tmp78_;
				vala_report_error (_tmp79_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (cm);
				return;
			}
		}
		_vala_code_node_unref0 (cm);
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* result = NULL;
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaObjectType* _tmp0_;
	ValaObjectType* _tmp1_;
	ValaParameter* _tmp2_;
	ValaParameter* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	ValaField* _tmp12_;
	ValaField* _tmp13_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_parameter_new ("this", (ValaDataType*) _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	vala_property_set_this_parameter (prop, _tmp3_);
	_vala_code_node_unref0 (_tmp3_);
	_vala_code_node_unref0 (_tmp1_);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_property_get_this_parameter (prop);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	vala_scope_add (_tmp5_, _tmp9_, (ValaSymbol*) _tmp11_);
	_tmp12_ = vala_property_get_field (prop);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaField* _tmp14_;
		ValaField* _tmp15_;
		_tmp14_ = vala_property_get_field (prop);
		_tmp15_ = _tmp14_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp15_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp57_;
	ValaConstructor* _tmp58_;
	ValaConstructor* _tmp61_;
	ValaConstructor* _tmp62_;
	ValaConstructor* _tmp65_;
	ValaConstructor* _tmp66_;
	ValaDestructor* _tmp69_;
	ValaDestructor* _tmp70_;
	ValaDestructor* _tmp73_;
	ValaDestructor* _tmp74_;
	ValaDestructor* _tmp77_;
	ValaDestructor* _tmp78_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp8_;
		gint _p_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _p_index = 0;
		_tmp8_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp8_;
		_tmp9_ = _p_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_p_size = _tmp11_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaTypeParameter* _tmp14_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp12_ = _p_list;
			_tmp13_ = vala_list_get (_tmp12_, _p_index);
			p = (ValaTypeParameter*) _tmp13_;
			_tmp14_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp15_;
		gint _en_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _en_index = 0;
		_tmp15_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp15_;
		_tmp16_ = _en_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_en_size = _tmp18_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaEnum* _tmp21_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp19_ = _en_list;
			_tmp20_ = vala_list_get (_tmp19_, _en_index);
			en = (ValaEnum*) _tmp20_;
			_tmp21_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp21_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp22_;
		gint _f_size = 0;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _f_index = 0;
		_tmp22_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp22_;
		_tmp23_ = _f_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_f_size = _tmp25_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			ValaField* _tmp28_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp26_ = _f_list;
			_tmp27_ = vala_list_get (_tmp26_, _f_index);
			f = (ValaField*) _tmp27_;
			_tmp28_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp29_;
		gint _c_size = 0;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _c_index = 0;
		_tmp29_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp29_;
		_tmp30_ = _c_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_c_size = _tmp32_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp33_;
			gpointer _tmp34_;
			ValaConstant* _tmp35_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp33_ = _c_list;
			_tmp34_ = vala_list_get (_tmp33_, _c_index);
			c = (ValaConstant*) _tmp34_;
			_tmp35_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp36_;
		gint _m_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _m_index = 0;
		_tmp36_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp36_;
		_tmp37_ = _m_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_m_size = _tmp39_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp40_;
			gpointer _tmp41_;
			ValaMethod* _tmp42_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp40_ = _m_list;
			_tmp41_ = vala_list_get (_tmp40_, _m_index);
			m = (ValaMethod*) _tmp41_;
			_tmp42_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp42_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp43_;
		gint _prop_size = 0;
		ValaList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _prop_index = 0;
		_tmp43_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp43_;
		_tmp44_ = _prop_list;
		_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_prop_size = _tmp46_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp47_;
			gpointer _tmp48_;
			ValaProperty* _tmp49_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp47_ = _prop_list;
			_tmp48_ = vala_list_get (_tmp47_, _prop_index);
			prop = (ValaProperty*) _tmp48_;
			_tmp49_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp49_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp50_;
		gint _sig_size = 0;
		ValaList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _sig_index = 0;
		_tmp50_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp50_;
		_tmp51_ = _sig_list;
		_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		_sig_size = _tmp53_;
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig = NULL;
			ValaList* _tmp54_;
			gpointer _tmp55_;
			ValaSignal* _tmp56_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp54_ = _sig_list;
			_tmp55_ = vala_list_get (_tmp54_, _sig_index);
			sig = (ValaSignal*) _tmp55_;
			_tmp56_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp56_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp57_ = vala_class_get_constructor (self);
	_tmp58_ = _tmp57_;
	if (_tmp58_ != NULL) {
		ValaConstructor* _tmp59_;
		ValaConstructor* _tmp60_;
		_tmp59_ = vala_class_get_constructor (self);
		_tmp60_ = _tmp59_;
		vala_code_node_accept ((ValaCodeNode*) _tmp60_, visitor);
	}
	_tmp61_ = vala_class_get_class_constructor (self);
	_tmp62_ = _tmp61_;
	if (_tmp62_ != NULL) {
		ValaConstructor* _tmp63_;
		ValaConstructor* _tmp64_;
		_tmp63_ = vala_class_get_class_constructor (self);
		_tmp64_ = _tmp63_;
		vala_code_node_accept ((ValaCodeNode*) _tmp64_, visitor);
	}
	_tmp65_ = vala_class_get_static_constructor (self);
	_tmp66_ = _tmp65_;
	if (_tmp66_ != NULL) {
		ValaConstructor* _tmp67_;
		ValaConstructor* _tmp68_;
		_tmp67_ = vala_class_get_static_constructor (self);
		_tmp68_ = _tmp67_;
		vala_code_node_accept ((ValaCodeNode*) _tmp68_, visitor);
	}
	_tmp69_ = vala_class_get_destructor (self);
	_tmp70_ = _tmp69_;
	if (_tmp70_ != NULL) {
		ValaDestructor* _tmp71_;
		ValaDestructor* _tmp72_;
		_tmp71_ = vala_class_get_destructor (self);
		_tmp72_ = _tmp71_;
		vala_code_node_accept ((ValaCodeNode*) _tmp72_, visitor);
	}
	_tmp73_ = vala_class_get_static_destructor (self);
	_tmp74_ = _tmp73_;
	if (_tmp74_ != NULL) {
		ValaDestructor* _tmp75_;
		ValaDestructor* _tmp76_;
		_tmp75_ = vala_class_get_static_destructor (self);
		_tmp76_ = _tmp75_;
		vala_code_node_accept ((ValaCodeNode*) _tmp76_, visitor);
	}
	_tmp77_ = vala_class_get_class_destructor (self);
	_tmp78_ = _tmp77_;
	if (_tmp78_ != NULL) {
		ValaDestructor* _tmp79_;
		ValaDestructor* _tmp80_;
		_tmp79_ = vala_class_get_class_destructor (self);
		_tmp80_ = _tmp79_;
		vala_code_node_accept ((ValaCodeNode*) _tmp80_, visitor);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp81_;
		gint _cl_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _cl_index = 0;
		_tmp81_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp81_;
		_tmp82_ = _cl_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_cl_size = _tmp84_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp85_;
			gpointer _tmp86_;
			ValaClass* _tmp87_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp85_ = _cl_list;
			_tmp86_ = vala_list_get (_tmp85_, _cl_index);
			cl = (ValaClass*) _tmp86_;
			_tmp87_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp87_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp88_;
		gint _st_size = 0;
		ValaList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _st_index = 0;
		_tmp88_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp88_;
		_tmp89_ = _st_list;
		_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_st_size = _tmp91_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp92_;
			gpointer _tmp93_;
			ValaStruct* _tmp94_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp92_ = _st_list;
			_tmp93_ = vala_list_get (_tmp92_, _st_index);
			st = (ValaStruct*) _tmp93_;
			_tmp94_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp94_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp95_;
		gint _d_size = 0;
		ValaList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _d_index = 0;
		_tmp95_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp95_;
		_tmp96_ = _d_list;
		_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		_d_size = _tmp98_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp99_;
			gpointer _tmp100_;
			ValaDelegate* _tmp101_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp99_ = _d_list;
			_tmp100_ = vala_list_get (_tmp99_, _d_index);
			d = (ValaDelegate*) _tmp100_;
			_tmp101_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp101_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_data_type (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = base_type;
				_tmp12_ = vala_data_type_get_data_type (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = vala_typesymbol_is_subtype_of (_tmp13_, t);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp4_ = _prereq_list;
			_tmp5_ = vala_list_get (_tmp4_, _prereq_index);
			prereq = (ValaDataType*) _tmp5_;
			_tmp6_ = prereq;
			_tmp7_ = vala_data_type_get_data_type (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _vala_code_node_ref0 (_tmp8_);
			type = _tmp9_;
			_tmp10_ = type;
			if (_tmp10_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp11_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp11_);
			_tmp12_ = type;
			if (VALA_IS_INTERFACE (_tmp12_)) {
				ValaTypeSymbol* _tmp13_;
				_tmp13_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}

static gboolean
vala_class_class_is_a (ValaClass* self,
                       ValaClass* cl,
                       ValaTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (cl, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp4_ = _base_type_list;
			_tmp5_ = vala_list_get (_tmp4_, _base_type_index);
			base_type = (ValaDataType*) _tmp5_;
			_tmp6_ = base_type;
			_tmp7_ = vala_data_type_get_data_type (_tmp6_);
			_tmp8_ = _tmp7_;
			if (VALA_IS_CLASS (_tmp8_)) {
				ValaDataType* _tmp9_;
				ValaTypeSymbol* _tmp10_;
				ValaTypeSymbol* _tmp11_;
				_tmp9_ = base_type;
				_tmp10_ = vala_data_type_get_data_type (_tmp9_);
				_tmp11_ = _tmp10_;
				if (vala_class_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = base_type;
				_tmp13_ = vala_data_type_get_data_type (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == t) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp88_ = FALSE;
	ValaClass* _tmp89_;
	gboolean _tmp102_ = FALSE;
	gboolean _tmp103_;
	gboolean _tmp104_;
	gboolean _tmp114_ = FALSE;
	gboolean _tmp115_;
	gboolean _tmp116_;
	ValaConstructor* _tmp199_;
	ValaConstructor* _tmp200_;
	ValaConstructor* _tmp203_;
	ValaConstructor* _tmp204_;
	ValaConstructor* _tmp207_;
	ValaConstructor* _tmp208_;
	ValaDestructor* _tmp211_;
	ValaDestructor* _tmp212_;
	ValaDestructor* _tmp215_;
	ValaDestructor* _tmp216_;
	ValaDestructor* _tmp219_;
	ValaDestructor* _tmp220_;
	gboolean _tmp244_;
	gboolean _tmp245_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp284_;
	ValaArrayList* _tmp285_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp299_;
	ValaArrayList* _tmp300_;
	ValaList* _tmp313_;
	gint _tmp314_;
	gint _tmp315_;
	ValaSourceFileType _tmp338_;
	ValaSourceFileType _tmp339_;
	ValaSemanticAnalyzer* _tmp561_;
	ValaSemanticAnalyzer* _tmp562_;
	ValaSourceFile* _tmp563_;
	ValaSemanticAnalyzer* _tmp564_;
	ValaSemanticAnalyzer* _tmp565_;
	ValaSymbol* _tmp566_;
	gboolean _tmp567_;
	gboolean _tmp568_;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaDataType* _tmp30_;
			ValaDataType* _tmp31_;
			ValaSemanticAnalyzer* _tmp41_;
			ValaSemanticAnalyzer* _tmp42_;
			ValaDataType* _tmp43_;
			gint n_type_args = 0;
			ValaDataType* _tmp53_;
			ValaList* _tmp54_;
			ValaList* _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			gint n_type_params = 0;
			ValaDataType* _tmp59_;
			ValaTypeSymbol* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaList* _tmp62_;
			ValaList* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			gint _tmp66_;
			_base_type_reference_index = _base_type_reference_index + 1;
			if (!(_base_type_reference_index < _base_type_reference_size)) {
				break;
			}
			_tmp28_ = _base_type_reference_list;
			_tmp29_ = vala_list_get (_tmp28_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp29_;
			_tmp30_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp30_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp31_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp31_)) {
				ValaSourceReference* _tmp32_;
				ValaSourceReference* _tmp33_;
				ValaDataType* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp33_ = _tmp32_;
				_tmp34_ = base_type_reference;
				_tmp35_ = vala_code_node_to_string ((ValaCodeNode*) _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strdup_printf ("base type `%s' of class `%s' is not an object type", _tmp36_, _tmp38_);
				_tmp40_ = _tmp39_;
				vala_report_error (_tmp33_, _tmp40_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp36_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp41_ = vala_code_context_get_analyzer (context);
			_tmp42_ = _tmp41_;
			_tmp43_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp42_, (ValaSymbol*) self, _tmp43_)) {
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaDataType* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				_tmp46_ = base_type_reference;
				_tmp47_ = vala_code_node_to_string ((ValaCodeNode*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp50_ = _tmp49_;
				_tmp51_ = g_strdup_printf ("base type `%s' is less accessible than class `%s'", _tmp48_, _tmp50_);
				_tmp52_ = _tmp51_;
				vala_report_error (_tmp45_, _tmp52_);
				_g_free0 (_tmp52_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp48_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp53_ = base_type_reference;
			_tmp54_ = vala_data_type_get_type_arguments (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = _tmp57_;
			_vala_iterable_unref0 (_tmp55_);
			n_type_args = _tmp58_;
			_tmp59_ = base_type_reference;
			_tmp60_ = vala_data_type_get_data_type (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = _tmp65_;
			_vala_iterable_unref0 (_tmp63_);
			n_type_params = _tmp66_;
			if (n_type_args < n_type_params) {
				ValaDataType* _tmp67_;
				ValaSourceReference* _tmp68_;
				ValaSourceReference* _tmp69_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp67_ = base_type_reference;
				_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
				_tmp69_ = _tmp68_;
				vala_report_error (_tmp69_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				if (n_type_args > n_type_params) {
					ValaDataType* _tmp70_;
					ValaSourceReference* _tmp71_;
					ValaSourceReference* _tmp72_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp70_ = base_type_reference;
					_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp70_);
					_tmp72_ = _tmp71_;
					vala_report_error (_tmp72_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp73_;
		ValaList* _tmp74_;
		gint _type_size = 0;
		ValaList* _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		gint _type_index = 0;
		_tmp73_ = self->priv->base_types;
		_tmp74_ = _vala_iterable_ref0 (_tmp73_);
		_type_list = _tmp74_;
		_tmp75_ = _type_list;
		_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
		_tmp77_ = _tmp76_;
		_type_size = _tmp77_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp78_;
			gpointer _tmp79_;
			ValaDataType* _tmp80_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp78_ = _type_list;
			_tmp79_ = vala_list_get (_tmp78_, _type_index);
			type = (ValaDataType*) _tmp79_;
			_tmp80_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp80_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp81_;
		gint _p_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _p_index = 0;
		_tmp81_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp81_;
		_tmp82_ = _p_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_p_size = _tmp84_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp85_;
			gpointer _tmp86_;
			ValaTypeParameter* _tmp87_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp85_ = _p_list;
			_tmp86_ = vala_list_get (_tmp85_, _p_index);
			p = (ValaTypeParameter*) _tmp86_;
			_tmp87_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp87_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp89_ = self->priv->_base_class;
	if (_tmp89_ != NULL) {
		ValaClass* _tmp90_;
		gboolean _tmp91_;
		gboolean _tmp92_;
		_tmp90_ = self->priv->_base_class;
		_tmp91_ = vala_class_get_is_singleton (_tmp90_);
		_tmp92_ = _tmp91_;
		_tmp88_ = _tmp92_;
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		ValaSourceReference* _tmp93_;
		ValaSourceReference* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		ValaClass* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp94_ = _tmp93_;
		_tmp95_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp96_ = _tmp95_;
		_tmp97_ = self->priv->_base_class;
		_tmp98_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = g_strdup_printf ("`%s' cannot inherit from SingleInstance class `%s'", _tmp96_, _tmp99_);
		_tmp101_ = _tmp100_;
		vala_report_error (_tmp94_, _tmp101_);
		_g_free0 (_tmp101_);
		_g_free0 (_tmp99_);
		_g_free0 (_tmp96_);
	}
	_tmp103_ = vala_class_get_is_singleton (self);
	_tmp104_ = _tmp103_;
	if (_tmp104_) {
		ValaSemanticAnalyzer* _tmp105_;
		ValaSemanticAnalyzer* _tmp106_;
		ValaClass* _tmp107_;
		_tmp105_ = vala_code_context_get_analyzer (context);
		_tmp106_ = _tmp105_;
		_tmp107_ = _tmp106_->object_type;
		_tmp102_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp107_);
	} else {
		_tmp102_ = FALSE;
	}
	if (_tmp102_) {
		ValaSourceReference* _tmp108_;
		ValaSourceReference* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		gchar* _tmp113_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp109_ = _tmp108_;
		_tmp110_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp111_ = _tmp110_;
		_tmp112_ = g_strdup_printf ("SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp111_);
		_tmp113_ = _tmp112_;
		vala_report_error (_tmp109_, _tmp113_);
		_g_free0 (_tmp113_);
		_g_free0 (_tmp111_);
	}
	_tmp115_ = vala_class_get_is_singleton (self);
	_tmp116_ = _tmp115_;
	if (_tmp116_) {
		ValaConstructor* _tmp117_;
		ValaConstructor* _tmp118_;
		_tmp117_ = vala_class_get_constructor (self);
		_tmp118_ = _tmp117_;
		_tmp114_ = _tmp118_ == NULL;
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp119_;
		ValaSourceReference* _tmp120_;
		ValaConstructor* _tmp121_;
		ValaConstructor* _tmp122_;
		ValaSourceReference* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaBlock* _tmp125_;
		ValaBlock* _tmp126_;
		ValaConstructor* _tmp127_;
		_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_constructor_new (_tmp120_);
		c = _tmp121_;
		_tmp122_ = c;
		_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_block_new (_tmp124_);
		_tmp126_ = _tmp125_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp122_, _tmp126_);
		_vala_code_node_unref0 (_tmp126_);
		_tmp127_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp127_);
		_vala_code_node_unref0 (c);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp128_;
		gint _en_size = 0;
		ValaList* _tmp129_;
		gint _tmp130_;
		gint _tmp131_;
		gint _en_index = 0;
		_tmp128_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp128_;
		_tmp129_ = _en_list;
		_tmp130_ = vala_collection_get_size ((ValaCollection*) _tmp129_);
		_tmp131_ = _tmp130_;
		_en_size = _tmp131_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp132_;
			gpointer _tmp133_;
			ValaEnum* _tmp134_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp132_ = _en_list;
			_tmp133_ = vala_list_get (_tmp132_, _en_index);
			en = (ValaEnum*) _tmp133_;
			_tmp134_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp134_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp135_;
		gint _f_size = 0;
		ValaList* _tmp136_;
		gint _tmp137_;
		gint _tmp138_;
		gint _f_index = 0;
		_tmp135_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp135_;
		_tmp136_ = _f_list;
		_tmp137_ = vala_collection_get_size ((ValaCollection*) _tmp136_);
		_tmp138_ = _tmp137_;
		_f_size = _tmp138_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp139_;
			gpointer _tmp140_;
			gboolean _tmp141_ = FALSE;
			gboolean _tmp142_;
			gboolean _tmp143_;
			ValaField* _tmp161_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp139_ = _f_list;
			_tmp140_ = vala_list_get (_tmp139_, _f_index);
			f = (ValaField*) _tmp140_;
			_tmp142_ = vala_class_get_is_compact (self);
			_tmp143_ = _tmp142_;
			if (_tmp143_) {
				ValaField* _tmp144_;
				ValaMemberBinding _tmp145_;
				ValaMemberBinding _tmp146_;
				_tmp144_ = f;
				_tmp145_ = vala_field_get_binding (_tmp144_);
				_tmp146_ = _tmp145_;
				_tmp141_ = _tmp146_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp141_ = FALSE;
			}
			if (_tmp141_) {
				gboolean _tmp147_ = FALSE;
				gboolean _tmp148_;
				gboolean _tmp149_;
				ValaField* _tmp155_;
				ValaMemberBinding _tmp156_;
				ValaMemberBinding _tmp157_;
				_tmp148_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp149_ = _tmp148_;
				if (!_tmp149_) {
					ValaField* _tmp150_;
					ValaSymbolAccessibility _tmp151_;
					ValaSymbolAccessibility _tmp152_;
					_tmp150_ = f;
					_tmp151_ = vala_symbol_get_access ((ValaSymbol*) _tmp150_);
					_tmp152_ = _tmp151_;
					_tmp147_ = _tmp152_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp147_ = FALSE;
				}
				if (_tmp147_) {
					ValaSourceReference* _tmp153_;
					ValaSourceReference* _tmp154_;
					_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp154_ = _tmp153_;
					vala_report_error (_tmp154_, "private fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp155_ = f;
				_tmp156_ = vala_field_get_binding (_tmp155_);
				_tmp157_ = _tmp156_;
				if (_tmp157_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp158_;
					ValaSourceReference* _tmp159_;
					ValaSourceReference* _tmp160_;
					_tmp158_ = f;
					_tmp159_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp158_);
					_tmp160_ = _tmp159_;
					vala_report_error (_tmp160_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp161_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp161_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp162_;
		gint _c_size = 0;
		ValaList* _tmp163_;
		gint _tmp164_;
		gint _tmp165_;
		gint _c_index = 0;
		_tmp162_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp162_;
		_tmp163_ = _c_list;
		_tmp164_ = vala_collection_get_size ((ValaCollection*) _tmp163_);
		_tmp165_ = _tmp164_;
		_c_size = _tmp165_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp166_;
			gpointer _tmp167_;
			ValaConstant* _tmp168_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp166_ = _c_list;
			_tmp167_ = vala_list_get (_tmp166_, _c_index);
			c = (ValaConstant*) _tmp167_;
			_tmp168_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp168_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp169_;
		gint _m_size = 0;
		ValaList* _tmp170_;
		gint _tmp171_;
		gint _tmp172_;
		gint _m_index = 0;
		_tmp169_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp169_;
		_tmp170_ = _m_list;
		_tmp171_ = vala_collection_get_size ((ValaCollection*) _tmp170_);
		_tmp172_ = _tmp171_;
		_m_size = _tmp172_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp173_;
			gpointer _tmp174_;
			ValaMethod* _tmp175_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp173_ = _m_list;
			_tmp174_ = vala_list_get (_tmp173_, _m_index);
			m = (ValaMethod*) _tmp174_;
			_tmp175_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp175_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp176_;
		gint _prop_size = 0;
		ValaList* _tmp177_;
		gint _tmp178_;
		gint _tmp179_;
		gint _prop_index = 0;
		_tmp176_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp176_;
		_tmp177_ = _prop_list;
		_tmp178_ = vala_collection_get_size ((ValaCollection*) _tmp177_);
		_tmp179_ = _tmp178_;
		_prop_size = _tmp179_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp180_;
			gpointer _tmp181_;
			gboolean _tmp182_ = FALSE;
			ValaProperty* _tmp183_;
			ValaAttribute* _tmp184_;
			ValaProperty* _tmp191_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp180_ = _prop_list;
			_tmp181_ = vala_list_get (_tmp180_, _prop_index);
			prop = (ValaProperty*) _tmp181_;
			_tmp183_ = prop;
			_tmp184_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp183_, "NoAccessorMethod");
			if (_tmp184_ != NULL) {
				ValaSemanticAnalyzer* _tmp185_;
				ValaSemanticAnalyzer* _tmp186_;
				ValaClass* _tmp187_;
				_tmp185_ = vala_code_context_get_analyzer (context);
				_tmp186_ = _tmp185_;
				_tmp187_ = _tmp186_->object_type;
				_tmp182_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp187_);
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				ValaProperty* _tmp188_;
				ValaSourceReference* _tmp189_;
				ValaSourceReference* _tmp190_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp188_ = prop;
				_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp188_);
				_tmp190_ = _tmp189_;
				vala_report_error (_tmp190_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp191_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp191_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp192_;
		gint _sig_size = 0;
		ValaList* _tmp193_;
		gint _tmp194_;
		gint _tmp195_;
		gint _sig_index = 0;
		_tmp192_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp192_;
		_tmp193_ = _sig_list;
		_tmp194_ = vala_collection_get_size ((ValaCollection*) _tmp193_);
		_tmp195_ = _tmp194_;
		_sig_size = _tmp195_;
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig = NULL;
			ValaList* _tmp196_;
			gpointer _tmp197_;
			ValaSignal* _tmp198_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp196_ = _sig_list;
			_tmp197_ = vala_list_get (_tmp196_, _sig_index);
			sig = (ValaSignal*) _tmp197_;
			_tmp198_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp198_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp199_ = vala_class_get_constructor (self);
	_tmp200_ = _tmp199_;
	if (_tmp200_ != NULL) {
		ValaConstructor* _tmp201_;
		ValaConstructor* _tmp202_;
		_tmp201_ = vala_class_get_constructor (self);
		_tmp202_ = _tmp201_;
		vala_code_node_check ((ValaCodeNode*) _tmp202_, context);
	}
	_tmp203_ = vala_class_get_class_constructor (self);
	_tmp204_ = _tmp203_;
	if (_tmp204_ != NULL) {
		ValaConstructor* _tmp205_;
		ValaConstructor* _tmp206_;
		_tmp205_ = vala_class_get_class_constructor (self);
		_tmp206_ = _tmp205_;
		vala_code_node_check ((ValaCodeNode*) _tmp206_, context);
	}
	_tmp207_ = vala_class_get_static_constructor (self);
	_tmp208_ = _tmp207_;
	if (_tmp208_ != NULL) {
		ValaConstructor* _tmp209_;
		ValaConstructor* _tmp210_;
		_tmp209_ = vala_class_get_static_constructor (self);
		_tmp210_ = _tmp209_;
		vala_code_node_check ((ValaCodeNode*) _tmp210_, context);
	}
	_tmp211_ = vala_class_get_destructor (self);
	_tmp212_ = _tmp211_;
	if (_tmp212_ != NULL) {
		ValaDestructor* _tmp213_;
		ValaDestructor* _tmp214_;
		_tmp213_ = vala_class_get_destructor (self);
		_tmp214_ = _tmp213_;
		vala_code_node_check ((ValaCodeNode*) _tmp214_, context);
	}
	_tmp215_ = vala_class_get_static_destructor (self);
	_tmp216_ = _tmp215_;
	if (_tmp216_ != NULL) {
		ValaDestructor* _tmp217_;
		ValaDestructor* _tmp218_;
		_tmp217_ = vala_class_get_static_destructor (self);
		_tmp218_ = _tmp217_;
		vala_code_node_check ((ValaCodeNode*) _tmp218_, context);
	}
	_tmp219_ = vala_class_get_class_destructor (self);
	_tmp220_ = _tmp219_;
	if (_tmp220_ != NULL) {
		ValaDestructor* _tmp221_;
		ValaDestructor* _tmp222_;
		_tmp221_ = vala_class_get_class_destructor (self);
		_tmp222_ = _tmp221_;
		vala_code_node_check ((ValaCodeNode*) _tmp222_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp223_;
		gint _cl_size = 0;
		ValaList* _tmp224_;
		gint _tmp225_;
		gint _tmp226_;
		gint _cl_index = 0;
		_tmp223_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp223_;
		_tmp224_ = _cl_list;
		_tmp225_ = vala_collection_get_size ((ValaCollection*) _tmp224_);
		_tmp226_ = _tmp225_;
		_cl_size = _tmp226_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp227_;
			gpointer _tmp228_;
			ValaClass* _tmp229_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp227_ = _cl_list;
			_tmp228_ = vala_list_get (_tmp227_, _cl_index);
			cl = (ValaClass*) _tmp228_;
			_tmp229_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp229_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp230_;
		gint _st_size = 0;
		ValaList* _tmp231_;
		gint _tmp232_;
		gint _tmp233_;
		gint _st_index = 0;
		_tmp230_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp230_;
		_tmp231_ = _st_list;
		_tmp232_ = vala_collection_get_size ((ValaCollection*) _tmp231_);
		_tmp233_ = _tmp232_;
		_st_size = _tmp233_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp234_;
			gpointer _tmp235_;
			ValaStruct* _tmp236_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp234_ = _st_list;
			_tmp235_ = vala_list_get (_tmp234_, _st_index);
			st = (ValaStruct*) _tmp235_;
			_tmp236_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp236_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp237_;
		gint _d_size = 0;
		ValaList* _tmp238_;
		gint _tmp239_;
		gint _tmp240_;
		gint _d_index = 0;
		_tmp237_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp237_;
		_tmp238_ = _d_list;
		_tmp239_ = vala_collection_get_size ((ValaCollection*) _tmp238_);
		_tmp240_ = _tmp239_;
		_d_size = _tmp240_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp241_;
			gpointer _tmp242_;
			ValaDelegate* _tmp243_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp241_ = _d_list;
			_tmp242_ = vala_list_get (_tmp241_, _d_index);
			d = (ValaDelegate*) _tmp242_;
			_tmp243_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp243_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp244_ = vala_class_get_is_compact (self);
	_tmp245_ = _tmp244_;
	if (_tmp245_) {
		gboolean _tmp261_ = FALSE;
		gboolean _tmp262_ = FALSE;
		gboolean _tmp263_ = FALSE;
		gboolean _tmp264_;
		gboolean _tmp265_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp246_;
			gint _base_type_size = 0;
			ValaList* _tmp247_;
			gint _tmp248_;
			gint _tmp249_;
			gint _base_type_index = 0;
			_tmp246_ = vala_class_get_base_types (self);
			_base_type_list = _tmp246_;
			_tmp247_ = _base_type_list;
			_tmp248_ = vala_collection_get_size ((ValaCollection*) _tmp247_);
			_tmp249_ = _tmp248_;
			_base_type_size = _tmp249_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp250_;
				gpointer _tmp251_;
				ValaDataType* _tmp252_;
				ValaTypeSymbol* _tmp253_;
				ValaTypeSymbol* _tmp254_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp250_ = _base_type_list;
				_tmp251_ = vala_list_get (_tmp250_, _base_type_index);
				base_type = (ValaDataType*) _tmp251_;
				_tmp252_ = base_type;
				_tmp253_ = vala_data_type_get_data_type (_tmp252_);
				_tmp254_ = _tmp253_;
				if (VALA_IS_INTERFACE (_tmp254_)) {
					ValaSourceReference* _tmp255_;
					ValaSourceReference* _tmp256_;
					gchar* _tmp257_;
					gchar* _tmp258_;
					gchar* _tmp259_;
					gchar* _tmp260_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp256_ = _tmp255_;
					_tmp257_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp258_ = _tmp257_;
					_tmp259_ = g_strdup_printf ("compact classes `%s' may not implement interfaces", _tmp258_);
					_tmp260_ = _tmp259_;
					vala_report_error (_tmp256_, _tmp260_);
					_g_free0 (_tmp260_);
					_g_free0 (_tmp258_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp264_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp265_ = _tmp264_;
		if (!_tmp265_) {
			gboolean _tmp266_;
			gboolean _tmp267_;
			_tmp266_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp267_ = _tmp266_;
			_tmp263_ = !_tmp267_;
		} else {
			_tmp263_ = FALSE;
		}
		if (_tmp263_) {
			ValaClass* _tmp268_;
			_tmp268_ = self->priv->_base_class;
			_tmp262_ = _tmp268_ != NULL;
		} else {
			_tmp262_ = FALSE;
		}
		if (_tmp262_) {
			ValaClass* _tmp269_;
			ValaSemanticAnalyzer* _tmp270_;
			ValaSemanticAnalyzer* _tmp271_;
			ValaClass* _tmp272_;
			_tmp269_ = self->priv->_base_class;
			_tmp270_ = vala_code_context_get_analyzer (context);
			_tmp271_ = _tmp270_;
			_tmp272_ = _tmp271_->gsource_type;
			_tmp261_ = _tmp269_ != _tmp272_;
		} else {
			_tmp261_ = FALSE;
		}
		if (_tmp261_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp273_;
				gint _f_size = 0;
				ValaList* _tmp274_;
				gint _tmp275_;
				gint _tmp276_;
				gint _f_index = 0;
				_tmp273_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp273_;
				_tmp274_ = _f_list;
				_tmp275_ = vala_collection_get_size ((ValaCollection*) _tmp274_);
				_tmp276_ = _tmp275_;
				_f_size = _tmp276_;
				_f_index = -1;
				while (TRUE) {
					ValaField* f = NULL;
					ValaList* _tmp277_;
					gpointer _tmp278_;
					ValaField* _tmp279_;
					ValaMemberBinding _tmp280_;
					ValaMemberBinding _tmp281_;
					_f_index = _f_index + 1;
					if (!(_f_index < _f_size)) {
						break;
					}
					_tmp277_ = _f_list;
					_tmp278_ = vala_list_get (_tmp277_, _f_index);
					f = (ValaField*) _tmp278_;
					_tmp279_ = f;
					_tmp280_ = vala_field_get_binding (_tmp279_);
					_tmp281_ = _tmp280_;
					if (_tmp281_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp282_;
						ValaSourceReference* _tmp283_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp282_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp283_ = _tmp282_;
						vala_report_error (_tmp283_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp284_ = g_direct_equal;
	_tmp285_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp284_);
	prerequisites = (ValaList*) _tmp285_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp286_;
		gint _base_type_size = 0;
		ValaList* _tmp287_;
		gint _tmp288_;
		gint _tmp289_;
		gint _base_type_index = 0;
		_tmp286_ = vala_class_get_base_types (self);
		_base_type_list = _tmp286_;
		_tmp287_ = _base_type_list;
		_tmp288_ = vala_collection_get_size ((ValaCollection*) _tmp287_);
		_tmp289_ = _tmp288_;
		_base_type_size = _tmp289_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp290_;
			gpointer _tmp291_;
			ValaDataType* _tmp292_;
			ValaTypeSymbol* _tmp293_;
			ValaTypeSymbol* _tmp294_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp290_ = _base_type_list;
			_tmp291_ = vala_list_get (_tmp290_, _base_type_index);
			base_type = (ValaDataType*) _tmp291_;
			_tmp292_ = base_type;
			_tmp293_ = vala_data_type_get_data_type (_tmp292_);
			_tmp294_ = _tmp293_;
			if (VALA_IS_INTERFACE (_tmp294_)) {
				ValaDataType* _tmp295_;
				ValaTypeSymbol* _tmp296_;
				ValaTypeSymbol* _tmp297_;
				ValaList* _tmp298_;
				_tmp295_ = base_type;
				_tmp296_ = vala_data_type_get_data_type (_tmp295_);
				_tmp297_ = _tmp296_;
				_tmp298_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp297_, VALA_TYPE_INTERFACE, ValaInterface), _tmp298_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp299_ = g_direct_equal;
	_tmp300_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp299_);
	missing_prereqs = (ValaList*) _tmp300_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp301_;
		ValaList* _tmp302_;
		gint _prereq_size = 0;
		ValaList* _tmp303_;
		gint _tmp304_;
		gint _tmp305_;
		gint _prereq_index = 0;
		_tmp301_ = prerequisites;
		_tmp302_ = _vala_iterable_ref0 (_tmp301_);
		_prereq_list = _tmp302_;
		_tmp303_ = _prereq_list;
		_tmp304_ = vala_collection_get_size ((ValaCollection*) _tmp303_);
		_tmp305_ = _tmp304_;
		_prereq_size = _tmp305_;
		_prereq_index = -1;
		while (TRUE) {
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp306_;
			gpointer _tmp307_;
			ValaTypeSymbol* _tmp308_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp306_ = _prereq_list;
			_tmp307_ = vala_list_get (_tmp306_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp307_;
			_tmp308_ = prereq;
			if (!vala_class_class_is_a (self, self, _tmp308_)) {
				ValaList* _tmp309_;
				ValaTypeSymbol* _tmp310_;
				gchar* _tmp311_;
				gchar* _tmp312_;
				_tmp309_ = missing_prereqs;
				_tmp310_ = prereq;
				_tmp311_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp310_);
				_tmp312_ = _tmp311_;
				vala_list_insert (_tmp309_, 0, _tmp312_);
				_g_free0 (_tmp312_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp313_ = missing_prereqs;
	_tmp314_ = vala_collection_get_size ((ValaCollection*) _tmp313_);
	_tmp315_ = _tmp314_;
	if (_tmp315_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp316_;
		gchar* _tmp317_;
		gchar* _tmp318_;
		gchar* _tmp319_;
		gboolean first = FALSE;
		const gchar* _tmp333_;
		gchar* _tmp334_;
		ValaSourceReference* _tmp335_;
		ValaSourceReference* _tmp336_;
		const gchar* _tmp337_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp316_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp317_ = _tmp316_;
		_tmp318_ = g_strdup_printf ("%s: some prerequisites (", _tmp317_);
		_tmp319_ = _tmp318_;
		_g_free0 (_tmp317_);
		error_string = _tmp319_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp320_;
			ValaList* _tmp321_;
			gint _s_size = 0;
			ValaList* _tmp322_;
			gint _tmp323_;
			gint _tmp324_;
			gint _s_index = 0;
			_tmp320_ = missing_prereqs;
			_tmp321_ = _vala_iterable_ref0 (_tmp320_);
			_s_list = _tmp321_;
			_tmp322_ = _s_list;
			_tmp323_ = vala_collection_get_size ((ValaCollection*) _tmp322_);
			_tmp324_ = _tmp323_;
			_s_size = _tmp324_;
			_s_index = -1;
			while (TRUE) {
				gchar* s = NULL;
				ValaList* _tmp325_;
				gpointer _tmp326_;
				_s_index = _s_index + 1;
				if (!(_s_index < _s_size)) {
					break;
				}
				_tmp325_ = _s_list;
				_tmp326_ = vala_list_get (_tmp325_, _s_index);
				s = (gchar*) _tmp326_;
				if (first) {
					const gchar* _tmp327_;
					const gchar* _tmp328_;
					gchar* _tmp329_;
					_tmp327_ = error_string;
					_tmp328_ = s;
					_tmp329_ = g_strdup_printf ("%s`%s'", _tmp327_, _tmp328_);
					_g_free0 (error_string);
					error_string = _tmp329_;
					first = FALSE;
				} else {
					const gchar* _tmp330_;
					const gchar* _tmp331_;
					gchar* _tmp332_;
					_tmp330_ = error_string;
					_tmp331_ = s;
					_tmp332_ = g_strdup_printf ("%s, `%s'", _tmp330_, _tmp331_);
					_g_free0 (error_string);
					error_string = _tmp332_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp333_ = error_string;
		_tmp334_ = g_strconcat (_tmp333_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp334_;
		_tmp335_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp336_ = _tmp335_;
		_tmp337_ = error_string;
		vala_report_error (_tmp336_, _tmp337_);
		_g_free0 (error_string);
	}
	_tmp338_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp339_ = _tmp338_;
	if (_tmp339_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp493_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp340_;
			gint _base_type_size = 0;
			ValaList* _tmp341_;
			gint _tmp342_;
			gint _tmp343_;
			gint _base_type_index = 0;
			_tmp340_ = vala_class_get_base_types (self);
			_base_type_list = _tmp340_;
			_tmp341_ = _base_type_list;
			_tmp342_ = vala_collection_get_size ((ValaCollection*) _tmp341_);
			_tmp343_ = _tmp342_;
			_base_type_size = _tmp343_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp344_;
				gpointer _tmp345_;
				ValaDataType* _tmp346_;
				ValaTypeSymbol* _tmp347_;
				ValaTypeSymbol* _tmp348_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp344_ = _base_type_list;
				_tmp345_ = vala_list_get (_tmp344_, _base_type_index);
				base_type = (ValaDataType*) _tmp345_;
				_tmp346_ = base_type;
				_tmp347_ = vala_data_type_get_data_type (_tmp346_);
				_tmp348_ = _tmp347_;
				if (VALA_IS_INTERFACE (_tmp348_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp349_;
					ValaTypeSymbol* _tmp350_;
					ValaTypeSymbol* _tmp351_;
					ValaInterface* _tmp352_;
					gboolean _tmp353_ = FALSE;
					ValaClass* _tmp354_;
					_tmp349_ = base_type;
					_tmp350_ = vala_data_type_get_data_type (_tmp349_);
					_tmp351_ = _tmp350_;
					_tmp352_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp351_, VALA_TYPE_INTERFACE, ValaInterface));
					iface = _tmp352_;
					_tmp354_ = self->priv->_base_class;
					if (_tmp354_ != NULL) {
						ValaClass* _tmp355_;
						ValaInterface* _tmp356_;
						_tmp355_ = self->priv->_base_class;
						_tmp356_ = iface;
						_tmp353_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp355_, (ValaTypeSymbol*) _tmp356_);
					} else {
						_tmp353_ = FALSE;
					}
					if (_tmp353_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp357_;
						ValaList* _tmp358_;
						gint _m_size = 0;
						ValaList* _tmp359_;
						gint _tmp360_;
						gint _tmp361_;
						gint _m_index = 0;
						_tmp357_ = iface;
						_tmp358_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp357_);
						_m_list = _tmp358_;
						_tmp359_ = _m_list;
						_tmp360_ = vala_collection_get_size ((ValaCollection*) _tmp359_);
						_tmp361_ = _tmp360_;
						_m_size = _tmp361_;
						_m_index = -1;
						while (TRUE) {
							ValaMethod* m = NULL;
							ValaList* _tmp362_;
							gpointer _tmp363_;
							ValaMethod* _tmp364_;
							gboolean _tmp365_;
							gboolean _tmp366_;
							_m_index = _m_index + 1;
							if (!(_m_index < _m_size)) {
								break;
							}
							_tmp362_ = _m_list;
							_tmp363_ = vala_list_get (_tmp362_, _m_index);
							m = (ValaMethod*) _tmp363_;
							_tmp364_ = m;
							_tmp365_ = vala_method_get_is_abstract (_tmp364_);
							_tmp366_ = _tmp365_;
							if (_tmp366_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								ValaClass* _tmp367_;
								implemented = FALSE;
								_tmp367_ = _vala_code_node_ref0 (self);
								base_class = _tmp367_;
								while (TRUE) {
									gboolean _tmp368_ = FALSE;
									ValaClass* _tmp369_;
									ValaClass* _tmp420_;
									ValaClass* _tmp421_;
									ValaClass* _tmp422_;
									_tmp369_ = base_class;
									if (_tmp369_ != NULL) {
										_tmp368_ = !implemented;
									} else {
										_tmp368_ = FALSE;
									}
									if (!_tmp368_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp370_;
										ValaList* _tmp371_;
										gint _impl_size = 0;
										ValaList* _tmp372_;
										gint _tmp373_;
										gint _tmp374_;
										gint _impl_index = 0;
										_tmp370_ = base_class;
										_tmp371_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp370_);
										_impl_list = _tmp371_;
										_tmp372_ = _impl_list;
										_tmp373_ = vala_collection_get_size ((ValaCollection*) _tmp372_);
										_tmp374_ = _tmp373_;
										_impl_size = _tmp374_;
										_impl_index = -1;
										while (TRUE) {
											ValaMethod* impl = NULL;
											ValaList* _tmp375_;
											gpointer _tmp376_;
											gboolean _tmp377_ = FALSE;
											ValaMethod* _tmp378_;
											ValaMethod* _tmp379_;
											ValaMethod* _tmp380_;
											ValaMethod* _tmp381_;
											_impl_index = _impl_index + 1;
											if (!(_impl_index < _impl_size)) {
												break;
											}
											_tmp375_ = _impl_list;
											_tmp376_ = vala_list_get (_tmp375_, _impl_index);
											impl = (ValaMethod*) _tmp376_;
											_tmp378_ = impl;
											_tmp379_ = vala_method_get_base_interface_method (_tmp378_);
											_tmp380_ = _tmp379_;
											_tmp381_ = m;
											if (_tmp380_ == _tmp381_) {
												_tmp377_ = TRUE;
											} else {
												gboolean _tmp382_ = FALSE;
												gboolean _tmp383_ = FALSE;
												gboolean _tmp384_ = FALSE;
												gboolean _tmp385_ = FALSE;
												ValaClass* _tmp386_;
												_tmp386_ = base_class;
												if (_tmp386_ != self) {
													ValaMethod* _tmp387_;
													ValaMethod* _tmp388_;
													ValaMethod* _tmp389_;
													_tmp387_ = impl;
													_tmp388_ = vala_method_get_base_interface_method (_tmp387_);
													_tmp389_ = _tmp388_;
													_tmp385_ = _tmp389_ == NULL;
												} else {
													_tmp385_ = FALSE;
												}
												if (_tmp385_) {
													ValaMethod* _tmp390_;
													const gchar* _tmp391_;
													const gchar* _tmp392_;
													ValaMethod* _tmp393_;
													const gchar* _tmp394_;
													const gchar* _tmp395_;
													_tmp390_ = impl;
													_tmp391_ = vala_symbol_get_name ((ValaSymbol*) _tmp390_);
													_tmp392_ = _tmp391_;
													_tmp393_ = m;
													_tmp394_ = vala_symbol_get_name ((ValaSymbol*) _tmp393_);
													_tmp395_ = _tmp394_;
													_tmp384_ = g_strcmp0 (_tmp392_, _tmp395_) == 0;
												} else {
													_tmp384_ = FALSE;
												}
												if (_tmp384_) {
													gboolean _tmp396_ = FALSE;
													ValaMethod* _tmp397_;
													ValaDataType* _tmp398_;
													ValaDataType* _tmp399_;
													_tmp397_ = impl;
													_tmp398_ = vala_method_get_base_interface_type (_tmp397_);
													_tmp399_ = _tmp398_;
													if (_tmp399_ == NULL) {
														_tmp396_ = TRUE;
													} else {
														ValaMethod* _tmp400_;
														ValaDataType* _tmp401_;
														ValaDataType* _tmp402_;
														ValaTypeSymbol* _tmp403_;
														ValaTypeSymbol* _tmp404_;
														ValaInterface* _tmp405_;
														_tmp400_ = impl;
														_tmp401_ = vala_method_get_base_interface_type (_tmp400_);
														_tmp402_ = _tmp401_;
														_tmp403_ = vala_data_type_get_data_type (_tmp402_);
														_tmp404_ = _tmp403_;
														_tmp405_ = iface;
														_tmp396_ = _tmp404_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp405_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp383_ = _tmp396_;
												} else {
													_tmp383_ = FALSE;
												}
												if (_tmp383_) {
													ValaMethod* _tmp406_;
													ValaMethod* _tmp407_;
													_tmp406_ = impl;
													_tmp407_ = m;
													_tmp382_ = vala_method_compatible_no_error (_tmp406_, _tmp407_);
												} else {
													_tmp382_ = FALSE;
												}
												_tmp377_ = _tmp382_;
											}
											if (_tmp377_) {
												ValaMethod* _tmp408_;
												ValaVersionAttribute* _tmp409_;
												ValaVersionAttribute* _tmp410_;
												ValaSourceReference* _tmp411_;
												ValaSourceReference* _tmp412_;
												ValaMethod* _tmp413_;
												ValaMethod* _tmp414_;
												ValaMethod* _tmp415_;
												ValaMethod* _tmp416_;
												_tmp408_ = impl;
												_tmp409_ = vala_symbol_get_version ((ValaSymbol*) _tmp408_);
												_tmp410_ = _tmp409_;
												_tmp411_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp412_ = _tmp411_;
												vala_version_attribute_check (_tmp410_, _tmp412_);
												_tmp413_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp413_, TRUE);
												implemented = TRUE;
												_tmp414_ = impl;
												_tmp415_ = vala_method_get_base_interface_method (_tmp414_);
												_tmp416_ = _tmp415_;
												if (_tmp416_ == NULL) {
													ValaHashMap* _tmp417_;
													ValaMethod* _tmp418_;
													ValaMethod* _tmp419_;
													_tmp417_ = self->priv->implicit_implementations;
													_tmp418_ = m;
													_tmp419_ = impl;
													vala_map_set ((ValaMap*) _tmp417_, _tmp418_, _tmp419_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp420_ = base_class;
									_tmp421_ = _tmp420_->priv->_base_class;
									_tmp422_ = _vala_code_node_ref0 (_tmp421_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp422_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp423_;
									ValaSourceReference* _tmp424_;
									gchar* _tmp425_;
									gchar* _tmp426_;
									ValaMethod* _tmp427_;
									gchar* _tmp428_;
									gchar* _tmp429_;
									gchar* _tmp430_;
									gchar* _tmp431_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp423_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp424_ = _tmp423_;
									_tmp425_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp426_ = _tmp425_;
									_tmp427_ = m;
									_tmp428_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp427_);
									_tmp429_ = _tmp428_;
									_tmp430_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp426_, _tmp429_);
									_tmp431_ = _tmp430_;
									vala_report_error (_tmp424_, _tmp431_);
									_g_free0 (_tmp431_);
									_g_free0 (_tmp429_);
									_g_free0 (_tmp426_);
								}
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp432_;
						ValaList* _tmp433_;
						gint _prop_size = 0;
						ValaList* _tmp434_;
						gint _tmp435_;
						gint _tmp436_;
						gint _prop_index = 0;
						_tmp432_ = iface;
						_tmp433_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp432_);
						_prop_list = _tmp433_;
						_tmp434_ = _prop_list;
						_tmp435_ = vala_collection_get_size ((ValaCollection*) _tmp434_);
						_tmp436_ = _tmp435_;
						_prop_size = _tmp436_;
						_prop_index = -1;
						while (TRUE) {
							ValaProperty* prop = NULL;
							ValaList* _tmp437_;
							gpointer _tmp438_;
							ValaProperty* _tmp439_;
							gboolean _tmp440_;
							gboolean _tmp441_;
							_prop_index = _prop_index + 1;
							if (!(_prop_index < _prop_size)) {
								break;
							}
							_tmp437_ = _prop_list;
							_tmp438_ = vala_list_get (_tmp437_, _prop_index);
							prop = (ValaProperty*) _tmp438_;
							_tmp439_ = prop;
							_tmp440_ = vala_property_get_is_abstract (_tmp439_);
							_tmp441_ = _tmp440_;
							if (_tmp441_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaClass* _tmp442_;
								ValaSymbol* _tmp456_;
								sym = NULL;
								_tmp442_ = _vala_code_node_ref0 (self);
								base_class = _tmp442_;
								while (TRUE) {
									gboolean _tmp443_ = FALSE;
									ValaClass* _tmp444_;
									ValaClass* _tmp446_;
									ValaScope* _tmp447_;
									ValaScope* _tmp448_;
									ValaProperty* _tmp449_;
									const gchar* _tmp450_;
									const gchar* _tmp451_;
									ValaSymbol* _tmp452_;
									ValaClass* _tmp453_;
									ValaClass* _tmp454_;
									ValaClass* _tmp455_;
									_tmp444_ = base_class;
									if (_tmp444_ != NULL) {
										ValaSymbol* _tmp445_;
										_tmp445_ = sym;
										_tmp443_ = !VALA_IS_PROPERTY (_tmp445_);
									} else {
										_tmp443_ = FALSE;
									}
									if (!_tmp443_) {
										break;
									}
									_tmp446_ = base_class;
									_tmp447_ = vala_symbol_get_scope ((ValaSymbol*) _tmp446_);
									_tmp448_ = _tmp447_;
									_tmp449_ = prop;
									_tmp450_ = vala_symbol_get_name ((ValaSymbol*) _tmp449_);
									_tmp451_ = _tmp450_;
									_tmp452_ = vala_scope_lookup (_tmp448_, _tmp451_);
									_vala_code_node_unref0 (sym);
									sym = _tmp452_;
									_tmp453_ = base_class;
									_tmp454_ = _tmp453_->priv->_base_class;
									_tmp455_ = _vala_code_node_ref0 (_tmp454_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp455_;
								}
								_tmp456_ = sym;
								if (VALA_IS_PROPERTY (_tmp456_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp457_;
									ValaProperty* _tmp458_;
									gchar* invalid_match = NULL;
									gboolean _tmp459_ = FALSE;
									ValaProperty* _tmp460_;
									gboolean _tmp461_;
									gboolean _tmp462_;
									ValaSymbol* _tmp478_;
									ValaVersionAttribute* _tmp479_;
									ValaVersionAttribute* _tmp480_;
									ValaSourceReference* _tmp481_;
									ValaSourceReference* _tmp482_;
									ValaSymbol* _tmp483_;
									_tmp457_ = sym;
									_tmp458_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp457_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp458_;
									invalid_match = NULL;
									_tmp460_ = base_prop;
									_tmp461_ = vala_symbol_get_hides ((ValaSymbol*) _tmp460_);
									_tmp462_ = _tmp461_;
									if (!_tmp462_) {
										ValaProperty* _tmp463_;
										ValaProperty* _tmp464_;
										gchar* _tmp465_ = NULL;
										gboolean _tmp466_;
										_tmp463_ = base_prop;
										_tmp464_ = prop;
										_tmp466_ = vala_property_compatible (_tmp463_, _tmp464_, &_tmp465_);
										_g_free0 (invalid_match);
										invalid_match = _tmp465_;
										_tmp459_ = !_tmp466_;
									} else {
										_tmp459_ = FALSE;
									}
									if (_tmp459_) {
										ValaSourceReference* _tmp467_;
										ValaSourceReference* _tmp468_;
										ValaProperty* _tmp469_;
										gchar* _tmp470_;
										gchar* _tmp471_;
										ValaProperty* _tmp472_;
										gchar* _tmp473_;
										gchar* _tmp474_;
										const gchar* _tmp475_;
										gchar* _tmp476_;
										gchar* _tmp477_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp467_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp468_ = _tmp467_;
										_tmp469_ = prop;
										_tmp470_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp469_);
										_tmp471_ = _tmp470_;
										_tmp472_ = base_prop;
										_tmp473_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp472_);
										_tmp474_ = _tmp473_;
										_tmp475_ = invalid_match;
										_tmp476_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp471_, _tmp474_, _tmp475_);
										_tmp477_ = _tmp476_;
										vala_report_error (_tmp468_, _tmp477_);
										_g_free0 (_tmp477_);
										_g_free0 (_tmp474_);
										_g_free0 (_tmp471_);
									}
									_tmp478_ = sym;
									_tmp479_ = vala_symbol_get_version (_tmp478_);
									_tmp480_ = _tmp479_;
									_tmp481_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp482_ = _tmp481_;
									vala_version_attribute_check (_tmp480_, _tmp482_);
									_tmp483_ = sym;
									vala_symbol_set_used (_tmp483_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp484_;
									ValaSourceReference* _tmp485_;
									gchar* _tmp486_;
									gchar* _tmp487_;
									ValaProperty* _tmp488_;
									gchar* _tmp489_;
									gchar* _tmp490_;
									gchar* _tmp491_;
									gchar* _tmp492_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp484_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp485_ = _tmp484_;
									_tmp486_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp487_ = _tmp486_;
									_tmp488_ = prop;
									_tmp489_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp488_);
									_tmp490_ = _tmp489_;
									_tmp491_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp487_, _tmp490_);
									_tmp492_ = _tmp491_;
									vala_report_error (_tmp485_, _tmp492_);
									_g_free0 (_tmp492_);
									_g_free0 (_tmp490_);
									_g_free0 (_tmp487_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp493_ = self->priv->_is_abstract;
		if (!_tmp493_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp494_;
			ValaClass* _tmp495_;
			_tmp494_ = self->priv->_base_class;
			_tmp495_ = _vala_code_node_ref0 (_tmp494_);
			base_class = _tmp495_;
			while (TRUE) {
				gboolean _tmp496_ = FALSE;
				ValaClass* _tmp497_;
				ValaClass* _tmp558_;
				ValaClass* _tmp559_;
				ValaClass* _tmp560_;
				_tmp497_ = base_class;
				if (_tmp497_ != NULL) {
					ValaClass* _tmp498_;
					gboolean _tmp499_;
					_tmp498_ = base_class;
					_tmp499_ = _tmp498_->priv->_is_abstract;
					_tmp496_ = _tmp499_;
				} else {
					_tmp496_ = FALSE;
				}
				if (!_tmp496_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp500_;
					ValaList* _tmp501_;
					gint _base_method_size = 0;
					ValaList* _tmp502_;
					gint _tmp503_;
					gint _tmp504_;
					gint _base_method_index = 0;
					_tmp500_ = base_class;
					_tmp501_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp500_);
					_base_method_list = _tmp501_;
					_tmp502_ = _base_method_list;
					_tmp503_ = vala_collection_get_size ((ValaCollection*) _tmp502_);
					_tmp504_ = _tmp503_;
					_base_method_size = _tmp504_;
					_base_method_index = -1;
					while (TRUE) {
						ValaMethod* base_method = NULL;
						ValaList* _tmp505_;
						gpointer _tmp506_;
						ValaMethod* _tmp507_;
						gboolean _tmp508_;
						gboolean _tmp509_;
						_base_method_index = _base_method_index + 1;
						if (!(_base_method_index < _base_method_size)) {
							break;
						}
						_tmp505_ = _base_method_list;
						_tmp506_ = vala_list_get (_tmp505_, _base_method_index);
						base_method = (ValaMethod*) _tmp506_;
						_tmp507_ = base_method;
						_tmp508_ = vala_method_get_is_abstract (_tmp507_);
						_tmp509_ = _tmp508_;
						if (_tmp509_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp510_;
							const gchar* _tmp511_;
							const gchar* _tmp512_;
							ValaSymbol* _tmp513_;
							ValaMethod* _tmp514_;
							gboolean _tmp515_ = FALSE;
							ValaMethod* _tmp516_;
							_tmp510_ = base_method;
							_tmp511_ = vala_symbol_get_name ((ValaSymbol*) _tmp510_);
							_tmp512_ = _tmp511_;
							_tmp513_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp512_);
							_tmp514_ = VALA_IS_METHOD (_tmp513_) ? ((ValaMethod*) _tmp513_) : NULL;
							if (_tmp514_ == NULL) {
								_vala_code_node_unref0 (_tmp513_);
							}
							override_method = _tmp514_;
							_tmp516_ = override_method;
							if (_tmp516_ == NULL) {
								_tmp515_ = TRUE;
							} else {
								ValaMethod* _tmp517_;
								gboolean _tmp518_;
								gboolean _tmp519_;
								_tmp517_ = override_method;
								_tmp518_ = vala_method_get_overrides (_tmp517_);
								_tmp519_ = _tmp518_;
								_tmp515_ = !_tmp519_;
							}
							if (_tmp515_) {
								ValaSourceReference* _tmp520_;
								ValaSourceReference* _tmp521_;
								gchar* _tmp522_;
								gchar* _tmp523_;
								ValaMethod* _tmp524_;
								gchar* _tmp525_;
								gchar* _tmp526_;
								gchar* _tmp527_;
								gchar* _tmp528_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp520_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp521_ = _tmp520_;
								_tmp522_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp523_ = _tmp522_;
								_tmp524_ = base_method;
								_tmp525_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp524_);
								_tmp526_ = _tmp525_;
								_tmp527_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp523_, _tmp526_);
								_tmp528_ = _tmp527_;
								vala_report_error (_tmp521_, _tmp528_);
								_g_free0 (_tmp528_);
								_g_free0 (_tmp526_);
								_g_free0 (_tmp523_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp529_;
					ValaList* _tmp530_;
					gint _base_property_size = 0;
					ValaList* _tmp531_;
					gint _tmp532_;
					gint _tmp533_;
					gint _base_property_index = 0;
					_tmp529_ = base_class;
					_tmp530_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp529_);
					_base_property_list = _tmp530_;
					_tmp531_ = _base_property_list;
					_tmp532_ = vala_collection_get_size ((ValaCollection*) _tmp531_);
					_tmp533_ = _tmp532_;
					_base_property_size = _tmp533_;
					_base_property_index = -1;
					while (TRUE) {
						ValaProperty* base_property = NULL;
						ValaList* _tmp534_;
						gpointer _tmp535_;
						ValaProperty* _tmp536_;
						gboolean _tmp537_;
						gboolean _tmp538_;
						_base_property_index = _base_property_index + 1;
						if (!(_base_property_index < _base_property_size)) {
							break;
						}
						_tmp534_ = _base_property_list;
						_tmp535_ = vala_list_get (_tmp534_, _base_property_index);
						base_property = (ValaProperty*) _tmp535_;
						_tmp536_ = base_property;
						_tmp537_ = vala_property_get_is_abstract (_tmp536_);
						_tmp538_ = _tmp537_;
						if (_tmp538_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp539_;
							const gchar* _tmp540_;
							const gchar* _tmp541_;
							ValaSymbol* _tmp542_;
							ValaProperty* _tmp543_;
							gboolean _tmp544_ = FALSE;
							ValaProperty* _tmp545_;
							_tmp539_ = base_property;
							_tmp540_ = vala_symbol_get_name ((ValaSymbol*) _tmp539_);
							_tmp541_ = _tmp540_;
							_tmp542_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp541_);
							_tmp543_ = VALA_IS_PROPERTY (_tmp542_) ? ((ValaProperty*) _tmp542_) : NULL;
							if (_tmp543_ == NULL) {
								_vala_code_node_unref0 (_tmp542_);
							}
							override_property = _tmp543_;
							_tmp545_ = override_property;
							if (_tmp545_ == NULL) {
								_tmp544_ = TRUE;
							} else {
								ValaProperty* _tmp546_;
								gboolean _tmp547_;
								gboolean _tmp548_;
								_tmp546_ = override_property;
								_tmp547_ = vala_property_get_overrides (_tmp546_);
								_tmp548_ = _tmp547_;
								_tmp544_ = !_tmp548_;
							}
							if (_tmp544_) {
								ValaSourceReference* _tmp549_;
								ValaSourceReference* _tmp550_;
								gchar* _tmp551_;
								gchar* _tmp552_;
								ValaProperty* _tmp553_;
								gchar* _tmp554_;
								gchar* _tmp555_;
								gchar* _tmp556_;
								gchar* _tmp557_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp549_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp550_ = _tmp549_;
								_tmp551_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp552_ = _tmp551_;
								_tmp553_ = base_property;
								_tmp554_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp553_);
								_tmp555_ = _tmp554_;
								_tmp556_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp552_, _tmp555_);
								_tmp557_ = _tmp556_;
								vala_report_error (_tmp550_, _tmp557_);
								_g_free0 (_tmp557_);
								_g_free0 (_tmp555_);
								_g_free0 (_tmp552_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp558_ = base_class;
				_tmp559_ = _tmp558_->priv->_base_class;
				_tmp560_ = _vala_code_node_ref0 (_tmp559_);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp560_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp561_ = vala_code_context_get_analyzer (context);
	_tmp562_ = _tmp561_;
	_tmp563_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp562_, _tmp563_);
	_tmp564_ = vala_code_context_get_analyzer (context);
	_tmp565_ = _tmp564_;
	_tmp566_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp565_, _tmp566_);
	_tmp567_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp568_ = _tmp567_;
	result = !_tmp568_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_compact (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			gboolean _tmp7_;
			gboolean* _tmp8_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp7_ = _tmp6_ != NULL;
			_tmp8_ = __bool_dup0 (&_tmp7_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp8_;
		}
	}
	_tmp9_ = self->priv->_is_compact;
	result = *_tmp9_;
	return result;
}

void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_immutable (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			gboolean _tmp7_;
			gboolean* _tmp8_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp7_ = _tmp6_ != NULL;
			_tmp8_ = __bool_dup0 (&_tmp7_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp8_;
		}
	}
	_tmp9_ = self->priv->_is_immutable;
	result = *_tmp9_;
	return result;
}

void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

void
vala_class_set_is_singleton (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_singleton);
	self->priv->_is_singleton = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SingleInstance", value, NULL);
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		ValaDestructor* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaDestructor* _tmp16_;
		ValaObjectType* _tmp17_;
		ValaObjectType* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		ValaDestructor* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		ValaDestructor* _tmp24_;
		ValaParameter* _tmp25_;
		ValaParameter* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		ValaDestructor* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
		_tmp5_ = self->priv->_destructor;
		_tmp6_ = vala_destructor_get_this_parameter (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaDestructor* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			ValaDestructor* _tmp11_;
			ValaParameter* _tmp12_;
			ValaParameter* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = self->priv->_destructor;
			_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_destructor;
			_tmp12_ = vala_destructor_get_this_parameter (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			vala_scope_remove (_tmp10_, _tmp15_);
		}
		_tmp16_ = self->priv->_destructor;
		_tmp17_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_parameter_new ("this", (ValaDataType*) _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		vala_destructor_set_this_parameter (_tmp16_, _tmp20_);
		_vala_code_node_unref0 (_tmp20_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp21_ = self->priv->_destructor;
		_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_destructor;
		_tmp25_ = vala_destructor_get_this_parameter (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->_destructor;
		_tmp30_ = vala_destructor_get_this_parameter (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_scope_add (_tmp23_, _tmp28_, (ValaSymbol*) _tmp31_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GEqualFunc _tmp4_;
	ValaHashMap* _tmp5_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_, _tmp3_, _tmp4_);
	self->priv->implicit_implementations = _tmp5_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}

