/* valaelementaccess.c generated by valac, the Vala compiler
 * generated from valaelementaccess.vala, do not modify */

/* valaelementaccess.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_ELEMENT_ACCESS_DUMMY_PROPERTY,
	VALA_ELEMENT_ACCESS_LAST_PROPERTY
};
static GParamSpec* vala_element_access_properties[VALA_ELEMENT_ACCESS_LAST_PROPERTY];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaElementAccessPrivate {
	ValaList* indices;
	ValaExpression* _container;
};


static gpointer vala_element_access_parent_class = NULL;

#define VALA_ELEMENT_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessPrivate))
static void vala_element_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_element_access_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_element_access_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_element_access_real_is_pure (ValaExpression* base);
static gboolean vala_element_access_real_is_accessible (ValaExpression* base, ValaSymbol* sym);
static gboolean vala_element_access_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_element_access_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_element_access_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_element_access_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_element_access_finalize (ValaCodeNode * obj);


void vala_element_access_append_index (ValaElementAccess* self, ValaExpression* index) {
	ValaList* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (index != NULL);
	_tmp0_ = self->priv->indices;
	_tmp1_ = index;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = index;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_element_access_get_indices (ValaElementAccess* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->indices;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaElementAccess* vala_element_access_construct (GType object_type, ValaExpression* container, ValaSourceReference* source_reference) {
	ValaElementAccess* self = NULL;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaElementAccess*) vala_expression_construct (object_type);
	_tmp0_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	_tmp1_ = container;
	vala_element_access_set_container (self, _tmp1_);
	return self;
}


ValaElementAccess* vala_element_access_new (ValaExpression* container, ValaSourceReference* source_reference) {
	return vala_element_access_construct (VALA_TYPE_ELEMENT_ACCESS, container, source_reference);
}


static void vala_element_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaElementAccess * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_element_access (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static void vala_element_access_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _e_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _e_index = 0;
		_tmp3_ = self->priv->indices;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_e_list = _tmp4_;
		_tmp5_ = _e_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_e_size = _tmp7_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* e = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaCodeVisitor* _tmp15_;
			_tmp8_ = _e_index;
			_e_index = _tmp8_ + 1;
			_tmp9_ = _e_index;
			_tmp10_ = _e_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _e_list;
			_tmp12_ = _e_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			e = (ValaExpression*) _tmp13_;
			_tmp14_ = e;
			_tmp15_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
}


static void vala_element_access_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gint index = 0;
	ValaList* _tmp4_;
	ValaExpression* _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_element_access_set_container (self, _tmp3_);
	}
	_tmp4_ = self->priv->indices;
	_tmp5_ = old_node;
	_tmp6_ = vala_list_index_of (_tmp4_, _tmp5_);
	index = _tmp6_;
	_tmp8_ = index;
	if (_tmp8_ >= 0) {
		ValaExpression* _tmp9_;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp11_;
		_tmp9_ = new_node;
		_tmp10_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_ == NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaList* _tmp12_;
		gint _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		_tmp12_ = self->priv->indices;
		_tmp13_ = index;
		_tmp14_ = new_node;
		vala_list_set (_tmp12_, _tmp13_, _tmp14_);
		_tmp15_ = new_node;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp15_, (ValaCodeNode*) self);
	}
}


static gboolean vala_element_access_real_is_pure (ValaExpression* base) {
	ValaElementAccess * self;
	gboolean result = FALSE;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	gboolean _tmp15_;
	self = (ValaElementAccess*) base;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _index_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_index_list = _tmp1_;
		_tmp2_ = _index_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_index_size = _tmp4_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* index = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			gboolean _tmp12_;
			_tmp5_ = _index_index;
			_index_index = _tmp5_ + 1;
			_tmp6_ = _index_index;
			_tmp7_ = _index_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _index_list;
			_tmp9_ = _index_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			index = (ValaExpression*) _tmp10_;
			_tmp11_ = index;
			_tmp12_ = vala_expression_is_pure (_tmp11_);
			if (!_tmp12_) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				_vala_iterable_unref0 (_index_list);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp13_ = vala_element_access_get_container (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_expression_is_pure (_tmp14_);
	result = _tmp15_;
	return result;
}


static gboolean vala_element_access_real_is_accessible (ValaExpression* base, ValaSymbol* sym) {
	ValaElementAccess * self;
	gboolean result = FALSE;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	ValaSymbol* _tmp16_;
	gboolean _tmp17_;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _index_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_index_list = _tmp1_;
		_tmp2_ = _index_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_index_size = _tmp4_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* index = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _index_index;
			_index_index = _tmp5_ + 1;
			_tmp6_ = _index_index;
			_tmp7_ = _index_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _index_list;
			_tmp9_ = _index_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			index = (ValaExpression*) _tmp10_;
			_tmp11_ = index;
			_tmp12_ = sym;
			_tmp13_ = vala_expression_is_accessible (_tmp11_, _tmp12_);
			if (!_tmp13_) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				_vala_iterable_unref0 (_index_list);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp14_ = vala_element_access_get_container (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = sym;
	_tmp17_ = vala_expression_is_accessible (_tmp15_, _tmp16_);
	result = _tmp17_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_element_access_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaElementAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCodeContext* _tmp6_;
	gboolean _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	gboolean _tmp16_ = FALSE;
	ValaExpression* _tmp17_;
	ValaExpression* _tmp18_;
	gboolean index_int_type_check = FALSE;
	ValaPointerType* pointer_type = NULL;
	ValaExpression* _tmp52_;
	ValaExpression* _tmp53_;
	ValaDataType* _tmp54_;
	ValaDataType* _tmp55_;
	ValaPointerType* _tmp56_;
	ValaExpression* _tmp57_;
	ValaExpression* _tmp58_;
	ValaDataType* _tmp59_;
	ValaDataType* _tmp60_;
	gboolean _tmp255_;
	gboolean _tmp279_;
	gboolean _tmp280_;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_element_access_get_container (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	if (!_tmp7_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp8_ = vala_element_access_get_container (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_expression_get_value_type (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == NULL) {
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp12_ = vala_element_access_get_container (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
		_tmp15_ = _tmp14_;
		vala_report_error (_tmp15_, "Invalid container expression");
		result = FALSE;
		return result;
	}
	_tmp17_ = vala_element_access_get_container (self);
	_tmp18_ = _tmp17_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaExpression* _tmp19_;
		ValaExpression* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		_tmp19_ = vala_element_access_get_container (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_expression_get_symbol_reference (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_SIGNAL);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gboolean _tmp27_;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		gpointer _tmp32_;
		ValaExpression* _tmp33_;
		ValaCodeContext* _tmp34_;
		ValaSemanticAnalyzer* _tmp35_;
		ValaSemanticAnalyzer* _tmp36_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		_tmp23_ = vala_element_access_get_indices (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_ != 1;
		_vala_iterable_unref0 (_tmp24_);
		if (_tmp27_) {
			ValaSourceReference* _tmp28_;
			ValaSourceReference* _tmp29_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp29_ = _tmp28_;
			vala_report_error (_tmp29_, "Element access with more than one dimension is not supported for signa" \
"ls");
			result = FALSE;
			return result;
		}
		_tmp30_ = vala_element_access_get_indices (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_list_get (_tmp31_, 0);
		_tmp33_ = (ValaExpression*) _tmp32_;
		_tmp34_ = context;
		_tmp35_ = vala_code_context_get_analyzer (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = _tmp36_->string_type;
		_tmp38_ = vala_data_type_copy (_tmp37_);
		_tmp39_ = _tmp38_;
		vala_expression_set_target_type (_tmp33_, _tmp39_);
		_vala_code_node_unref0 (_tmp39_);
		_vala_code_node_unref0 (_tmp33_);
		_vala_iterable_unref0 (_tmp31_);
	}
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp40_;
		gint _index_size = 0;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _index_index = 0;
		_tmp40_ = vala_element_access_get_indices (self);
		_index_list = _tmp40_;
		_tmp41_ = _index_list;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_index_size = _tmp43_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			ValaExpression* index = NULL;
			ValaList* _tmp47_;
			gint _tmp48_;
			gpointer _tmp49_;
			ValaExpression* _tmp50_;
			ValaCodeContext* _tmp51_;
			_tmp44_ = _index_index;
			_index_index = _tmp44_ + 1;
			_tmp45_ = _index_index;
			_tmp46_ = _index_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _index_list;
			_tmp48_ = _index_index;
			_tmp49_ = vala_list_get (_tmp47_, _tmp48_);
			index = (ValaExpression*) _tmp49_;
			_tmp50_ = index;
			_tmp51_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp50_, _tmp51_);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	index_int_type_check = TRUE;
	_tmp52_ = vala_element_access_get_container (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_expression_get_value_type (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp55_) : NULL);
	pointer_type = _tmp56_;
	_tmp57_ = vala_element_access_get_container (self);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_expression_get_value_type (_tmp58_);
	_tmp60_ = _tmp59_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_ARRAY_TYPE)) {
		ValaArrayType* array_type = NULL;
		ValaExpression* _tmp61_;
		ValaExpression* _tmp62_;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		ValaArrayType* _tmp65_;
		ValaArrayType* _tmp66_;
		ValaDataType* _tmp67_;
		ValaDataType* _tmp68_;
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		gboolean _tmp71_;
		gboolean _tmp72_;
		ValaArrayType* _tmp120_;
		gint _tmp121_;
		gint _tmp122_;
		ValaList* _tmp123_;
		ValaList* _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		gboolean _tmp127_;
		_tmp61_ = vala_element_access_get_container (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_expression_get_value_type (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp65_;
		_tmp66_ = array_type;
		_tmp67_ = vala_array_type_get_element_type (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_data_type_copy (_tmp68_);
		_tmp70_ = _tmp69_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp70_);
		_vala_code_node_unref0 (_tmp70_);
		_tmp71_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp72_ = _tmp71_;
		if (!_tmp72_) {
			ValaDataType* _tmp73_;
			ValaDataType* _tmp74_;
			_tmp73_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp74_ = _tmp73_;
			vala_data_type_set_value_owned (_tmp74_, FALSE);
		} else {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp75_;
			ValaExpression* _tmp76_;
			ValaMemberAccess* _tmp77_;
			gboolean _tmp78_ = FALSE;
			ValaMemberAccess* _tmp79_;
			_tmp75_ = vala_element_access_get_container (self);
			_tmp76_ = _tmp75_;
			_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp76_) : NULL);
			ma = _tmp77_;
			_tmp79_ = ma;
			if (_tmp79_ != NULL) {
				ValaMemberAccess* _tmp80_;
				ValaSymbol* _tmp81_;
				ValaSymbol* _tmp82_;
				_tmp80_ = ma;
				_tmp81_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp78_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, VALA_TYPE_ARRAY_LENGTH_FIELD);
			} else {
				_tmp78_ = FALSE;
			}
			if (_tmp78_) {
				ValaMemberAccess* _tmp83_;
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaMemberAccess* _tmp86_;
				ValaExpression* _tmp87_;
				ValaExpression* _tmp88_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_inner (_tmp83_);
				_tmp85_ = _tmp84_;
				vala_expression_set_lvalue (_tmp85_, TRUE);
				_tmp86_ = ma;
				_tmp87_ = vala_member_access_get_inner (_tmp86_);
				_tmp88_ = _tmp87_;
				vala_member_access_check_lvalue_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			} else {
				gboolean _tmp89_ = FALSE;
				gboolean _tmp90_ = FALSE;
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				gboolean _tmp93_ = FALSE;
				ValaMemberAccess* _tmp94_;
				_tmp94_ = ma;
				if (_tmp94_ != NULL) {
					ValaMemberAccess* _tmp95_;
					ValaSymbol* _tmp96_;
					ValaSymbol* _tmp97_;
					_tmp95_ = ma;
					_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp95_);
					_tmp97_ = _tmp96_;
					_tmp93_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_FIELD);
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaMemberAccess* _tmp98_;
					ValaExpression* _tmp99_;
					ValaExpression* _tmp100_;
					_tmp98_ = ma;
					_tmp99_ = vala_member_access_get_inner (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp92_ = _tmp100_ != NULL;
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					ValaMemberAccess* _tmp101_;
					ValaExpression* _tmp102_;
					ValaExpression* _tmp103_;
					ValaSymbol* _tmp104_;
					ValaSymbol* _tmp105_;
					_tmp101_ = ma;
					_tmp102_ = vala_member_access_get_inner (_tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = vala_expression_get_symbol_reference (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp91_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp105_, VALA_TYPE_VARIABLE);
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaMemberAccess* _tmp106_;
					ValaExpression* _tmp107_;
					ValaExpression* _tmp108_;
					ValaDataType* _tmp109_;
					ValaDataType* _tmp110_;
					_tmp106_ = ma;
					_tmp107_ = vala_member_access_get_inner (_tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = vala_expression_get_value_type (_tmp108_);
					_tmp110_ = _tmp109_;
					_tmp90_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp110_, VALA_TYPE_STRUCT_VALUE_TYPE);
				} else {
					_tmp90_ = FALSE;
				}
				if (_tmp90_) {
					ValaMemberAccess* _tmp111_;
					ValaExpression* _tmp112_;
					ValaExpression* _tmp113_;
					ValaDataType* _tmp114_;
					ValaDataType* _tmp115_;
					gboolean _tmp116_;
					gboolean _tmp117_;
					_tmp111_ = ma;
					_tmp112_ = vala_member_access_get_inner (_tmp111_);
					_tmp113_ = _tmp112_;
					_tmp114_ = vala_expression_get_value_type (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = vala_data_type_get_nullable (_tmp115_);
					_tmp117_ = _tmp116_;
					_tmp89_ = !_tmp117_;
				} else {
					_tmp89_ = FALSE;
				}
				if (_tmp89_) {
					ValaMemberAccess* _tmp118_;
					ValaMemberAccess* _tmp119_;
					_tmp118_ = ma;
					vala_expression_set_lvalue ((ValaExpression*) _tmp118_, TRUE);
					_tmp119_ = ma;
					vala_member_access_check_lvalue_access (_tmp119_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp120_ = array_type;
		_tmp121_ = vala_array_type_get_rank (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_element_access_get_indices (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
		_tmp126_ = _tmp125_;
		_tmp127_ = _tmp122_ < _tmp126_;
		_vala_iterable_unref0 (_tmp124_);
		if (_tmp127_) {
			ValaSourceReference* _tmp128_;
			ValaSourceReference* _tmp129_;
			ValaList* _tmp130_;
			ValaList* _tmp131_;
			gint _tmp132_;
			gint _tmp133_;
			ValaArrayType* _tmp134_;
			gint _tmp135_;
			gint _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp129_ = _tmp128_;
			_tmp130_ = vala_element_access_get_indices (self);
			_tmp131_ = _tmp130_;
			_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp134_ = array_type;
			_tmp135_ = vala_array_type_get_rank (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = g_strdup_printf ("%d extra indices for element access", _tmp133_ - _tmp136_);
			_tmp138_ = _tmp137_;
			vala_report_error (_tmp129_, _tmp138_);
			_g_free0 (_tmp138_);
			_vala_iterable_unref0 (_tmp131_);
		} else {
			ValaArrayType* _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			ValaList* _tmp142_;
			ValaList* _tmp143_;
			gint _tmp144_;
			gint _tmp145_;
			gboolean _tmp146_;
			_tmp139_ = array_type;
			_tmp140_ = vala_array_type_get_rank (_tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_element_access_get_indices (self);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = _tmp141_ > _tmp145_;
			_vala_iterable_unref0 (_tmp143_);
			if (_tmp146_) {
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				ValaArrayType* _tmp149_;
				gint _tmp150_;
				gint _tmp151_;
				ValaList* _tmp152_;
				ValaList* _tmp153_;
				gint _tmp154_;
				gint _tmp155_;
				gchar* _tmp156_;
				gchar* _tmp157_;
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp148_ = _tmp147_;
				_tmp149_ = array_type;
				_tmp150_ = vala_array_type_get_rank (_tmp149_);
				_tmp151_ = _tmp150_;
				_tmp152_ = vala_element_access_get_indices (self);
				_tmp153_ = _tmp152_;
				_tmp154_ = vala_collection_get_size ((ValaCollection*) _tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = g_strdup_printf ("%d missing indices for element access", _tmp151_ - _tmp155_);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp148_, _tmp157_);
				_g_free0 (_tmp157_);
				_vala_iterable_unref0 (_tmp153_);
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp158_ = FALSE;
		ValaPointerType* _tmp159_;
		_tmp159_ = pointer_type;
		if (_tmp159_ != NULL) {
			ValaPointerType* _tmp160_;
			ValaDataType* _tmp161_;
			ValaDataType* _tmp162_;
			gboolean _tmp163_;
			_tmp160_ = pointer_type;
			_tmp161_ = vala_pointer_type_get_base_type (_tmp160_);
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_data_type_is_reference_type_or_type_parameter (_tmp162_);
			_tmp158_ = !_tmp163_;
		} else {
			_tmp158_ = FALSE;
		}
		if (_tmp158_) {
			ValaPointerType* _tmp164_;
			ValaDataType* _tmp165_;
			ValaDataType* _tmp166_;
			ValaDataType* _tmp167_;
			ValaDataType* _tmp168_;
			_tmp164_ = pointer_type;
			_tmp165_ = vala_pointer_type_get_base_type (_tmp164_);
			_tmp166_ = _tmp165_;
			_tmp167_ = vala_data_type_copy (_tmp166_);
			_tmp168_ = _tmp167_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp168_);
			_vala_code_node_unref0 (_tmp168_);
		} else {
			gboolean _tmp169_ = FALSE;
			ValaExpression* _tmp170_;
			ValaExpression* _tmp171_;
			_tmp170_ = vala_element_access_get_container (self);
			_tmp171_ = _tmp170_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp171_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaExpression* _tmp172_;
				ValaExpression* _tmp173_;
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp175_;
				_tmp172_ = vala_element_access_get_container (self);
				_tmp173_ = _tmp172_;
				_tmp174_ = vala_expression_get_symbol_reference (_tmp173_);
				_tmp175_ = _tmp174_;
				_tmp169_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp175_, VALA_TYPE_SIGNAL);
			} else {
				_tmp169_ = FALSE;
			}
			if (_tmp169_) {
				ValaExpression* _tmp176_;
				ValaExpression* _tmp177_;
				ValaSymbol* _tmp178_;
				ValaSymbol* _tmp179_;
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				ValaDataType* _tmp182_;
				ValaDataType* _tmp183_;
				index_int_type_check = FALSE;
				_tmp176_ = vala_element_access_get_container (self);
				_tmp177_ = _tmp176_;
				_tmp178_ = vala_expression_get_symbol_reference (_tmp177_);
				_tmp179_ = _tmp178_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp179_);
				_tmp180_ = vala_element_access_get_container (self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_value_type (_tmp181_);
				_tmp183_ = _tmp182_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp183_);
			} else {
				gboolean _tmp184_;
				gboolean _tmp185_;
				ValaSourceReference* _tmp245_;
				ValaSourceReference* _tmp246_;
				ValaExpression* _tmp247_;
				ValaExpression* _tmp248_;
				ValaDataType* _tmp249_;
				ValaDataType* _tmp250_;
				gchar* _tmp251_;
				gchar* _tmp252_;
				gchar* _tmp253_;
				gchar* _tmp254_;
				_tmp184_ = vala_expression_get_lvalue ((ValaExpression*) self);
				_tmp185_ = _tmp184_;
				if (_tmp185_) {
					ValaMethod* set_method = NULL;
					ValaExpression* _tmp186_;
					ValaExpression* _tmp187_;
					ValaDataType* _tmp188_;
					ValaDataType* _tmp189_;
					ValaSymbol* _tmp190_;
					ValaMethod* _tmp191_;
					ValaAssignment* assignment = NULL;
					ValaCodeNode* _tmp192_;
					ValaCodeNode* _tmp193_;
					ValaAssignment* _tmp194_;
					gboolean _tmp195_ = FALSE;
					gboolean _tmp196_ = FALSE;
					ValaMethod* _tmp197_;
					_tmp186_ = vala_element_access_get_container (self);
					_tmp187_ = _tmp186_;
					_tmp188_ = vala_expression_get_value_type (_tmp187_);
					_tmp189_ = _tmp188_;
					_tmp190_ = vala_data_type_get_member (_tmp189_, "set");
					_tmp191_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp190_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp190_) : NULL;
					if (_tmp191_ == NULL) {
						_vala_code_node_unref0 (_tmp190_);
					}
					set_method = _tmp191_;
					_tmp192_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp193_ = _tmp192_;
					_tmp194_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp193_, VALA_TYPE_ASSIGNMENT) ? ((ValaAssignment*) _tmp193_) : NULL);
					assignment = _tmp194_;
					_tmp197_ = set_method;
					if (_tmp197_ != NULL) {
						ValaMethod* _tmp198_;
						ValaDataType* _tmp199_;
						ValaDataType* _tmp200_;
						_tmp198_ = set_method;
						_tmp199_ = vala_callable_get_return_type ((ValaCallable*) _tmp198_);
						_tmp200_ = _tmp199_;
						_tmp196_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp200_, VALA_TYPE_VOID_TYPE);
					} else {
						_tmp196_ = FALSE;
					}
					if (_tmp196_) {
						ValaAssignment* _tmp201_;
						_tmp201_ = assignment;
						_tmp195_ = _tmp201_ != NULL;
					} else {
						_tmp195_ = FALSE;
					}
					if (_tmp195_) {
						gboolean _tmp202_;
						gboolean _tmp203_;
						_tmp202_ = vala_code_node_get_error ((ValaCodeNode*) self);
						_tmp203_ = _tmp202_;
						result = !_tmp203_;
						_vala_code_node_unref0 (assignment);
						_vala_code_node_unref0 (set_method);
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_vala_code_node_unref0 (assignment);
					_vala_code_node_unref0 (set_method);
				} else {
					ValaMethod* get_method = NULL;
					ValaExpression* _tmp204_;
					ValaExpression* _tmp205_;
					ValaDataType* _tmp206_;
					ValaDataType* _tmp207_;
					ValaSymbol* _tmp208_;
					ValaMethod* _tmp209_;
					ValaMethod* _tmp210_;
					_tmp204_ = vala_element_access_get_container (self);
					_tmp205_ = _tmp204_;
					_tmp206_ = vala_expression_get_value_type (_tmp205_);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_data_type_get_member (_tmp207_, "get");
					_tmp209_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp208_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp208_) : NULL;
					if (_tmp209_ == NULL) {
						_vala_code_node_unref0 (_tmp208_);
					}
					get_method = _tmp209_;
					_tmp210_ = get_method;
					if (_tmp210_ != NULL) {
						ValaMethodCall* get_call = NULL;
						ValaExpression* _tmp211_;
						ValaExpression* _tmp212_;
						ValaSourceReference* _tmp213_;
						ValaSourceReference* _tmp214_;
						ValaMemberAccess* _tmp215_;
						ValaMemberAccess* _tmp216_;
						ValaSourceReference* _tmp217_;
						ValaSourceReference* _tmp218_;
						ValaMethodCall* _tmp219_;
						ValaMethodCall* _tmp220_;
						ValaMethodCall* _tmp233_;
						ValaDataType* _tmp234_;
						ValaDataType* _tmp235_;
						ValaMethodCall* _tmp236_;
						ValaDataType* _tmp237_;
						ValaDataType* _tmp238_;
						ValaCodeNode* _tmp239_;
						ValaCodeNode* _tmp240_;
						ValaMethodCall* _tmp241_;
						ValaMethodCall* _tmp242_;
						ValaCodeContext* _tmp243_;
						gboolean _tmp244_;
						_tmp211_ = vala_element_access_get_container (self);
						_tmp212_ = _tmp211_;
						_tmp213_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp214_ = _tmp213_;
						_tmp215_ = vala_member_access_new (_tmp212_, "get", _tmp214_);
						_tmp216_ = _tmp215_;
						_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp218_ = _tmp217_;
						_tmp219_ = vala_method_call_new ((ValaExpression*) _tmp216_, _tmp218_);
						_tmp220_ = _tmp219_;
						_vala_code_node_unref0 (_tmp216_);
						get_call = _tmp220_;
						{
							ValaList* _e_list = NULL;
							ValaList* _tmp221_;
							gint _e_size = 0;
							ValaList* _tmp222_;
							gint _tmp223_;
							gint _tmp224_;
							gint _e_index = 0;
							_tmp221_ = vala_element_access_get_indices (self);
							_e_list = _tmp221_;
							_tmp222_ = _e_list;
							_tmp223_ = vala_collection_get_size ((ValaCollection*) _tmp222_);
							_tmp224_ = _tmp223_;
							_e_size = _tmp224_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp225_;
								gint _tmp226_;
								gint _tmp227_;
								ValaExpression* e = NULL;
								ValaList* _tmp228_;
								gint _tmp229_;
								gpointer _tmp230_;
								ValaMethodCall* _tmp231_;
								ValaExpression* _tmp232_;
								_tmp225_ = _e_index;
								_e_index = _tmp225_ + 1;
								_tmp226_ = _e_index;
								_tmp227_ = _e_size;
								if (!(_tmp226_ < _tmp227_)) {
									break;
								}
								_tmp228_ = _e_list;
								_tmp229_ = _e_index;
								_tmp230_ = vala_list_get (_tmp228_, _tmp229_);
								e = (ValaExpression*) _tmp230_;
								_tmp231_ = get_call;
								_tmp232_ = e;
								vala_method_call_add_argument (_tmp231_, _tmp232_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp233_ = get_call;
						_tmp234_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
						_tmp235_ = _tmp234_;
						vala_expression_set_formal_target_type ((ValaExpression*) _tmp233_, _tmp235_);
						_tmp236_ = get_call;
						_tmp237_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp238_ = _tmp237_;
						vala_expression_set_target_type ((ValaExpression*) _tmp236_, _tmp238_);
						_tmp239_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp240_ = _tmp239_;
						_tmp241_ = get_call;
						vala_code_node_replace_expression (_tmp240_, (ValaExpression*) self, (ValaExpression*) _tmp241_);
						_tmp242_ = get_call;
						_tmp243_ = context;
						_tmp244_ = vala_code_node_check ((ValaCodeNode*) _tmp242_, _tmp243_);
						result = _tmp244_;
						_vala_code_node_unref0 (get_call);
						_vala_code_node_unref0 (get_method);
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_vala_code_node_unref0 (get_method);
				}
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp245_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp246_ = _tmp245_;
				_tmp247_ = vala_element_access_get_container (self);
				_tmp248_ = _tmp247_;
				_tmp249_ = vala_expression_get_value_type (_tmp248_);
				_tmp250_ = _tmp249_;
				_tmp251_ = vala_code_node_to_string ((ValaCodeNode*) _tmp250_);
				_tmp252_ = _tmp251_;
				_tmp253_ = g_strdup_printf ("The expression `%s' does not denote an array", _tmp252_);
				_tmp254_ = _tmp253_;
				vala_report_error (_tmp246_, _tmp254_);
				_g_free0 (_tmp254_);
				_g_free0 (_tmp252_);
			}
		}
	}
	_tmp255_ = index_int_type_check;
	if (_tmp255_) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp256_;
			gint _e_size = 0;
			ValaList* _tmp257_;
			gint _tmp258_;
			gint _tmp259_;
			gint _e_index = 0;
			_tmp256_ = vala_element_access_get_indices (self);
			_e_list = _tmp256_;
			_tmp257_ = _e_list;
			_tmp258_ = vala_collection_get_size ((ValaCollection*) _tmp257_);
			_tmp259_ = _tmp258_;
			_e_size = _tmp259_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp260_;
				gint _tmp261_;
				gint _tmp262_;
				ValaExpression* e = NULL;
				ValaList* _tmp263_;
				gint _tmp264_;
				gpointer _tmp265_;
				ValaExpression* _tmp266_;
				ValaDataType* _tmp267_;
				ValaDataType* _tmp268_;
				gboolean _tmp269_ = FALSE;
				ValaExpression* _tmp270_;
				ValaDataType* _tmp271_;
				ValaDataType* _tmp272_;
				_tmp260_ = _e_index;
				_e_index = _tmp260_ + 1;
				_tmp261_ = _e_index;
				_tmp262_ = _e_size;
				if (!(_tmp261_ < _tmp262_)) {
					break;
				}
				_tmp263_ = _e_list;
				_tmp264_ = _e_index;
				_tmp265_ = vala_list_get (_tmp263_, _tmp264_);
				e = (ValaExpression*) _tmp265_;
				_tmp266_ = e;
				_tmp267_ = vala_expression_get_value_type (_tmp266_);
				_tmp268_ = _tmp267_;
				if (_tmp268_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					_vala_code_node_unref0 (pointer_type);
					return result;
				}
				_tmp270_ = e;
				_tmp271_ = vala_expression_get_value_type (_tmp270_);
				_tmp272_ = _tmp271_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp272_, VALA_TYPE_INTEGER_TYPE)) {
					_tmp269_ = TRUE;
				} else {
					ValaExpression* _tmp273_;
					ValaDataType* _tmp274_;
					ValaDataType* _tmp275_;
					_tmp273_ = e;
					_tmp274_ = vala_expression_get_value_type (_tmp273_);
					_tmp275_ = _tmp274_;
					_tmp269_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp275_, VALA_TYPE_ENUM_VALUE_TYPE);
				}
				if (!_tmp269_) {
					ValaExpression* _tmp276_;
					ValaSourceReference* _tmp277_;
					ValaSourceReference* _tmp278_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp276_ = e;
					_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp276_);
					_tmp278_ = _tmp277_;
					vala_report_error (_tmp278_, "Expression of integer type expected");
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	}
	_tmp279_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp280_ = _tmp279_;
	result = !_tmp280_;
	_vala_code_node_unref0 (pointer_type);
	return result;
}


static void vala_element_access_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeGenerator* _tmp2_;
	ValaCodeGenerator* _tmp16_;
	ValaCodeGenerator* _tmp17_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = codegen;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _e_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _e_index = 0;
		_tmp3_ = self->priv->indices;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_e_list = _tmp4_;
		_tmp5_ = _e_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_e_size = _tmp7_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* e = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaCodeGenerator* _tmp15_;
			_tmp8_ = _e_index;
			_e_index = _tmp8_ + 1;
			_tmp9_ = _e_index;
			_tmp10_ = _e_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _e_list;
			_tmp12_ = _e_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			e = (ValaExpression*) _tmp13_;
			_tmp14_ = e;
			_tmp15_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp16_ = codegen;
	vala_code_visitor_visit_element_access ((ValaCodeVisitor*) _tmp16_, self);
	_tmp17_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp17_, (ValaExpression*) self);
}


static void vala_element_access_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _index_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _index_index = 0;
		_tmp3_ = self->priv->indices;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_index_list = _tmp4_;
		_tmp5_ = _index_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_index_size = _tmp7_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* index = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaCollection* _tmp15_;
			_tmp8_ = _index_index;
			_index_index = _tmp8_ + 1;
			_tmp9_ = _index_index;
			_tmp10_ = _index_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _index_list;
			_tmp12_ = _index_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			index = (ValaExpression*) _tmp13_;
			_tmp14_ = index;
			_tmp15_ = collection;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
}


static void vala_element_access_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _index_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _index_index = 0;
		_tmp3_ = self->priv->indices;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_index_list = _tmp4_;
		_tmp5_ = _index_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_index_size = _tmp7_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* index = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaCollection* _tmp15_;
			_tmp8_ = _index_index;
			_index_index = _tmp8_ + 1;
			_tmp9_ = _index_index;
			_tmp10_ = _index_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _index_list;
			_tmp12_ = _index_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			index = (ValaExpression*) _tmp13_;
			_tmp14_ = index;
			_tmp15_ = collection;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
}


ValaExpression* vala_element_access_get_container (ValaElementAccess* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_container;
	result = _tmp0_;
	return result;
}


void vala_element_access_set_container (ValaElementAccess* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_container);
	self->priv->_container = _tmp1_;
	_tmp2_ = self->priv->_container;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_element_access_class_init (ValaElementAccessClass * klass) {
	vala_element_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_element_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaElementAccessPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_element_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_element_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_element_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_element_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_element_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_element_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_element_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_element_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_element_access_real_get_used_variables;
}


static void vala_element_access_instance_init (ValaElementAccess * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_ELEMENT_ACCESS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->indices = (ValaList*) _tmp1_;
}


static void vala_element_access_finalize (ValaCodeNode * obj) {
	ValaElementAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
	_vala_iterable_unref0 (self->priv->indices);
	_vala_code_node_unref0 (self->priv->_container);
	VALA_CODE_NODE_CLASS (vala_element_access_parent_class)->finalize (obj);
}


/**
 * Represents an array access expression e.g. "a[1,2]".
 */
GType vala_element_access_get_type (void) {
	static volatile gsize vala_element_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_element_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaElementAccess), 0, (GInstanceInitFunc) vala_element_access_instance_init, NULL };
		GType vala_element_access_type_id;
		vala_element_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaElementAccess", &g_define_type_info, 0);
		g_once_init_leave (&vala_element_access_type_id__volatile, vala_element_access_type_id);
	}
	return vala_element_access_type_id__volatile;
}



