/* valadostatement.c generated by valac, the Vala compiler
 * generated from valadostatement.vala, do not modify */

/* valadostatement.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"

enum  {
	VALA_DO_STATEMENT_DUMMY_PROPERTY,
	VALA_DO_STATEMENT_LAST_PROPERTY
};
static GParamSpec* vala_do_statement_properties[VALA_DO_STATEMENT_LAST_PROPERTY];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaDoStatementPrivate {
	ValaExpression* _condition;
	ValaBlock* _body;
};


static gpointer vala_do_statement_parent_class = NULL;
static ValaStatementIface * vala_do_statement_vala_statement_parent_iface = NULL;

#define VALA_DO_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DO_STATEMENT, ValaDoStatementPrivate))
static void vala_do_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_do_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_do_statement_always_true (ValaDoStatement* self, ValaExpression* condition);
static gboolean vala_do_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_do_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new do statement.
 *
 * @param body              loop body
 * @param condition         loop condition
 * @param source_reference  reference to source code
 * @return                  newly created do statement
 */
ValaDoStatement* vala_do_statement_construct (GType object_type, ValaBlock* body, ValaExpression* condition, ValaSourceReference* source_reference) {
	ValaDoStatement* self = NULL;
	ValaExpression* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (condition != NULL, NULL);
	self = (ValaDoStatement*) vala_code_node_construct (object_type);
	_tmp0_ = condition;
	vala_do_statement_set_condition (self, _tmp0_);
	_tmp1_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	_tmp2_ = body;
	vala_do_statement_set_body (self, _tmp2_);
	return self;
}


ValaDoStatement* vala_do_statement_new (ValaBlock* body, ValaExpression* condition, ValaSourceReference* source_reference) {
	return vala_do_statement_construct (VALA_TYPE_DO_STATEMENT, body, condition, source_reference);
}


static void vala_do_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDoStatement * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaDoStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_do_statement (_tmp0_, self);
}


static void vala_do_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDoStatement * self;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaCodeVisitor* _tmp5_;
	ValaCodeVisitor* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	self = (ValaDoStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_do_statement_get_body (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_do_statement_get_condition (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp4_, _tmp5_);
	_tmp6_ = visitor;
	_tmp7_ = vala_do_statement_get_condition (self);
	_tmp8_ = _tmp7_;
	vala_code_visitor_visit_end_full_expression (_tmp6_, _tmp8_);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_do_statement_always_true (ValaDoStatement* self, ValaExpression* condition) {
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBooleanLiteral* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = condition;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) _tmp0_) : NULL);
	literal = _tmp1_;
	_tmp3_ = literal;
	if (_tmp3_ != NULL) {
		ValaBooleanLiteral* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = literal;
		_tmp5_ = vala_boolean_literal_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean vala_do_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaDoStatement * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_;
	ValaBlock* block = NULL;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaBlock* _tmp18_;
	ValaLocalVariable* first_local = NULL;
	ValaCodeContext* _tmp19_;
	ValaSemanticAnalyzer* _tmp20_;
	ValaSemanticAnalyzer* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	ValaSourceReference* _tmp27_;
	ValaSourceReference* _tmp28_;
	ValaBooleanLiteral* _tmp29_;
	ValaBooleanLiteral* _tmp30_;
	ValaSourceReference* _tmp31_;
	ValaSourceReference* _tmp32_;
	ValaLocalVariable* _tmp33_;
	ValaLocalVariable* _tmp34_;
	ValaBlock* _tmp35_;
	ValaLocalVariable* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaSourceReference* _tmp38_;
	ValaDeclarationStatement* _tmp39_;
	ValaDeclarationStatement* _tmp40_;
	ValaUnaryExpression* if_condition = NULL;
	ValaExpression* _tmp41_;
	ValaExpression* _tmp42_;
	ValaExpression* _tmp43_;
	ValaExpression* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaSourceReference* _tmp46_;
	ValaUnaryExpression* _tmp47_;
	ValaBlock* true_block = NULL;
	ValaExpression* _tmp48_;
	ValaExpression* _tmp49_;
	ValaSourceReference* _tmp50_;
	ValaSourceReference* _tmp51_;
	ValaBlock* _tmp52_;
	ValaBlock* _tmp53_;
	ValaExpression* _tmp54_;
	ValaExpression* _tmp55_;
	ValaSourceReference* _tmp56_;
	ValaSourceReference* _tmp57_;
	ValaBreakStatement* _tmp58_;
	ValaBreakStatement* _tmp59_;
	ValaIfStatement* if_stmt = NULL;
	ValaUnaryExpression* _tmp60_;
	ValaBlock* _tmp61_;
	ValaExpression* _tmp62_;
	ValaExpression* _tmp63_;
	ValaSourceReference* _tmp64_;
	ValaSourceReference* _tmp65_;
	ValaIfStatement* _tmp66_;
	ValaBlock* condition_block = NULL;
	ValaExpression* _tmp67_;
	ValaExpression* _tmp68_;
	ValaSourceReference* _tmp69_;
	ValaSourceReference* _tmp70_;
	ValaBlock* _tmp71_;
	ValaBlock* _tmp72_;
	ValaIfStatement* _tmp73_;
	ValaIfStatement* first_if = NULL;
	ValaLocalVariable* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	ValaSourceReference* _tmp77_;
	ValaSourceReference* _tmp78_;
	ValaMemberAccess* _tmp79_;
	ValaMemberAccess* _tmp80_;
	ValaSourceReference* _tmp81_;
	ValaSourceReference* _tmp82_;
	ValaUnaryExpression* _tmp83_;
	ValaUnaryExpression* _tmp84_;
	ValaBlock* _tmp85_;
	ValaSourceReference* _tmp86_;
	ValaSourceReference* _tmp87_;
	ValaIfStatement* _tmp88_;
	ValaIfStatement* _tmp89_;
	ValaBlock* _tmp90_;
	ValaBlock* _tmp91_;
	ValaIfStatement* _tmp92_;
	ValaBlock* _tmp93_;
	ValaBlock* _tmp94_;
	ValaLocalVariable* _tmp95_;
	const gchar* _tmp96_;
	const gchar* _tmp97_;
	ValaSourceReference* _tmp98_;
	ValaSourceReference* _tmp99_;
	ValaMemberAccess* _tmp100_;
	ValaMemberAccess* _tmp101_;
	ValaSourceReference* _tmp102_;
	ValaSourceReference* _tmp103_;
	ValaBooleanLiteral* _tmp104_;
	ValaBooleanLiteral* _tmp105_;
	ValaSourceReference* _tmp106_;
	ValaSourceReference* _tmp107_;
	ValaAssignment* _tmp108_;
	ValaAssignment* _tmp109_;
	ValaSourceReference* _tmp110_;
	ValaSourceReference* _tmp111_;
	ValaExpressionStatement* _tmp112_;
	ValaExpressionStatement* _tmp113_;
	ValaBlock* _tmp114_;
	ValaBlock* _tmp115_;
	ValaBlock* _tmp116_;
	ValaSourceReference* _tmp117_;
	ValaSourceReference* _tmp118_;
	ValaLoop* _tmp119_;
	ValaLoop* _tmp120_;
	ValaBlock* parent_block = NULL;
	ValaCodeNode* _tmp121_;
	ValaCodeNode* _tmp122_;
	ValaBlock* _tmp123_;
	ValaBlock* _tmp124_;
	ValaBlock* _tmp125_;
	ValaBlock* _tmp126_;
	ValaCodeContext* _tmp127_;
	gboolean _tmp128_;
	self = (ValaDoStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_do_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_do_statement_always_true (self, _tmp1_);
	if (_tmp2_) {
		ValaLoop* loop = NULL;
		ValaBlock* _tmp3_;
		ValaBlock* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaLoop* _tmp7_;
		ValaBlock* parent_block = NULL;
		ValaCodeNode* _tmp8_;
		ValaCodeNode* _tmp9_;
		ValaBlock* _tmp10_;
		ValaBlock* _tmp11_;
		ValaLoop* _tmp12_;
		ValaLoop* _tmp13_;
		ValaCodeContext* _tmp14_;
		gboolean _tmp15_;
		_tmp3_ = vala_do_statement_get_body (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_loop_new (_tmp4_, _tmp6_);
		loop = _tmp7_;
		_tmp8_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_BLOCK, ValaBlock));
		parent_block = _tmp10_;
		_tmp11_ = parent_block;
		_tmp12_ = loop;
		vala_block_replace_statement (_tmp11_, (ValaStatement*) self, (ValaStatement*) _tmp12_);
		_tmp13_ = loop;
		_tmp14_ = context;
		_tmp15_ = vala_code_node_check ((ValaCodeNode*) _tmp13_, _tmp14_);
		result = _tmp15_;
		_vala_code_node_unref0 (parent_block);
		_vala_code_node_unref0 (loop);
		return result;
	}
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_block_new (_tmp17_);
	block = _tmp18_;
	_tmp19_ = context;
	_tmp20_ = vala_code_context_get_analyzer (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_->bool_type;
	_tmp23_ = vala_data_type_copy (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_code_node_get_temp_name ();
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_boolean_literal_new (TRUE, _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_local_variable_new (_tmp24_, _tmp26_, (ValaExpression*) _tmp30_, _tmp32_);
	_tmp34_ = _tmp33_;
	_vala_code_node_unref0 (_tmp30_);
	_g_free0 (_tmp26_);
	_vala_code_node_unref0 (_tmp24_);
	first_local = _tmp34_;
	_tmp35_ = block;
	_tmp36_ = first_local;
	_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_declaration_statement_new ((ValaSymbol*) _tmp36_, _tmp38_);
	_tmp40_ = _tmp39_;
	vala_block_add_statement (_tmp35_, (ValaStatement*) _tmp40_);
	_vala_code_node_unref0 (_tmp40_);
	_tmp41_ = vala_do_statement_get_condition (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_do_statement_get_condition (self);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, _tmp42_, _tmp46_);
	if_condition = _tmp47_;
	_tmp48_ = vala_do_statement_get_condition (self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_block_new (_tmp51_);
	true_block = _tmp52_;
	_tmp53_ = true_block;
	_tmp54_ = vala_do_statement_get_condition (self);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_break_statement_new (_tmp57_);
	_tmp59_ = _tmp58_;
	vala_block_add_statement (_tmp53_, (ValaStatement*) _tmp59_);
	_vala_code_node_unref0 (_tmp59_);
	_tmp60_ = if_condition;
	_tmp61_ = true_block;
	_tmp62_ = vala_do_statement_get_condition (self);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_if_statement_new ((ValaExpression*) _tmp60_, _tmp61_, NULL, _tmp65_);
	if_stmt = _tmp66_;
	_tmp67_ = vala_do_statement_get_condition (self);
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = vala_block_new (_tmp70_);
	condition_block = _tmp71_;
	_tmp72_ = condition_block;
	_tmp73_ = if_stmt;
	vala_block_add_statement (_tmp72_, (ValaStatement*) _tmp73_);
	_tmp74_ = first_local;
	_tmp75_ = vala_symbol_get_name ((ValaSymbol*) _tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_member_access_new_simple (_tmp76_, _tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp82_ = _tmp81_;
	_tmp83_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaExpression*) _tmp80_, _tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = condition_block;
	_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp87_ = _tmp86_;
	_tmp88_ = vala_if_statement_new ((ValaExpression*) _tmp84_, _tmp85_, NULL, _tmp87_);
	_tmp89_ = _tmp88_;
	_vala_code_node_unref0 (_tmp84_);
	_vala_code_node_unref0 (_tmp80_);
	first_if = _tmp89_;
	_tmp90_ = vala_do_statement_get_body (self);
	_tmp91_ = _tmp90_;
	_tmp92_ = first_if;
	vala_block_insert_statement (_tmp91_, 0, (ValaStatement*) _tmp92_);
	_tmp93_ = vala_do_statement_get_body (self);
	_tmp94_ = _tmp93_;
	_tmp95_ = first_local;
	_tmp96_ = vala_symbol_get_name ((ValaSymbol*) _tmp95_);
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = vala_member_access_new_simple (_tmp97_, _tmp99_);
	_tmp101_ = _tmp100_;
	_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_boolean_literal_new (FALSE, _tmp103_);
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_assignment_new ((ValaExpression*) _tmp101_, (ValaExpression*) _tmp105_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_expression_statement_new ((ValaExpression*) _tmp109_, _tmp111_);
	_tmp113_ = _tmp112_;
	vala_block_insert_statement (_tmp94_, 1, (ValaStatement*) _tmp113_);
	_vala_code_node_unref0 (_tmp113_);
	_vala_code_node_unref0 (_tmp109_);
	_vala_code_node_unref0 (_tmp105_);
	_vala_code_node_unref0 (_tmp101_);
	_tmp114_ = block;
	_tmp115_ = vala_do_statement_get_body (self);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp118_ = _tmp117_;
	_tmp119_ = vala_loop_new (_tmp116_, _tmp118_);
	_tmp120_ = _tmp119_;
	vala_block_add_statement (_tmp114_, (ValaStatement*) _tmp120_);
	_vala_code_node_unref0 (_tmp120_);
	_tmp121_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp122_ = _tmp121_;
	_tmp123_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_BLOCK, ValaBlock));
	parent_block = _tmp123_;
	_tmp124_ = parent_block;
	_tmp125_ = block;
	vala_block_replace_statement (_tmp124_, (ValaStatement*) self, (ValaStatement*) _tmp125_);
	_tmp126_ = block;
	_tmp127_ = context;
	_tmp128_ = vala_code_node_check ((ValaCodeNode*) _tmp126_, _tmp127_);
	result = _tmp128_;
	_vala_code_node_unref0 (parent_block);
	_vala_code_node_unref0 (first_if);
	_vala_code_node_unref0 (condition_block);
	_vala_code_node_unref0 (if_stmt);
	_vala_code_node_unref0 (true_block);
	_vala_code_node_unref0 (if_condition);
	_vala_code_node_unref0 (first_local);
	_vala_code_node_unref0 (block);
	return result;
}


ValaBlock* vala_do_statement_get_body (ValaDoStatement* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void vala_do_statement_set_body (ValaDoStatement* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp1_;
	_tmp2_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaExpression* vala_do_statement_get_condition (ValaDoStatement* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}


void vala_do_statement_set_condition (ValaDoStatement* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp1_;
	_tmp2_ = self->priv->_condition;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_do_statement_class_init (ValaDoStatementClass * klass) {
	vala_do_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_do_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaDoStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_do_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_do_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_do_statement_real_check;
}


static void vala_do_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_do_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_do_statement_instance_init (ValaDoStatement * self) {
	self->priv = VALA_DO_STATEMENT_GET_PRIVATE (self);
}


static void vala_do_statement_finalize (ValaCodeNode * obj) {
	ValaDoStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_DO_STATEMENT, ValaDoStatement);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_do_statement_parent_class)->finalize (obj);
}


/**
 * Represents a do iteration statement in the source code.
 */
GType vala_do_statement_get_type (void) {
	static volatile gsize vala_do_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_do_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDoStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_do_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDoStatement), 0, (GInstanceInitFunc) vala_do_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_do_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_do_statement_type_id;
		vala_do_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDoStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_do_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_do_statement_type_id__volatile, vala_do_statement_type_id);
	}
	return vala_do_statement_type_id__volatile;
}



