/* game-view.c generated by valac 0.38.1.9-3e35a, the Vala compiler
 * generated from game-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <librsvg/rsvg.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_SCOREBOARD_PROPERTY,
	GAME_VIEW_SOUND_FLIP_PROPERTY,
	GAME_VIEW_SOUND_GAMEOVER_PROPERTY,
	GAME_VIEW_GAME_PROPERTY,
	GAME_VIEW_THEME_PROPERTY,
	GAME_VIEW_LAST_PROPERTY
};
static GParamSpec* game_view_properties[GAME_VIEW_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_PLAYER (player_get_type ())
typedef struct _Block2Data Block2Data;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
enum  {
	GAME_VIEW_MOVE_SIGNAL,
	GAME_VIEW_LAST_SIGNAL
};
static guint game_view_signals[GAME_VIEW_LAST_SIGNAL] = {0};

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	GtkDrawingArea* _scoreboard;
	gchar* pieces_file;
	gdouble background_red;
	gdouble background_green;
	gdouble background_blue;
	gint background_radius;
	gdouble mark_red;
	gdouble mark_green;
	gdouble mark_blue;
	gint mark_width;
	gdouble border_red;
	gdouble border_green;
	gdouble border_blue;
	gint border_width;
	gdouble spacing_red;
	gdouble spacing_green;
	gdouble spacing_blue;
	gint spacing_width;
	gdouble highlight_red;
	gdouble highlight_green;
	gdouble highlight_blue;
	gdouble highlight_alpha;
	gchar* _sound_flip;
	gchar* _sound_gameover;
	gint paving_size;
	gint tile_size;
	gint board_size;
	gboolean show_highlight;
	gint highlight_x;
	gint highlight_y;
	gint highlight_state;
	guint render_size;
	cairo_pattern_t* tiles_pattern;
	cairo_pattern_t* scoreboard_tiles_pattern;
	gint* pixmaps;
	gint pixmaps_length1;
	gint pixmaps_length2;
	guint animate_timeout;
	gint current_player_number;
	gboolean flip_final_result_now;
	Game* _game;
	gchar* _theme;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _Block2Data {
	int _ref_count_;
	GameView* self;
	gint x;
	gint y;
};


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
#define GAME_VIEW_HIGHLIGHT_MAX 5
#define GAME_VIEW_PIXMAP_FLIP_DELAY 20
static void game_view_set_default_theme (GameView* self, GKeyFile* * key);
static void game_view_load_theme (GameView* self, GKeyFile* key);
static void game_view_set_sound_flip (GameView* self, const gchar* value);
static void game_view_set_sound_gameover (GameView* self, const gchar* value);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void game_view_calculate (GameView* self);
Game* game_view_get_game (GameView* self);
gint game_get_size (Game* self);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
static void game_view_load_image (GameView* self, cairo_t* c, gint width, gint height);
static gint game_view_get_board_x (GameView* self);
static gint game_view_get_board_y (GameView* self);
static void game_view_rounded_square (GameView* self, cairo_t* cr, gdouble x, gdouble y, gint size, gdouble width, gdouble radius_percent);
gboolean game_get_is_complete (Game* self);
GType player_get_type (void) G_GNUC_CONST;
static void game_view_square_changed_cb (GameView* self, gint x, gint y, Player replacement);
static void game_view_update_square (GameView* self, gint x, gint y);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint game_view_get_pixmap (GameView* self, Player color);
Player game_get_owner (Game* self, gint x, gint y);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap);
static gboolean ___lambda6_ (Block2Data* _data2_);
static gboolean ____lambda6__gsource_func (gpointer self);
static gboolean game_view_animate_cb (GameView* self);
static gboolean _game_view_animate_cb_gsource_func (gpointer self);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static gboolean game_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static gboolean game_view_draw_scoreboard (GameView* self, cairo_t* cr);
static GtkDrawingArea* game_view_get_scoreboard (GameView* self);
void game_view_update_scoreboard (GameView* self);
Player game_get_current_color (Game* self);
void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value);
static gboolean _game_view_draw_scoreboard_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
const gchar* game_view_get_sound_flip (GameView* self);
const gchar* game_view_get_sound_gameover (GameView* self);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, Player new_color, gpointer self);
const gchar* game_view_get_theme (GameView* self);
void game_view_set_theme (GameView* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_view_finalize (GObject * obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void game_view_set_default_theme (GameView* self, GKeyFile* * key) {
	GtkSettings* defaults = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	gchar* filename = NULL;
	GtkSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gchar* filepath = NULL;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*key != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	defaults = _tmp1_;
	_tmp2_ = defaults;
	g_object_get (_tmp2_, "gtk-theme-name", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = string_contains (_tmp5_, "HighContrast");
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	if (_tmp7_) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("high_contrast.theme");
		_g_free0 (filename);
		filename = _tmp8_;
	} else {
		GtkSettings* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = defaults;
		g_object_get (_tmp9_, "gtk-application-prefer-dark-theme", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == TRUE) {
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("adwaita.theme");
			_g_free0 (filename);
			filename = _tmp12_;
		} else {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("classic.theme");
			_g_free0 (filename);
			filename = _tmp13_;
		}
	}
	_tmp14_ = filename;
	_tmp15_ = g_build_filename (DATA_DIRECTORY, "themes", "key", _tmp14_, NULL);
	filepath = _tmp15_;
	{
		GKeyFile* _tmp16_;
		_tmp16_ = *key;
		g_key_file_load_from_file (_tmp16_, filepath, G_KEY_FILE_NONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (filepath);
		_g_free0 (filename);
		_g_object_unref0 (defaults);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (filepath);
	_g_free0 (filename);
	_g_object_unref0 (defaults);
}


static void game_view_load_theme (GameView* self, GKeyFile* key) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	{
		gchar* svg_path = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		GKeyFile* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_;
		gdouble _tmp13_ = 0.0;
		GKeyFile* _tmp14_;
		gdouble _tmp15_;
		gdouble _tmp16_ = 0.0;
		GKeyFile* _tmp17_;
		gdouble _tmp18_;
		gdouble _tmp19_ = 0.0;
		GKeyFile* _tmp20_;
		gdouble _tmp21_;
		gint _tmp22_ = 0;
		GKeyFile* _tmp23_;
		gint _tmp24_;
		gdouble _tmp25_ = 0.0;
		GKeyFile* _tmp26_;
		gdouble _tmp27_;
		gdouble _tmp28_ = 0.0;
		GKeyFile* _tmp29_;
		gdouble _tmp30_;
		gdouble _tmp31_ = 0.0;
		GKeyFile* _tmp32_;
		gdouble _tmp33_;
		gint _tmp34_ = 0;
		GKeyFile* _tmp35_;
		gint _tmp36_;
		gdouble _tmp37_ = 0.0;
		GKeyFile* _tmp38_;
		gdouble _tmp39_;
		gdouble _tmp40_ = 0.0;
		GKeyFile* _tmp41_;
		gdouble _tmp42_;
		gdouble _tmp43_ = 0.0;
		GKeyFile* _tmp44_;
		gdouble _tmp45_;
		gint _tmp46_ = 0;
		GKeyFile* _tmp47_;
		gint _tmp48_;
		gdouble _tmp49_ = 0.0;
		GKeyFile* _tmp50_;
		gdouble _tmp51_;
		gdouble _tmp52_ = 0.0;
		GKeyFile* _tmp53_;
		gdouble _tmp54_;
		gdouble _tmp55_ = 0.0;
		GKeyFile* _tmp56_;
		gdouble _tmp57_;
		gint _tmp58_ = 0;
		GKeyFile* _tmp59_;
		gint _tmp60_;
		gdouble _tmp61_ = 0.0;
		GKeyFile* _tmp62_;
		gdouble _tmp63_;
		gdouble _tmp64_ = 0.0;
		GKeyFile* _tmp65_;
		gdouble _tmp66_;
		gdouble _tmp67_ = 0.0;
		GKeyFile* _tmp68_;
		gdouble _tmp69_;
		gdouble _tmp70_ = 0.0;
		GKeyFile* _tmp71_;
		gdouble _tmp72_;
		gchar* _tmp73_ = NULL;
		GKeyFile* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_ = NULL;
		GKeyFile* _tmp77_;
		gchar* _tmp78_;
		_tmp0_ = g_build_filename (DATA_DIRECTORY, "themes", "svg", NULL);
		svg_path = _tmp0_;
		_tmp2_ = key;
		_tmp3_ = g_key_file_get_string (_tmp2_, "Pieces", "File", &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = svg_path;
		_tmp5_ = g_build_filename (_tmp4_, _tmp1_, NULL);
		_g_free0 (self->priv->pieces_file);
		self->priv->pieces_file = _tmp5_;
		_tmp6_ = self->priv->pieces_file;
		_tmp7_ = g_path_get_dirname (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = svg_path;
		_tmp10_ = g_strcmp0 (_tmp8_, _tmp9_) != 0;
		_g_free0 (_tmp8_);
		if (_tmp10_) {
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = svg_path;
			_tmp12_ = g_build_filename (_tmp11_, "black_and_white.svg", NULL);
			_g_free0 (self->priv->pieces_file);
			self->priv->pieces_file = _tmp12_;
		}
		_tmp14_ = key;
		_tmp15_ = g_key_file_get_double (_tmp14_, "Background", "Red", &_inner_error_);
		_tmp13_ = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->background_red = _tmp13_;
		_tmp17_ = key;
		_tmp18_ = g_key_file_get_double (_tmp17_, "Background", "Green", &_inner_error_);
		_tmp16_ = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->background_green = _tmp16_;
		_tmp20_ = key;
		_tmp21_ = g_key_file_get_double (_tmp20_, "Background", "Blue", &_inner_error_);
		_tmp19_ = _tmp21_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->background_blue = _tmp19_;
		_tmp23_ = key;
		_tmp24_ = g_key_file_get_integer (_tmp23_, "Background", "Radius", &_inner_error_);
		_tmp22_ = _tmp24_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->background_radius = _tmp22_;
		_tmp26_ = key;
		_tmp27_ = g_key_file_get_double (_tmp26_, "Mark", "Red", &_inner_error_);
		_tmp25_ = _tmp27_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->mark_red = _tmp25_;
		_tmp29_ = key;
		_tmp30_ = g_key_file_get_double (_tmp29_, "Mark", "Green", &_inner_error_);
		_tmp28_ = _tmp30_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->mark_green = _tmp28_;
		_tmp32_ = key;
		_tmp33_ = g_key_file_get_double (_tmp32_, "Mark", "Blue", &_inner_error_);
		_tmp31_ = _tmp33_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->mark_blue = _tmp31_;
		_tmp35_ = key;
		_tmp36_ = g_key_file_get_integer (_tmp35_, "Mark", "Width", &_inner_error_);
		_tmp34_ = _tmp36_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->mark_width = _tmp34_;
		_tmp38_ = key;
		_tmp39_ = g_key_file_get_double (_tmp38_, "Border", "Red", &_inner_error_);
		_tmp37_ = _tmp39_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->border_red = _tmp37_;
		_tmp41_ = key;
		_tmp42_ = g_key_file_get_double (_tmp41_, "Border", "Green", &_inner_error_);
		_tmp40_ = _tmp42_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->border_green = _tmp40_;
		_tmp44_ = key;
		_tmp45_ = g_key_file_get_double (_tmp44_, "Border", "Blue", &_inner_error_);
		_tmp43_ = _tmp45_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->border_blue = _tmp43_;
		_tmp47_ = key;
		_tmp48_ = g_key_file_get_integer (_tmp47_, "Border", "Width", &_inner_error_);
		_tmp46_ = _tmp48_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->border_width = _tmp46_;
		_tmp50_ = key;
		_tmp51_ = g_key_file_get_double (_tmp50_, "Spacing", "Red", &_inner_error_);
		_tmp49_ = _tmp51_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->spacing_red = _tmp49_;
		_tmp53_ = key;
		_tmp54_ = g_key_file_get_double (_tmp53_, "Spacing", "Green", &_inner_error_);
		_tmp52_ = _tmp54_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->spacing_green = _tmp52_;
		_tmp56_ = key;
		_tmp57_ = g_key_file_get_double (_tmp56_, "Spacing", "Blue", &_inner_error_);
		_tmp55_ = _tmp57_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->spacing_blue = _tmp55_;
		_tmp59_ = key;
		_tmp60_ = g_key_file_get_integer (_tmp59_, "Spacing", "Width", &_inner_error_);
		_tmp58_ = _tmp60_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->spacing_width = _tmp58_;
		_tmp62_ = key;
		_tmp63_ = g_key_file_get_double (_tmp62_, "Highlight", "Red", &_inner_error_);
		_tmp61_ = _tmp63_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->highlight_red = _tmp61_;
		_tmp65_ = key;
		_tmp66_ = g_key_file_get_double (_tmp65_, "Highlight", "Green", &_inner_error_);
		_tmp64_ = _tmp66_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->highlight_green = _tmp64_;
		_tmp68_ = key;
		_tmp69_ = g_key_file_get_double (_tmp68_, "Highlight", "Blue", &_inner_error_);
		_tmp67_ = _tmp69_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->highlight_blue = _tmp67_;
		_tmp71_ = key;
		_tmp72_ = g_key_file_get_double (_tmp71_, "Highlight", "Alpha", &_inner_error_);
		_tmp70_ = _tmp72_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->highlight_alpha = _tmp70_;
		_tmp74_ = key;
		_tmp75_ = g_key_file_get_string (_tmp74_, "Sound", "Flip", &_inner_error_);
		_tmp73_ = _tmp75_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		game_view_set_sound_flip (self, _tmp73_);
		_tmp77_ = key;
		_tmp78_ = g_key_file_get_string (_tmp77_, "Sound", "GameOver", &_inner_error_);
		_tmp76_ = _tmp78_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp73_);
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp73_);
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		game_view_set_sound_gameover (self, _tmp76_);
		_g_free0 (_tmp76_);
		_g_free0 (_tmp73_);
		_g_free0 (_tmp1_);
		_g_free0 (svg_path);
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp79_;
		const gchar* _tmp80_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp79_ = e;
		_tmp80_ = _tmp79_->message;
		g_warning ("game-view.vala:226: Errors when loading theme: %s", _tmp80_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) ((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK));
	gtk_widget_set_size_request ((GtkWidget*) self, 350, 350);
	return self;
}


GameView* game_view_new (void) {
	return game_view_construct (TYPE_GAME_VIEW);
}


static void game_view_calculate (GameView* self) {
	gint size = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	Game* _tmp12_;
	Game* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_, _tmp1_);
	size = _tmp2_;
	_tmp3_ = self->priv->border_width;
	_tmp4_ = self->priv->spacing_width;
	_tmp5_ = game_view_get_game (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = game_get_size (_tmp6_);
	_tmp8_ = _tmp7_;
	self->priv->paving_size = ((size - (2 * _tmp3_)) + _tmp4_) / _tmp8_;
	_tmp9_ = self->priv->paving_size;
	_tmp10_ = self->priv->spacing_width;
	self->priv->tile_size = _tmp9_ - _tmp10_;
	_tmp11_ = self->priv->paving_size;
	_tmp12_ = game_view_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = game_get_size (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->spacing_width;
	self->priv->board_size = (_tmp11_ * _tmp15_) - _tmp16_;
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_;
	cairo_t* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	cairo_t* _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	cairo_t* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	cairo_t* _tmp35_;
	cairo_t* _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	gdouble _tmp39_;
	cairo_t* _tmp40_;
	gint _tmp41_;
	cairo_t* _tmp42_;
	self = (GameView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	game_view_calculate (self);
	_tmp3_ = self->priv->tiles_pattern;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		guint _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->render_size;
		_tmp5_ = self->priv->tile_size;
		_tmp2_ = _tmp4_ != ((guint) _tmp5_);
	}
	if (_tmp2_) {
		gint _tmp6_;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp7_;
		cairo_surface_t* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		cairo_surface_t* _tmp11_;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp12_;
		cairo_t* _tmp13_;
		cairo_t* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		cairo_surface_t* _tmp17_;
		cairo_pattern_t* _tmp18_;
		_tmp6_ = self->priv->tile_size;
		self->priv->render_size = (guint) _tmp6_;
		_tmp7_ = cr;
		_tmp8_ = cairo_get_target (_tmp7_);
		_tmp9_ = self->priv->tile_size;
		_tmp10_ = self->priv->tile_size;
		_tmp11_ = cairo_surface_create_similar (_tmp8_, CAIRO_CONTENT_COLOR_ALPHA, _tmp9_ * 8, _tmp10_ * 4);
		surface = _tmp11_;
		_tmp12_ = surface;
		_tmp13_ = cairo_create (_tmp12_);
		c = _tmp13_;
		_tmp14_ = c;
		_tmp15_ = self->priv->tile_size;
		_tmp16_ = self->priv->tile_size;
		game_view_load_image (self, _tmp14_, _tmp15_ * 8, _tmp16_ * 4);
		_tmp17_ = surface;
		_tmp18_ = cairo_pattern_create_for_surface (_tmp17_);
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
		self->priv->tiles_pattern = _tmp18_;
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
	}
	_tmp19_ = cr;
	_tmp20_ = game_view_get_board_x (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = game_view_get_board_y (self);
	_tmp23_ = _tmp22_;
	cairo_translate (_tmp19_, (gdouble) _tmp21_, (gdouble) _tmp23_);
	_tmp24_ = cr;
	_tmp25_ = self->priv->spacing_red;
	_tmp26_ = self->priv->spacing_green;
	_tmp27_ = self->priv->spacing_blue;
	cairo_set_source_rgba (_tmp24_, _tmp25_, _tmp26_, _tmp27_, 1.0);
	_tmp28_ = cr;
	_tmp29_ = self->priv->border_width;
	_tmp30_ = self->priv->border_width;
	_tmp31_ = self->priv->board_size;
	_tmp32_ = self->priv->border_width;
	_tmp33_ = self->priv->board_size;
	_tmp34_ = self->priv->border_width;
	cairo_rectangle (_tmp28_, (-_tmp29_) / 2.0, (-_tmp30_) / 2.0, (gdouble) (_tmp31_ + _tmp32_), (gdouble) (_tmp33_ + _tmp34_));
	_tmp35_ = cr;
	cairo_fill_preserve (_tmp35_);
	_tmp36_ = cr;
	_tmp37_ = self->priv->border_red;
	_tmp38_ = self->priv->border_green;
	_tmp39_ = self->priv->border_blue;
	cairo_set_source_rgba (_tmp36_, _tmp37_, _tmp38_, _tmp39_, 1.0);
	_tmp40_ = cr;
	_tmp41_ = self->priv->border_width;
	cairo_set_line_width (_tmp40_, (gdouble) _tmp41_);
	_tmp42_ = cr;
	cairo_stroke (_tmp42_);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp43_ = FALSE;
			_tmp43_ = TRUE;
			while (TRUE) {
				gint _tmp45_;
				Game* _tmp46_;
				Game* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				if (!_tmp43_) {
					gint _tmp44_;
					_tmp44_ = x;
					x = _tmp44_ + 1;
				}
				_tmp43_ = FALSE;
				_tmp45_ = x;
				_tmp46_ = game_view_get_game (self);
				_tmp47_ = _tmp46_;
				_tmp48_ = game_get_size (_tmp47_);
				_tmp49_ = _tmp48_;
				if (!(_tmp45_ < _tmp49_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp50_ = FALSE;
						_tmp50_ = TRUE;
						while (TRUE) {
							gint _tmp52_;
							Game* _tmp53_;
							Game* _tmp54_;
							gint _tmp55_;
							gint _tmp56_;
							gint tile_x = 0;
							gint _tmp57_;
							gint _tmp58_;
							gint tile_y = 0;
							gint _tmp59_;
							gint _tmp60_;
							cairo_t* _tmp61_;
							gdouble _tmp62_;
							gdouble _tmp63_;
							gdouble _tmp64_;
							cairo_t* _tmp65_;
							gint _tmp66_;
							gint _tmp67_;
							gint _tmp68_;
							gint _tmp69_;
							cairo_t* _tmp70_;
							gboolean _tmp71_ = FALSE;
							gboolean _tmp72_ = FALSE;
							gboolean _tmp73_ = FALSE;
							gint _tmp74_;
							gint _tmp75_;
							gint* _tmp116_;
							gint _tmp116__length1;
							gint _tmp116__length2;
							gint _tmp117_;
							gint _tmp118_;
							gint _tmp119_;
							gint texture_x = 0;
							gint* _tmp120_;
							gint _tmp120__length1;
							gint _tmp120__length2;
							gint _tmp121_;
							gint _tmp122_;
							gint _tmp123_;
							gint _tmp124_;
							gint texture_y = 0;
							gint* _tmp125_;
							gint _tmp125__length1;
							gint _tmp125__length2;
							gint _tmp126_;
							gint _tmp127_;
							gint _tmp128_;
							gint _tmp129_;
							cairo_matrix_t matrix = {0};
							gint _tmp130_;
							gint _tmp131_;
							gint _tmp132_;
							gint _tmp133_;
							cairo_pattern_t* _tmp134_;
							cairo_matrix_t _tmp135_;
							cairo_t* _tmp136_;
							cairo_pattern_t* _tmp137_;
							cairo_t* _tmp138_;
							gint _tmp139_;
							gint _tmp140_;
							gint _tmp141_;
							gint _tmp142_;
							cairo_t* _tmp143_;
							if (!_tmp50_) {
								gint _tmp51_;
								_tmp51_ = y;
								y = _tmp51_ + 1;
							}
							_tmp50_ = FALSE;
							_tmp52_ = y;
							_tmp53_ = game_view_get_game (self);
							_tmp54_ = _tmp53_;
							_tmp55_ = game_get_size (_tmp54_);
							_tmp56_ = _tmp55_;
							if (!(_tmp52_ < _tmp56_)) {
								break;
							}
							_tmp57_ = x;
							_tmp58_ = self->priv->paving_size;
							tile_x = _tmp57_ * _tmp58_;
							_tmp59_ = y;
							_tmp60_ = self->priv->paving_size;
							tile_y = _tmp59_ * _tmp60_;
							_tmp61_ = cr;
							_tmp62_ = self->priv->background_red;
							_tmp63_ = self->priv->background_green;
							_tmp64_ = self->priv->background_blue;
							cairo_set_source_rgba (_tmp61_, _tmp62_, _tmp63_, _tmp64_, 1.0);
							_tmp65_ = cr;
							_tmp66_ = tile_x;
							_tmp67_ = tile_y;
							_tmp68_ = self->priv->tile_size;
							_tmp69_ = self->priv->background_radius;
							game_view_rounded_square (self, _tmp65_, (gdouble) _tmp66_, (gdouble) _tmp67_, _tmp68_, (gdouble) 0, (gdouble) _tmp69_);
							_tmp70_ = cr;
							cairo_fill (_tmp70_);
							_tmp74_ = self->priv->highlight_x;
							_tmp75_ = x;
							if (_tmp74_ == _tmp75_) {
								gint _tmp76_;
								gint _tmp77_;
								_tmp76_ = self->priv->highlight_y;
								_tmp77_ = y;
								_tmp73_ = _tmp76_ == _tmp77_;
							} else {
								_tmp73_ = FALSE;
							}
							if (_tmp73_) {
								gboolean _tmp78_ = FALSE;
								gboolean _tmp79_;
								_tmp79_ = self->priv->show_highlight;
								if (_tmp79_) {
									_tmp78_ = TRUE;
								} else {
									gint _tmp80_;
									_tmp80_ = self->priv->highlight_state;
									_tmp78_ = _tmp80_ != 0;
								}
								_tmp72_ = _tmp78_;
							} else {
								_tmp72_ = FALSE;
							}
							if (_tmp72_) {
								Game* _tmp81_;
								Game* _tmp82_;
								gboolean _tmp83_;
								gboolean _tmp84_;
								_tmp81_ = game_view_get_game (self);
								_tmp82_ = _tmp81_;
								_tmp83_ = game_get_is_complete (_tmp82_);
								_tmp84_ = _tmp83_;
								_tmp71_ = !_tmp84_;
							} else {
								_tmp71_ = FALSE;
							}
							if (_tmp71_) {
								gboolean _tmp85_ = FALSE;
								gboolean _tmp86_;
								cairo_t* _tmp100_;
								gdouble _tmp101_;
								gdouble _tmp102_;
								gdouble _tmp103_;
								gdouble _tmp104_;
								cairo_t* _tmp105_;
								gint _tmp106_;
								gint _tmp107_;
								gint _tmp108_;
								gint _tmp109_;
								gint _tmp110_;
								gint _tmp111_;
								gint _tmp112_;
								gint _tmp113_;
								gint _tmp114_;
								cairo_t* _tmp115_;
								_tmp86_ = self->priv->show_highlight;
								if (_tmp86_) {
									gint _tmp87_;
									_tmp87_ = self->priv->highlight_state;
									_tmp85_ = _tmp87_ != GAME_VIEW_HIGHLIGHT_MAX;
								} else {
									_tmp85_ = FALSE;
								}
								if (_tmp85_) {
									gint _tmp88_;
									gint _tmp89_;
									gint _tmp90_;
									gint _tmp91_;
									gint _tmp92_;
									gint _tmp93_;
									gint _tmp94_;
									gint _tmp95_;
									gint _tmp96_;
									_tmp88_ = self->priv->highlight_state;
									self->priv->highlight_state = _tmp88_ + 1;
									_tmp89_ = game_view_get_board_x (self);
									_tmp90_ = _tmp89_;
									_tmp91_ = tile_x;
									_tmp92_ = game_view_get_board_y (self);
									_tmp93_ = _tmp92_;
									_tmp94_ = tile_y;
									_tmp95_ = self->priv->tile_size;
									_tmp96_ = self->priv->tile_size;
									gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp90_ + _tmp91_, _tmp93_ + _tmp94_, _tmp95_, _tmp96_);
								} else {
									gboolean _tmp97_ = FALSE;
									gboolean _tmp98_;
									_tmp98_ = self->priv->show_highlight;
									if (!_tmp98_) {
										gint _tmp99_;
										_tmp99_ = self->priv->highlight_state;
										_tmp97_ = _tmp99_ != 0;
									} else {
										_tmp97_ = FALSE;
									}
									if (_tmp97_) {
										self->priv->highlight_state = 0;
									}
								}
								_tmp100_ = cr;
								_tmp101_ = self->priv->highlight_red;
								_tmp102_ = self->priv->highlight_green;
								_tmp103_ = self->priv->highlight_blue;
								_tmp104_ = self->priv->highlight_alpha;
								cairo_set_source_rgba (_tmp100_, _tmp101_, _tmp102_, _tmp103_, _tmp104_);
								_tmp105_ = cr;
								_tmp106_ = tile_x;
								_tmp107_ = self->priv->tile_size;
								_tmp108_ = self->priv->highlight_state;
								_tmp109_ = tile_y;
								_tmp110_ = self->priv->tile_size;
								_tmp111_ = self->priv->highlight_state;
								_tmp112_ = self->priv->tile_size;
								_tmp113_ = self->priv->highlight_state;
								_tmp114_ = self->priv->background_radius;
								game_view_rounded_square (self, _tmp105_, (gdouble) (_tmp106_ + ((_tmp107_ * (GAME_VIEW_HIGHLIGHT_MAX - _tmp108_)) / (2 * GAME_VIEW_HIGHLIGHT_MAX))), (gdouble) (_tmp109_ + ((_tmp110_ * (GAME_VIEW_HIGHLIGHT_MAX - _tmp111_)) / (2 * GAME_VIEW_HIGHLIGHT_MAX))), (_tmp112_ * _tmp113_) / GAME_VIEW_HIGHLIGHT_MAX, (gdouble) 0, (gdouble) _tmp114_);
								_tmp115_ = cr;
								cairo_fill (_tmp115_);
							}
							_tmp116_ = self->priv->pixmaps;
							_tmp116__length1 = self->priv->pixmaps_length1;
							_tmp116__length2 = self->priv->pixmaps_length2;
							_tmp117_ = x;
							_tmp118_ = y;
							_tmp119_ = _tmp116_[(_tmp117_ * _tmp116__length2) + _tmp118_];
							if (_tmp119_ == 0) {
								continue;
							}
							_tmp120_ = self->priv->pixmaps;
							_tmp120__length1 = self->priv->pixmaps_length1;
							_tmp120__length2 = self->priv->pixmaps_length2;
							_tmp121_ = x;
							_tmp122_ = y;
							_tmp123_ = _tmp120_[(_tmp121_ * _tmp120__length2) + _tmp122_];
							_tmp124_ = self->priv->tile_size;
							texture_x = (_tmp123_ % 8) * _tmp124_;
							_tmp125_ = self->priv->pixmaps;
							_tmp125__length1 = self->priv->pixmaps_length1;
							_tmp125__length2 = self->priv->pixmaps_length2;
							_tmp126_ = x;
							_tmp127_ = y;
							_tmp128_ = _tmp125_[(_tmp126_ * _tmp125__length2) + _tmp127_];
							_tmp129_ = self->priv->tile_size;
							texture_y = (_tmp128_ / 8) * _tmp129_;
							cairo_matrix_init_identity (&matrix);
							_tmp130_ = texture_x;
							_tmp131_ = tile_x;
							_tmp132_ = texture_y;
							_tmp133_ = tile_y;
							cairo_matrix_translate (&matrix, (gdouble) (_tmp130_ - _tmp131_), (gdouble) (_tmp132_ - _tmp133_));
							_tmp134_ = self->priv->tiles_pattern;
							_tmp135_ = matrix;
							cairo_pattern_set_matrix (_tmp134_, &_tmp135_);
							_tmp136_ = cr;
							_tmp137_ = self->priv->tiles_pattern;
							cairo_set_source (_tmp136_, _tmp137_);
							_tmp138_ = cr;
							_tmp139_ = tile_x;
							_tmp140_ = tile_y;
							_tmp141_ = self->priv->tile_size;
							_tmp142_ = self->priv->tile_size;
							cairo_rectangle (_tmp138_, (gdouble) _tmp139_, (gdouble) _tmp140_, (gdouble) _tmp141_, (gdouble) _tmp142_);
							_tmp143_ = cr;
							cairo_fill (_tmp143_);
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void game_view_rounded_square (GameView* self, cairo_t* cr, gdouble x, gdouble y, gint size, gdouble width, gdouble radius_percent) {
	gdouble _tmp0_;
	gdouble _tmp10_;
	gdouble radius_border = 0.0;
	gdouble _tmp11_;
	gint _tmp12_;
	gdouble radius_arc = 0.0;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble x1 = 0.0;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble y1 = 0.0;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble x2 = 0.0;
	gdouble _tmp19_;
	gint _tmp20_;
	gdouble _tmp21_;
	gdouble y2 = 0.0;
	gdouble _tmp22_;
	gint _tmp23_;
	gdouble _tmp24_;
	cairo_t* _tmp25_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	cairo_t* _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	cairo_t* _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	cairo_t* _tmp37_;
	gdouble _tmp38_;
	gdouble _tmp39_;
	gdouble _tmp40_;
	cairo_t* _tmp41_;
	gdouble _tmp42_;
	gdouble _tmp43_;
	gdouble _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = radius_percent;
	if (_tmp0_ <= ((gdouble) 0)) {
		cairo_t* _tmp1_;
		gdouble _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		gint _tmp6_;
		gdouble _tmp7_;
		gint _tmp8_;
		gdouble _tmp9_;
		_tmp1_ = cr;
		_tmp2_ = x;
		_tmp3_ = width;
		_tmp4_ = y;
		_tmp5_ = width;
		_tmp6_ = size;
		_tmp7_ = width;
		_tmp8_ = size;
		_tmp9_ = width;
		cairo_rectangle (_tmp1_, _tmp2_ + (_tmp3_ / 2.0), _tmp4_ + (_tmp5_ / 2.0), _tmp6_ + _tmp7_, _tmp8_ + _tmp9_);
		return;
	}
	_tmp10_ = radius_percent;
	if (_tmp10_ > ((gdouble) 50)) {
		radius_percent = (gdouble) 50;
	}
	_tmp11_ = radius_percent;
	_tmp12_ = size;
	radius_border = (_tmp11_ * _tmp12_) / 100.0;
	_tmp13_ = radius_border;
	_tmp14_ = width;
	radius_arc = _tmp13_ - (_tmp14_ / 2.0);
	_tmp15_ = x;
	_tmp16_ = radius_border;
	x1 = _tmp15_ + _tmp16_;
	_tmp17_ = y;
	_tmp18_ = radius_border;
	y1 = _tmp17_ + _tmp18_;
	_tmp19_ = x;
	_tmp20_ = size;
	_tmp21_ = radius_border;
	x2 = (_tmp19_ + _tmp20_) - _tmp21_;
	_tmp22_ = y;
	_tmp23_ = size;
	_tmp24_ = radius_border;
	y2 = (_tmp22_ + _tmp23_) - _tmp24_;
	_tmp25_ = cr;
	_tmp26_ = x1;
	_tmp27_ = y1;
	_tmp28_ = radius_arc;
	cairo_arc (_tmp25_, _tmp26_, _tmp27_, _tmp28_, G_PI, (G_PI * 3) / 2.0);
	_tmp29_ = cr;
	_tmp30_ = x2;
	_tmp31_ = y1;
	_tmp32_ = radius_arc;
	cairo_arc (_tmp29_, _tmp30_, _tmp31_, _tmp32_, (G_PI * 3) / 2.0, (gdouble) 0);
	_tmp33_ = cr;
	_tmp34_ = x2;
	_tmp35_ = y2;
	_tmp36_ = radius_arc;
	cairo_arc (_tmp33_, _tmp34_, _tmp35_, _tmp36_, (gdouble) 0, G_PI / 2.0);
	_tmp37_ = cr;
	_tmp38_ = x1;
	_tmp39_ = y2;
	_tmp40_ = radius_arc;
	cairo_arc (_tmp37_, _tmp38_, _tmp39_, _tmp40_, G_PI / 2.0, G_PI);
	_tmp41_ = cr;
	_tmp42_ = x1;
	_tmp43_ = y1;
	_tmp44_ = radius_arc;
	cairo_arc (_tmp41_, _tmp42_, _tmp43_, _tmp44_, G_PI, (G_PI * 3) / 2.0);
}


static void game_view_load_image (GameView* self, cairo_t* c, gint width, gint height) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp0_;
		RsvgHandle* _tmp1_;
		cairo_matrix_t m = {0};
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		cairo_t* _tmp8_;
		cairo_matrix_t _tmp9_;
		cairo_t* _tmp10_;
		_tmp0_ = self->priv->pieces_file;
		_tmp1_ = rsvg_handle_new_from_file (_tmp0_, &_inner_error_);
		h = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		cairo_matrix_init_identity (&m);
		_tmp2_ = width;
		g_object_get (h, "width", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = height;
		g_object_get (h, "height", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		cairo_matrix_scale (&m, ((gdouble) _tmp2_) / _tmp4_, ((gdouble) _tmp5_) / _tmp7_);
		_tmp8_ = c;
		_tmp9_ = m;
		cairo_set_matrix (_tmp8_, &_tmp9_);
		_tmp10_ = c;
		rsvg_handle_render_cairo (h, _tmp10_);
		_g_object_unref0 (h);
		return;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GdkPixbuf* _tmp14_;
		cairo_t* _tmp15_;
		GdkPixbuf* _tmp16_;
		cairo_t* _tmp17_;
		_tmp11_ = self->priv->pieces_file;
		_tmp12_ = width;
		_tmp13_ = height;
		_tmp14_ = gdk_pixbuf_new_from_file_at_scale (_tmp11_, _tmp12_, _tmp13_, FALSE, &_inner_error_);
		p = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp15_ = c;
		_tmp16_ = p;
		gdk_cairo_set_source_pixbuf (_tmp15_, _tmp16_, (gdouble) 0, (gdouble) 0);
		_tmp17_ = c;
		cairo_paint (_tmp17_);
		_g_object_unref0 (p);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = self->priv->pieces_file;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("game-view.vala:374: Failed to load theme image %s: %s", _tmp18_, _tmp20_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void game_view_square_changed_cb (GameView* self, gint x, gint y, Player replacement) {
	Player _tmp0_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = replacement;
	if (_tmp0_ == PLAYER_NONE) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = x;
		self->priv->highlight_x = _tmp1_;
		_tmp2_ = y;
		self->priv->highlight_y = _tmp2_;
	}
	_tmp3_ = x;
	_tmp4_ = y;
	game_view_update_square (self, _tmp3_, _tmp4_);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GameView* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean ___lambda6_ (Block2Data* _data2_) {
	GameView* self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	self = _data2_->self;
	self->priv->flip_final_result_now = TRUE;
	_tmp0_ = _data2_->x;
	_tmp1_ = _data2_->y;
	game_view_update_square (self, _tmp0_, _tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ____lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda6_ (self);
	return result;
}


static void game_view_update_square (GameView* self, gint x, gint y) {
	Block2Data* _data2_;
	gint _tmp0_;
	gint _tmp1_;
	gint pixmap = 0;
	Game* _tmp2_;
	Game* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Player _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	gint _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	Game* _tmp49_;
	Game* _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp52_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = x;
	_data2_->x = _tmp0_;
	_tmp1_ = y;
	_data2_->y = _tmp1_;
	_tmp2_ = game_view_get_game (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data2_->x;
	_tmp5_ = _data2_->y;
	_tmp6_ = game_get_owner (_tmp3_, _tmp4_, _tmp5_);
	_tmp7_ = game_view_get_pixmap (self, _tmp6_);
	pixmap = _tmp7_;
	_tmp9_ = self->priv->flip_final_result_now;
	if (_tmp9_) {
		Game* _tmp10_;
		Game* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = game_view_get_game (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = game_get_is_complete (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp8_ = _tmp13_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gint n = 0;
		gint _tmp14_;
		Game* _tmp15_;
		Game* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		Player winning_color = 0;
		Player losing_color = 0;
		gint n_winning_tiles = 0;
		Game* _tmp20_;
		Game* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint n_losing_tiles = 0;
		Game* _tmp24_;
		Game* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _tmp33_;
		gint _tmp34_;
		_tmp14_ = _data2_->y;
		_tmp15_ = game_view_get_game (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = game_get_size (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _data2_->x;
		n = (_tmp14_ * _tmp18_) + _tmp19_;
		winning_color = PLAYER_LIGHT;
		losing_color = PLAYER_DARK;
		_tmp20_ = game_view_get_game (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = game_get_n_light_tiles (_tmp21_);
		_tmp23_ = _tmp22_;
		n_winning_tiles = _tmp23_;
		_tmp24_ = game_view_get_game (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = game_get_n_dark_tiles (_tmp25_);
		_tmp27_ = _tmp26_;
		n_losing_tiles = _tmp27_;
		_tmp28_ = n_losing_tiles;
		_tmp29_ = n_winning_tiles;
		if (_tmp28_ > _tmp29_) {
			gint t = 0;
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			winning_color = PLAYER_DARK;
			losing_color = PLAYER_LIGHT;
			_tmp30_ = n_winning_tiles;
			t = _tmp30_;
			_tmp31_ = n_losing_tiles;
			n_winning_tiles = _tmp31_;
			_tmp32_ = t;
			n_losing_tiles = _tmp32_;
		}
		_tmp33_ = n;
		_tmp34_ = n_winning_tiles;
		if (_tmp33_ < _tmp34_) {
			Player _tmp35_;
			gint _tmp36_;
			_tmp35_ = winning_color;
			_tmp36_ = game_view_get_pixmap (self, _tmp35_);
			pixmap = _tmp36_;
		} else {
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			_tmp37_ = n;
			_tmp38_ = n_winning_tiles;
			_tmp39_ = n_losing_tiles;
			if (_tmp37_ < (_tmp38_ + _tmp39_)) {
				Player _tmp40_;
				gint _tmp41_;
				_tmp40_ = losing_color;
				_tmp41_ = game_view_get_pixmap (self, _tmp40_);
				pixmap = _tmp41_;
			} else {
				gint _tmp42_;
				_tmp42_ = game_view_get_pixmap (self, PLAYER_NONE);
				pixmap = _tmp42_;
			}
		}
	} else {
		gboolean _tmp43_;
		_tmp43_ = self->priv->flip_final_result_now;
		if (_tmp43_) {
			self->priv->flip_final_result_now = FALSE;
		}
	}
	_tmp44_ = _data2_->x;
	_tmp45_ = _data2_->y;
	_tmp46_ = pixmap;
	game_view_set_square (self, _tmp44_, _tmp45_, _tmp46_);
	_tmp49_ = game_view_get_game (self);
	_tmp50_ = _tmp49_;
	_tmp51_ = game_get_is_complete (_tmp50_);
	_tmp52_ = _tmp51_;
	if (_tmp52_) {
		Game* _tmp53_;
		Game* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		_tmp53_ = game_view_get_game (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = game_get_n_light_tiles (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp48_ = _tmp56_ > 0;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		Game* _tmp57_;
		Game* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		_tmp57_ = game_view_get_game (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = game_get_n_dark_tiles (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp47_ = _tmp60_ > 0;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ____lambda6__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static gboolean _game_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_view_animate_cb ((GameView*) self);
	return result;
}


static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap) {
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pixmaps;
	_tmp0__length1 = self->priv->pixmaps_length1;
	_tmp0__length2 = self->priv->pixmaps_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = pixmap;
	if (_tmp3_ == _tmp4_) {
		return;
	}
	_tmp6_ = pixmap;
	if (_tmp6_ == 0) {
		_tmp5_ = TRUE;
	} else {
		gint* _tmp7_;
		gint _tmp7__length1;
		gint _tmp7__length2;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp7_ = self->priv->pixmaps;
		_tmp7__length1 = self->priv->pixmaps_length1;
		_tmp7__length2 = self->priv->pixmaps_length2;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
		_tmp5_ = _tmp10_ == 0;
	}
	if (_tmp5_) {
		gint* _tmp11_;
		gint _tmp11__length1;
		gint _tmp11__length2;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp11_ = self->priv->pixmaps;
		_tmp11__length1 = self->priv->pixmaps_length1;
		_tmp11__length2 = self->priv->pixmaps_length2;
		_tmp12_ = x;
		_tmp13_ = y;
		_tmp14_ = pixmap;
		_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = _tmp14_;
		_tmp15_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
	} else {
		gint _tmp16_;
		gint* _tmp17_;
		gint _tmp17__length1;
		gint _tmp17__length2;
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		guint _tmp29_;
		_tmp16_ = pixmap;
		_tmp17_ = self->priv->pixmaps;
		_tmp17__length1 = self->priv->pixmaps_length1;
		_tmp17__length2 = self->priv->pixmaps_length2;
		_tmp18_ = x;
		_tmp19_ = y;
		_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
		if (_tmp16_ > _tmp20_) {
			gint* _tmp21_;
			gint _tmp21__length1;
			gint _tmp21__length2;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			_tmp21_ = self->priv->pixmaps;
			_tmp21__length1 = self->priv->pixmaps_length1;
			_tmp21__length2 = self->priv->pixmaps_length2;
			_tmp22_ = x;
			_tmp23_ = y;
			_tmp24_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
			_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp24_ + 1;
		} else {
			gint* _tmp25_;
			gint _tmp25__length1;
			gint _tmp25__length2;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp25_ = self->priv->pixmaps;
			_tmp25__length1 = self->priv->pixmaps_length1;
			_tmp25__length2 = self->priv->pixmaps_length2;
			_tmp26_ = x;
			_tmp27_ = y;
			_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
			_tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_] = _tmp28_ - 1;
		}
		_tmp29_ = self->priv->animate_timeout;
		if (_tmp29_ == ((guint) 0)) {
			guint _tmp30_;
			_tmp30_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GAME_VIEW_PIXMAP_FLIP_DELAY, _game_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->animate_timeout = _tmp30_;
		}
	}
	_tmp31_ = game_view_get_board_x (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = x;
	_tmp34_ = self->priv->paving_size;
	_tmp35_ = game_view_get_board_y (self);
	_tmp36_ = _tmp35_;
	_tmp37_ = y;
	_tmp38_ = self->priv->paving_size;
	_tmp39_ = self->priv->tile_size;
	_tmp40_ = self->priv->tile_size;
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp32_ + (_tmp33_ * _tmp34_), _tmp36_ + (_tmp37_ * _tmp38_), _tmp39_, _tmp40_);
}


static gboolean game_view_animate_cb (GameView* self) {
	gboolean result = FALSE;
	gboolean animating = FALSE;
	gboolean _tmp25_;
	g_return_val_if_fail (self != NULL, FALSE);
	animating = FALSE;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Game* _tmp3_;
				Game* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = x;
				_tmp3_ = game_view_get_game (self);
				_tmp4_ = _tmp3_;
				_tmp5_ = game_get_size (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							Game* _tmp10_;
							Game* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							gint old = 0;
							gint* _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							gint _tmp15_;
							gint _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							gint _tmp19_;
							gint* _tmp20_;
							gint _tmp20__length1;
							gint _tmp20__length2;
							gint _tmp21_;
							gint _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = game_view_get_game (self);
							_tmp11_ = _tmp10_;
							_tmp12_ = game_get_size (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(_tmp9_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->pixmaps;
							_tmp14__length1 = self->priv->pixmaps_length1;
							_tmp14__length2 = self->priv->pixmaps_length2;
							_tmp15_ = x;
							_tmp16_ = y;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							old = _tmp17_;
							_tmp18_ = x;
							_tmp19_ = y;
							game_view_update_square (self, _tmp18_, _tmp19_);
							_tmp20_ = self->priv->pixmaps;
							_tmp20__length1 = self->priv->pixmaps_length1;
							_tmp20__length2 = self->priv->pixmaps_length2;
							_tmp21_ = x;
							_tmp22_ = y;
							_tmp23_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
							_tmp24_ = old;
							if (_tmp23_ != _tmp24_) {
								animating = TRUE;
							}
						}
					}
				}
			}
		}
	}
	_tmp25_ = animating;
	if (!_tmp25_) {
		self->priv->animate_timeout = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


static gint game_view_get_pixmap (GameView* self, Player color) {
	gint result = 0;
	Player _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = color;
	switch (_tmp0_) {
		default:
		case PLAYER_NONE:
		{
			result = 0;
			return result;
		}
		case PLAYER_DARK:
		{
			result = 1;
			return result;
		}
		case PLAYER_LIGHT:
		{
			result = 31;
			return result;
		}
	}
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_;
	guint _tmp2_;
	self = (GameView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->button;
	if (_tmp2_ == ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton* _tmp3_;
		guint _tmp4_;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->button;
		_tmp0_ = _tmp4_ == ((guint) GDK_BUTTON_SECONDARY);
	}
	if (_tmp0_) {
		gint x = 0;
		GdkEventButton* _tmp5_;
		gdouble _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint y = 0;
		GdkEventButton* _tmp10_;
		gdouble _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gint _tmp18_;
		_tmp5_ = event;
		_tmp6_ = _tmp5_->x;
		_tmp7_ = game_view_get_board_x (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->paving_size;
		x = ((gint) (_tmp6_ - _tmp8_)) / _tmp9_;
		_tmp10_ = event;
		_tmp11_ = _tmp10_->y;
		_tmp12_ = game_view_get_board_y (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->paving_size;
		y = ((gint) (_tmp11_ - _tmp13_)) / _tmp14_;
		_tmp18_ = x;
		if (_tmp18_ >= 0) {
			gint _tmp19_;
			Game* _tmp20_;
			Game* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp19_ = x;
			_tmp20_ = game_view_get_game (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = game_get_size (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp17_ = _tmp19_ < _tmp23_;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			gint _tmp24_;
			_tmp24_ = y;
			_tmp16_ = _tmp24_ >= 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			gint _tmp25_;
			Game* _tmp26_;
			Game* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			_tmp25_ = y;
			_tmp26_ = game_view_get_game (self);
			_tmp27_ = _tmp26_;
			_tmp28_ = game_get_size (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp15_ = _tmp25_ < _tmp29_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			self->priv->show_highlight = FALSE;
			gtk_widget_queue_draw ((GtkWidget*) self);
			_tmp30_ = x;
			self->priv->highlight_x = _tmp30_;
			_tmp31_ = y;
			self->priv->highlight_y = _tmp31_;
			_tmp32_ = x;
			_tmp33_ = y;
			g_signal_emit (self, game_view_signals[GAME_VIEW_MOVE_SIGNAL], 0, _tmp32_, _tmp33_);
		}
	}
	result = TRUE;
	return result;
}


static gboolean game_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	GameView * self;
	gboolean result = FALSE;
	gchar* key = NULL;
	GdkEventKey* _tmp0_;
	guint _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	Game* _tmp19_;
	Game* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	GQuark _tmp81_ = 0U;
	static GQuark _tmp80_label0 = 0;
	static GQuark _tmp80_label1 = 0;
	static GQuark _tmp80_label2 = 0;
	static GQuark _tmp80_label3 = 0;
	static GQuark _tmp80_label4 = 0;
	static GQuark _tmp80_label5 = 0;
	static GQuark _tmp80_label6 = 0;
	static GQuark _tmp80_label7 = 0;
	static GQuark _tmp80_label8 = 0;
	static GQuark _tmp80_label9 = 0;
	static GQuark _tmp80_label10 = 0;
	static GQuark _tmp80_label11 = 0;
	static GQuark _tmp80_label12 = 0;
	static GQuark _tmp80_label13 = 0;
	static GQuark _tmp80_label14 = 0;
	static GQuark _tmp80_label15 = 0;
	static GQuark _tmp80_label16 = 0;
	static GQuark _tmp80_label17 = 0;
	static GQuark _tmp80_label18 = 0;
	static GQuark _tmp80_label19 = 0;
	static GQuark _tmp80_label20 = 0;
	static GQuark _tmp80_label21 = 0;
	static GQuark _tmp80_label22 = 0;
	static GQuark _tmp80_label23 = 0;
	static GQuark _tmp80_label24 = 0;
	static GQuark _tmp80_label25 = 0;
	static GQuark _tmp80_label26 = 0;
	static GQuark _tmp80_label27 = 0;
	static GQuark _tmp80_label28 = 0;
	static GQuark _tmp80_label29 = 0;
	static GQuark _tmp80_label30 = 0;
	static GQuark _tmp80_label31 = 0;
	static GQuark _tmp80_label32 = 0;
	static GQuark _tmp80_label33 = 0;
	static GQuark _tmp80_label34 = 0;
	static GQuark _tmp80_label35 = 0;
	static GQuark _tmp80_label36 = 0;
	static GQuark _tmp80_label37 = 0;
	static GQuark _tmp80_label38 = 0;
	static GQuark _tmp80_label39 = 0;
	static GQuark _tmp80_label40 = 0;
	static GQuark _tmp80_label41 = 0;
	static GQuark _tmp80_label42 = 0;
	static GQuark _tmp80_label43 = 0;
	static GQuark _tmp80_label44 = 0;
	static GQuark _tmp80_label45 = 0;
	static GQuark _tmp80_label46 = 0;
	static GQuark _tmp80_label47 = 0;
	static GQuark _tmp80_label48 = 0;
	static GQuark _tmp80_label49 = 0;
	const gchar* _tmp106_;
	self = (GameView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	_tmp2_ = gdk_keyval_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	key = _tmp3_;
	_tmp5_ = self->priv->show_highlight;
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		_tmp8_ = key;
		if (g_strcmp0 (_tmp8_, "space") == 0) {
			_tmp7_ = TRUE;
		} else {
			const gchar* _tmp9_;
			_tmp9_ = key;
			_tmp7_ = g_strcmp0 (_tmp9_, "Return") == 0;
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			const gchar* _tmp10_;
			_tmp10_ = key;
			_tmp6_ = g_strcmp0 (_tmp10_, "KP_Enter") == 0;
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gint _tmp11_;
		gint _tmp12_;
		_tmp11_ = self->priv->highlight_x;
		_tmp12_ = self->priv->highlight_y;
		g_signal_emit (self, game_view_signals[GAME_VIEW_MOVE_SIGNAL], 0, _tmp11_, _tmp12_);
		result = TRUE;
		_g_free0 (key);
		return result;
	}
	_tmp19_ = game_view_get_game (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = game_get_size (_tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ <= 4) {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		const gchar* _tmp25_;
		_tmp25_ = key;
		if (g_strcmp0 (_tmp25_, "e") == 0) {
			_tmp24_ = TRUE;
		} else {
			const gchar* _tmp26_;
			_tmp26_ = key;
			_tmp24_ = g_strcmp0 (_tmp26_, "5") == 0;
		}
		if (_tmp24_) {
			_tmp23_ = TRUE;
		} else {
			const gchar* _tmp27_;
			_tmp27_ = key;
			_tmp23_ = g_strcmp0 (_tmp27_, "KP_5") == 0;
		}
		_tmp18_ = _tmp23_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		gboolean _tmp28_ = FALSE;
		Game* _tmp29_;
		Game* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp29_ = game_view_get_game (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = game_get_size (_tmp30_);
		_tmp32_ = _tmp31_;
		if (_tmp32_ <= 5) {
			gboolean _tmp33_ = FALSE;
			gboolean _tmp34_ = FALSE;
			const gchar* _tmp35_;
			_tmp35_ = key;
			if (g_strcmp0 (_tmp35_, "f") == 0) {
				_tmp34_ = TRUE;
			} else {
				const gchar* _tmp36_;
				_tmp36_ = key;
				_tmp34_ = g_strcmp0 (_tmp36_, "6") == 0;
			}
			if (_tmp34_) {
				_tmp33_ = TRUE;
			} else {
				const gchar* _tmp37_;
				_tmp37_ = key;
				_tmp33_ = g_strcmp0 (_tmp37_, "KP_6") == 0;
			}
			_tmp28_ = _tmp33_;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp17_ = _tmp28_;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		gboolean _tmp38_ = FALSE;
		Game* _tmp39_;
		Game* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		_tmp39_ = game_view_get_game (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = game_get_size (_tmp40_);
		_tmp42_ = _tmp41_;
		if (_tmp42_ <= 6) {
			gboolean _tmp43_ = FALSE;
			gboolean _tmp44_ = FALSE;
			const gchar* _tmp45_;
			_tmp45_ = key;
			if (g_strcmp0 (_tmp45_, "g") == 0) {
				_tmp44_ = TRUE;
			} else {
				const gchar* _tmp46_;
				_tmp46_ = key;
				_tmp44_ = g_strcmp0 (_tmp46_, "7") == 0;
			}
			if (_tmp44_) {
				_tmp43_ = TRUE;
			} else {
				const gchar* _tmp47_;
				_tmp47_ = key;
				_tmp43_ = g_strcmp0 (_tmp47_, "KP_7") == 0;
			}
			_tmp38_ = _tmp43_;
		} else {
			_tmp38_ = FALSE;
		}
		_tmp16_ = _tmp38_;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		gboolean _tmp48_ = FALSE;
		Game* _tmp49_;
		Game* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		_tmp49_ = game_view_get_game (self);
		_tmp50_ = _tmp49_;
		_tmp51_ = game_get_size (_tmp50_);
		_tmp52_ = _tmp51_;
		if (_tmp52_ <= 7) {
			gboolean _tmp53_ = FALSE;
			gboolean _tmp54_ = FALSE;
			const gchar* _tmp55_;
			_tmp55_ = key;
			if (g_strcmp0 (_tmp55_, "h") == 0) {
				_tmp54_ = TRUE;
			} else {
				const gchar* _tmp56_;
				_tmp56_ = key;
				_tmp54_ = g_strcmp0 (_tmp56_, "8") == 0;
			}
			if (_tmp54_) {
				_tmp53_ = TRUE;
			} else {
				const gchar* _tmp57_;
				_tmp57_ = key;
				_tmp53_ = g_strcmp0 (_tmp57_, "KP_8") == 0;
			}
			_tmp48_ = _tmp53_;
		} else {
			_tmp48_ = FALSE;
		}
		_tmp15_ = _tmp48_;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		gboolean _tmp58_ = FALSE;
		Game* _tmp59_;
		Game* _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		_tmp59_ = game_view_get_game (self);
		_tmp60_ = _tmp59_;
		_tmp61_ = game_get_size (_tmp60_);
		_tmp62_ = _tmp61_;
		if (_tmp62_ <= 8) {
			gboolean _tmp63_ = FALSE;
			gboolean _tmp64_ = FALSE;
			const gchar* _tmp65_;
			_tmp65_ = key;
			if (g_strcmp0 (_tmp65_, "i") == 0) {
				_tmp64_ = TRUE;
			} else {
				const gchar* _tmp66_;
				_tmp66_ = key;
				_tmp64_ = g_strcmp0 (_tmp66_, "9") == 0;
			}
			if (_tmp64_) {
				_tmp63_ = TRUE;
			} else {
				const gchar* _tmp67_;
				_tmp67_ = key;
				_tmp63_ = g_strcmp0 (_tmp67_, "KP_9") == 0;
			}
			_tmp58_ = _tmp63_;
		} else {
			_tmp58_ = FALSE;
		}
		_tmp14_ = _tmp58_;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp68_ = FALSE;
		Game* _tmp69_;
		Game* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		_tmp69_ = game_view_get_game (self);
		_tmp70_ = _tmp69_;
		_tmp71_ = game_get_size (_tmp70_);
		_tmp72_ = _tmp71_;
		if (_tmp72_ <= 9) {
			gboolean _tmp73_ = FALSE;
			gboolean _tmp74_ = FALSE;
			const gchar* _tmp75_;
			_tmp75_ = key;
			if (g_strcmp0 (_tmp75_, "j") == 0) {
				_tmp74_ = TRUE;
			} else {
				const gchar* _tmp76_;
				_tmp76_ = key;
				_tmp74_ = g_strcmp0 (_tmp76_, "0") == 0;
			}
			if (_tmp74_) {
				_tmp73_ = TRUE;
			} else {
				const gchar* _tmp77_;
				_tmp77_ = key;
				_tmp73_ = g_strcmp0 (_tmp77_, "KP_0") == 0;
			}
			_tmp68_ = _tmp73_;
		} else {
			_tmp68_ = FALSE;
		}
		_tmp13_ = _tmp68_;
	}
	if (_tmp13_) {
		result = FALSE;
		_g_free0 (key);
		return result;
	}
	_tmp78_ = key;
	_tmp79_ = _tmp78_;
	_tmp81_ = (NULL == _tmp79_) ? 0 : g_quark_from_string (_tmp79_);
	if ((_tmp81_ == ((0 != _tmp80_label0) ? _tmp80_label0 : (_tmp80_label0 = g_quark_from_static_string ("Left")))) || (_tmp81_ == ((0 != _tmp80_label1) ? _tmp80_label1 : (_tmp80_label1 = g_quark_from_static_string ("KP_Left"))))) {
		switch (0) {
			default:
			{
				gint _tmp82_;
				_tmp82_ = self->priv->highlight_x;
				if (_tmp82_ > 0) {
					gint _tmp83_;
					_tmp83_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp83_ - 1;
				}
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label2) ? _tmp80_label2 : (_tmp80_label2 = g_quark_from_static_string ("Right")))) || (_tmp81_ == ((0 != _tmp80_label3) ? _tmp80_label3 : (_tmp80_label3 = g_quark_from_static_string ("KP_Right"))))) {
		switch (0) {
			default:
			{
				gint _tmp84_;
				Game* _tmp85_;
				Game* _tmp86_;
				gint _tmp87_;
				gint _tmp88_;
				_tmp84_ = self->priv->highlight_x;
				_tmp85_ = game_view_get_game (self);
				_tmp86_ = _tmp85_;
				_tmp87_ = game_get_size (_tmp86_);
				_tmp88_ = _tmp87_;
				if (_tmp84_ < (_tmp88_ - 1)) {
					gint _tmp89_;
					_tmp89_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp89_ + 1;
				}
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label4) ? _tmp80_label4 : (_tmp80_label4 = g_quark_from_static_string ("Up")))) || (_tmp81_ == ((0 != _tmp80_label5) ? _tmp80_label5 : (_tmp80_label5 = g_quark_from_static_string ("KP_Up"))))) {
		switch (0) {
			default:
			{
				gint _tmp90_;
				_tmp90_ = self->priv->highlight_y;
				if (_tmp90_ > 0) {
					gint _tmp91_;
					_tmp91_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp91_ - 1;
				}
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label6) ? _tmp80_label6 : (_tmp80_label6 = g_quark_from_static_string ("Down")))) || (_tmp81_ == ((0 != _tmp80_label7) ? _tmp80_label7 : (_tmp80_label7 = g_quark_from_static_string ("KP_Down"))))) {
		switch (0) {
			default:
			{
				gint _tmp92_;
				Game* _tmp93_;
				Game* _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				_tmp92_ = self->priv->highlight_y;
				_tmp93_ = game_view_get_game (self);
				_tmp94_ = _tmp93_;
				_tmp95_ = game_get_size (_tmp94_);
				_tmp96_ = _tmp95_;
				if (_tmp92_ < (_tmp96_ - 1)) {
					gint _tmp97_;
					_tmp97_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp97_ + 1;
				}
				break;
			}
		}
	} else if ((((_tmp81_ == ((0 != _tmp80_label8) ? _tmp80_label8 : (_tmp80_label8 = g_quark_from_static_string ("space")))) || (_tmp81_ == ((0 != _tmp80_label9) ? _tmp80_label9 : (_tmp80_label9 = g_quark_from_static_string ("Return"))))) || (_tmp81_ == ((0 != _tmp80_label10) ? _tmp80_label10 : (_tmp80_label10 = g_quark_from_static_string ("KP_Enter"))))) || (_tmp81_ == ((0 != _tmp80_label11) ? _tmp80_label11 : (_tmp80_label11 = g_quark_from_static_string ("Escape"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label12) ? _tmp80_label12 : (_tmp80_label12 = g_quark_from_static_string ("a")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 0;
				break;
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label13) ? _tmp80_label13 : (_tmp80_label13 = g_quark_from_static_string ("b")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 1;
				break;
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label14) ? _tmp80_label14 : (_tmp80_label14 = g_quark_from_static_string ("c")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 2;
				break;
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label15) ? _tmp80_label15 : (_tmp80_label15 = g_quark_from_static_string ("d")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 3;
				break;
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label16) ? _tmp80_label16 : (_tmp80_label16 = g_quark_from_static_string ("e")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 4;
				break;
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label17) ? _tmp80_label17 : (_tmp80_label17 = g_quark_from_static_string ("f")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 5;
				break;
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label18) ? _tmp80_label18 : (_tmp80_label18 = g_quark_from_static_string ("g")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 6;
				break;
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label19) ? _tmp80_label19 : (_tmp80_label19 = g_quark_from_static_string ("h")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 7;
				break;
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label20) ? _tmp80_label20 : (_tmp80_label20 = g_quark_from_static_string ("i")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 8;
				break;
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label21) ? _tmp80_label21 : (_tmp80_label21 = g_quark_from_static_string ("j")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 9;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label22) ? _tmp80_label22 : (_tmp80_label22 = g_quark_from_static_string ("1")))) || (_tmp81_ == ((0 != _tmp80_label23) ? _tmp80_label23 : (_tmp80_label23 = g_quark_from_static_string ("KP_1"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 0;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label24) ? _tmp80_label24 : (_tmp80_label24 = g_quark_from_static_string ("2")))) || (_tmp81_ == ((0 != _tmp80_label25) ? _tmp80_label25 : (_tmp80_label25 = g_quark_from_static_string ("KP_2"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 1;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label26) ? _tmp80_label26 : (_tmp80_label26 = g_quark_from_static_string ("3")))) || (_tmp81_ == ((0 != _tmp80_label27) ? _tmp80_label27 : (_tmp80_label27 = g_quark_from_static_string ("KP_3"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 2;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label28) ? _tmp80_label28 : (_tmp80_label28 = g_quark_from_static_string ("4")))) || (_tmp81_ == ((0 != _tmp80_label29) ? _tmp80_label29 : (_tmp80_label29 = g_quark_from_static_string ("KP_4"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 3;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label30) ? _tmp80_label30 : (_tmp80_label30 = g_quark_from_static_string ("5")))) || (_tmp81_ == ((0 != _tmp80_label31) ? _tmp80_label31 : (_tmp80_label31 = g_quark_from_static_string ("KP_5"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 4;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label32) ? _tmp80_label32 : (_tmp80_label32 = g_quark_from_static_string ("6")))) || (_tmp81_ == ((0 != _tmp80_label33) ? _tmp80_label33 : (_tmp80_label33 = g_quark_from_static_string ("KP_6"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 5;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label34) ? _tmp80_label34 : (_tmp80_label34 = g_quark_from_static_string ("7")))) || (_tmp81_ == ((0 != _tmp80_label35) ? _tmp80_label35 : (_tmp80_label35 = g_quark_from_static_string ("KP_7"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 6;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label36) ? _tmp80_label36 : (_tmp80_label36 = g_quark_from_static_string ("8")))) || (_tmp81_ == ((0 != _tmp80_label37) ? _tmp80_label37 : (_tmp80_label37 = g_quark_from_static_string ("KP_8"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 7;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label38) ? _tmp80_label38 : (_tmp80_label38 = g_quark_from_static_string ("9")))) || (_tmp81_ == ((0 != _tmp80_label39) ? _tmp80_label39 : (_tmp80_label39 = g_quark_from_static_string ("KP_9"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 8;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label40) ? _tmp80_label40 : (_tmp80_label40 = g_quark_from_static_string ("0")))) || (_tmp81_ == ((0 != _tmp80_label41) ? _tmp80_label41 : (_tmp80_label41 = g_quark_from_static_string ("KP_0"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 9;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label42) ? _tmp80_label42 : (_tmp80_label42 = g_quark_from_static_string ("Home")))) || (_tmp81_ == ((0 != _tmp80_label43) ? _tmp80_label43 : (_tmp80_label43 = g_quark_from_static_string ("KP_Home"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 0;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label44) ? _tmp80_label44 : (_tmp80_label44 = g_quark_from_static_string ("End")))) || (_tmp81_ == ((0 != _tmp80_label45) ? _tmp80_label45 : (_tmp80_label45 = g_quark_from_static_string ("KP_End"))))) {
		switch (0) {
			default:
			{
				Game* _tmp98_;
				Game* _tmp99_;
				gint _tmp100_;
				gint _tmp101_;
				_tmp98_ = game_view_get_game (self);
				_tmp99_ = _tmp98_;
				_tmp100_ = game_get_size (_tmp99_);
				_tmp101_ = _tmp100_;
				self->priv->highlight_x = _tmp101_ - 1;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label46) ? _tmp80_label46 : (_tmp80_label46 = g_quark_from_static_string ("Page_Up")))) || (_tmp81_ == ((0 != _tmp80_label47) ? _tmp80_label47 : (_tmp80_label47 = g_quark_from_static_string ("KP_Page_Up"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 0;
				break;
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label48) ? _tmp80_label48 : (_tmp80_label48 = g_quark_from_static_string ("Page_Down")))) || (_tmp81_ == ((0 != _tmp80_label49) ? _tmp80_label49 : (_tmp80_label49 = g_quark_from_static_string ("KP_Next"))))) {
		switch (0) {
			default:
			{
				Game* _tmp102_;
				Game* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				_tmp102_ = game_view_get_game (self);
				_tmp103_ = _tmp102_;
				_tmp104_ = game_get_size (_tmp103_);
				_tmp105_ = _tmp104_;
				self->priv->highlight_y = _tmp105_ - 1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (key);
				return result;
			}
		}
	}
	_tmp106_ = key;
	if (g_strcmp0 (_tmp106_, "Escape") == 0) {
		self->priv->show_highlight = FALSE;
	} else {
		gboolean _tmp107_;
		_tmp107_ = self->priv->show_highlight;
		if (_tmp107_) {
			self->priv->highlight_state = GAME_VIEW_HIGHLIGHT_MAX;
		} else {
			self->priv->show_highlight = TRUE;
		}
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	_g_free0 (key);
	return result;
}


static gboolean game_view_draw_scoreboard (GameView* self, cairo_t* cr) {
	gboolean result = FALSE;
	gint height = 0;
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	gint _tmp2_;
	gint width = 0;
	GtkDrawingArea* _tmp3_;
	GtkDrawingArea* _tmp4_;
	gint _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	cairo_t* _tmp13_;
	gint _tmp14_;
	cairo_t* _tmp15_;
	gint _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_surface_t* surface = NULL;
	cairo_t* _tmp22_;
	cairo_surface_t* _tmp23_;
	cairo_surface_t* _tmp24_;
	cairo_t* c = NULL;
	cairo_t* _tmp25_;
	cairo_pattern_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_matrix_t matrix = {0};
	cairo_pattern_t* _tmp28_;
	cairo_matrix_t _tmp29_;
	cairo_t* _tmp30_;
	cairo_pattern_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	cairo_pattern_t* _tmp34_;
	cairo_matrix_t _tmp35_;
	cairo_t* _tmp36_;
	cairo_pattern_t* _tmp37_;
	cairo_t* _tmp38_;
	cairo_t* _tmp39_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = game_view_get_scoreboard (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp1_);
	height = _tmp2_;
	_tmp3_ = game_view_get_scoreboard (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp4_);
	width = _tmp5_;
	_tmp6_ = cr;
	cairo_set_line_cap (_tmp6_, CAIRO_LINE_CAP_ROUND);
	_tmp7_ = cr;
	cairo_set_line_join (_tmp7_, CAIRO_LINE_JOIN_ROUND);
	_tmp8_ = cr;
	cairo_save (_tmp8_);
	_tmp9_ = cr;
	_tmp10_ = self->priv->mark_red;
	_tmp11_ = self->priv->mark_green;
	_tmp12_ = self->priv->mark_blue;
	cairo_set_source_rgba (_tmp9_, _tmp10_, _tmp11_, _tmp12_, 1.0);
	_tmp13_ = cr;
	_tmp14_ = self->priv->mark_width;
	cairo_set_line_width (_tmp13_, (gdouble) _tmp14_);
	_tmp15_ = cr;
	_tmp16_ = self->priv->current_player_number;
	cairo_translate (_tmp15_, (gdouble) 0, (_tmp16_ * height) / 2.0);
	_tmp17_ = cr;
	cairo_move_to (_tmp17_, height / 4.0, height / 8.0);
	_tmp18_ = cr;
	cairo_line_to (_tmp18_, width - ((5.0 * height) / 8.0), height / 4.0);
	_tmp19_ = cr;
	cairo_line_to (_tmp19_, height / 4.0, (3.0 * height) / 8.0);
	_tmp20_ = cr;
	cairo_stroke (_tmp20_);
	_tmp21_ = cr;
	cairo_restore (_tmp21_);
	_tmp22_ = cr;
	_tmp23_ = cairo_get_target (_tmp22_);
	_tmp24_ = cairo_surface_create_similar (_tmp23_, CAIRO_CONTENT_COLOR_ALPHA, height * 4, height * 2);
	surface = _tmp24_;
	_tmp25_ = cairo_create (surface);
	c = _tmp25_;
	game_view_load_image (self, c, height * 4, height * 2);
	_tmp26_ = cairo_pattern_create_for_surface (surface);
	_cairo_pattern_destroy0 (self->priv->scoreboard_tiles_pattern);
	self->priv->scoreboard_tiles_pattern = _tmp26_;
	_tmp27_ = cr;
	cairo_translate (_tmp27_, width - (height / 2.0), (gdouble) 0);
	cairo_matrix_init_identity (&matrix);
	cairo_matrix_translate (&matrix, height / 2.0, (gdouble) 0);
	_tmp28_ = self->priv->scoreboard_tiles_pattern;
	_tmp29_ = matrix;
	cairo_pattern_set_matrix (_tmp28_, &_tmp29_);
	_tmp30_ = cr;
	_tmp31_ = self->priv->scoreboard_tiles_pattern;
	cairo_set_source (_tmp30_, _tmp31_);
	_tmp32_ = cr;
	cairo_rectangle (_tmp32_, (gdouble) 0, (gdouble) 0, height / 2.0, height / 2.0);
	_tmp33_ = cr;
	cairo_fill (_tmp33_);
	cairo_matrix_translate (&matrix, (gdouble) (3 * height), (gdouble) height);
	_tmp34_ = self->priv->scoreboard_tiles_pattern;
	_tmp35_ = matrix;
	cairo_pattern_set_matrix (_tmp34_, &_tmp35_);
	_tmp36_ = cr;
	_tmp37_ = self->priv->scoreboard_tiles_pattern;
	cairo_set_source (_tmp36_, _tmp37_);
	_tmp38_ = cr;
	cairo_rectangle (_tmp38_, (gdouble) 0, height / 2.0, height / 2.0, height / 2.0);
	_tmp39_ = cr;
	cairo_fill (_tmp39_);
	result = TRUE;
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	return result;
}


void game_view_update_scoreboard (GameView* self) {
	gint _tmp0_ = 0;
	Game* _tmp1_;
	Game* _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	GtkDrawingArea* _tmp5_;
	GtkDrawingArea* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == PLAYER_DARK) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	self->priv->current_player_number = _tmp0_;
	_tmp5_ = game_view_get_scoreboard (self);
	_tmp6_ = _tmp5_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
}


static GtkDrawingArea* game_view_get_scoreboard (GameView* self) {
	GtkDrawingArea* result;
	GtkDrawingArea* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scoreboard;
	result = _tmp0_;
	return result;
}


static gboolean _game_view_draw_scoreboard_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = game_view_draw_scoreboard ((GameView*) self, cr);
	return result;
}


void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value) {
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	GtkDrawingArea* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_scoreboard);
	self->priv->_scoreboard = _tmp1_;
	_tmp2_ = self->priv->_scoreboard;
	g_signal_connect_object ((GtkWidget*) _tmp2_, "draw", (GCallback) _game_view_draw_scoreboard_gtk_widget_draw, self, 0);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_SCOREBOARD_PROPERTY]);
}


const gchar* game_view_get_sound_flip (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sound_flip;
	result = _tmp0_;
	return result;
}


static void game_view_set_sound_flip (GameView* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, game_view_get_sound_flip (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_sound_flip);
		self->priv->_sound_flip = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_SOUND_FLIP_PROPERTY]);
	}
}


const gchar* game_view_get_sound_gameover (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sound_gameover;
	result = _tmp0_;
	return result;
}


static void game_view_set_sound_gameover (GameView* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, game_view_get_sound_gameover (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_sound_gameover);
		self->priv->_sound_gameover = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_SOUND_GAMEOVER_PROPERTY]);
	}
}


static gint game_view_get_board_x (GameView* self) {
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = self->priv->board_size;
	result = (_tmp0_ - _tmp1_) / 2;
	return result;
}


static gint game_view_get_board_y (GameView* self) {
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = self->priv->board_size;
	result = (_tmp0_ - _tmp1_) / 2;
	return result;
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, Player new_color, gpointer self) {
	game_view_square_changed_cb ((GameView*) self, x, y, new_color);
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	Game* _tmp8_;
	Game* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint* _tmp12_;
	Game* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp3_;
	_tmp4_ = game_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = game_view_get_game (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = game_get_size (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_new0 (gint, _tmp7_ * _tmp11_);
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
	self->priv->pixmaps = _tmp12_;
	self->priv->pixmaps_length1 = _tmp7_;
	self->priv->pixmaps_length2 = _tmp11_;
	_tmp13_ = self->priv->_game;
	if (_tmp13_ != NULL) {
		Game* _tmp14_;
		_tmp14_ = self->priv->_game;
		g_signal_connect_object (_tmp14_, "square-changed", (GCallback) _game_view_square_changed_cb_game_square_changed, self, 0);
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					gint _tmp17_;
					Game* _tmp18_;
					Game* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					if (!_tmp15_) {
						gint _tmp16_;
						_tmp16_ = x;
						x = _tmp16_ + 1;
					}
					_tmp15_ = FALSE;
					_tmp17_ = x;
					_tmp18_ = game_view_get_game (self);
					_tmp19_ = _tmp18_;
					_tmp20_ = game_get_size (_tmp19_);
					_tmp21_ = _tmp20_;
					if (!(_tmp17_ < _tmp21_)) {
						break;
					}
					{
						gint y = 0;
						y = 0;
						{
							gboolean _tmp22_ = FALSE;
							_tmp22_ = TRUE;
							while (TRUE) {
								gint _tmp24_;
								Game* _tmp25_;
								Game* _tmp26_;
								gint _tmp27_;
								gint _tmp28_;
								gint* _tmp29_;
								gint _tmp29__length1;
								gint _tmp29__length2;
								gint _tmp30_;
								gint _tmp31_;
								Game* _tmp32_;
								gint _tmp33_;
								gint _tmp34_;
								Player _tmp35_;
								gint _tmp36_;
								gint _tmp37_;
								if (!_tmp22_) {
									gint _tmp23_;
									_tmp23_ = y;
									y = _tmp23_ + 1;
								}
								_tmp22_ = FALSE;
								_tmp24_ = y;
								_tmp25_ = game_view_get_game (self);
								_tmp26_ = _tmp25_;
								_tmp27_ = game_get_size (_tmp26_);
								_tmp28_ = _tmp27_;
								if (!(_tmp24_ < _tmp28_)) {
									break;
								}
								_tmp29_ = self->priv->pixmaps;
								_tmp29__length1 = self->priv->pixmaps_length1;
								_tmp29__length2 = self->priv->pixmaps_length2;
								_tmp30_ = x;
								_tmp31_ = y;
								_tmp32_ = self->priv->_game;
								_tmp33_ = x;
								_tmp34_ = y;
								_tmp35_ = game_get_owner (_tmp32_, _tmp33_, _tmp34_);
								_tmp36_ = game_view_get_pixmap (self, _tmp35_);
								_tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_] = _tmp36_;
								_tmp37_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
							}
						}
					}
				}
			}
		}
	}
	self->priv->show_highlight = FALSE;
	self->priv->highlight_x = 3;
	self->priv->highlight_y = 3;
	self->priv->highlight_state = 0;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_GAME_PROPERTY]);
}


const gchar* game_view_get_theme (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}


void game_view_set_theme (GameView* self, const gchar* value) {
	GKeyFile* key = NULL;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	GKeyFile* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	GtkDrawingArea* _tmp19_;
	GtkDrawingArea* _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	key = _tmp0_;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp1_, "default") == 0) {
		game_view_set_default_theme (self, &key);
	} else {
		{
			gchar* key_path = NULL;
			gchar* _tmp2_;
			gchar* filepath = NULL;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp10_;
			GKeyFile* _tmp12_;
			const gchar* _tmp13_;
			_tmp2_ = g_build_filename (DATA_DIRECTORY, "themes", "key", NULL);
			key_path = _tmp2_;
			_tmp3_ = key_path;
			_tmp4_ = value;
			_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
			filepath = _tmp5_;
			_tmp6_ = filepath;
			_tmp7_ = g_path_get_dirname (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = key_path;
			_tmp10_ = g_strcmp0 (_tmp8_, _tmp9_) != 0;
			_g_free0 (_tmp8_);
			if (_tmp10_) {
				GError* _tmp11_;
				_tmp11_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Theme file is not in the \"key\" directory.");
				_inner_error_ = _tmp11_;
				_g_free0 (filepath);
				_g_free0 (key_path);
				goto __catch4_g_error;
			}
			_tmp12_ = key;
			_tmp13_ = filepath;
			g_key_file_load_from_file (_tmp12_, _tmp13_, G_KEY_FILE_NONE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (filepath);
				_g_free0 (key_path);
				goto __catch4_g_error;
			}
			_g_free0 (filepath);
			_g_free0 (key_path);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_warning ("game-view.vala:149: Failed to load theme: %s", _tmp15_);
			game_view_set_default_theme (self, &key);
			value = "default";
			_g_error_free0 (e);
		}
		__finally4:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_key_file_unref0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = key;
	game_view_load_theme (self, _tmp16_);
	_tmp17_ = value;
	_tmp18_ = g_strdup (_tmp17_);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp18_;
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	_tmp19_ = game_view_get_scoreboard (self);
	_tmp20_ = _tmp19_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp20_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_key_file_unref0 (key);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_THEME_PROPERTY]);
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) game_view_real_draw;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) game_view_real_button_press_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget *, GdkEventKey*)) game_view_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SCOREBOARD_PROPERTY, game_view_properties[GAME_VIEW_SCOREBOARD_PROPERTY] = g_param_spec_object ("scoreboard", "scoreboard", "scoreboard", gtk_drawing_area_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SOUND_FLIP_PROPERTY, game_view_properties[GAME_VIEW_SOUND_FLIP_PROPERTY] = g_param_spec_string ("sound-flip", "sound-flip", "sound-flip", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SOUND_GAMEOVER_PROPERTY, game_view_properties[GAME_VIEW_SOUND_GAMEOVER_PROPERTY] = g_param_spec_string ("sound-gameover", "sound-gameover", "sound-gameover", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME_PROPERTY, game_view_properties[GAME_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME_PROPERTY, game_view_properties[GAME_VIEW_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	game_view_signals[GAME_VIEW_MOVE_SIGNAL] = g_signal_new ("move", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->background_red = 0.2;
	self->priv->background_green = 0.6;
	self->priv->background_blue = 0.4;
	self->priv->background_radius = 0;
	self->priv->mark_red = 0.2;
	self->priv->mark_green = 0.6;
	self->priv->mark_blue = 0.4;
	self->priv->mark_width = 2;
	self->priv->border_red = 0.1;
	self->priv->border_green = 0.1;
	self->priv->border_blue = 0.1;
	self->priv->border_width = 3;
	self->priv->spacing_red = 0.1;
	self->priv->spacing_green = 0.3;
	self->priv->spacing_blue = 0.2;
	self->priv->spacing_width = 2;
	self->priv->highlight_red = 0.1;
	self->priv->highlight_green = 0.3;
	self->priv->highlight_blue = 0.2;
	self->priv->highlight_alpha = 0.4;
	self->priv->render_size = (guint) 0;
	self->priv->tiles_pattern = NULL;
	self->priv->scoreboard_tiles_pattern = NULL;
	self->priv->animate_timeout = (guint) 0;
	self->priv->current_player_number = 0;
	self->priv->flip_final_result_now = FALSE;
	self->priv->_game = NULL;
	self->priv->_theme = NULL;
}


static void game_view_finalize (GObject * obj) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->_scoreboard);
	_g_free0 (self->priv->pieces_file);
	_g_free0 (self->priv->_sound_flip);
	_g_free0 (self->priv->_sound_gameover);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	_cairo_pattern_destroy0 (self->priv->scoreboard_tiles_pattern);
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
	_g_object_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_SCOREBOARD_PROPERTY:
		g_value_set_object (value, game_view_get_scoreboard (self));
		break;
		case GAME_VIEW_SOUND_FLIP_PROPERTY:
		g_value_set_string (value, game_view_get_sound_flip (self));
		break;
		case GAME_VIEW_SOUND_GAMEOVER_PROPERTY:
		g_value_set_string (value, game_view_get_sound_gameover (self));
		break;
		case GAME_VIEW_GAME_PROPERTY:
		g_value_set_object (value, game_view_get_game (self));
		break;
		case GAME_VIEW_THEME_PROPERTY:
		g_value_set_string (value, game_view_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_SCOREBOARD_PROPERTY:
		game_view_set_scoreboard (self, g_value_get_object (value));
		break;
		case GAME_VIEW_SOUND_FLIP_PROPERTY:
		game_view_set_sound_flip (self, g_value_get_string (value));
		break;
		case GAME_VIEW_SOUND_GAMEOVER_PROPERTY:
		game_view_set_sound_gameover (self, g_value_get_string (value));
		break;
		case GAME_VIEW_GAME_PROPERTY:
		game_view_set_game (self, g_value_get_object (value));
		break;
		case GAME_VIEW_THEME_PROPERTY:
		game_view_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



