/* rygel-default-player-controller.c generated by valac 0.27.1.26-9b1a5, the Vala compiler
 * generated from rygel-default-player-controller.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2014 Atlantic PuffinPack AB.
 *
 * Author: Richard Röjfors <richard@puffinpack.se>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <float.h>
#include <math.h>
#include <rygel-core.h>


#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerIface))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerIface RygelPlayerControllerIface;

#define RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER (rygel_default_player_controller_get_type ())
#define RYGEL_DEFAULT_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerController))
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerControllerClass))
#define RYGEL_IS_DEFAULT_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER))
#define RYGEL_IS_DEFAULT_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER))
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerControllerClass))

typedef struct _RygelDefaultPlayerController RygelDefaultPlayerController;
typedef struct _RygelDefaultPlayerControllerClass RygelDefaultPlayerControllerClass;
typedef struct _RygelDefaultPlayerControllerPrivate RygelDefaultPlayerControllerPrivate;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelPlayerControllerIface {
	GTypeInterface parent_iface;
	gboolean (*next) (RygelPlayerController* self);
	gboolean (*previous) (RygelPlayerController* self);
	void (*set_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	void (*set_next_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_next_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	gboolean (*is_play_mode_valid) (RygelPlayerController* self, const gchar* play_mode);
	const gchar* (*get_playback_state) (RygelPlayerController* self);
	void (*set_playback_state) (RygelPlayerController* self, const gchar* value);
	guint (*get_n_tracks) (RygelPlayerController* self);
	void (*set_n_tracks) (RygelPlayerController* self, guint value);
	guint (*get_track) (RygelPlayerController* self);
	void (*set_track) (RygelPlayerController* self, guint value);
	gchar* (*get_uri) (RygelPlayerController* self);
	void (*set_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_metadata) (RygelPlayerController* self);
	void (*set_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_uri) (RygelPlayerController* self);
	void (*set_track_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_metadata) (RygelPlayerController* self);
	void (*set_track_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_uri) (RygelPlayerController* self);
	void (*set_next_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_metadata) (RygelPlayerController* self);
	void (*set_next_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_current_transport_actions) (RygelPlayerController* self);
	const gchar* (*get_play_mode) (RygelPlayerController* self);
	void (*set_play_mode) (RygelPlayerController* self, const gchar* value);
};

struct _RygelDefaultPlayerController {
	GObject parent_instance;
	RygelDefaultPlayerControllerPrivate * priv;
};

struct _RygelDefaultPlayerControllerClass {
	GObjectClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gboolean (*seek_bytes) (RygelMediaPlayer* self, gint64 bytes);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_size) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gboolean (*get_can_seek_bytes) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
	gint64 (*get_byte_position) (RygelMediaPlayer* self);
};

struct _RygelDefaultPlayerControllerPrivate {
	RygelMediaPlayer* _player;
	gchar* _protocol_info;
	gchar* _uri;
	gchar* _metadata;
	gchar* _next_uri;
	gchar* _next_metadata;
	GList* playlist;
	guint timeout_id;
	guint default_image_timeout;
	RygelConfiguration* config;
	gchar* next_features;
	gchar* next_mime;
	GUPnPMediaCollection* next_collection;
	guint _n_tracks;
	guint _track;
	gchar* _playback_state;
	gchar* _play_mode;
};


static gpointer rygel_default_player_controller_parent_class = NULL;
static RygelPlayerControllerIface* rygel_default_player_controller_rygel_player_controller_parent_iface = NULL;

GType rygel_player_controller_get_type (void) G_GNUC_CONST;
GType rygel_default_player_controller_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerControllerPrivate))
enum  {
	RYGEL_DEFAULT_PLAYER_CONTROLLER_DUMMY_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYER,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_PROTOCOL_INFO,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYBACK_STATE,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_N_TRACKS,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_URI,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_METADATA,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_URI,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_METADATA,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_URI,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_METADATA,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAY_MODE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT 15
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_CONFIG_SECTION "Renderer"
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_TIMEOUT_KEY "image-timeout"
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_DIDL_FRAME_TEMPLATE "<DIDL-Lite " "xmlns:dc=\"http://purl.org/dc/elements/1.1/\" " "xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\" " "xmlns:dlna=\"urn:schemas-dlna-org:metadata-1-0/\" " "xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\">" "%s</DIDL-Lite>"
RygelDefaultPlayerController* rygel_default_player_controller_new (RygelMediaPlayer* player, const gchar* protocol_info);
RygelDefaultPlayerController* rygel_default_player_controller_construct (GType object_type, RygelMediaPlayer* player, const gchar* protocol_info);
static void rygel_default_player_controller_real_constructed (GObject* base);
static RygelMediaPlayer* rygel_default_player_controller_get_player (RygelDefaultPlayerController* self);
static void rygel_default_player_controller_notify_state_cb (RygelDefaultPlayerController* self, GObject* player, GParamSpec* p);
static void _rygel_default_player_controller_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_default_player_controller_notify_uri_cb (RygelDefaultPlayerController* self, GObject* player, GParamSpec* p);
static void _rygel_default_player_controller_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_default_player_controller_notify_metadata_cb (RygelDefaultPlayerController* self, GObject* player, GParamSpec* p);
static void _rygel_default_player_controller_notify_metadata_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_default_player_controller_on_setting_changed (RygelDefaultPlayerController* self, const gchar* section, const gchar* key);
static void _rygel_default_player_controller_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self);
static gboolean rygel_default_player_controller_real_next (RygelPlayerController* base);
guint rygel_player_controller_get_track (RygelPlayerController* self);
guint rygel_player_controller_get_n_tracks (RygelPlayerController* self);
void rygel_player_controller_set_track (RygelPlayerController* self, guint value);
gchar* rygel_player_controller_get_next_uri (RygelPlayerController* self);
void rygel_player_controller_set_playlist_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
gchar* rygel_player_controller_get_next_metadata (RygelPlayerController* self);
void rygel_player_controller_set_single_play_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
void rygel_player_controller_set_next_uri (RygelPlayerController* self, const gchar* value);
void rygel_player_controller_set_next_metadata (RygelPlayerController* self, const gchar* value);
static gboolean rygel_default_player_controller_real_previous (RygelPlayerController* base);
static void rygel_default_player_controller_real_set_single_play_uri (RygelPlayerController* base, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
gchar* rygel_player_controller_unescape (RygelPlayerController* self, const gchar* input);
void rygel_player_controller_set_metadata (RygelPlayerController* self, const gchar* value);
void rygel_player_controller_set_uri (RygelPlayerController* self, const gchar* value);
void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value);
void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_player_controller_get_metadata (RygelPlayerController* self);
void rygel_player_controller_set_track_metadata (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_uri (RygelPlayerController* self);
void rygel_player_controller_set_track_uri (RygelPlayerController* self, const gchar* value);
void rygel_player_controller_set_n_tracks (RygelPlayerController* self, guint value);
static void rygel_default_player_controller_real_set_playlist_uri (RygelPlayerController* base, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
static void rygel_default_player_controller_apply_track (RygelDefaultPlayerController* self);
static void rygel_default_player_controller_real_set_next_single_play_uri (RygelPlayerController* base, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
static void rygel_default_player_controller_real_set_next_playlist_uri (RygelPlayerController* base, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
static gboolean ___lambda5_ (RygelDefaultPlayerController* self);
gboolean rygel_player_controller_next (RygelPlayerController* self);
static void rygel_default_player_controller_reset (RygelDefaultPlayerController* self);
static gboolean ____lambda5__gsource_func (gpointer self);
static gboolean rygel_default_player_controller_real_is_play_mode_valid (RygelPlayerController* base, const gchar* play_mode);
static const gchar* rygel_default_player_controller_get_protocol_info (RygelDefaultPlayerController* self);
const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self);
static void rygel_default_player_controller_setup_image_timeouts (RygelDefaultPlayerController* self, glong lifetime);
void rygel_player_controller_set_playback_state (RygelPlayerController* self, const gchar* value);
static gboolean __lambda6_ (RygelDefaultPlayerController* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static void rygel_default_player_controller_set_player (RygelDefaultPlayerController* self, RygelMediaPlayer* value);
static void rygel_default_player_controller_set_protocol_info (RygelDefaultPlayerController* self, const gchar* value);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self);
void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value);
gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self);
gboolean rygel_media_player_get_can_seek_bytes (RygelMediaPlayer* self);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1);
static void rygel_default_player_controller_finalize (GObject* obj);
gchar* rygel_player_controller_get_track_uri (RygelPlayerController* self);
gchar* rygel_player_controller_get_track_metadata (RygelPlayerController* self);
gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self);
const gchar* rygel_player_controller_get_play_mode (RygelPlayerController* self);
static void _vala_rygel_default_player_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_player_controller_set_play_mode (RygelPlayerController* self, const gchar* value);
static void _vala_rygel_default_player_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


RygelDefaultPlayerController* rygel_default_player_controller_construct (GType object_type, RygelMediaPlayer* player, const gchar* protocol_info) {
	RygelDefaultPlayerController * self = NULL;
	RygelMediaPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (player != NULL, NULL);
	g_return_val_if_fail (protocol_info != NULL, NULL);
	_tmp0_ = player;
	_tmp1_ = protocol_info;
	self = (RygelDefaultPlayerController*) g_object_new (object_type, "player", _tmp0_, "protocol-info", _tmp1_, NULL);
	return self;
}


RygelDefaultPlayerController* rygel_default_player_controller_new (RygelMediaPlayer* player, const gchar* protocol_info) {
	return rygel_default_player_controller_construct (RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, player, protocol_info);
}


static void _rygel_default_player_controller_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_default_player_controller_notify_state_cb ((RygelDefaultPlayerController*) self, _sender, pspec);
}


static void _rygel_default_player_controller_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_default_player_controller_notify_uri_cb ((RygelDefaultPlayerController*) self, _sender, pspec);
}


static void _rygel_default_player_controller_notify_metadata_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_default_player_controller_notify_metadata_cb ((RygelDefaultPlayerController*) self, _sender, pspec);
}


static void _rygel_default_player_controller_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self) {
	rygel_default_player_controller_on_setting_changed ((RygelDefaultPlayerController*) self, section, key);
}


static void rygel_default_player_controller_real_constructed (GObject* base) {
	RygelDefaultPlayerController * self;
	RygelMediaPlayer* _tmp0_ = NULL;
	RygelMediaPlayer* _tmp1_ = NULL;
	RygelMediaPlayer* _tmp2_ = NULL;
	RygelMetaConfig* _tmp3_ = NULL;
	RygelConfiguration* _tmp4_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	G_OBJECT_CLASS (rygel_default_player_controller_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = self->priv->_player;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::playback-state", (GCallback) _rygel_default_player_controller_notify_state_cb_g_object_notify, self, 0);
	_tmp1_ = self->priv->_player;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::uri", (GCallback) _rygel_default_player_controller_notify_uri_cb_g_object_notify, self, 0);
	_tmp2_ = self->priv->_player;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::metadata", (GCallback) _rygel_default_player_controller_notify_metadata_cb_g_object_notify, self, 0);
	_tmp3_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp3_;
	_tmp4_ = self->priv->config;
	g_signal_connect_object (_tmp4_, "setting-changed", (GCallback) _rygel_default_player_controller_on_setting_changed_rygel_configuration_setting_changed, self, 0);
	self->priv->default_image_timeout = (guint) RYGEL_DEFAULT_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT;
	rygel_default_player_controller_on_setting_changed (self, RYGEL_DEFAULT_PLAYER_CONTROLLER_CONFIG_SECTION, RYGEL_DEFAULT_PLAYER_CONTROLLER_TIMEOUT_KEY);
}


static gboolean rygel_default_player_controller_real_next (RygelPlayerController* base) {
	RygelDefaultPlayerController * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_player_controller_get_n_tracks ((RygelPlayerController*) self);
	_tmp3_ = _tmp2_;
	if (_tmp1_ < _tmp3_) {
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp4_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
		_tmp5_ = _tmp4_;
		rygel_player_controller_set_track ((RygelPlayerController*) self, _tmp5_ + 1);
		result = TRUE;
		return result;
	}
	_tmp6_ = rygel_player_controller_get_next_uri ((RygelPlayerController*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp8_, "") != 0;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		GUPnPMediaCollection* _tmp10_ = NULL;
		_tmp10_ = self->priv->next_collection;
		if (_tmp10_ != NULL) {
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			GUPnPMediaCollection* _tmp17_ = NULL;
			_tmp11_ = rygel_player_controller_get_next_uri ((RygelPlayerController*) self);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp14_ = rygel_player_controller_get_next_metadata ((RygelPlayerController*) self);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp17_ = self->priv->next_collection;
			rygel_player_controller_set_playlist_uri ((RygelPlayerController*) self, _tmp13_, _tmp16_, _tmp17_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp13_);
		} else {
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			_tmp18_ = rygel_player_controller_get_next_uri ((RygelPlayerController*) self);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			_tmp21_ = rygel_player_controller_get_next_metadata ((RygelPlayerController*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_;
			_tmp24_ = self->priv->next_mime;
			_tmp25_ = self->priv->next_features;
			rygel_player_controller_set_single_play_uri ((RygelPlayerController*) self, _tmp20_, _tmp23_, _tmp24_, _tmp25_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp20_);
		}
		rygel_player_controller_set_next_uri ((RygelPlayerController*) self, "");
		rygel_player_controller_set_next_metadata ((RygelPlayerController*) self, "");
		_g_free0 (self->priv->next_mime);
		self->priv->next_mime = NULL;
		_g_free0 (self->priv->next_features);
		self->priv->next_features = NULL;
		_g_object_unref0 (self->priv->next_collection);
		self->priv->next_collection = NULL;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean rygel_default_player_controller_real_previous (RygelPlayerController* base) {
	RygelDefaultPlayerController * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ <= ((guint) 1)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp3_ = _tmp2_;
	rygel_player_controller_set_track ((RygelPlayerController*) self, _tmp3_ - 1);
	result = TRUE;
	return result;
}


static void rygel_default_player_controller_real_set_single_play_uri (RygelPlayerController* base, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features) {
	RygelDefaultPlayerController * self;
	guint _tmp0_ = 0U;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RygelMediaPlayer* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	RygelMediaPlayer* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	self = (RygelDefaultPlayerController*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = self->priv->timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->timeout_id;
		g_source_remove (_tmp1_);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp2_ = metadata;
	_tmp3_ = rygel_player_controller_unescape ((RygelPlayerController*) self, _tmp2_);
	_tmp4_ = _tmp3_;
	rygel_player_controller_set_metadata ((RygelPlayerController*) self, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = uri;
	rygel_player_controller_set_uri ((RygelPlayerController*) self, _tmp5_);
	_tmp7_ = mime;
	_tmp6_ = _tmp7_;
	if (_tmp6_ == NULL) {
		_tmp6_ = "";
	}
	_tmp8_ = self->priv->_player;
	rygel_media_player_set_mime_type (_tmp8_, _tmp6_);
	_tmp10_ = features;
	_tmp9_ = _tmp10_;
	if (_tmp9_ == NULL) {
		_tmp9_ = "*";
	}
	_tmp11_ = self->priv->_player;
	rygel_media_player_set_content_features (_tmp11_, _tmp9_);
	_tmp12_ = rygel_player_controller_get_metadata ((RygelPlayerController*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	rygel_player_controller_set_track_metadata ((RygelPlayerController*) self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = rygel_player_controller_get_uri ((RygelPlayerController*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	rygel_player_controller_set_track_uri ((RygelPlayerController*) self, _tmp17_);
	_g_free0 (_tmp17_);
	__g_list_free__g_object_unref0_0 (self->priv->playlist);
	self->priv->playlist = NULL;
	_tmp18_ = rygel_player_controller_get_uri ((RygelPlayerController*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strcmp0 (_tmp20_, "") == 0;
	_g_free0 (_tmp20_);
	if (_tmp21_) {
		rygel_player_controller_set_n_tracks ((RygelPlayerController*) self, (guint) 0);
		rygel_player_controller_set_track ((RygelPlayerController*) self, (guint) 0);
	} else {
		rygel_player_controller_set_n_tracks ((RygelPlayerController*) self, (guint) 1);
		rygel_player_controller_set_track ((RygelPlayerController*) self, (guint) 1);
	}
}


static void rygel_default_player_controller_real_set_playlist_uri (RygelPlayerController* base, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection) {
	RygelDefaultPlayerController * self;
	guint _tmp0_ = 0U;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPMediaCollection* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	gboolean need_notify = FALSE;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	gboolean _tmp12_ = FALSE;
	self = (RygelDefaultPlayerController*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->timeout_id;
		g_source_remove (_tmp1_);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp2_ = metadata;
	_tmp3_ = rygel_player_controller_unescape ((RygelPlayerController*) self, _tmp2_);
	_tmp4_ = _tmp3_;
	rygel_player_controller_set_metadata ((RygelPlayerController*) self, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = uri;
	rygel_player_controller_set_uri ((RygelPlayerController*) self, _tmp5_);
	_tmp6_ = collection;
	_tmp7_ = gupnp_media_collection_get_items (_tmp6_);
	__g_list_free__g_object_unref0_0 (self->priv->playlist);
	self->priv->playlist = _tmp7_;
	_tmp8_ = self->priv->playlist;
	_tmp9_ = g_list_length (_tmp8_);
	rygel_player_controller_set_n_tracks ((RygelPlayerController*) self, _tmp9_);
	_tmp10_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp11_ = _tmp10_;
	need_notify = _tmp11_ != ((guint) 1);
	self->priv->_track = (guint) 1;
	rygel_default_player_controller_apply_track (self);
	_tmp12_ = need_notify;
	if (_tmp12_) {
		g_object_notify ((GObject*) self, "track");
	}
}


static void rygel_default_player_controller_real_set_next_single_play_uri (RygelPlayerController* base, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features) {
	RygelDefaultPlayerController * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = uri;
	rygel_player_controller_set_next_uri ((RygelPlayerController*) self, _tmp0_);
	_tmp1_ = metadata;
	rygel_player_controller_set_next_metadata ((RygelPlayerController*) self, _tmp1_);
	_tmp2_ = mime;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->next_mime);
	self->priv->next_mime = _tmp3_;
	_tmp4_ = features;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->next_features);
	self->priv->next_features = _tmp5_;
	_g_object_unref0 (self->priv->next_collection);
	self->priv->next_collection = NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_default_player_controller_real_set_next_playlist_uri (RygelPlayerController* base, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection) {
	RygelDefaultPlayerController * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GUPnPMediaCollection* _tmp2_ = NULL;
	GUPnPMediaCollection* _tmp3_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	g_return_if_fail (collection != NULL);
	_tmp0_ = uri;
	rygel_player_controller_set_next_uri ((RygelPlayerController*) self, _tmp0_);
	_tmp1_ = metadata;
	rygel_player_controller_set_next_metadata ((RygelPlayerController*) self, _tmp1_);
	_g_free0 (self->priv->next_mime);
	self->priv->next_mime = NULL;
	_g_free0 (self->priv->next_features);
	self->priv->next_features = NULL;
	_tmp2_ = collection;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->next_collection);
	self->priv->next_collection = _tmp3_;
}


static gboolean ___lambda5_ (RygelDefaultPlayerController* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	_tmp0_ = rygel_player_controller_next ((RygelPlayerController*) self);
	if (!_tmp0_) {
		rygel_default_player_controller_reset (self);
	}
	result = FALSE;
	return result;
}


static gboolean ____lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda5_ ((RygelDefaultPlayerController*) self);
	return result;
}


static void rygel_default_player_controller_notify_state_cb (RygelDefaultPlayerController* self, GObject* player, GParamSpec* p) {
	gchar* state = NULL;
	RygelMediaPlayer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->_player;
	_tmp1_ = rygel_media_player_get_playback_state (_tmp0_);
	_tmp2_ = _tmp1_;
	state = _tmp2_;
	_tmp3_ = state;
	if (g_strcmp0 (_tmp3_, "EOS") == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->_playback_state;
		_tmp5_ = state;
		if (g_strcmp0 (_tmp4_, _tmp5_) != 0) {
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp6_ = state;
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (self->priv->_playback_state);
			self->priv->_playback_state = _tmp7_;
			g_object_notify ((GObject*) self, "playback-state");
		}
	}
	_g_free0 (state);
}


static gboolean rygel_default_player_controller_real_is_play_mode_valid (RygelPlayerController* base, const gchar* play_mode) {
	RygelDefaultPlayerController * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	g_return_val_if_fail (play_mode != NULL, FALSE);
	_tmp0_ = play_mode;
	result = g_strcmp0 (_tmp0_, "NORMAL") == 0;
	return result;
}


static void rygel_default_player_controller_notify_uri_cb (RygelDefaultPlayerController* self, GObject* player, GParamSpec* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	g_object_notify ((GObject*) self, "track-uri");
}


static void rygel_default_player_controller_notify_metadata_cb (RygelDefaultPlayerController* self, GObject* player, GParamSpec* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	g_object_notify ((GObject*) self, "track-metadata");
}


static void rygel_default_player_controller_apply_track (RygelDefaultPlayerController* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playlist;
	if (_tmp0_ != NULL) {
		GUPnPDIDLLiteItem* item = NULL;
		GList* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		GList* _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		GUPnPDIDLLiteItem* _tmp6_ = NULL;
		GUPnPDIDLLiteResource* res = NULL;
		GUPnPDIDLLiteItem* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GUPnPDIDLLiteResource* _tmp9_ = NULL;
		GUPnPDIDLLiteItem* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GUPnPDIDLLiteResource* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		GUPnPDIDLLiteItem* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		_tmp1_ = self->priv->playlist;
		_tmp2_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_list_nth (_tmp1_, _tmp3_ - 1);
		_tmp5_ = _tmp4_->data;
		_tmp6_ = _g_object_ref0 ((GUPnPDIDLLiteItem*) _tmp5_);
		item = _tmp6_;
		_tmp7_ = item;
		_tmp8_ = self->priv->_protocol_info;
		_tmp9_ = gupnp_didl_lite_object_get_compat_resource ((GUPnPDIDLLiteObject*) _tmp7_, _tmp8_, TRUE);
		res = _tmp9_;
		_tmp10_ = item;
		_tmp11_ = gupnp_didl_lite_object_get_xml_string ((GUPnPDIDLLiteObject*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf (RYGEL_DEFAULT_PLAYER_CONTROLLER_DIDL_FRAME_TEMPLATE, _tmp12_);
		_tmp14_ = _tmp13_;
		rygel_player_controller_set_track_metadata ((RygelPlayerController*) self, _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_tmp15_ = res;
		_tmp16_ = gupnp_didl_lite_resource_get_uri (_tmp15_);
		rygel_player_controller_set_track_uri ((RygelPlayerController*) self, _tmp16_);
		_tmp18_ = item;
		_tmp19_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_str_has_prefix (_tmp20_, "object.item.image");
		if (_tmp21_) {
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			_tmp22_ = rygel_player_controller_get_playback_state ((RygelPlayerController*) self);
			_tmp23_ = _tmp22_;
			_tmp17_ = g_strcmp0 (_tmp23_, "STOPPED") != 0;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			GUPnPDIDLLiteItem* _tmp24_ = NULL;
			glong _tmp25_ = 0L;
			glong _tmp26_ = 0L;
			_tmp24_ = item;
			_tmp25_ = gupnp_didl_lite_item_get_lifetime (_tmp24_);
			_tmp26_ = _tmp25_;
			rygel_default_player_controller_setup_image_timeouts (self, _tmp26_);
		}
		_g_object_unref0 (res);
		_g_object_unref0 (item);
	}
}


static void rygel_default_player_controller_reset (RygelDefaultPlayerController* self) {
	g_return_if_fail (self != NULL);
	rygel_player_controller_set_playback_state ((RygelPlayerController*) self, "STOPPED");
	rygel_player_controller_set_track ((RygelPlayerController*) self, (guint) 1);
}


static gboolean __lambda6_ (RygelDefaultPlayerController* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self->priv->timeout_id = (guint) 0;
	_tmp0_ = rygel_player_controller_next ((RygelPlayerController*) self);
	if (!_tmp0_) {
		rygel_default_player_controller_reset (self);
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ ((RygelDefaultPlayerController*) self);
	return result;
}


static void rygel_default_player_controller_setup_image_timeouts (RygelDefaultPlayerController* self, glong lifetime) {
	guint timeout = 0U;
	guint _tmp0_ = 0U;
	glong _tmp1_ = 0L;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->default_image_timeout;
	timeout = _tmp0_;
	_tmp1_ = lifetime;
	if (_tmp1_ > ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = lifetime;
		timeout = (guint) _tmp2_;
	}
	_tmp3_ = timeout;
	g_debug ("rygel-default-player-controller.vala:404: Item is image, setup timer: " \
"%ld", (glong) _tmp3_);
	_tmp4_ = self->priv->timeout_id;
	if (_tmp4_ != ((guint) 0)) {
		guint _tmp5_ = 0U;
		_tmp5_ = self->priv->timeout_id;
		g_source_remove (_tmp5_);
	}
	_tmp6_ = timeout;
	_tmp7_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp6_, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->timeout_id = _tmp7_;
}


static void rygel_default_player_controller_on_setting_changed (RygelDefaultPlayerController* self, const gchar* section, const gchar* key) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	guint _tmp6_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	_tmp1_ = section;
	if (g_strcmp0 (_tmp1_, RYGEL_DEFAULT_PLAYER_CONTROLLER_CONFIG_SECTION) != 0) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = key;
		_tmp0_ = g_strcmp0 (_tmp2_, RYGEL_DEFAULT_PLAYER_CONTROLLER_TIMEOUT_KEY) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	{
		gint _tmp3_ = 0;
		RygelConfiguration* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = self->priv->config;
		_tmp5_ = rygel_configuration_get_int (_tmp4_, RYGEL_DEFAULT_PLAYER_CONTROLLER_CONFIG_SECTION, RYGEL_DEFAULT_PLAYER_CONTROLLER_TIMEOUT_KEY, 0, G_MAXINT, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		self->priv->default_image_timeout = (guint) _tmp3_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		self->priv->default_image_timeout = (guint) RYGEL_DEFAULT_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT;
		_g_error_free0 (_error_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = self->priv->default_image_timeout;
	g_debug ("rygel-default-player-controller.vala:434: New image timeout: %lu", (gulong) _tmp6_);
}


static RygelMediaPlayer* rygel_default_player_controller_get_player (RygelDefaultPlayerController* self) {
	RygelMediaPlayer* result;
	RygelMediaPlayer* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_player;
	result = _tmp0_;
	return result;
}


static void rygel_default_player_controller_set_player (RygelDefaultPlayerController* self, RygelMediaPlayer* value) {
	RygelMediaPlayer* _tmp0_ = NULL;
	RygelMediaPlayer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_player);
	self->priv->_player = _tmp1_;
	g_object_notify ((GObject *) self, "player");
}


static const gchar* rygel_default_player_controller_get_protocol_info (RygelDefaultPlayerController* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_protocol_info;
	result = _tmp0_;
	return result;
}


static void rygel_default_player_controller_set_protocol_info (RygelDefaultPlayerController* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_protocol_info);
	self->priv->_protocol_info = _tmp1_;
	g_object_notify ((GObject *) self, "protocol-info");
}


static const gchar* rygel_default_player_controller_real_get_playback_state (RygelPlayerController* base) {
	const gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_playback_state;
	result = _tmp0_;
	return result;
}


static void rygel_default_player_controller_real_set_playback_state (RygelPlayerController* base, const gchar* value) {
	RygelDefaultPlayerController* self;
	RygelMediaPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_player;
	_tmp1_ = value;
	rygel_media_player_set_playback_state (_tmp0_, _tmp1_);
}


static guint rygel_default_player_controller_real_get_n_tracks (RygelPlayerController* base) {
	guint result;
	RygelDefaultPlayerController* self;
	guint _tmp0_ = 0U;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_n_tracks;
	result = _tmp0_;
	return result;
}


static void rygel_default_player_controller_real_set_n_tracks (RygelPlayerController* base, guint value) {
	RygelDefaultPlayerController* self;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = value;
	_tmp1_ = self->priv->_n_tracks;
	if (_tmp0_ != _tmp1_) {
		guint _tmp2_ = 0U;
		_tmp2_ = value;
		self->priv->_n_tracks = _tmp2_;
		g_object_notify ((GObject*) self, "n-tracks");
	}
}


static guint rygel_default_player_controller_real_get_track (RygelPlayerController* base) {
	guint result;
	RygelDefaultPlayerController* self;
	guint _tmp0_ = 0U;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_track;
	result = _tmp0_;
	return result;
}


static void rygel_default_player_controller_real_set_track (RygelPlayerController* base, guint value) {
	RygelDefaultPlayerController* self;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = value;
	_tmp1_ = self->priv->_track;
	if (_tmp0_ != _tmp1_) {
		guint _tmp2_ = 0U;
		_tmp2_ = value;
		self->priv->_track = _tmp2_;
		rygel_default_player_controller_apply_track (self);
		g_object_notify ((GObject*) self, "track");
	}
}


static gchar* rygel_default_player_controller_real_get_uri (RygelPlayerController* base) {
	gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_default_player_controller_real_set_uri (RygelPlayerController* base, const gchar* value) {
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	g_object_notify ((GObject *) self, "uri");
}


static gchar* rygel_default_player_controller_real_get_metadata (RygelPlayerController* base) {
	gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_metadata;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_default_player_controller_real_set_metadata (RygelPlayerController* base, const gchar* value) {
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_metadata);
	self->priv->_metadata = _tmp1_;
	g_object_notify ((GObject *) self, "metadata");
}


static gchar* rygel_default_player_controller_real_get_track_uri (RygelPlayerController* base) {
	gchar* result;
	RygelDefaultPlayerController* self;
	RygelMediaPlayer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_player;
	_tmp1_ = rygel_media_player_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		RygelMediaPlayer* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp5_ = self->priv->_player;
		_tmp6_ = rygel_media_player_get_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = g_markup_escape_text (_tmp8_, (gssize) (-1));
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		result = _tmp10_;
		return result;
	} else {
		gchar* _tmp11_ = NULL;
		_tmp11_ = g_strdup ("");
		result = _tmp11_;
		return result;
	}
}


static void rygel_default_player_controller_real_set_track_uri (RygelPlayerController* base, const gchar* value) {
	RygelDefaultPlayerController* self;
	RygelMediaPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_player;
	_tmp1_ = value;
	rygel_media_player_set_uri (_tmp0_, _tmp1_);
}


static gchar* rygel_default_player_controller_real_get_track_metadata (RygelPlayerController* base) {
	gchar* result;
	RygelDefaultPlayerController* self;
	gchar* _tmp0_ = NULL;
	RygelMediaPlayer* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp5_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp1_ = self->priv->_player;
	_tmp2_ = rygel_media_player_get_metadata (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}


static void rygel_default_player_controller_real_set_track_metadata (RygelPlayerController* base, const gchar* value) {
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = value;
	_tmp1_ = g_str_has_prefix (_tmp0_, "&lt;");
	if (_tmp1_) {
		RygelMediaPlayer* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = self->priv->_player;
		_tmp3_ = value;
		_tmp4_ = rygel_player_controller_unescape ((RygelPlayerController*) self, _tmp3_);
		_tmp5_ = _tmp4_;
		rygel_media_player_set_metadata (_tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
	} else {
		RygelMediaPlayer* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = self->priv->_player;
		_tmp7_ = value;
		rygel_media_player_set_metadata (_tmp6_, _tmp7_);
	}
}


static gchar* rygel_default_player_controller_real_get_next_uri (RygelPlayerController* base) {
	gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_next_uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_default_player_controller_real_set_next_uri (RygelPlayerController* base, const gchar* value) {
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_next_uri);
	self->priv->_next_uri = _tmp1_;
	g_object_notify ((GObject *) self, "next-uri");
}


static gchar* rygel_default_player_controller_real_get_next_metadata (RygelPlayerController* base) {
	gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_next_metadata;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_default_player_controller_real_set_next_metadata (RygelPlayerController* base, const gchar* value) {
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_next_metadata);
	self->priv->_next_metadata = _tmp1_;
	g_object_notify ((GObject *) self, "next-metadata");
}


static gchar* rygel_default_player_controller_real_get_current_transport_actions (RygelPlayerController* base) {
	gchar* result;
	RygelDefaultPlayerController* self;
	gchar* actions = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	const gchar* _tmp8_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	RygelMediaPlayer* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_ = NULL;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	actions = NULL;
	_tmp0_ = rygel_player_controller_get_playback_state ((RygelPlayerController*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if ((_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("PLAYING")))) || (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("TRANSITIONING"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_ = NULL;
				_tmp5_ = g_strdup ("Stop,Seek,Pause");
				_g_free0 (actions);
				actions = _tmp5_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("STOPPED")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_ = NULL;
				_tmp6_ = g_strdup ("Play");
				_g_free0 (actions);
				actions = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_ = NULL;
				_tmp7_ = g_strdup ("Stop,Play,Seek");
				_g_free0 (actions);
				actions = _tmp7_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp8_ = actions;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup ("");
		result = _tmp9_;
		_g_free0 (actions);
		return result;
	}
	_tmp10_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = rygel_player_controller_get_n_tracks ((RygelPlayerController*) self);
	_tmp13_ = _tmp12_;
	if (_tmp11_ < _tmp13_) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp14_ = actions;
		_tmp15_ = g_strconcat (_tmp14_, ",Next", NULL);
		_g_free0 (actions);
		actions = _tmp15_;
	}
	_tmp16_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ > ((guint) 1)) {
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp18_ = actions;
		_tmp19_ = g_strconcat (_tmp18_, ",Previous", NULL);
		_g_free0 (actions);
		actions = _tmp19_;
	}
	_tmp20_ = self->priv->_player;
	_tmp21_ = rygel_media_player_get_can_seek (_tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_) {
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp23_ = actions;
		_tmp24_ = g_strconcat (_tmp23_, ",X_DLNA_SeekTime", NULL);
		_g_free0 (actions);
		actions = _tmp24_;
	}
	_tmp26_ = actions;
	if (_tmp26_ != NULL) {
		RygelMediaPlayer* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		_tmp27_ = self->priv->_player;
		_tmp28_ = rygel_media_player_get_can_seek_bytes (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp25_ = _tmp29_;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		_tmp30_ = actions;
		_tmp31_ = g_strconcat (_tmp30_, ",X_DLNA_SeekByte", NULL);
		_g_free0 (actions);
		actions = _tmp31_;
	}
	_tmp33_ = actions;
	if (_tmp33_ != NULL) {
		RygelMediaPlayer* _tmp34_ = NULL;
		gchar** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		gchar** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		gchar** _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
		_tmp34_ = self->priv->_player;
		_tmp35_ = rygel_media_player_get_allowed_playback_speeds (_tmp34_, &_tmp35__length1);
		_tmp36_ = _tmp35_;
		_tmp36__length1 = _tmp35__length1;
		_tmp37_ = _tmp36_;
		_tmp37__length1 = _tmp36__length1;
		_tmp32_ = _tmp36__length1 > 1;
		_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		gchar* play_speeds = NULL;
		gchar* _tmp38_ = NULL;
		RygelMediaPlayer* _tmp39_ = NULL;
		gchar** _tmp40_ = NULL;
		gint _tmp40__length1 = 0;
		gchar** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		const gchar* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		_tmp38_ = g_strdup ("");
		play_speeds = _tmp38_;
		_tmp39_ = self->priv->_player;
		_tmp40_ = rygel_media_player_get_allowed_playback_speeds (_tmp39_, &_tmp40__length1);
		_tmp41_ = _tmp40_;
		_tmp41__length1 = _tmp40__length1;
		{
			gchar** speed_collection = NULL;
			gint speed_collection_length1 = 0;
			gint _speed_collection_size_ = 0;
			gint speed_it = 0;
			speed_collection = _tmp41_;
			speed_collection_length1 = _tmp41__length1;
			for (speed_it = 0; speed_it < _tmp41__length1; speed_it = speed_it + 1) {
				gchar* _tmp42_ = NULL;
				gchar* speed = NULL;
				_tmp42_ = g_strdup (speed_collection[speed_it]);
				speed = _tmp42_;
				{
					const gchar* _tmp43_ = NULL;
					_tmp43_ = speed;
					if (g_strcmp0 (_tmp43_, "1") != 0) {
						const gchar* _tmp44_ = NULL;
						_tmp44_ = play_speeds;
						if (g_strcmp0 (_tmp44_, "") == 0) {
							const gchar* _tmp45_ = NULL;
							gchar* _tmp46_ = NULL;
							_tmp45_ = speed;
							_tmp46_ = g_strconcat (",X_DLNA_PS=", _tmp45_, NULL);
							_g_free0 (play_speeds);
							play_speeds = _tmp46_;
						} else {
							const gchar* _tmp47_ = NULL;
							const gchar* _tmp48_ = NULL;
							gchar* _tmp49_ = NULL;
							gchar* _tmp50_ = NULL;
							gchar* _tmp51_ = NULL;
							_tmp47_ = play_speeds;
							_tmp48_ = speed;
							_tmp49_ = g_strconcat ("\\,", _tmp48_, NULL);
							_tmp50_ = _tmp49_;
							_tmp51_ = g_strconcat (_tmp47_, _tmp50_, NULL);
							_g_free0 (play_speeds);
							play_speeds = _tmp51_;
							_g_free0 (_tmp50_);
						}
					}
					_g_free0 (speed);
				}
			}
			speed_collection = (_vala_array_free (speed_collection, speed_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp52_ = actions;
		_tmp53_ = play_speeds;
		_tmp54_ = g_strconcat (_tmp52_, _tmp53_, NULL);
		_g_free0 (actions);
		actions = _tmp54_;
		_g_free0 (play_speeds);
	}
	result = actions;
	return result;
}


static const gchar* rygel_default_player_controller_real_get_play_mode (RygelPlayerController* base) {
	const gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_play_mode;
	result = _tmp0_;
	return result;
}


static void rygel_default_player_controller_real_set_play_mode (RygelPlayerController* base, const gchar* value) {
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = value;
	_tmp1_ = self->priv->_play_mode;
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = value;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (self->priv->_play_mode);
		self->priv->_play_mode = _tmp3_;
		g_object_notify ((GObject*) self, "play-mode");
	}
}


static void rygel_default_player_controller_class_init (RygelDefaultPlayerControllerClass * klass) {
	rygel_default_player_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDefaultPlayerControllerPrivate));
	((GObjectClass *) klass)->constructed = rygel_default_player_controller_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_default_player_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_default_player_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_default_player_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYER, g_param_spec_object ("player", "player", "player", RYGEL_TYPE_MEDIA_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_PROTOCOL_INFO, g_param_spec_string ("protocol-info", "protocol-info", "protocol-info", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_N_TRACKS, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_URI, g_param_spec_string ("track-uri", "track-uri", "track-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_METADATA, g_param_spec_string ("track-metadata", "track-metadata", "track-metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_URI, g_param_spec_string ("next-uri", "next-uri", "next-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_METADATA, g_param_spec_string ("next-metadata", "next-metadata", "next-metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS, g_param_spec_string ("current-transport-actions", "current-transport-actions", "current-transport-actions", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAY_MODE, g_param_spec_string ("play-mode", "play-mode", "play-mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_default_player_controller_rygel_player_controller_interface_init (RygelPlayerControllerIface * iface) {
	rygel_default_player_controller_rygel_player_controller_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(RygelPlayerController*)) rygel_default_player_controller_real_next;
	iface->previous = (gboolean (*)(RygelPlayerController*)) rygel_default_player_controller_real_previous;
	iface->set_single_play_uri = (void (*)(RygelPlayerController*, const gchar*, const gchar*, const gchar*, const gchar*)) rygel_default_player_controller_real_set_single_play_uri;
	iface->set_playlist_uri = (void (*)(RygelPlayerController*, const gchar*, const gchar*, GUPnPMediaCollection*)) rygel_default_player_controller_real_set_playlist_uri;
	iface->set_next_single_play_uri = (void (*)(RygelPlayerController*, const gchar*, const gchar*, const gchar*, const gchar*)) rygel_default_player_controller_real_set_next_single_play_uri;
	iface->set_next_playlist_uri = (void (*)(RygelPlayerController*, const gchar*, const gchar*, GUPnPMediaCollection*)) rygel_default_player_controller_real_set_next_playlist_uri;
	iface->is_play_mode_valid = (gboolean (*)(RygelPlayerController*, const gchar*)) rygel_default_player_controller_real_is_play_mode_valid;
	iface->get_playback_state = rygel_default_player_controller_real_get_playback_state;
	iface->set_playback_state = rygel_default_player_controller_real_set_playback_state;
	iface->get_n_tracks = rygel_default_player_controller_real_get_n_tracks;
	iface->set_n_tracks = rygel_default_player_controller_real_set_n_tracks;
	iface->get_track = rygel_default_player_controller_real_get_track;
	iface->set_track = rygel_default_player_controller_real_set_track;
	iface->get_uri = rygel_default_player_controller_real_get_uri;
	iface->set_uri = rygel_default_player_controller_real_set_uri;
	iface->get_metadata = rygel_default_player_controller_real_get_metadata;
	iface->set_metadata = rygel_default_player_controller_real_set_metadata;
	iface->get_track_uri = rygel_default_player_controller_real_get_track_uri;
	iface->set_track_uri = rygel_default_player_controller_real_set_track_uri;
	iface->get_track_metadata = rygel_default_player_controller_real_get_track_metadata;
	iface->set_track_metadata = rygel_default_player_controller_real_set_track_metadata;
	iface->get_next_uri = rygel_default_player_controller_real_get_next_uri;
	iface->set_next_uri = rygel_default_player_controller_real_set_next_uri;
	iface->get_next_metadata = rygel_default_player_controller_real_get_next_metadata;
	iface->set_next_metadata = rygel_default_player_controller_real_set_next_metadata;
	iface->get_current_transport_actions = rygel_default_player_controller_real_get_current_transport_actions;
	iface->get_play_mode = rygel_default_player_controller_real_get_play_mode;
	iface->set_play_mode = rygel_default_player_controller_real_set_play_mode;
}


static void rygel_default_player_controller_instance_init (RygelDefaultPlayerController * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	self->priv = RYGEL_DEFAULT_PLAYER_CONTROLLER_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_uri = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_metadata = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_next_uri = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_next_metadata = _tmp3_;
	_tmp4_ = g_strdup ("NO_MEDIA_PRESENT");
	self->priv->_playback_state = _tmp4_;
	_tmp5_ = g_strdup ("NORMAL");
	self->priv->_play_mode = _tmp5_;
}


static void rygel_default_player_controller_finalize (GObject* obj) {
	RygelDefaultPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerController);
	_g_object_unref0 (self->priv->_player);
	_g_free0 (self->priv->_protocol_info);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_next_uri);
	_g_free0 (self->priv->_next_metadata);
	__g_list_free__g_object_unref0_0 (self->priv->playlist);
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->next_features);
	_g_free0 (self->priv->next_mime);
	_g_object_unref0 (self->priv->next_collection);
	_g_free0 (self->priv->_playback_state);
	_g_free0 (self->priv->_play_mode);
	G_OBJECT_CLASS (rygel_default_player_controller_parent_class)->finalize (obj);
}


/**
 * This class keeps track of global states that are not dependant on the
 * RygelMediaPlayer.
 *
 * These states are:
 * # URI
 * # MetaData
 * # Number of tracks
 * # Current track
 * # Playback state
 *
 * In case of playlists this class will also control the player. It needs to
 * proxy the playback state to react on end of item to be able to switch to
 * the next item.
 */
GType rygel_default_player_controller_get_type (void) {
	static volatile gsize rygel_default_player_controller_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_default_player_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDefaultPlayerControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_default_player_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDefaultPlayerController), 0, (GInstanceInitFunc) rygel_default_player_controller_instance_init, NULL };
		static const GInterfaceInfo rygel_player_controller_info = { (GInterfaceInitFunc) rygel_default_player_controller_rygel_player_controller_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_default_player_controller_type_id;
		rygel_default_player_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDefaultPlayerController", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_default_player_controller_type_id, RYGEL_TYPE_PLAYER_CONTROLLER, &rygel_player_controller_info);
		g_once_init_leave (&rygel_default_player_controller_type_id__volatile, rygel_default_player_controller_type_id);
	}
	return rygel_default_player_controller_type_id__volatile;
}


static void _vala_rygel_default_player_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelDefaultPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerController);
	switch (property_id) {
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYER:
		g_value_set_object (value, rygel_default_player_controller_get_player (self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PROTOCOL_INFO:
		g_value_set_string (value, rygel_default_player_controller_get_protocol_info (self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYBACK_STATE:
		g_value_set_string (value, rygel_player_controller_get_playback_state ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_N_TRACKS:
		g_value_set_uint (value, rygel_player_controller_get_n_tracks ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK:
		g_value_set_uint (value, rygel_player_controller_get_track ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_URI:
		g_value_take_string (value, rygel_player_controller_get_uri ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_METADATA:
		g_value_take_string (value, rygel_player_controller_get_metadata ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_URI:
		g_value_take_string (value, rygel_player_controller_get_track_uri ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_METADATA:
		g_value_take_string (value, rygel_player_controller_get_track_metadata ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_URI:
		g_value_take_string (value, rygel_player_controller_get_next_uri ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_METADATA:
		g_value_take_string (value, rygel_player_controller_get_next_metadata ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS:
		g_value_take_string (value, rygel_player_controller_get_current_transport_actions ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAY_MODE:
		g_value_set_string (value, rygel_player_controller_get_play_mode ((RygelPlayerController*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_default_player_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelDefaultPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerController);
	switch (property_id) {
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYER:
		rygel_default_player_controller_set_player (self, g_value_get_object (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PROTOCOL_INFO:
		rygel_default_player_controller_set_protocol_info (self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYBACK_STATE:
		rygel_player_controller_set_playback_state ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_N_TRACKS:
		rygel_player_controller_set_n_tracks ((RygelPlayerController*) self, g_value_get_uint (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK:
		rygel_player_controller_set_track ((RygelPlayerController*) self, g_value_get_uint (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_URI:
		rygel_player_controller_set_uri ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_METADATA:
		rygel_player_controller_set_metadata ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_URI:
		rygel_player_controller_set_track_uri ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_METADATA:
		rygel_player_controller_set_track_metadata ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_URI:
		rygel_player_controller_set_next_uri ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_METADATA:
		rygel_player_controller_set_next_metadata ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAY_MODE:
		rygel_player_controller_set_play_mode ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



