/* gnome-sudoku.c generated by valac 0.26.0.49-3a6f, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;
typedef struct _Block3Data Block3Data;

struct _Sudoku {
	GtkApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	GtkApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	gboolean is_maximized;
	gint window_width;
	gint window_height;
	GtkButton* play_pause_button;
	GtkLabel* play_pause_label;
	GtkLabel* clock_label;
	GtkImage* clock_image;
	GtkApplicationWindow* window;
	SudokuGame* game;
	SudokuView* view;
	GtkHeaderBar* headerbar;
	GtkStack* main_stack;
	GtkBox* game_box;
	GtkBox* undo_redo_box;
	GtkButton* back_button;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	GSimpleAction* pause_action;
	GSimpleAction* new_game_action;
	gboolean show_possibilities;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	PrintDialog* print_dialog;
};


static gpointer sudoku_parent_class = NULL;

GType sudoku_get_type (void) G_GNUC_CONST;
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU, SudokuPrivate))
enum  {
	SUDOKU_DUMMY_PROPERTY
};
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_toggle_pause_cb (Sudoku* self);
static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Sudoku* sudoku_new (void);
Sudoku* sudoku_construct (GType object_type);
static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean sudoku_is_desktop (Sudoku* self, const gchar* name);
static void sudoku_real_startup (GApplication* base);
static void __lambda21_ (Sudoku* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda22_ (Sudoku* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void ___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean sudoku_window_configure_event_cb (Sudoku* self, GdkEventConfigure* event);
static gboolean _sudoku_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event);
static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void sudoku_start_game (Sudoku* self, SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
static void sudoku_paused_changed_cb (Sudoku* self);
static void sudoku_display_unpause_button (Sudoku* self);
static void sudoku_display_pause_button (Sudoku* self);
static void sudoku_tick_cb (Sudoku* self);
static void sudoku_show_game_view (Sudoku* self);
static void _sudoku_tick_cb_sudoku_game_tick (SudokuGame* _sender, gpointer self);
static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender, gpointer self);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void __lambda14_ (Sudoku* self);
static void ___lambda14__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static void __lambda15_ (Sudoku* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda16_ (Block1Data* _data1_, gint response_id);
static void ___lambda16__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void ___lambda15__sudoku_board_completed (SudokuBoard* _sender, gpointer self);
static void __lambda13_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda17_ (Block2Data* _data2_, gint response_id);
void sudoku_view_clear (SudokuView* self);
static void ___lambda17__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
GType print_dialog_get_type (void) G_GNUC_CONST;
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void __lambda20_ (Block3Data* _data3_);
static void ___lambda20__print_dialog_finished (PrintDialog* _sender, gpointer self);
gint sudoku_main (gchar** args, int args_length1);
static void sudoku_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry SUDOKU_action_entries[12] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"pause", _sudoku_toggle_pause_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {"show-possible-values", 's', 0, G_OPTION_ARG_NONE, NULL, "Show the possible values for each cell", NULL}, {NULL}};
static const gchar* SUDOKU_authors[6] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", NULL};

static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_new_game_cb ((Sudoku*) self);
#line 244 "gnome-sudoku.c"
}


static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
#line 251 "gnome-sudoku.c"
}


static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_reset_cb ((Sudoku*) self);
#line 258 "gnome-sudoku.c"
}


static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_back_cb ((Sudoku*) self);
#line 265 "gnome-sudoku.c"
}


static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_undo_cb ((Sudoku*) self);
#line 272 "gnome-sudoku.c"
}


static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_redo_cb ((Sudoku*) self);
#line 279 "gnome-sudoku.c"
}


static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_cb ((Sudoku*) self);
#line 286 "gnome-sudoku.c"
}


static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_toggle_pause_cb ((Sudoku*) self);
#line 293 "gnome-sudoku.c"
}


static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_multiple_cb ((Sudoku*) self);
#line 300 "gnome-sudoku.c"
}


static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_help_cb ((Sudoku*) self);
#line 307 "gnome-sudoku.c"
}


static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_about_cb ((Sudoku*) self);
#line 314 "gnome-sudoku.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_quit ((GApplication*) self);
#line 321 "gnome-sudoku.c"
}


Sudoku* sudoku_construct (GType object_type) {
	Sudoku * self = NULL;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	setlocale (LC_ALL, "");
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	textdomain (GETTEXT_PACKAGE);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self;
#line 341 "gnome-sudoku.c"
}


Sudoku* sudoku_new (void) {
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_construct (TYPE_SUDOKU);
#line 348 "gnome-sudoku.c"
}


static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Sudoku * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = options;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 369 "gnome-sudoku.c"
		FILE* _tmp2_ = NULL;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = stderr;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		fprintf (_tmp2_, "gnome-sudoku %s\n", VERSION);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = EXIT_SUCCESS;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 379 "gnome-sudoku.c"
	}
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = options;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_variant_dict_contains (_tmp3_, "show-possible-values");
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp4_) {
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->show_possibilities = TRUE;
#line 389 "gnome-sudoku.c"
	}
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = -1;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 395 "gnome-sudoku.c"
}


static gboolean sudoku_is_desktop (Sudoku* self, const gchar* name) {
	gboolean result = FALSE;
	gchar* desktop_name_list = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	desktop_name_list = _tmp1_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = desktop_name_list;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_ == NULL) {
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = FALSE;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (desktop_name_list);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 428 "gnome-sudoku.c"
	}
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = desktop_name_list;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 0);
#line 434 "gnome-sudoku.c"
	{
		gchar** n_collection = NULL;
		gint n_collection_length1 = 0;
		gint _n_collection_size_ = 0;
		gint n_it = 0;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection = _tmp5_;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection_length1 = _vala_array_length (_tmp4_);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		for (n_it = 0; n_it < _vala_array_length (_tmp4_); n_it = n_it + 1) {
#line 446 "gnome-sudoku.c"
			gchar* _tmp6_ = NULL;
			gchar* n = NULL;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = g_strdup (n_collection[n_it]);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			n = _tmp6_;
#line 453 "gnome-sudoku.c"
			{
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp7_ = n;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp8_ = name;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					result = TRUE;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_g_free0 (n);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_g_free0 (desktop_name_list);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					return result;
#line 473 "gnome-sudoku.c"
				}
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_free0 (n);
#line 477 "gnome-sudoku.c"
			}
		}
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 482 "gnome-sudoku.c"
	}
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (desktop_name_list);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 490 "gnome-sudoku.c"
}


static void __lambda21_ (Sudoku* self) {
	SudokuView* _tmp0_ = NULL;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 500 "gnome-sudoku.c"
		SudokuView* _tmp1_ = NULL;
		GSettings* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->settings;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = g_settings_get_boolean (_tmp2_, "show-warnings");
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp1_, _tmp3_);
#line 512 "gnome-sudoku.c"
	}
}


static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda21_ ((Sudoku*) self);
#line 520 "gnome-sudoku.c"
}


static void __lambda22_ (Sudoku* self) {
	SudokuView* _tmp0_ = NULL;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 530 "gnome-sudoku.c"
		SudokuView* _tmp1_ = NULL;
		GSettings* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->settings;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = g_settings_get_boolean (_tmp2_, "highlighter");
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_highlighter (_tmp1_, _tmp3_);
#line 542 "gnome-sudoku.c"
	}
}


static void ___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda22_ ((Sudoku*) self);
#line 550 "gnome-sudoku.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self ? g_object_ref (self) : NULL;
#line 557 "gnome-sudoku.c"
}


static gboolean _sudoku_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = sudoku_window_configure_event_cb ((Sudoku*) self, event);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 566 "gnome-sudoku.c"
}


static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = sudoku_window_state_event_cb ((Sudoku*) self, event);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 575 "gnome-sudoku.c"
}


static void sudoku_real_startup (GApplication* base) {
	Sudoku * self;
	GSettings* _tmp0_ = NULL;
	GAction* action = NULL;
	GSettings* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GAction* _tmp3_ = NULL;
	GAction* _tmp4_ = NULL;
	GAction* highlighter_action = NULL;
	GSettings* _tmp5_ = NULL;
	GAction* _tmp6_ = NULL;
	GAction* _tmp7_ = NULL;
	GAction* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gchar* _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp30_ = NULL;
	GtkCssProvider* _tmp31_ = NULL;
	GdkScreen* _tmp32_ = NULL;
	GtkCssProvider* _tmp33_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkApplicationWindow* _tmp37_ = NULL;
	GtkApplicationWindow* _tmp38_ = NULL;
	GtkApplicationWindow* _tmp39_ = NULL;
	GtkApplicationWindow* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	GSettings* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	GSettings* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	GtkApplicationWindow* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	GObject* _tmp50_ = NULL;
	GtkHeaderBar* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkStack* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkBox* _tmp60_ = NULL;
	GtkBuilder* _tmp61_ = NULL;
	GObject* _tmp62_ = NULL;
	GtkButton* _tmp63_ = NULL;
	GtkBuilder* _tmp64_ = NULL;
	GObject* _tmp65_ = NULL;
	GtkLabel* _tmp66_ = NULL;
	GtkBuilder* _tmp67_ = NULL;
	GObject* _tmp68_ = NULL;
	GtkImage* _tmp69_ = NULL;
	GtkBuilder* _tmp70_ = NULL;
	GObject* _tmp71_ = NULL;
	GtkButton* _tmp72_ = NULL;
	GtkBuilder* _tmp73_ = NULL;
	GObject* _tmp74_ = NULL;
	GtkLabel* _tmp75_ = NULL;
	GAction* _tmp76_ = NULL;
	GSimpleAction* _tmp77_ = NULL;
	GAction* _tmp78_ = NULL;
	GSimpleAction* _tmp79_ = NULL;
	GAction* _tmp80_ = NULL;
	GSimpleAction* _tmp81_ = NULL;
	GAction* _tmp82_ = NULL;
	GSimpleAction* _tmp83_ = NULL;
	GAction* _tmp84_ = NULL;
	GSimpleAction* _tmp85_ = NULL;
	GAction* _tmp86_ = NULL;
	GSimpleAction* _tmp87_ = NULL;
	GAction* _tmp88_ = NULL;
	GSimpleAction* _tmp89_ = NULL;
	gboolean _tmp90_ = FALSE;
	SudokuSaver* _tmp99_ = NULL;
	SudokuGame* savegame = NULL;
	SudokuSaver* _tmp100_ = NULL;
	SudokuGame* _tmp101_ = NULL;
	SudokuGame* _tmp102_ = NULL;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, G_N_ELEMENTS (SUDOKU_action_entries), self);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_settings_new ("org.gnome.sudoku");
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->settings = _tmp0_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->settings;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	action = _tmp2_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = action;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::state", (GCallback) ___lambda21__g_object_notify, self, 0);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = action;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp4_);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->settings;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = g_settings_create_action (_tmp5_, "highlighter");
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	highlighter_action = _tmp6_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = highlighter_action;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) ___lambda22__g_object_notify, self, 0);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = highlighter_action;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp8_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = g_strdup ("<Primary>n");
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = g_new0 (gchar*, 1 + 1);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_[0] = _tmp9_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = _tmp10_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11__length1 = 1;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp11_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = g_strdup ("<Primary>p");
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = g_new0 (gchar*, 1 + 1);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_[0] = _tmp12_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = _tmp13_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14__length1 = 1;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp14_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = g_strdup ("<Primary>q");
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = g_new0 (gchar*, 1 + 1);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_[0] = _tmp15_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = _tmp16_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17__length1 = 1;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp17_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = g_strdup ("<Primary>r");
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_[0] = _tmp18_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = _tmp19_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20__length1 = 1;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp20_);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup ("<Primary>z");
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_[0] = _tmp21_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = _tmp22_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23__length1 = 1;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp23_);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = g_strdup ("<Primary><Shift>z");
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = g_new0 (gchar*, 1 + 1);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_[0] = _tmp24_;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = _tmp25_;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26__length1 = 1;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp26_);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = g_strdup ("F1");
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = g_new0 (gchar*, 1 + 1);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_[0] = _tmp27_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = _tmp28_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29__length1 = 1;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp29_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_icon_name ("gnome-sudoku");
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = gtk_css_provider_new ();
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	css_provider = _tmp30_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = css_provider;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_css_provider_load_from_resource (_tmp31_, "/org/gnome/sudoku/ui/gnome-sudoku.css");
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = gdk_screen_get_default ();
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = css_provider;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_style_context_add_provider_for_screen (_tmp32_, (GtkStyleProvider*) _tmp33_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = gtk_builder_new_from_resource ("/org/gnome/sudoku/ui/gnome-sudoku.ui");
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	builder = _tmp34_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = builder;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = gtk_builder_get_object (_tmp35_, "sudoku_app");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window = _tmp37_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp38_ = self->priv->window;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp38_, "configure-event", (GCallback) _sudoku_window_configure_event_cb_gtk_widget_configure_event, self, 0);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp39_ = self->priv->window;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp39_, "window-state-event", (GCallback) _sudoku_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp40_ = self->priv->window;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp41_ = self->priv->settings;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp42_ = g_settings_get_int (_tmp41_, "window-width");
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp43_ = self->priv->settings;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp44_ = g_settings_get_int (_tmp43_, "window-height");
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp40_, _tmp42_, _tmp44_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp45_ = self->priv->settings;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp46_ = g_settings_get_boolean (_tmp45_, "window-is-maximized");
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp46_) {
#line 881 "gnome-sudoku.c"
		GtkApplicationWindow* _tmp47_ = NULL;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp47_ = self->priv->window;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_maximize ((GtkWindow*) _tmp47_);
#line 887 "gnome-sudoku.c"
	}
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp48_ = self->priv->window;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp48_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp49_ = builder;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp50_ = gtk_builder_get_object (_tmp49_, "headerbar");
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->headerbar = _tmp51_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp52_ = builder;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp53_ = gtk_builder_get_object (_tmp52_, "main_stack");
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_stack_get_type (), GtkStack));
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->main_stack = _tmp54_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp55_ = builder;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp56_ = gtk_builder_get_object (_tmp55_, "game_box");
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_box_get_type (), GtkBox));
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game_box = _tmp57_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp58_ = builder;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp59_ = gtk_builder_get_object (_tmp58_, "undo_redo_box");
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_box_get_type (), GtkBox));
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_redo_box = _tmp60_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp61_ = builder;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp62_ = gtk_builder_get_object (_tmp61_, "back_button");
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_button_get_type (), GtkButton));
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->back_button = _tmp63_;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp64_ = builder;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp65_ = gtk_builder_get_object (_tmp64_, "clock_label");
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_label_get_type (), GtkLabel));
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_label);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clock_label = _tmp66_;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp67_ = builder;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp68_ = gtk_builder_get_object (_tmp67_, "clock_image");
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_image_get_type (), GtkImage));
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_image);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clock_image = _tmp69_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp70_ = builder;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp71_ = gtk_builder_get_object (_tmp70_, "play_pause_button");
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_button_get_type (), GtkButton));
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_button);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_pause_button = _tmp72_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp73_ = builder;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp74_ = gtk_builder_get_object (_tmp73_, "play_pause_label");
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gtk_label_get_type (), GtkLabel));
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_label);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_pause_label = _tmp75_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp76_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, g_simple_action_get_type (), GSimpleAction));
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_action = _tmp77_;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp78_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, g_simple_action_get_type (), GSimpleAction));
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->redo_action = _tmp79_;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp80_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, g_simple_action_get_type (), GSimpleAction));
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->new_game_action = _tmp81_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp82_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, g_simple_action_get_type (), GSimpleAction));
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clear_action = _tmp83_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp84_ = g_action_map_lookup_action ((GActionMap*) self, "print");
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, g_simple_action_get_type (), GSimpleAction));
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_action = _tmp85_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp86_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, g_simple_action_get_type (), GSimpleAction));
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_multiple_action = _tmp87_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp88_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp89_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, g_simple_action_get_type (), GSimpleAction));
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->pause_action = _tmp89_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp90_ = sudoku_is_desktop (self, "Unity");
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp90_) {
#line 1043 "gnome-sudoku.c"
		GtkHeaderBar* _tmp91_ = NULL;
		GtkApplicationWindow* _tmp92_ = NULL;
		GtkHeaderBar* _tmp93_ = NULL;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp91_ = self->priv->headerbar;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_show_close_button (_tmp91_, TRUE);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp92_ = self->priv->window;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp93_ = self->priv->headerbar;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_set_titlebar ((GtkWindow*) _tmp92_, (GtkWidget*) _tmp93_);
#line 1057 "gnome-sudoku.c"
	} else {
		GtkBox* vbox = NULL;
		GtkBuilder* _tmp94_ = NULL;
		GObject* _tmp95_ = NULL;
		GtkBox* _tmp96_ = NULL;
		GtkBox* _tmp97_ = NULL;
		GtkHeaderBar* _tmp98_ = NULL;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp94_ = builder;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp95_ = gtk_builder_get_object (_tmp94_, "vbox");
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, gtk_box_get_type (), GtkBox));
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		vbox = _tmp96_;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp97_ = vbox;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp98_ = self->priv->headerbar;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_box_pack_start (_tmp97_, (GtkWidget*) _tmp98_, FALSE, FALSE, (guint) 0);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (vbox);
#line 1081 "gnome-sudoku.c"
	}
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp99_ = sudoku_saver_new ();
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->saver = _tmp99_;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp100_ = self->priv->saver;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp101_ = sudoku_saver_get_savedgame (_tmp100_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	savegame = _tmp101_;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp102_ = savegame;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp102_ != NULL) {
#line 1099 "gnome-sudoku.c"
		SudokuGame* _tmp103_ = NULL;
		SudokuBoard* _tmp104_ = NULL;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp103_ = savegame;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp104_ = _tmp103_->board;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp104_);
#line 1108 "gnome-sudoku.c"
	} else {
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 1112 "gnome-sudoku.c"
	}
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (savegame);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (builder);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (css_provider);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (highlighter_action);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (action);
#line 1124 "gnome-sudoku.c"
}


static void sudoku_real_activate (GApplication* base) {
	Sudoku * self;
	GtkApplicationWindow* _tmp0_ = NULL;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1137 "gnome-sudoku.c"
}


static void sudoku_real_shutdown (GApplication* base) {
	Sudoku * self;
	SudokuGame* _tmp0_ = NULL;
	GSettings* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	GSettings* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GError * _inner_error_ = NULL;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 1157 "gnome-sudoku.c"
		gboolean _tmp1_ = FALSE;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp11_ = FALSE;
		SudokuGame* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->board;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = sudoku_board_is_empty (_tmp3_);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (!_tmp4_) {
#line 1174 "gnome-sudoku.c"
			SudokuGame* _tmp5_ = NULL;
			SudokuBoard* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp5_ = self->priv->game;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = _tmp5_->board;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp7_ = sudoku_board_get_complete (_tmp6_);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp8_ = _tmp7_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = !_tmp8_;
#line 1189 "gnome-sudoku.c"
		} else {
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = FALSE;
#line 1193 "gnome-sudoku.c"
		}
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_) {
#line 1197 "gnome-sudoku.c"
			SudokuSaver* _tmp9_ = NULL;
			SudokuGame* _tmp10_ = NULL;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->saver;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = self->priv->game;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_saver_save_game (_tmp9_, _tmp10_);
#line 1206 "gnome-sudoku.c"
		}
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->game;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_->board;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = sudoku_board_is_empty (_tmp13_);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp14_) {
#line 1216 "gnome-sudoku.c"
			SudokuSaver* _tmp15_ = NULL;
			SudokuGame* _tmp16_ = NULL;
			SudokuGame* _tmp17_ = NULL;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = self->priv->saver;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = sudoku_saver_get_savedgame (_tmp15_);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = _tmp16_;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = _tmp17_ != NULL;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (_tmp17_);
#line 1230 "gnome-sudoku.c"
		} else {
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = FALSE;
#line 1234 "gnome-sudoku.c"
		}
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp11_) {
#line 1238 "gnome-sudoku.c"
			GFile* file = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GFile* _tmp20_ = NULL;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = sudoku_saver_get_savegame_file ();
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp19_ = _tmp18_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp20_ = g_file_new_for_path (_tmp19_);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			file = _tmp20_;
#line 1251 "gnome-sudoku.c"
			{
				GFile* _tmp21_ = NULL;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp21_ = file;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_file_delete (_tmp21_, NULL, &_inner_error_);
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1260 "gnome-sudoku.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				e = _inner_error_;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_inner_error_ = NULL;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp22_ = e;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp23_ = _tmp22_->message;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_warning ("gnome-sudoku.vala:232: Failed to delete saved game: %s", _tmp23_);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_error_free0 (e);
#line 1282 "gnome-sudoku.c"
			}
			__finally0:
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_object_unref0 (file);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_clear_error (&_inner_error_);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				return;
#line 1295 "gnome-sudoku.c"
			}
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (file);
#line 1299 "gnome-sudoku.c"
		}
	}
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = self->priv->settings;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->window_width;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp24_, "window-width", _tmp25_);
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = self->priv->settings;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->window_height;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp26_, "window-height", _tmp27_);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = self->priv->settings;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->is_maximized;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_boolean (_tmp28_, "window-is-maximized", _tmp29_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1322 "gnome-sudoku.c"
}


static gboolean sudoku_window_configure_event_cb (Sudoku* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->is_maximized;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp0_) {
#line 1337 "gnome-sudoku.c"
		GdkEventConfigure* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = event;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = _tmp1_->width;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->window_width = _tmp2_;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = event;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = _tmp3_->height;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->window_height = _tmp4_;
#line 1354 "gnome-sudoku.c"
	}
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 1360 "gnome-sudoku.c"
}


static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = event;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1378 "gnome-sudoku.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = event;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1387 "gnome-sudoku.c"
	}
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 1393 "gnome-sudoku.c"
}


static void sudoku_paused_changed_cb (Sudoku* self) {
	SudokuGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _tmp1_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_) {
#line 1411 "gnome-sudoku.c"
		GSimpleAction* _tmp3_ = NULL;
		GSimpleAction* _tmp4_ = NULL;
		GSimpleAction* _tmp5_ = NULL;
		GSimpleAction* _tmp6_ = NULL;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_display_unpause_button (self);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->clear_action;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->undo_action;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = self->priv->redo_action;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp5_, FALSE);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = self->priv->new_game_action;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp6_, FALSE);
#line 1434 "gnome-sudoku.c"
	} else {
		SudokuGame* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = self->priv->game;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = sudoku_game_get_total_time_played (_tmp7_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp8_ > ((gdouble) 0)) {
#line 1444 "gnome-sudoku.c"
			GSimpleAction* _tmp9_ = NULL;
			SudokuGame* _tmp10_ = NULL;
			SudokuBoard* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			GSimpleAction* _tmp13_ = NULL;
			SudokuGame* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			GSimpleAction* _tmp16_ = NULL;
			SudokuGame* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			GSimpleAction* _tmp19_ = NULL;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_display_pause_button (self);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->clear_action;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = self->priv->game;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = _tmp10_->board;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp12_ = sudoku_board_is_empty (_tmp11_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp9_, !_tmp12_);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp13_ = self->priv->undo_action;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp14_ = self->priv->game;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = sudoku_game_is_undostack_null (_tmp14_);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp13_, !_tmp15_);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = self->priv->redo_action;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = self->priv->game;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = sudoku_game_is_redostack_null (_tmp17_);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp16_, !_tmp18_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp19_ = self->priv->new_game_action;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp19_, TRUE);
#line 1488 "gnome-sudoku.c"
		}
	}
}


static void sudoku_toggle_pause_cb (Sudoku* self) {
	SudokuGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _tmp1_;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_) {
#line 1508 "gnome-sudoku.c"
		SudokuGame* _tmp3_ = NULL;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->game;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_resume_clock (_tmp3_);
#line 1514 "gnome-sudoku.c"
	} else {
		SudokuGame* _tmp4_ = NULL;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->game;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_stop_clock (_tmp4_);
#line 1521 "gnome-sudoku.c"
	}
}


static void sudoku_tick_cb (Sudoku* self) {
	gint elapsed_time = 0;
	SudokuGame* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gint hours = 0;
	gint _tmp2_ = 0;
	gint minutes = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint seconds = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_total_time_played (_tmp0_);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	elapsed_time = (gint) _tmp1_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = elapsed_time;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	hours = _tmp2_ / 3600;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = elapsed_time;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = hours;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = (_tmp3_ - (_tmp4_ * 3600)) / 60;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = elapsed_time;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = hours;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = minutes;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	seconds = (_tmp5_ - (_tmp6_ * 3600)) - (_tmp7_ * 60);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = hours;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_ > 0) {
#line 1570 "gnome-sudoku.c"
		GtkLabel* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->clock_label;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = hours;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = minutes;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = seconds;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp10_, _tmp11_, _tmp12_);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = _tmp13_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_label_set_text (_tmp9_, _tmp14_);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp14_);
#line 1593 "gnome-sudoku.c"
	} else {
		GtkLabel* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = self->priv->clock_label;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = minutes;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = seconds;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp16_, _tmp17_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp19_ = _tmp18_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_label_set_text (_tmp15_, _tmp19_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp19_);
#line 1614 "gnome-sudoku.c"
	}
}


static void sudoku_display_pause_button (Sudoku* self) {
	GtkButton* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_pause_button;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->play_pause_label;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _ ("_Pause");
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_label_set_label (_tmp1_, _tmp2_);
#line 1635 "gnome-sudoku.c"
}


static void sudoku_display_unpause_button (Sudoku* self) {
	GtkButton* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_pause_button;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->play_pause_label;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _ ("_Resume");
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_label_set_label (_tmp1_, _tmp2_);
#line 1655 "gnome-sudoku.c"
}


static void _sudoku_tick_cb_sudoku_game_tick (SudokuGame* _sender, gpointer self) {
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_tick_cb ((Sudoku*) self);
#line 1662 "gnome-sudoku.c"
}


static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender, gpointer self) {
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_paused_changed_cb ((Sudoku*) self);
#line 1669 "gnome-sudoku.c"
}


static void __lambda14_ (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->undo_action;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->game;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_game_is_undostack_null (_tmp1_);
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, !_tmp2_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->clear_action;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->game;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = _tmp7_->board;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = sudoku_board_is_empty (_tmp8_);
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp6_, !_tmp9_);
#line 1710 "gnome-sudoku.c"
}


static void ___lambda14__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda14_ ((Sudoku*) self);
#line 1717 "gnome-sudoku.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data1_;
#line 1726 "gnome-sudoku.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1735 "gnome-sudoku.c"
		Sudoku* self;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data1_->self;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data1_->dialog);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block1Data, _data1_);
#line 1745 "gnome-sudoku.c"
	}
}


static void __lambda16_ (Block1Data* _data1_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data1_->self;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 1761 "gnome-sudoku.c"
	} else {
		gint _tmp1_ = 0;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = response_id;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_ == ((gint) GTK_RESPONSE_REJECT)) {
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_application_quit ((GApplication*) self);
#line 1770 "gnome-sudoku.c"
		}
	}
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
#line 1775 "gnome-sudoku.c"
}


static void ___lambda16__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda16_ (self, response_id);
#line 1782 "gnome-sudoku.c"
}


static void __lambda15_ (Sudoku* self) {
	Block1Data* _data1_;
	SudokuSaver* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	gint minutes = 0;
	SudokuGame* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
	gint _tmp19_ = 0;
	gchar* time_str = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkApplicationWindow* _tmp22_ = NULL;
	GtkMessageDialog* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->_ref_count_ = 1;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->self = g_object_ref (self);
#line 1807 "gnome-sudoku.c"
	{
		gint i = 0;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		i = 0;
#line 1812 "gnome-sudoku.c"
		{
			gboolean _tmp0_ = FALSE;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp0_ = TRUE;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			while (TRUE) {
#line 1819 "gnome-sudoku.c"
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!_tmp0_) {
#line 1827 "gnome-sudoku.c"
					gint _tmp1_ = 0;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_tmp1_ = i;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					i = _tmp1_ + 1;
#line 1833 "gnome-sudoku.c"
				}
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp0_ = FALSE;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp2_ = i;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp3_ = self->priv->game;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp4_ = _tmp3_->board;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp6_ = _tmp5_;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					break;
#line 1851 "gnome-sudoku.c"
				}
				{
					gint j = 0;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					j = 0;
#line 1857 "gnome-sudoku.c"
					{
						gboolean _tmp7_ = FALSE;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						_tmp7_ = TRUE;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						while (TRUE) {
#line 1864 "gnome-sudoku.c"
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuView* _tmp14_ = NULL;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!_tmp7_) {
#line 1873 "gnome-sudoku.c"
								gint _tmp8_ = 0;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								_tmp8_ = j;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								j = _tmp8_ + 1;
#line 1879 "gnome-sudoku.c"
							}
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp7_ = FALSE;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp9_ = j;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp10_ = self->priv->game;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp11_ = _tmp10_->board;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp13_ = _tmp12_;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								break;
#line 1897 "gnome-sudoku.c"
							}
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp14_ = self->priv->view;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							g_object_set ((GtkWidget*) _tmp14_, "can-focus", FALSE, NULL);
#line 1903 "gnome-sudoku.c"
						}
					}
				}
			}
		}
	}
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->saver;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = self->priv->game;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_saver_add_game_to_finished (_tmp15_, _tmp16_, TRUE);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = self->priv->game;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = sudoku_game_get_total_time_played (_tmp17_);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = MAX (1, ((gint) _tmp18_) / 60);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = _tmp19_;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = ngettext ("Well done, you completed the puzzle in %d minute!", "Well done, you completed the puzzle in %d minutes!", (gulong) minutes);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup_printf (_tmp20_, minutes);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	time_str = _tmp21_;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->window;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp22_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, time_str);
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp23_);
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_->dialog = _tmp23_;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = _ ("Play _Again");
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data1_->dialog, _tmp24_, (gint) GTK_RESPONSE_ACCEPT);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = _ ("_Quit");
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data1_->dialog, _tmp25_, (gint) GTK_RESPONSE_REJECT);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data1_->dialog, "response", (GCallback) ___lambda16__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data1_->dialog);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (time_str);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block1_data_unref (_data1_);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data1_ = NULL;
#line 1956 "gnome-sudoku.c"
}


static void ___lambda15__sudoku_board_completed (SudokuBoard* _sender, gpointer self) {
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda15_ ((Sudoku*) self);
#line 1963 "gnome-sudoku.c"
}


static void sudoku_start_game (Sudoku* self, SudokuBoard* board) {
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	SudokuView* _tmp2_ = NULL;
	SudokuBoard* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
	GtkHeaderBar* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	DifficultyCategory _tmp9_ = 0;
	DifficultyCategory _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	SudokuGame* _tmp13_ = NULL;
	SudokuGame* _tmp14_ = NULL;
	SudokuGame* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	SudokuView* _tmp17_ = NULL;
	SudokuView* _tmp18_ = NULL;
	SudokuView* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	SudokuView* _tmp21_ = NULL;
	GSettings* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	SudokuView* _tmp24_ = NULL;
	GSettings* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	SudokuView* _tmp27_ = NULL;
	GtkBox* _tmp28_ = NULL;
	SudokuView* _tmp29_ = NULL;
	SudokuGame* _tmp30_ = NULL;
	SudokuGame* _tmp31_ = NULL;
	SudokuBoard* _tmp32_ = NULL;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (board != NULL);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->undo_action;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->redo_action;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->view;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_ != NULL) {
#line 2015 "gnome-sudoku.c"
		GtkBox* _tmp3_ = NULL;
		SudokuView* _tmp4_ = NULL;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->game_box;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->view;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_container_remove ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
#line 2024 "gnome-sudoku.c"
	}
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_game_view (self);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = board;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = sudoku_game_new (_tmp5_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game = _tmp6_;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->headerbar;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = board;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = sudoku_board_get_difficulty_category (_tmp8_);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = _tmp9_;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = difficulty_category_to_string (_tmp10_);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = _tmp11_;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_header_bar_set_title (_tmp7_, _tmp12_);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp12_);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = self->priv->game;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp13_, "tick", (GCallback) _sudoku_tick_cb_sudoku_game_tick, self, 0);
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = self->priv->game;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp14_, "paused-changed", (GCallback) _sudoku_paused_changed_cb_sudoku_game_paused_changed, self, 0);
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->game;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_start_clock (_tmp15_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = self->priv->game;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = sudoku_view_new (_tmp16_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp17_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->view = _tmp17_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = self->priv->view;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp18_, 480, 480);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = self->priv->view;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = self->priv->show_possibilities;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_possibilities (_tmp19_, _tmp20_);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = self->priv->view;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->settings;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = g_settings_get_boolean (_tmp22_, "show-warnings");
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_warnings (_tmp21_, _tmp23_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = self->priv->view;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->settings;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = g_settings_get_boolean (_tmp25_, "highlighter");
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_highlighter (_tmp24_, _tmp26_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->view;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp27_);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = self->priv->game_box;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->view;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_box_pack_start (_tmp28_, (GtkWidget*) _tmp29_, TRUE, TRUE, (guint) 0);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = self->priv->game;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp30_, "cell-changed", (GCallback) ___lambda14__sudoku_game_cell_changed, self, 0);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = self->priv->game;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = _tmp31_->board;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp32_, "completed", (GCallback) ___lambda15__sudoku_board_completed, self, 0);
#line 2120 "gnome-sudoku.c"
}


static void sudoku_show_new_game_screen (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	SudokuGame* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkHeaderBar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkImage* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "start_box");
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->clear_action;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->game;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _tmp3_ != NULL);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->undo_redo_box;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, FALSE);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->headerbar;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = _ ("Select Difficulty");
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_header_bar_set_title (_tmp5_, _tmp6_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->print_action;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp7_, FALSE);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->clock_label;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_hide ((GtkWidget*) _tmp8_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = self->priv->clock_image;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_hide ((GtkWidget*) _tmp9_);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = self->priv->game;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp10_ != NULL) {
#line 2178 "gnome-sudoku.c"
		SudokuGame* _tmp11_ = NULL;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = self->priv->game;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_stop_clock (_tmp11_);
#line 2184 "gnome-sudoku.c"
	}
}


static void sudoku_new_game_cb (Sudoku* self) {
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_new_game_screen (self);
#line 2194 "gnome-sudoku.c"
}


static void __lambda13_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (res != NULL);
#line 2202 "gnome-sudoku.c"
	{
		GeeList* gen_boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		GtkButton* _tmp2_ = NULL;
		gpointer _tmp3_ = NULL;
		SudokuBoard* _tmp4_ = NULL;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = res;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gen_boards = _tmp1_;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (_inner_error_->domain == G_THREAD_ERROR) {
#line 2220 "gnome-sudoku.c"
				goto __catch1_g_thread_error;
			}
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_clear_error (&_inner_error_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			return;
#line 2229 "gnome-sudoku.c"
		}
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->back_button;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = gee_list_get (gen_boards, 0);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = (SudokuBoard*) _tmp3_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp4_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_tmp4_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (gen_boards);
#line 2245 "gnome-sudoku.c"
	}
	goto __finally1;
	__catch1_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = e->message;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_error ("gnome-sudoku.vala:413: Thread error: %s", _tmp5_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2262 "gnome-sudoku.c"
	}
	__finally1:
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2273 "gnome-sudoku.c"
	}
}


static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda13_ ((Sudoku*) self, source_object, res);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_unref (self);
#line 2283 "gnome-sudoku.c"
}


static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty) {
	DifficultyCategory selected_difficulty = 0;
	GVariant* _tmp0_ = NULL;
	gint32 _tmp1_ = 0;
	GtkButton* _tmp2_ = NULL;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (action != NULL);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = difficulty;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_get_int32 (_tmp0_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	selected_difficulty = (DifficultyCategory) _tmp1_;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_generator_generate_boards_async (1, selected_difficulty, ___lambda13__gasync_ready_callback, g_object_ref (self));
#line 2308 "gnome-sudoku.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data2_;
#line 2317 "gnome-sudoku.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2326 "gnome-sudoku.c"
		Sudoku* self;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data2_->self;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data2_->dialog);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block2Data, _data2_);
#line 2336 "gnome-sudoku.c"
	}
}


static void __lambda17_ (Block2Data* _data2_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data2_->self;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 2350 "gnome-sudoku.c"
		SudokuView* _tmp1_ = NULL;
		SudokuGame* _tmp2_ = NULL;
		GSimpleAction* _tmp3_ = NULL;
		GSimpleAction* _tmp4_ = NULL;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_clear (_tmp1_);
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_reset (_tmp2_);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->undo_action;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->redo_action;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 2371 "gnome-sudoku.c"
	}
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
#line 2375 "gnome-sudoku.c"
}


static void ___lambda17__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda17_ (self, response_id);
#line 2382 "gnome-sudoku.c"
}


static void sudoku_reset_cb (Sudoku* self) {
	Block2Data* _data2_;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->_ref_count_ = 1;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->self = g_object_ref (self);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Reset the board to its original state?");
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL, _tmp1_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp2_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->dialog = _tmp2_;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda17__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block2_data_unref (_data2_);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = NULL;
#line 2417 "gnome-sudoku.c"
}


static void sudoku_show_game_view (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkImage* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->back_button;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->undo_redo_box;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_action;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->clock_label;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->clock_image;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp6_ != NULL) {
#line 2459 "gnome-sudoku.c"
		SudokuGame* _tmp7_ = NULL;
		GSimpleAction* _tmp8_ = NULL;
		SudokuGame* _tmp9_ = NULL;
		SudokuBoard* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		GtkHeaderBar* _tmp12_ = NULL;
		SudokuGame* _tmp13_ = NULL;
		SudokuBoard* _tmp14_ = NULL;
		DifficultyCategory _tmp15_ = 0;
		DifficultyCategory _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = self->priv->game;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_resume_clock (_tmp7_);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = self->priv->clear_action;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->game;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = _tmp9_->board;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = sudoku_board_is_empty (_tmp10_);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp8_, !_tmp11_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->headerbar;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = self->priv->game;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = _tmp13_->board;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = sudoku_board_get_difficulty_category (_tmp14_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = _tmp15_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = difficulty_category_to_string (_tmp16_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = _tmp17_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp12_, _tmp18_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp18_);
#line 2504 "gnome-sudoku.c"
	}
}


static void sudoku_back_cb (Sudoku* self) {
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_game_view (self);
#line 2514 "gnome-sudoku.c"
}


static void sudoku_undo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2536 "gnome-sudoku.c"
	}
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_undo (_tmp2_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->undo_action;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_undostack_null (_tmp4_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 2554 "gnome-sudoku.c"
}


static void sudoku_redo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2576 "gnome-sudoku.c"
	}
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_redo (_tmp2_);
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 2594 "gnome-sudoku.c"
}


static void sudoku_print_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
	SudokuBoard* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	SudokuBoard* _tmp9_ = NULL;
	SudokuPrinter* printer = NULL;
	GeeArrayList* _tmp10_ = NULL;
	GtkApplicationWindow* _tmp11_ = NULL;
	SudokuPrinter* _tmp12_ = NULL;
	SudokuPrinter* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2627 "gnome-sudoku.c"
	}
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->print_action;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	list = _tmp4_;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = list;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _tmp6_->board;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = sudoku_board_clone (_tmp7_);
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = _tmp8_;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp9_);
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp9_);
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = list;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = self->priv->window;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = sudoku_printer_new ((GeeList*) _tmp10_, (GtkWindow*) _tmp11_);
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	printer = _tmp12_;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = printer;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_printer_print_sudoku (_tmp13_);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = self->priv->print_action;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp14_, TRUE);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->print_multiple_action;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp15_, TRUE);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (printer);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (list);
#line 2679 "gnome-sudoku.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data3_;
#line 2688 "gnome-sudoku.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2697 "gnome-sudoku.c"
		Sudoku* self;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data3_->self;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data3_->print_dialog);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block3Data, _data3_);
#line 2707 "gnome-sudoku.c"
	}
}


static void __lambda20_ (Block3Data* _data3_) {
	Sudoku* self;
	GSimpleAction* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data3_->self;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data3_->print_dialog);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->main_stack;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, g_strcmp0 (_tmp2_, "frame") == 0);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 2734 "gnome-sudoku.c"
}


static void ___lambda20__print_dialog_finished (PrintDialog* _sender, gpointer self) {
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda20_ (self);
#line 2741 "gnome-sudoku.c"
}


static void sudoku_print_multiple_cb (Sudoku* self) {
	Block3Data* _data3_;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	SudokuSaver* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	PrintDialog* _tmp4_ = NULL;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->_ref_count_ = 1;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->self = g_object_ref (self);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->print_multiple_action;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->saver;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->window;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = print_dialog_new (_tmp2_, (GtkWindow*) _tmp3_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp4_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->print_dialog = _tmp4_;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data (_data3_->print_dialog, "finished", (GCallback) ___lambda20__print_dialog_finished, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_run ((GtkDialog*) _data3_->print_dialog);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block3_data_unref (_data3_);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = NULL;
#line 2786 "gnome-sudoku.c"
}


static void sudoku_help_cb (Sudoku* self) {
	GError * _inner_error_ = NULL;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 2794 "gnome-sudoku.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = self->priv->window;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_show_uri (_tmp1_, "help:gnome-sudoku", _tmp2_, &_inner_error_);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2809 "gnome-sudoku.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = e;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = _tmp3_->message;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_warning ("gnome-sudoku.vala:513: Unable to open help: %s", _tmp4_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2831 "gnome-sudoku.c"
	}
	__finally2:
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2842 "gnome-sudoku.c"
	}
}


static void sudoku_about_cb (Sudoku* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Sudoku");
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_generator_qqwing_version ();
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _tmp2_;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_strdup_printf ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s", _tmp3_);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = _ (_tmp5_);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _ ("translator-credits");
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _tmp1_, "logo-icon-name", "gnome-sudoku", "version", VERSION, "comments", _tmp6_, "copyright", "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha", "license-type", GTK_LICENSE_GPL_2_0, "authors", SUDOKU_authors, "artists", NULL, "translator-credits", _tmp7_, "website", "https://wiki.gnome.org/Apps/Sudoku/", NULL);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp5_);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp3_);
#line 2880 "gnome-sudoku.c"
}


gint sudoku_main (gchar** args, int args_length1) {
	gint result = 0;
	Sudoku* _tmp0_ = NULL;
	Sudoku* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = sudoku_new ();
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = args;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2__length1 = args_length1;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = _tmp3_;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp1_);
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = _tmp4_;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 2910 "gnome-sudoku.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_main (argv, argc);
#line 2920 "gnome-sudoku.c"
}


static void sudoku_class_init (SudokuClass * klass) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_type_class_add_private (klass, sizeof (SudokuPrivate));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->handle_local_options = sudoku_real_handle_local_options;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->startup = sudoku_real_startup;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->activate = sudoku_real_activate;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->shutdown = sudoku_real_shutdown;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
#line 2939 "gnome-sudoku.c"
}


static void sudoku_instance_init (Sudoku * self) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv = SUDOKU_GET_PRIVATE (self);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->show_possibilities = FALSE;
#line 2948 "gnome-sudoku.c"
}


static void sudoku_finalize (GObject* obj) {
	Sudoku * self;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_button);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_label);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_label);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_image);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
#line 3000 "gnome-sudoku.c"
}


GType sudoku_get_type (void) {
	static volatile gsize sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
		GType sudoku_type_id;
		sudoku_type_id = g_type_register_static (gtk_application_get_type (), "Sudoku", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_type_id__volatile, sudoku_type_id);
	}
	return sudoku_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



