untrusted comment: verify with openbsd-78-base.pub
RWS3/nvFmk4SWUZvZJJi+eBwz9RO98Z0ifP+prkixsK4/QOWeZHwHsclytU86YjcSMHZXQXx+4IGvjYjW0bu9UPYVBTL6rpXDAg=

OpenBSD 7.8 errata 002, October 28, 2025:

Use-after-free and integer overflow in the Xkb and Present X server
extensions.  CVE-2025-62229 CVE-2025-62230 CVE-2025-62231

Apply by doing:
    signify -Vep /etc/signify/openbsd-78-base.pub -x 002_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install the X server:
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/present/present_notify.c
===================================================================
RCS file: /cvs/xenocara/xserver/present/present_notify.c,v
diff -u -p -r1.2 present_notify.c
--- xserver/present/present_notify.c	11 Nov 2021 09:03:14 -0000	1.2
+++ xserver/present/present_notify.c	16 Oct 2025 13:12:46 -0000
@@ -90,7 +90,7 @@ present_create_notifies(ClientPtr client
         if (status != Success)
             goto bail;
 
-        added = i;
+        added++;
     }
     return Success;
 
Index: xserver/xkb/xkb.c
===================================================================
RCS file: /cvs/xenocara/xserver/xkb/xkb.c,v
diff -u -p -r1.26 xkb.c
--- xserver/xkb/xkb.c	25 Feb 2025 15:52:13 -0000	1.26
+++ xserver/xkb/xkb.c	16 Oct 2025 13:12:47 -0000
@@ -51,7 +51,7 @@ int XkbKeyboardErrorCode;
 CARD32 xkbDebugFlags = 0;
 static CARD32 xkbDebugCtrls = 0;
 
-static RESTYPE RT_XKBCLIENT;
+RESTYPE RT_XKBCLIENT = 0;
 
 /***====================================================================***/
 
@@ -2992,6 +2992,8 @@ _XkbSetCompatMap(ClientPtr client, Devic
         XkbSymInterpretPtr sym;
         unsigned int skipped = 0;
 
+        if ((unsigned) (req->firstSI + req->nSI) > USHRT_MAX)
+            return BadValue;
         if ((unsigned) (req->firstSI + req->nSI) > compat->size_si) {
             compat->num_si = compat->size_si = req->firstSI + req->nSI;
             compat->sym_interpret = reallocarray(compat->sym_interpret,
Index: xserver/xkb/xkb.h
===================================================================
RCS file: /cvs/xenocara/xserver/xkb/xkb.h,v
diff -u -p -r1.4 xkb.h
--- xserver/xkb/xkb.h	7 Jun 2013 17:28:56 -0000	1.4
+++ xserver/xkb/xkb.h	16 Oct 2025 13:12:47 -0000
@@ -1,6 +1,8 @@
 #ifndef _XKB_H
 #define _XKB_H
 
+extern RESTYPE RT_XKBCLIENT;
+
 extern int ProcXkbUseExtension(ClientPtr client);
 extern int ProcXkbSelectEvents(ClientPtr client);
 extern int ProcXkbBell(ClientPtr client);
Index: xserver/xkb/xkbEvents.c
===================================================================
RCS file: /cvs/xenocara/xserver/xkb/xkbEvents.c,v
diff -u -p -r1.12 xkbEvents.c
--- xserver/xkb/xkbEvents.c	9 Aug 2016 18:59:55 -0000	1.12
+++ xserver/xkb/xkbEvents.c	16 Oct 2025 13:12:47 -0000
@@ -1056,6 +1056,7 @@ XkbRemoveResourceClient(DevicePtr inDev,
             autoCtrls = interest->autoCtrls;
             autoValues = interest->autoCtrlValues;
             client = interest->client;
+            FreeResource(interest->resource, RT_XKBCLIENT);
             free(interest);
             found = TRUE;
         }
@@ -1067,6 +1068,7 @@ XkbRemoveResourceClient(DevicePtr inDev,
                 autoCtrls = victim->autoCtrls;
                 autoValues = victim->autoCtrlValues;
                 client = victim->client;
+                FreeResource(victim->resource, RT_XKBCLIENT);
                 free(victim);
                 found = TRUE;
             }
