untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFu6b9mIf2k4+gMH4CYRf54JYC70wVw701O0eB/ofRokon1pSZ/GDWfMMLlA6pHrHRJWVlc7x5BLViDNKk2pIiw4=

OpenBSD 7.3 errata 015, July 25, 2023:

Some hypervisors remain unpatched for writes to Zenbleed DE_CFG bit.

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 015_hvamdcpu.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/cpu.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/cpu.c,v
diff -u -p -u -r1.165.4.1 cpu.c
--- sys/arch/amd64/amd64/cpu.c	24 Jul 2023 19:31:39 -0000	1.165.4.1
+++ sys/arch/amd64/amd64/cpu.c	25 Jul 2023 03:35:23 -0000
@@ -1187,7 +1187,8 @@ cpu_fix_msrs(struct cpu_info *ci)
 			if (msr != nmsr)
 				wrmsr(MSR_DE_CFG, nmsr);
 		}
-		if (family == 0x17 && ci->ci_model >= 0x31) {
+		if (family == 0x17 && ci->ci_model >= 0x31 &&
+		    (cpu_ecxfeature & CPUIDECX_HV) == 0) {
 			nmsr = msr = rdmsr(MSR_DE_CFG);
 #define DE_CFG_SERIALIZE_9 (1 << 9)	/* Zenbleed chickenbit */
 			nmsr |= DE_CFG_SERIALIZE_9;
Index: sys/arch/i386/i386/machdep.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/i386/machdep.c,v
diff -u -p -u -r1.663.4.1 machdep.c
--- sys/arch/i386/i386/machdep.c	24 Jul 2023 19:31:39 -0000	1.663.4.1
+++ sys/arch/i386/i386/machdep.c	25 Jul 2023 03:35:23 -0000
@@ -1993,7 +1993,8 @@ identifycpu(struct cpu_info *ci)
 			if (msr != nmsr)
 				wrmsr(MSR_DE_CFG, nmsr);
 		}
-		if (family == 0x17 && ci->ci_model >= 0x31) {
+		if (family == 0x17 && ci->ci_model >= 0x31 &&
+		    (cpu_ecxfeature & CPUIDECX_HV) == 0) {
 			nmsr = msr = rdmsr(MSR_DE_CFG);
 #define DE_CFG_SERIALIZE_9 (1 << 9)		/* Zenbleed chickenbit */
 			nmsr |= DE_CFG_SERIALIZE_9;
