untrusted comment: verify with openbsd-70-base.pub
RWR3KL+gSr4QZ6p7LhlMLPAoJhFtOhMwKDbBMCyBqyRVKbjgMNEPwZqCild8wQQuLkPys2erbcQ6OHi34P4nWQ5y489AvvamOwY=

OpenBSD 7.0 errata 001, October 31, 2021:

In certain configurations, nsd can be crashed remotely.

Apply by doing:
    signify -Vep /etc/signify/openbsd-70-base.pub -x 001_nsd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install nsd:
    cd /usr/src/usr.sbin/nsd
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install

Index: usr.sbin/nsd/namedb.c
===================================================================
RCS file: /cvs/src/usr.sbin/nsd/namedb.c,v
retrieving revision 1.14
diff -u -p -r1.14 namedb.c
--- usr.sbin/nsd/namedb.c	10 Aug 2021 08:21:30 -0000	1.14
+++ usr.sbin/nsd/namedb.c	22 Oct 2021 09:16:11 -0000
@@ -583,10 +583,13 @@ domain_find_ns_rrsets(domain_type* domai
 {
 	/* return highest NS RRset in the zone that is a delegation above */
 	domain_type* result = NULL;
+	rrset_type* rrset = NULL;
 	while (domain && domain != zone->apex) {
-		*ns = domain_find_rrset(domain, zone, TYPE_NS);
-		if (*ns)
+		rrset = domain_find_rrset(domain, zone, TYPE_NS);
+		if (rrset) {
+			*ns = rrset;
 			result = domain;
+		}
 		domain = domain->parent;
 	}
 
