untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24MHXZBwe4YggdrTAkWQN+PQlU6Hs0eE9D6ejMrduS7Rj5DyhvC+g3pEaa+eOn5n6GgEeE+NenvPhC3C/9dD95wc=

OpenBSD 6.6 errata 031, June 8, 2019:

libc's resolver could get into a corrupted state.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 031_asr.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libc and static binaries:
    cd /usr/src/lib/libc
    make obj
    make
    make install
    cd /usr/src/bin
    make obj
    make
    make install
    cd /usr/src/sbin
    make obj
    make
    make install
    cd /usr/src/usr.bin/bgplg
    make obj
    make
    make install

Index: lib/libc/asr/asr.c
===================================================================
RCS file: /cvs/src/lib/libc/asr/asr.c,v
diff -u -p -u -r1.61 asr.c
--- lib/libc/asr/asr.c	22 Oct 2018 17:31:24 -0000	1.61
+++ lib/libc/asr/asr.c	4 Jun 2020 14:43:41 -0000
@@ -143,6 +143,8 @@ asr_run(struct asr_query *as, struct asr
 {
 	int	r, saved_errno = errno;
 
+	memset(ar, 0, sizeof(*ar));
+
 	DPRINT("asr: asr_run(%p, %p) %s ctx=[%p]\n", as, ar,
 	    _asr_querystr(as->as_type), as->as_ctx);
 	r = as->as_run(as, ar);
