untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24Icv2ypHJly8sKJfGTilSEiQVVkDejBzxQaH/xYrNbwM/DexJBiNT0QBg1IKTeswHou4vAmT75O/s+KMmlb4swI=

OpenBSD 6.6 errata 012, December 8, 2019:

A user can log in with a different user's login class.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 012_suauth.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install su:
    cd /usr/src/usr.bin/su
    make obj
    make
    make install

Index: usr.bin/su/su.c
===================================================================
RCS file: /var/cvs/src/usr.bin/su/su.c,v
retrieving revision 1.77.2.1
diff -u -p -r1.77.2.1 su.c
--- usr.bin/su/su.c	4 Dec 2019 09:52:22 -0000	1.77.2.1
+++ usr.bin/su/su.c	6 Dec 2019 20:46:25 -0000
@@ -172,6 +172,8 @@ main(int argc, char **argv)
 		err(1, "unveil");
 
 	for (;;) {
+		char *pw_class = class;
+
 		/* get target user, default to root unless in -L mode */
 		if (*argv) {
 			user = *argv;
@@ -207,11 +209,11 @@ main(int argc, char **argv)
 		}
 
 		/* If the user specified a login class, use it */
-		if (!class && pwd && pwd->pw_class && pwd->pw_class[0] != '\0')
-			class = strdup(pwd->pw_class);
-		if ((lc = login_getclass(class)) == NULL)
+		if (pw_class == NULL && pwd != NULL)
+			pw_class = pwd->pw_class;
+		if ((lc = login_getclass(pw_class)) == NULL)
 			auth_errx(as, 1, "no such login class: %s",
-			    class ? class : LOGIN_DEFCLASS);
+			    pw_class ? pw_class : LOGIN_DEFCLASS);
 
 		if ((ruid == 0 && !emlogin) ||
 		    verify_user(username, pwd, style, lc, as) == 0)
