# Standard library imports
import re
from typing import Any, TypeAlias

from ..common.by import _ByType
from ..remote.webdriver import WebDriver
from ..remote.webelement import WebElement

_Locator: TypeAlias = tuple[_ByType, str]

class title_is:
    def __init__(self, title: str) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class title_contains:
    def __init__(self, title: str) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class presence_of_element_located:
    def __init__(self, locator: _Locator) -> None: ...
    def __call__(self, driver: WebDriver) -> WebElement: ...

class url_contains:
    def __init__(self, url: str) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class url_matches:
    def __init__(self, pattern: str | re.Pattern[str]) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class url_to_be:
    def __init__(self, url: str) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class url_changes:
    def __init__(self, url: str) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class visibility_of_element_located:
    def __init__(self, locator: _Locator) -> None: ...
    def __call__(self, driver: WebDriver) -> WebElement | bool: ...

class visibility_of:
    def __init__(self, element: WebElement) -> None: ...
    def __call__(self, driver: WebDriver) -> WebElement | bool: ...

class presence_of_all_elements_located:
    def __init__(self, locator: _Locator) -> None: ...
    def __call__(self, driver: WebDriver) -> list[WebElement]: ...

class visibility_of_any_elements_located:
    def __init__(self, locator: _Locator) -> None: ...
    def __call__(self, driver: WebDriver) -> list[WebElement]: ...

class visibility_of_all_elements_located:
    def __init__(self, locator: _Locator) -> None: ...
    def __call__(self, driver: WebDriver) -> list[WebElement] | bool: ...

class text_to_be_present_in_element:
    def __init__(self, locator: _Locator, text_: str) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class text_to_be_present_in_element_value:
    def __init__(self, locator: _Locator, text_: str) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class frame_to_be_available_and_switch_to_it:
    def __init__(self, locator: _Locator) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class invisibility_of_element_located:
    def __init__(self, locator: _Locator) -> None: ...
    def __call__(self, driver: WebDriver) -> WebElement | bool: ...

class invisibility_of_element(invisibility_of_element_located):
    def __init__(self, element: _Locator | WebElement) -> None: ...
    def __call__(self, driver: WebDriver) -> WebElement | bool: ...

class element_to_be_clickable:
    def __init__(self, locator: _Locator) -> None: ...
    def __call__(self, driver: WebDriver) -> WebElement | bool: ...

class staleness_of:
    def __init__(self, element: WebElement) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class element_to_be_selected:
    def __init__(self, element: WebElement) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class element_located_to_be_selected:
    def __init__(self, locator: _Locator) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class element_selection_state_to_be:
    def __init__(self, element: WebElement, is_selected: bool) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class element_located_selection_state_to_be:
    def __init__(self, locator: _Locator, is_selected: bool) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class number_of_windows_to_be:
    def __init__(self, num_windows: int) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class new_window_is_opened:
    def __init__(self, current_handles: list[Any]) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...

class alert_is_present:
    def __init__(self) -> None: ...
    def __call__(self, driver: WebDriver) -> bool: ...
